/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the CryptoTokenActivationRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CryptoTokenActivationRestRequest{}

// CryptoTokenActivationRestRequest struct for CryptoTokenActivationRestRequest
type CryptoTokenActivationRestRequest struct {
	// Activation Code
	ActivationCode       *string `json:"activation_code,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CryptoTokenActivationRestRequest CryptoTokenActivationRestRequest

// NewCryptoTokenActivationRestRequest instantiates a new CryptoTokenActivationRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCryptoTokenActivationRestRequest() *CryptoTokenActivationRestRequest {
	this := CryptoTokenActivationRestRequest{}
	return &this
}

// NewCryptoTokenActivationRestRequestWithDefaults instantiates a new CryptoTokenActivationRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCryptoTokenActivationRestRequestWithDefaults() *CryptoTokenActivationRestRequest {
	this := CryptoTokenActivationRestRequest{}
	return &this
}

// GetActivationCode returns the ActivationCode field value if set, zero value otherwise.
func (o *CryptoTokenActivationRestRequest) GetActivationCode() string {
	if o == nil || isNil(o.ActivationCode) {
		var ret string
		return ret
	}
	return *o.ActivationCode
}

// GetActivationCodeOk returns a tuple with the ActivationCode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CryptoTokenActivationRestRequest) GetActivationCodeOk() (*string, bool) {
	if o == nil || isNil(o.ActivationCode) {
		return nil, false
	}
	return o.ActivationCode, true
}

// HasActivationCode returns a boolean if a field has been set.
func (o *CryptoTokenActivationRestRequest) HasActivationCode() bool {
	if o != nil && !isNil(o.ActivationCode) {
		return true
	}

	return false
}

// SetActivationCode gets a reference to the given string and assigns it to the ActivationCode field.
func (o *CryptoTokenActivationRestRequest) SetActivationCode(v string) {
	o.ActivationCode = &v
}

func (o CryptoTokenActivationRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CryptoTokenActivationRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.ActivationCode) {
		toSerialize["activation_code"] = o.ActivationCode
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CryptoTokenActivationRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varCryptoTokenActivationRestRequest := _CryptoTokenActivationRestRequest{}

	if err = json.Unmarshal(bytes, &varCryptoTokenActivationRestRequest); err == nil {
		*o = CryptoTokenActivationRestRequest(varCryptoTokenActivationRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "activation_code")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCryptoTokenActivationRestRequest struct {
	value *CryptoTokenActivationRestRequest
	isSet bool
}

func (v NullableCryptoTokenActivationRestRequest) Get() *CryptoTokenActivationRestRequest {
	return v.value
}

func (v *NullableCryptoTokenActivationRestRequest) Set(val *CryptoTokenActivationRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableCryptoTokenActivationRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableCryptoTokenActivationRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCryptoTokenActivationRestRequest(val *CryptoTokenActivationRestRequest) *NullableCryptoTokenActivationRestRequest {
	return &NullableCryptoTokenActivationRestRequest{value: val, isSet: true}
}

func (v NullableCryptoTokenActivationRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCryptoTokenActivationRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
