// Code generated by smithy-go-codegen DO NOT EDIT.

package acmpca

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/acmpca/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpCreateCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpCreateCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.CreateCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCertificateAuthorityAuditReport struct {
}

func (*awsAwsjson11_serializeOpCreateCertificateAuthorityAuditReport) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCertificateAuthorityAuditReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCertificateAuthorityAuditReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.CreateCertificateAuthorityAuditReport")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCertificateAuthorityAuditReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePermission struct {
}

func (*awsAwsjson11_serializeOpCreatePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.CreatePermission")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePermissionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpDeleteCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.DeleteCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeletePermission struct {
}

func (*awsAwsjson11_serializeOpDeletePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeletePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.DeletePermission")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeletePermissionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeletePolicy struct {
}

func (*awsAwsjson11_serializeOpDeletePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeletePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.DeletePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeletePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpDescribeCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.DescribeCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeCertificateAuthorityAuditReport struct {
}

func (*awsAwsjson11_serializeOpDescribeCertificateAuthorityAuditReport) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeCertificateAuthorityAuditReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCertificateAuthorityAuditReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.DescribeCertificateAuthorityAuditReport")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeCertificateAuthorityAuditReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCertificate struct {
}

func (*awsAwsjson11_serializeOpGetCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.GetCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCertificateAuthorityCertificate struct {
}

func (*awsAwsjson11_serializeOpGetCertificateAuthorityCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCertificateAuthorityCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCertificateAuthorityCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.GetCertificateAuthorityCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCertificateAuthorityCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCertificateAuthorityCsr struct {
}

func (*awsAwsjson11_serializeOpGetCertificateAuthorityCsr) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCertificateAuthorityCsr) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCertificateAuthorityCsrInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.GetCertificateAuthorityCsr")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCertificateAuthorityCsrInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPolicy struct {
}

func (*awsAwsjson11_serializeOpGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.GetPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpImportCertificateAuthorityCertificate struct {
}

func (*awsAwsjson11_serializeOpImportCertificateAuthorityCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpImportCertificateAuthorityCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportCertificateAuthorityCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.ImportCertificateAuthorityCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentImportCertificateAuthorityCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpIssueCertificate struct {
}

func (*awsAwsjson11_serializeOpIssueCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpIssueCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IssueCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.IssueCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentIssueCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCertificateAuthorities struct {
}

func (*awsAwsjson11_serializeOpListCertificateAuthorities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCertificateAuthorities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCertificateAuthoritiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.ListCertificateAuthorities")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCertificateAuthoritiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListPermissions struct {
}

func (*awsAwsjson11_serializeOpListPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.ListPermissions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTags struct {
}

func (*awsAwsjson11_serializeOpListTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.ListTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutPolicy struct {
}

func (*awsAwsjson11_serializeOpPutPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.PutPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRestoreCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpRestoreCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRestoreCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.RestoreCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRestoreCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRevokeCertificate struct {
}

func (*awsAwsjson11_serializeOpRevokeCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRevokeCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.RevokeCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRevokeCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpTagCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.TagCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpUntagCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.UntagCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCertificateAuthority struct {
}

func (*awsAwsjson11_serializeOpUpdateCertificateAuthority) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCertificateAuthority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCertificateAuthorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ACMPrivateCA.UpdateCertificateAuthority")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateCertificateAuthorityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAccessDescription(v *types.AccessDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLocation != nil {
		ok := object.Key("AccessLocation")
		if err := awsAwsjson11_serializeDocumentGeneralName(v.AccessLocation, ok); err != nil {
			return err
		}
	}

	if v.AccessMethod != nil {
		ok := object.Key("AccessMethod")
		if err := awsAwsjson11_serializeDocumentAccessMethod(v.AccessMethod, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAccessDescriptionList(v []types.AccessDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAccessDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAccessMethod(v *types.AccessMethod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AccessMethodType) > 0 {
		ok := object.Key("AccessMethodType")
		ok.String(string(v.AccessMethodType))
	}

	if v.CustomObjectIdentifier != nil {
		ok := object.Key("CustomObjectIdentifier")
		ok.String(*v.CustomObjectIdentifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionList(v []types.ActionType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentApiPassthrough(v *types.ApiPassthrough, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Extensions != nil {
		ok := object.Key("Extensions")
		if err := awsAwsjson11_serializeDocumentExtensions(v.Extensions, ok); err != nil {
			return err
		}
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		if err := awsAwsjson11_serializeDocumentASN1Subject(v.Subject, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentASN1Subject(v *types.ASN1Subject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CommonName != nil {
		ok := object.Key("CommonName")
		ok.String(*v.CommonName)
	}

	if v.Country != nil {
		ok := object.Key("Country")
		ok.String(*v.Country)
	}

	if v.CustomAttributes != nil {
		ok := object.Key("CustomAttributes")
		if err := awsAwsjson11_serializeDocumentCustomAttributeList(v.CustomAttributes, ok); err != nil {
			return err
		}
	}

	if v.DistinguishedNameQualifier != nil {
		ok := object.Key("DistinguishedNameQualifier")
		ok.String(*v.DistinguishedNameQualifier)
	}

	if v.GenerationQualifier != nil {
		ok := object.Key("GenerationQualifier")
		ok.String(*v.GenerationQualifier)
	}

	if v.GivenName != nil {
		ok := object.Key("GivenName")
		ok.String(*v.GivenName)
	}

	if v.Initials != nil {
		ok := object.Key("Initials")
		ok.String(*v.Initials)
	}

	if v.Locality != nil {
		ok := object.Key("Locality")
		ok.String(*v.Locality)
	}

	if v.Organization != nil {
		ok := object.Key("Organization")
		ok.String(*v.Organization)
	}

	if v.OrganizationalUnit != nil {
		ok := object.Key("OrganizationalUnit")
		ok.String(*v.OrganizationalUnit)
	}

	if v.Pseudonym != nil {
		ok := object.Key("Pseudonym")
		ok.String(*v.Pseudonym)
	}

	if v.SerialNumber != nil {
		ok := object.Key("SerialNumber")
		ok.String(*v.SerialNumber)
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	if v.Surname != nil {
		ok := object.Key("Surname")
		ok.String(*v.Surname)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCertificateAuthorityConfiguration(v *types.CertificateAuthorityConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CsrExtensions != nil {
		ok := object.Key("CsrExtensions")
		if err := awsAwsjson11_serializeDocumentCsrExtensions(v.CsrExtensions, ok); err != nil {
			return err
		}
	}

	if len(v.KeyAlgorithm) > 0 {
		ok := object.Key("KeyAlgorithm")
		ok.String(string(v.KeyAlgorithm))
	}

	if len(v.SigningAlgorithm) > 0 {
		ok := object.Key("SigningAlgorithm")
		ok.String(string(v.SigningAlgorithm))
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		if err := awsAwsjson11_serializeDocumentASN1Subject(v.Subject, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCertificatePolicyList(v []types.PolicyInformation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPolicyInformation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCrlConfiguration(v *types.CrlConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrlDistributionPointExtensionConfiguration != nil {
		ok := object.Key("CrlDistributionPointExtensionConfiguration")
		if err := awsAwsjson11_serializeDocumentCrlDistributionPointExtensionConfiguration(v.CrlDistributionPointExtensionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomCname != nil {
		ok := object.Key("CustomCname")
		ok.String(*v.CustomCname)
	}

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.ExpirationInDays != nil {
		ok := object.Key("ExpirationInDays")
		ok.Integer(*v.ExpirationInDays)
	}

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	if len(v.S3ObjectAcl) > 0 {
		ok := object.Key("S3ObjectAcl")
		ok.String(string(v.S3ObjectAcl))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCrlDistributionPointExtensionConfiguration(v *types.CrlDistributionPointExtensionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OmitExtension != nil {
		ok := object.Key("OmitExtension")
		ok.Boolean(*v.OmitExtension)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCsrExtensions(v *types.CsrExtensions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyUsage != nil {
		ok := object.Key("KeyUsage")
		if err := awsAwsjson11_serializeDocumentKeyUsage(v.KeyUsage, ok); err != nil {
			return err
		}
	}

	if v.SubjectInformationAccess != nil {
		ok := object.Key("SubjectInformationAccess")
		if err := awsAwsjson11_serializeDocumentAccessDescriptionList(v.SubjectInformationAccess, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomAttribute(v *types.CustomAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectIdentifier != nil {
		ok := object.Key("ObjectIdentifier")
		ok.String(*v.ObjectIdentifier)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomAttributeList(v []types.CustomAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCustomAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomExtension(v *types.CustomExtension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Critical != nil {
		ok := object.Key("Critical")
		ok.Boolean(*v.Critical)
	}

	if v.ObjectIdentifier != nil {
		ok := object.Key("ObjectIdentifier")
		ok.String(*v.ObjectIdentifier)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomExtensionList(v []types.CustomExtension, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCustomExtension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEdiPartyName(v *types.EdiPartyName, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NameAssigner != nil {
		ok := object.Key("NameAssigner")
		ok.String(*v.NameAssigner)
	}

	if v.PartyName != nil {
		ok := object.Key("PartyName")
		ok.String(*v.PartyName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentExtendedKeyUsage(v *types.ExtendedKeyUsage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExtendedKeyUsageObjectIdentifier != nil {
		ok := object.Key("ExtendedKeyUsageObjectIdentifier")
		ok.String(*v.ExtendedKeyUsageObjectIdentifier)
	}

	if len(v.ExtendedKeyUsageType) > 0 {
		ok := object.Key("ExtendedKeyUsageType")
		ok.String(string(v.ExtendedKeyUsageType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentExtendedKeyUsageList(v []types.ExtendedKeyUsage, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentExtendedKeyUsage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentExtensions(v *types.Extensions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificatePolicies != nil {
		ok := object.Key("CertificatePolicies")
		if err := awsAwsjson11_serializeDocumentCertificatePolicyList(v.CertificatePolicies, ok); err != nil {
			return err
		}
	}

	if v.CustomExtensions != nil {
		ok := object.Key("CustomExtensions")
		if err := awsAwsjson11_serializeDocumentCustomExtensionList(v.CustomExtensions, ok); err != nil {
			return err
		}
	}

	if v.ExtendedKeyUsage != nil {
		ok := object.Key("ExtendedKeyUsage")
		if err := awsAwsjson11_serializeDocumentExtendedKeyUsageList(v.ExtendedKeyUsage, ok); err != nil {
			return err
		}
	}

	if v.KeyUsage != nil {
		ok := object.Key("KeyUsage")
		if err := awsAwsjson11_serializeDocumentKeyUsage(v.KeyUsage, ok); err != nil {
			return err
		}
	}

	if v.SubjectAlternativeNames != nil {
		ok := object.Key("SubjectAlternativeNames")
		if err := awsAwsjson11_serializeDocumentGeneralNameList(v.SubjectAlternativeNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGeneralName(v *types.GeneralName, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DirectoryName != nil {
		ok := object.Key("DirectoryName")
		if err := awsAwsjson11_serializeDocumentASN1Subject(v.DirectoryName, ok); err != nil {
			return err
		}
	}

	if v.DnsName != nil {
		ok := object.Key("DnsName")
		ok.String(*v.DnsName)
	}

	if v.EdiPartyName != nil {
		ok := object.Key("EdiPartyName")
		if err := awsAwsjson11_serializeDocumentEdiPartyName(v.EdiPartyName, ok); err != nil {
			return err
		}
	}

	if v.IpAddress != nil {
		ok := object.Key("IpAddress")
		ok.String(*v.IpAddress)
	}

	if v.OtherName != nil {
		ok := object.Key("OtherName")
		if err := awsAwsjson11_serializeDocumentOtherName(v.OtherName, ok); err != nil {
			return err
		}
	}

	if v.RegisteredId != nil {
		ok := object.Key("RegisteredId")
		ok.String(*v.RegisteredId)
	}

	if v.Rfc822Name != nil {
		ok := object.Key("Rfc822Name")
		ok.String(*v.Rfc822Name)
	}

	if v.UniformResourceIdentifier != nil {
		ok := object.Key("UniformResourceIdentifier")
		ok.String(*v.UniformResourceIdentifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGeneralNameList(v []types.GeneralName, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGeneralName(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentKeyUsage(v *types.KeyUsage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CRLSign {
		ok := object.Key("CRLSign")
		ok.Boolean(v.CRLSign)
	}

	if v.DataEncipherment {
		ok := object.Key("DataEncipherment")
		ok.Boolean(v.DataEncipherment)
	}

	if v.DecipherOnly {
		ok := object.Key("DecipherOnly")
		ok.Boolean(v.DecipherOnly)
	}

	if v.DigitalSignature {
		ok := object.Key("DigitalSignature")
		ok.Boolean(v.DigitalSignature)
	}

	if v.EncipherOnly {
		ok := object.Key("EncipherOnly")
		ok.Boolean(v.EncipherOnly)
	}

	if v.KeyAgreement {
		ok := object.Key("KeyAgreement")
		ok.Boolean(v.KeyAgreement)
	}

	if v.KeyCertSign {
		ok := object.Key("KeyCertSign")
		ok.Boolean(v.KeyCertSign)
	}

	if v.KeyEncipherment {
		ok := object.Key("KeyEncipherment")
		ok.Boolean(v.KeyEncipherment)
	}

	if v.NonRepudiation {
		ok := object.Key("NonRepudiation")
		ok.Boolean(v.NonRepudiation)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOcspConfiguration(v *types.OcspConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.OcspCustomCname != nil {
		ok := object.Key("OcspCustomCname")
		ok.String(*v.OcspCustomCname)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOtherName(v *types.OtherName, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TypeId != nil {
		ok := object.Key("TypeId")
		ok.String(*v.TypeId)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPolicyInformation(v *types.PolicyInformation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertPolicyId != nil {
		ok := object.Key("CertPolicyId")
		ok.String(*v.CertPolicyId)
	}

	if v.PolicyQualifiers != nil {
		ok := object.Key("PolicyQualifiers")
		if err := awsAwsjson11_serializeDocumentPolicyQualifierInfoList(v.PolicyQualifiers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPolicyQualifierInfo(v *types.PolicyQualifierInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PolicyQualifierId) > 0 {
		ok := object.Key("PolicyQualifierId")
		ok.String(string(v.PolicyQualifierId))
	}

	if v.Qualifier != nil {
		ok := object.Key("Qualifier")
		if err := awsAwsjson11_serializeDocumentQualifier(v.Qualifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPolicyQualifierInfoList(v []types.PolicyQualifierInfo, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPolicyQualifierInfo(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentQualifier(v *types.Qualifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CpsUri != nil {
		ok := object.Key("CpsUri")
		ok.String(*v.CpsUri)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRevocationConfiguration(v *types.RevocationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrlConfiguration != nil {
		ok := object.Key("CrlConfiguration")
		if err := awsAwsjson11_serializeDocumentCrlConfiguration(v.CrlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OcspConfiguration != nil {
		ok := object.Key("OcspConfiguration")
		if err := awsAwsjson11_serializeDocumentOcspConfiguration(v.OcspConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentValidity(v *types.Validity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.Long(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCertificateAuthorityAuditReportInput(v *CreateCertificateAuthorityAuditReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuditReportResponseFormat) > 0 {
		ok := object.Key("AuditReportResponseFormat")
		ok.String(string(v.AuditReportResponseFormat))
	}

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCertificateAuthorityInput(v *CreateCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityConfiguration != nil {
		ok := object.Key("CertificateAuthorityConfiguration")
		if err := awsAwsjson11_serializeDocumentCertificateAuthorityConfiguration(v.CertificateAuthorityConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.CertificateAuthorityType) > 0 {
		ok := object.Key("CertificateAuthorityType")
		ok.String(string(v.CertificateAuthorityType))
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if len(v.KeyStorageSecurityStandard) > 0 {
		ok := object.Key("KeyStorageSecurityStandard")
		ok.String(string(v.KeyStorageSecurityStandard))
	}

	if v.RevocationConfiguration != nil {
		ok := object.Key("RevocationConfiguration")
		if err := awsAwsjson11_serializeDocumentRevocationConfiguration(v.RevocationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.UsageMode) > 0 {
		ok := object.Key("UsageMode")
		ok.String(string(v.UsageMode))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePermissionInput(v *CreatePermissionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		ok.String(*v.Principal)
	}

	if v.SourceAccount != nil {
		ok := object.Key("SourceAccount")
		ok.String(*v.SourceAccount)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCertificateAuthorityInput(v *DeleteCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.PermanentDeletionTimeInDays != nil {
		ok := object.Key("PermanentDeletionTimeInDays")
		ok.Integer(*v.PermanentDeletionTimeInDays)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeletePermissionInput(v *DeletePermissionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		ok.String(*v.Principal)
	}

	if v.SourceAccount != nil {
		ok := object.Key("SourceAccount")
		ok.String(*v.SourceAccount)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeletePolicyInput(v *DeletePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeCertificateAuthorityAuditReportInput(v *DescribeCertificateAuthorityAuditReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditReportId != nil {
		ok := object.Key("AuditReportId")
		ok.String(*v.AuditReportId)
	}

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeCertificateAuthorityInput(v *DescribeCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCertificateAuthorityCertificateInput(v *GetCertificateAuthorityCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCertificateAuthorityCsrInput(v *GetCertificateAuthorityCsrInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCertificateInput(v *GetCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("CertificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPolicyInput(v *GetPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentImportCertificateAuthorityCertificateInput(v *ImportCertificateAuthorityCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Certificate != nil {
		ok := object.Key("Certificate")
		ok.Base64EncodeBytes(v.Certificate)
	}

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.CertificateChain != nil {
		ok := object.Key("CertificateChain")
		ok.Base64EncodeBytes(v.CertificateChain)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentIssueCertificateInput(v *IssueCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiPassthrough != nil {
		ok := object.Key("ApiPassthrough")
		if err := awsAwsjson11_serializeDocumentApiPassthrough(v.ApiPassthrough, ok); err != nil {
			return err
		}
	}

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.Csr != nil {
		ok := object.Key("Csr")
		ok.Base64EncodeBytes(v.Csr)
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if len(v.SigningAlgorithm) > 0 {
		ok := object.Key("SigningAlgorithm")
		ok.String(string(v.SigningAlgorithm))
	}

	if v.TemplateArn != nil {
		ok := object.Key("TemplateArn")
		ok.String(*v.TemplateArn)
	}

	if v.Validity != nil {
		ok := object.Key("Validity")
		if err := awsAwsjson11_serializeDocumentValidity(v.Validity, ok); err != nil {
			return err
		}
	}

	if v.ValidityNotBefore != nil {
		ok := object.Key("ValidityNotBefore")
		if err := awsAwsjson11_serializeDocumentValidity(v.ValidityNotBefore, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCertificateAuthoritiesInput(v *ListCertificateAuthoritiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ResourceOwner) > 0 {
		ok := object.Key("ResourceOwner")
		ok.String(string(v.ResourceOwner))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListPermissionsInput(v *ListPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsInput(v *ListTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutPolicyInput(v *PutPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRestoreCertificateAuthorityInput(v *RestoreCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRevokeCertificateInput(v *RevokeCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.CertificateSerial != nil {
		ok := object.Key("CertificateSerial")
		ok.String(*v.CertificateSerial)
	}

	if len(v.RevocationReason) > 0 {
		ok := object.Key("RevocationReason")
		ok.String(string(v.RevocationReason))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagCertificateAuthorityInput(v *TagCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagCertificateAuthorityInput(v *UntagCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateCertificateAuthorityInput(v *UpdateCertificateAuthorityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.RevocationConfiguration != nil {
		ok := object.Key("RevocationConfiguration")
		if err := awsAwsjson11_serializeDocumentRevocationConfiguration(v.RevocationConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}
