/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { TranslatedString } from "@gnu-taler/taler-util";
import { ComponentChildren, Fragment, h, JSX, VNode } from "preact";
import { Button } from "../mui/Button.js";
import { Divider } from "../mui/Divider.js";
import { Grid } from "../mui/Grid.js";
import { Paper } from "../mui/Paper.js";

interface Props extends JSX.HTMLAttributes<HTMLDivElement> {
  titleHead?: VNode | TranslatedString;
  children: ComponentChildren;
  // elements: {
  //   icon?: VNode;
  //   description: VNode;
  //   action?: () => void;
  // }[];
  confirm?: {
    label: string;
    action: () => Promise<void>;
  };
}

export function Banner({
  titleHead,
  children,
  confirm,
  href,
  ...rest
}: Props): VNode {
  return (
    <Fragment>
      <Paper elevation={0} {...rest}>
        {titleHead && (
          <Grid container>
            <Grid item>{titleHead}</Grid>
          </Grid>
        )}
        <Grid container columns={1}>
          {children}
        </Grid>
        {confirm && (
          <Grid container justifyContent="flex-end" spacing={8}>
            <Grid item>
              <Button color="primary" onClick={confirm.action}>
                {confirm.label}
              </Button>
            </Grid>
          </Grid>
        )}
      </Paper>
      <Divider />
    </Fragment>
  );
}

export default Banner;
