/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors.data;

import io.github.skylot.raung.disasm.impl.visitors.data.LocalVar;
import io.github.skylot.raung.disasm.impl.visitors.data.TryCatchBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Label;

public class LabelData {
    private final Label label;
    private final String name;
    private int insnRef;
    private int useCount;
    private List<LocalVar> startVars;
    private List<LocalVar> endVars;
    private List<TryCatchBlock> catches;

    public LabelData(Label label, String name) {
        this.label = label;
        this.name = name;
    }

    public Label getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getInsnRef() {
        return this.insnRef;
    }

    public void setInsnRef(int insnRef) {
        this.insnRef = insnRef;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public LabelData addUse() {
        ++this.useCount;
        return this;
    }

    public List<LocalVar> getStartVars() {
        return this.startVars == null ? Collections.emptyList() : this.startVars;
    }

    public void addStartVars(LocalVar var) {
        if (this.startVars == null) {
            this.startVars = new ArrayList<LocalVar>();
        }
        this.startVars.add(var);
    }

    public List<LocalVar> getEndVars() {
        return this.endVars == null ? Collections.emptyList() : this.endVars;
    }

    public void addEndVar(LocalVar var) {
        if (this.endVars == null) {
            this.endVars = new ArrayList<LocalVar>();
        }
        this.endVars.add(var);
    }

    public List<TryCatchBlock> getCatches() {
        return this.catches == null ? Collections.emptyList() : this.catches;
    }

    public void addCatch(TryCatchBlock block) {
        if (this.catches == null) {
            this.catches = new ArrayList<TryCatchBlock>();
        }
        this.catches.add(block);
    }

    public boolean isUsed() {
        return this.getUseCount() != 0 || !this.getStartVars().isEmpty() || !this.getEndVars().isEmpty() || !this.getCatches().isEmpty();
    }
}

