/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * inversesqrt(0.1) => 3.1622777
 * inversesqrt(0.73333335) => 1.1677485
 * inversesqrt(1.3666667) => 0.8553989
 * inversesqrt(2.0) => 0.70710677
 */
#version 150

void main()
{
  float[distance(inversesqrt(0.1), 3.1622777) <= 3.1622778e-05 ? 1 : -1] array0;
  float[distance(inversesqrt(0.73333335), 1.1677485) <= 1.1677484e-05 ? 1 : -1] array1;
  float[distance(inversesqrt(1.3666667), 0.8553989) <= 8.55399e-06 ? 1 : -1] array2;
  float[distance(inversesqrt(2.0), 0.70710677) <= 7.071068e-06 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
