/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThan(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => bvec3(false, true, true)
 * lessThan(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u)) => bvec3(true, true, false)
 * lessThan(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u)) => bvec3(false, true, true)
 * lessThan(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u)) => bvec3(true, false, false)
 * lessThan(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => bvec3(false, true, true)
 * lessThan(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u)) => bvec3(false, false, false)
 * lessThan(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u)) => bvec3(false, true, false)
 * lessThan(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u)) => bvec3(false, false, false)
 * lessThan(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u)) => bvec3(false, false, true)
 */
#version 150

void main()
{
  float[all(equal(lessThan(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), bvec3(false, true, true))) ? 1 : -1] array0;
  float[all(equal(lessThan(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u)), bvec3(true, true, false))) ? 1 : -1] array1;
  float[all(equal(lessThan(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u)), bvec3(false, true, true))) ? 1 : -1] array2;
  float[all(equal(lessThan(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u)), bvec3(true, false, false))) ? 1 : -1] array3;
  float[all(equal(lessThan(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), bvec3(false, true, true))) ? 1 : -1] array4;
  float[all(equal(lessThan(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u)), bvec3(false, false, false))) ? 1 : -1] array5;
  float[all(equal(lessThan(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u)), bvec3(false, true, false))) ? 1 : -1] array6;
  float[all(equal(lessThan(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u)), bvec3(false, false, false))) ? 1 : -1] array7;
  float[all(equal(lessThan(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u)), bvec3(false, false, true))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
