/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) ^ (- abs(12))) => ivec2(-46, -41)
 * (ivec2(38, 35) ^ (- abs(-6))) => ivec2(-36, -39)
 * (ivec2(38, 35) ^ (- abs(76))) => ivec2(-110, -105)
 * (ivec2(38, 35) ^ (- abs(-32))) => ivec2(-58, -61)
 * (ivec2(38, 35) ^ (- abs(0))) => ivec2(38, 35)
 * (ivec2(64, -9) ^ (- abs(12))) => ivec2(-76, 3)
 * (ivec2(64, -9) ^ (- abs(-6))) => ivec2(-70, 13)
 * (ivec2(64, -9) ^ (- abs(76))) => ivec2(-12, 67)
 * (ivec2(64, -9) ^ (- abs(-32))) => ivec2(-96, 23)
 * (ivec2(64, -9) ^ (- abs(0))) => ivec2(64, -9)
 * (ivec2(64, 9) ^ (- abs(12))) => ivec2(-76, -3)
 * (ivec2(64, 9) ^ (- abs(-6))) => ivec2(-70, -13)
 * (ivec2(64, 9) ^ (- abs(76))) => ivec2(-12, -67)
 * (ivec2(64, 9) ^ (- abs(-32))) => ivec2(-96, -23)
 * (ivec2(64, 9) ^ (- abs(0))) => ivec2(64, 9)
 */
#version 150

void main()
{
  float[all(equal((ivec2(38, 35) ^ (- abs(12))), ivec2(-46, -41))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) ^ (- abs(-6))), ivec2(-36, -39))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) ^ (- abs(76))), ivec2(-110, -105))) ? 1 : -1] array2;
  float[all(equal((ivec2(38, 35) ^ (- abs(-32))), ivec2(-58, -61))) ? 1 : -1] array3;
  float[all(equal((ivec2(38, 35) ^ (- abs(0))), ivec2(38, 35))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) ^ (- abs(12))), ivec2(-76, 3))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, -9) ^ (- abs(-6))), ivec2(-70, 13))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, -9) ^ (- abs(76))), ivec2(-12, 67))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, -9) ^ (- abs(-32))), ivec2(-96, 23))) ? 1 : -1] array8;
  float[all(equal((ivec2(64, -9) ^ (- abs(0))), ivec2(64, -9))) ? 1 : -1] array9;
  float[all(equal((ivec2(64, 9) ^ (- abs(12))), ivec2(-76, -3))) ? 1 : -1] array10;
  float[all(equal((ivec2(64, 9) ^ (- abs(-6))), ivec2(-70, -13))) ? 1 : -1] array11;
  float[all(equal((ivec2(64, 9) ^ (- abs(76))), ivec2(-12, -67))) ? 1 : -1] array12;
  float[all(equal((ivec2(64, 9) ^ (- abs(-32))), ivec2(-96, -23))) ? 1 : -1] array13;
  float[all(equal((ivec2(64, 9) ^ (- abs(0))), ivec2(64, 9))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
