(()=>{var e,n,o,r={10124:(t,e,n)=>{var o=n(9325);t.exports=function(){return o.Date.now()}},18024:(t,e,n)=>{var o=n(75288);t.exports=function(t,e){for(var n=-1,r=t.length,i=0,s=[];++n<r;){var a=t[n],c=e?e(a):a;if(!n||!o(c,l)){var l=c;s[i++]=0===a?0:a}}return s}},21477:(t,e,n)=>{"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.two-factor-loading[data-v-086a272a] {\n\tdisplay: inline-block;\n\tvertical-align: sub;\n\tmargin-left: -2px;\n\tmargin-right: 1px;\n}\n.top-margin[data-v-086a272a] {\n\tmargin-top: 0.5rem;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/AdminTwoFactor.vue"],names:[],mappings:";AA0LA;CACA,qBAAA;CACA,mBAAA;CACA,iBAAA;CACA,iBAAA;AACA;AAEA;CACA,kBAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2019 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n<template>\n\t<NcSettingsSection :name=\"t('settings', 'Two-Factor Authentication')\"\n\t\t:description=\"t('settings', 'Two-factor authentication can be enforced for all accounts and specific groups. If they do not have a two-factor provider configured, they will be unable to log into the system.')\"\n\t\t:doc-url=\"twoFactorAdminDoc\">\n\t\t<p v-if=\"loading\">\n\t\t\t<span class=\"icon-loading-small two-factor-loading\" />\n\t\t\t<span>{{ t('settings', 'Enforce two-factor authentication') }}</span>\n\t\t</p>\n\t\t<NcCheckboxRadioSwitch v-else\n\t\t\tid=\"two-factor-enforced\"\n\t\t\t:checked.sync=\"enforced\"\n\t\t\ttype=\"switch\">\n\t\t\t{{ t('settings', 'Enforce two-factor authentication') }}\n\t\t</NcCheckboxRadioSwitch>\n\t\t<template v-if=\"enforced\">\n\t\t\t<h3>{{ t('settings', 'Limit to groups') }}</h3>\n\t\t\t{{ t('settings', 'Enforcement of two-factor authentication can be set for certain groups only.') }}\n\t\t\t<p class=\"top-margin\">\n\t\t\t\t{{ t('settings', 'Two-factor authentication is enforced for all members of the following groups.') }}\n\t\t\t</p>\n\t\t\t<p>\n\t\t\t\t<label for=\"enforcedGroups\">\n\t\t\t\t\t<span>{{ t('settings', 'Enforced groups') }}</span>\n\t\t\t\t</label>\n\t\t\t\t<NcSelect v-model=\"enforcedGroups\"\n\t\t\t\t\tinput-id=\"enforcedGroups\"\n\t\t\t\t\t:options=\"groups\"\n\t\t\t\t\t:disabled=\"loading\"\n\t\t\t\t\t:multiple=\"true\"\n\t\t\t\t\t:loading=\"loadingGroups\"\n\t\t\t\t\t:close-on-select=\"false\"\n\t\t\t\t\t@search=\"searchGroup\" />\n\t\t\t</p>\n\t\t\t<p class=\"top-margin\">\n\t\t\t\t{{ t('settings', 'Two-factor authentication is not enforced for members of the following groups.') }}\n\t\t\t</p>\n\t\t\t<p>\n\t\t\t\t<label for=\"excludedGroups\">\n\t\t\t\t\t<span>{{ t('settings', 'Excluded groups') }}</span>\n\t\t\t\t</label>\n\t\t\t\t<NcSelect v-model=\"excludedGroups\"\n\t\t\t\t\tinput-id=\"excludedGroups\"\n\t\t\t\t\t:options=\"groups\"\n\t\t\t\t\t:disabled=\"loading\"\n\t\t\t\t\t:multiple=\"true\"\n\t\t\t\t\t:loading=\"loadingGroups\"\n\t\t\t\t\t:close-on-select=\"false\"\n\t\t\t\t\t@search=\"searchGroup\" />\n\t\t\t</p>\n\t\t\t<p class=\"top-margin\">\n\t\t\t\t<em>\n\t\t\t\t\t\x3c!-- this text is also found in the documentation. update it there as well if it ever changes --\x3e\n\t\t\t\t\t{{ t('settings', 'When groups are selected/excluded, they use the following logic to determine if an account has 2FA enforced: If no groups are selected, 2FA is enabled for everyone except members of the excluded groups. If groups are selected, 2FA is enabled for all members of these. If an account is both in a selected and excluded group, the selected takes precedence and 2FA is enforced.') }}\n\t\t\t\t</em>\n\t\t\t</p>\n\t\t</template>\n\t\t<p class=\"top-margin\">\n\t\t\t<NcButton v-if=\"dirty\"\n\t\t\t\ttype=\"primary\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\t@click=\"saveChanges\">\n\t\t\t\t{{ t('settings', 'Save changes') }}\n\t\t\t</NcButton>\n\t\t</p>\n\t</NcSettingsSection>\n</template>\n\n<script>\nimport axios from '@nextcloud/axios'\nimport NcSelect from '@nextcloud/vue/dist/Components/NcSelect.js'\nimport NcButton from '@nextcloud/vue/dist/Components/NcButton.js'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/dist/Components/NcCheckboxRadioSwitch.js'\nimport NcSettingsSection from '@nextcloud/vue/dist/Components/NcSettingsSection.js'\nimport { loadState } from '@nextcloud/initial-state'\n\nimport sortedUniq from 'lodash/sortedUniq.js'\nimport uniq from 'lodash/uniq.js'\nimport debounce from 'lodash/debounce.js'\nimport { generateUrl, generateOcsUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'AdminTwoFactor',\n\tcomponents: {\n\t\tNcSelect,\n\t\tNcButton,\n\t\tNcCheckboxRadioSwitch,\n\t\tNcSettingsSection,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tloading: false,\n\t\t\tdirty: false,\n\t\t\tgroups: [],\n\t\t\tloadingGroups: false,\n\t\t\ttwoFactorAdminDoc: loadState('settings', 'two-factor-admin-doc'),\n\t\t}\n\t},\n\tcomputed: {\n\t\tenforced: {\n\t\t\tget() {\n\t\t\t\treturn this.$store.state.enforced\n\t\t\t},\n\t\t\tset(val) {\n\t\t\t\tthis.dirty = true\n\t\t\t\tthis.$store.commit('setEnforced', val)\n\t\t\t},\n\t\t},\n\t\tenforcedGroups: {\n\t\t\tget() {\n\t\t\t\treturn this.$store.state.enforcedGroups\n\t\t\t},\n\t\t\tset(val) {\n\t\t\t\tthis.dirty = true\n\t\t\t\tthis.$store.commit('setEnforcedGroups', val)\n\t\t\t},\n\t\t},\n\t\texcludedGroups: {\n\t\t\tget() {\n\t\t\t\treturn this.$store.state.excludedGroups\n\t\t\t},\n\t\t\tset(val) {\n\t\t\t\tthis.dirty = true\n\t\t\t\tthis.$store.commit('setExcludedGroups', val)\n\t\t\t},\n\t\t},\n\t},\n\tmounted() {\n\t\t// Groups are loaded dynamically, but the assigned ones *should*\n\t\t// be valid groups, so let's add them as initial state\n\t\tthis.groups = sortedUniq(uniq(this.enforcedGroups.concat(this.excludedGroups)))\n\n\t\t// Populate the groups with a first set so the dropdown is not empty\n\t\t// when opening the page the first time\n\t\tthis.searchGroup('')\n\t},\n\tmethods: {\n\t\tsearchGroup: debounce(function(query) {\n\t\t\tthis.loadingGroups = true\n\t\t\taxios.get(generateOcsUrl('cloud/groups?offset=0&search={query}&limit=20', { query }))\n\t\t\t\t.then(res => res.data.ocs)\n\t\t\t\t.then(ocs => ocs.data.groups)\n\t\t\t\t.then(groups => { this.groups = sortedUniq(uniq(this.groups.concat(groups))) })\n\t\t\t\t.catch(err => console.error('could not search groups', err))\n\t\t\t\t.then(() => { this.loadingGroups = false })\n\t\t}, 500),\n\n\t\tsaveChanges() {\n\t\t\tthis.loading = true\n\n\t\t\tconst data = {\n\t\t\t\tenforced: this.enforced,\n\t\t\t\tenforcedGroups: this.enforcedGroups,\n\t\t\t\texcludedGroups: this.excludedGroups,\n\t\t\t}\n\t\t\taxios.put(generateUrl('/settings/api/admin/twofactorauth'), data)\n\t\t\t\t.then(resp => resp.data)\n\t\t\t\t.then(state => {\n\t\t\t\t\tthis.state = state\n\t\t\t\t\tthis.dirty = false\n\t\t\t\t})\n\t\t\t\t.catch(err => {\n\t\t\t\t\tconsole.error('could not save changes', err)\n\t\t\t\t})\n\t\t\t\t.then(() => { this.loading = false })\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n\t.two-factor-loading {\n\t\tdisplay: inline-block;\n\t\tvertical-align: sub;\n\t\tmargin-left: -2px;\n\t\tmargin-right: 1px;\n\t}\n\n\t.top-margin {\n\t\tmargin-top: 0.5rem;\n\t}\n</style>\n"],sourceRoot:""}]);const a=s},29905:t=>{t.exports=function(t,e,n){for(var o=-1,r=null==t?0:t.length;++o<r;)if(n(e,t[o]))return!0;return!1}},38221:(t,e,n)=>{var o=n(23805),r=n(10124),i=n(99374),s=Math.max,a=Math.min;t.exports=function(t,e,n){var c,l,d,p,u,f,g=0,m=!1,h=!1,y=!0;if("function"!=typeof t)throw new TypeError("Expected a function");function v(e){var n=c,o=l;return c=l=void 0,g=e,p=t.apply(o,n)}function b(t){var n=t-f;return void 0===f||n>=e||n<0||h&&t-g>=d}function A(){var t=r();if(b(t))return w(t);u=setTimeout(A,function(t){var n=e-(t-f);return h?a(n,d-(t-g)):n}(t))}function w(t){return u=void 0,y&&c?v(t):(c=l=void 0,p)}function x(){var t=r(),n=b(t);if(c=arguments,l=this,f=t,n){if(void 0===u)return function(t){return g=t,u=setTimeout(A,e),m?v(t):p}(f);if(h)return clearTimeout(u),u=setTimeout(A,e),v(f)}return void 0===u&&(u=setTimeout(A,e)),p}return e=i(e)||0,o(n)&&(m=!!n.leading,d=(h="maxWait"in n)?s(i(n.maxWait)||0,e):d,y="trailing"in n?!!n.trailing:y),x.cancel=function(){void 0!==u&&clearTimeout(u),g=0,c=f=l=u=void 0},x.flush=function(){return void 0===u?p:w(r())},x}},44517:(t,e,n)=>{var o=n(76545),r=n(63950),i=n(84247),s=o&&1/i(new o([,-0]))[1]==1/0?function(t){return new o(t)}:r;t.exports=s},55765:(t,e,n)=>{var o=n(38859),r=n(15325),i=n(29905),s=n(19219),a=n(44517),c=n(84247);t.exports=function(t,e,n){var l=-1,d=r,p=t.length,u=!0,f=[],g=f;if(n)u=!1,d=i;else if(p>=200){var m=e?null:a(t);if(m)return c(m);u=!1,d=s,g=new o}else g=e?[]:f;t:for(;++l<p;){var h=t[l],y=e?e(h):h;if(h=n||0!==h?h:0,u&&y==y){for(var v=g.length;v--;)if(g[v]===y)continue t;e&&g.push(y),f.push(h)}else d(g,y,n)||(g!==f&&g.push(y),f.push(h))}return f}},58671:(t,e,n)=>{"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\ncode[data-v-641ed214] {\n\tbackground-color: var(--color-background-dark);\n\tcolor: var(--color-main-text);\n\n\tdisplay: block;\n\tmargin-block-start: 0.5rem;\n\tpadding: .25lh .5lh;\n\twidth: fit-content;\n}\n.disabled[data-v-641ed214] {\n\topacity: .75;\n}\n.disabled[data-v-641ed214] * {\n\tcursor: not-allowed !important;\n}\n.disable-hint[data-v-641ed214] {\n\tcolor: var(--color-text-maxcontrast);\n\tpadding-inline-start: 10px;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/Encryption/EncryptionSettings.vue"],names:[],mappings:";AA8KA;CACA,8CAAA;CACA,6BAAA;;CAEA,cAAA;CACA,0BAAA;CACA,mBAAA;CACA,kBAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,8BAAA;AACA;AAEA;CACA,oCAAA;CACA,0BAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2022 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<script setup lang=\"ts\">\nimport type { OCSResponse } from '@nextcloud/typings/ocs'\nimport { showError, spawnDialog } from '@nextcloud/dialogs'\nimport { loadState } from '@nextcloud/initial-state'\nimport { t } from '@nextcloud/l10n'\nimport { confirmPassword } from '@nextcloud/password-confirmation'\nimport { generateOcsUrl } from '@nextcloud/router'\nimport { ref } from 'vue'\nimport { textExistingFilesNotEncrypted } from './sharedTexts.ts'\n\nimport axios from '@nextcloud/axios'\nimport logger from '../../logger.ts'\n\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/dist/Components/NcCheckboxRadioSwitch.js'\nimport NcNoteCard from '@nextcloud/vue/dist/Components/NcNoteCard.js'\nimport NcSettingsSection from '@nextcloud/vue/dist/Components/NcSettingsSection.js'\nimport EncryptionWarningDialog from './EncryptionWarningDialog.vue'\n\ninterface EncryptionModule {\n\tdefault?: boolean\n\tdisplayName: string\n}\n\nconst allEncryptionModules = loadState<never[]|Record<string, EncryptionModule>>('settings', 'encryption-modules')\n/** Available encryption modules on the backend */\nconst encryptionModules = Array.isArray(allEncryptionModules) ? [] : Object.entries(allEncryptionModules).map(([id, module]) => ({ ...module, id }))\n/** ID of the default encryption module */\nconst defaultCheckedModule = encryptionModules.find((module) => module.default)?.id\n\n/** Is the server side encryptio ready to be enabled */\nconst encryptionReady = loadState<boolean>('settings', 'encryption-ready')\n/** Are external backends enabled (legacy ownCloud stuff) */\nconst externalBackendsEnabled = loadState<boolean>('settings', 'external-backends-enabled')\n/** URL to the admin docs */\nconst encryptionAdminDoc = loadState<string>('settings', 'encryption-admin-doc')\n\n/** Is the encryption enabled */\nconst encryptionEnabled = ref(loadState<boolean>('settings', 'encryption-enabled'))\n\n/** Loading state while enabling encryption (e.g. because the confirmation dialog is open) */\nconst loadingEncryptionState = ref(false)\n\n/**\n * Open the encryption-enabling warning (spawns a dialog)\n * @param enabled The enabled state of encryption\n */\nfunction displayWarning(enabled: boolean) {\n\tif (loadingEncryptionState.value || enabled === false) {\n\t\treturn\n\t}\n\n\tloadingEncryptionState.value = true\n\tspawnDialog(EncryptionWarningDialog, {}, async (confirmed) => {\n\t\ttry {\n\t\t\tif (confirmed) {\n\t\t\t\tawait enableEncryption()\n\t\t\t}\n\t\t} finally {\n\t\t\tloadingEncryptionState.value = false\n\t\t}\n\t})\n}\n\n/**\n * Update an encryption setting on the backend\n * @param key The setting to update\n * @param value The new value\n */\nasync function update(key: string, value: string) {\n\tawait confirmPassword()\n\n\tconst url = generateOcsUrl('/apps/provisioning_api/api/v1/config/apps/{appId}/{key}', {\n\t\tappId: 'core',\n\t\tkey,\n\t})\n\n\ttry {\n\t\tconst { data } = await axios.post<OCSResponse>(url, {\n\t\t\tvalue,\n\t\t})\n\t\tif (data.ocs.meta.status !== 'ok') {\n\t\t\tthrow new Error('Unsuccessful OCS response', { cause: data.ocs })\n\t\t}\n\t} catch (error) {\n\t\tshowError(t('settings', 'Unable to update server side encryption config'))\n\t\tlogger.error('Unable to update server side encryption config', { error })\n\t\treturn false\n\t}\n\treturn true\n}\n\n/**\n * Choose the default encryption module\n */\nasync function checkDefaultModule(): Promise<void> {\n\tif (defaultCheckedModule) {\n\t\tawait update('default_encryption_module', defaultCheckedModule)\n\t}\n}\n\n/**\n * Enable encryption - sends an async POST request\n */\nasync function enableEncryption(): Promise<void> {\n\tencryptionEnabled.value = await update('encryption_enabled', 'yes')\n}\n<\/script>\n\n<template>\n\t<NcSettingsSection :name=\"t('settings', 'Server-side encryption')\"\n\t\t:description=\"t('settings', 'Server-side encryption makes it possible to encrypt files which are uploaded to this server. This comes with limitations like a performance penalty, so enable this only if needed.')\"\n\t\t:doc-url=\"encryptionAdminDoc\">\n\t\t<NcNoteCard v-if=\"encryptionEnabled\" type=\"info\">\n\t\t\t<p>\n\t\t\t\t{{ textExistingFilesNotEncrypted }}\n\t\t\t\t{{ t('settings', 'To encrypt all existing files run this OCC command:') }}\n\t\t\t</p>\n\t\t\t<code>\n\t\t\t\t<pre>occ encryption:encrypt-all</pre>\n\t\t\t</code>\n\t\t</NcNoteCard>\n\n\t\t<NcCheckboxRadioSwitch :class=\"{ disabled: encryptionEnabled }\"\n\t\t\t:checked=\"encryptionEnabled\"\n\t\t\t:aria-disabled=\"encryptionEnabled ? 'true' : undefined\"\n\t\t\t:aria-describedby=\"encryptionEnabled ? 'server-side-encryption-disable-hint' : undefined\"\n\t\t\t:loading=\"loadingEncryptionState\"\n\t\t\ttype=\"switch\"\n\t\t\t@update:checked=\"displayWarning\">\n\t\t\t{{ t('settings', 'Enable server-side encryption') }}\n\t\t</NcCheckboxRadioSwitch>\n\t\t<p v-if=\"encryptionEnabled\" id=\"server-side-encryption-disable-hint\" class=\"disable-hint\">\n\t\t\t{{ t('settings', 'Disabling server side encryption is only possible using OCC, please refer to the documentation.') }}\n\t\t</p>\n\n\t\t<NcNoteCard v-if=\"encryptionModules.length === 0\"\n\t\t\ttype=\"warning\"\n\t\t\t:text=\"t('settings', 'No encryption module loaded, please enable an encryption module in the app menu.')\" />\n\n\t\t<template v-else-if=\"encryptionEnabled\">\n\t\t\t<div v-if=\"encryptionReady && encryptionModules.length > 0\">\n\t\t\t\t<h3>{{ t('settings', 'Select default encryption module:') }}</h3>\n\t\t\t\t<fieldset>\n\t\t\t\t\t<NcCheckboxRadioSwitch v-for=\"module in encryptionModules\"\n\t\t\t\t\t\t:key=\"module.id\"\n\t\t\t\t\t\t:checked.sync=\"defaultCheckedModule\"\n\t\t\t\t\t\t:value=\"module.id\"\n\t\t\t\t\t\ttype=\"radio\"\n\t\t\t\t\t\tname=\"default_encryption_module\"\n\t\t\t\t\t\t@update:checked=\"checkDefaultModule\">\n\t\t\t\t\t\t{{ module.displayName }}\n\t\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t\t</fieldset>\n\t\t\t</div>\n\n\t\t\t<div v-else-if=\"externalBackendsEnabled\">\n\t\t\t\t{{\n\t\t\t\t\tt(\n\t\t\t\t\t\t'settings',\n\t\t\t\t\t\t'You need to migrate your encryption keys from the old encryption (ownCloud <= 8.0) to the new one. Please enable the \"Default encryption module\" and run {command}',\n\t\t\t\t\t\t{ command: '\"occ encryption:migrate\"' },\n\t\t\t\t\t)\n\t\t\t\t}}\n\t\t\t</div>\n\t\t</template>\n\t</NcSettingsSection>\n</template>\n\n<style scoped>\ncode {\n\tbackground-color: var(--color-background-dark);\n\tcolor: var(--color-main-text);\n\n\tdisplay: block;\n\tmargin-block-start: 0.5rem;\n\tpadding: .25lh .5lh;\n\twidth: fit-content;\n}\n\n.disabled {\n\topacity: .75;\n}\n\n.disabled :deep(*) {\n\tcursor: not-allowed !important;\n}\n\n.disable-hint {\n\tcolor: var(--color-text-maxcontrast);\n\tpadding-inline-start: 10px;\n}\n</style>\n"],sourceRoot:""}]);const a=s},63375:(t,e,n)=>{var o=n(55765);t.exports=function(t){return t&&t.length?o(t):[]}},67684:(t,e,n)=>{"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\nli[data-v-2565ca49] {\n\tlist-style-type: initial;\n\tmargin-inline-start: 1rem;\n\tpadding: 0.25rem 0;\n}\np + p[data-v-2565ca49],\ndiv + p[data-v-2565ca49] {\n\tmargin-block: 0.75rem;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/Encryption/EncryptionWarningDialog.vue"],names:[],mappings:";AA6EA;CACA,wBAAA;CACA,yBAAA;CACA,kBAAA;AACA;AAEA;;CAEA,qBAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2025 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<script setup lang=\"ts\">\nimport type { IDialogButton } from '@nextcloud/dialogs'\n\nimport { t } from '@nextcloud/l10n'\nimport { textExistingFilesNotEncrypted } from './sharedTexts.ts'\nimport NcDialog from '@nextcloud/vue/dist/Components/NcDialog.js'\nimport NcNoteCard from '@nextcloud/vue/dist/Components/NcNoteCard.js'\n\nconst emit = defineEmits<{\n\t(e: 'close', encrypt: boolean): void\n}>()\n\nconst buttons: IDialogButton[] = [\n\t{\n\t\tlabel: t('settings', 'Cancel encryption'),\n\t\t// @ts-expect-error Needs to be fixed in the dialogs library - value is allowed but missing from the types\n\t\ttype: 'tertiary',\n\t\tcallback: () => emit('close', false),\n\t},\n\t{\n\t\tlabel: t('settings', 'Enable encryption'),\n\t\ttype: 'error',\n\t\tcallback: () => emit('close', true),\n\t},\n]\n\n/**\n * When closed we need to emit the close event\n * @param isOpen open state of the dialog\n */\nfunction onUpdateOpen(isOpen: boolean) {\n\tif (!isOpen) {\n\t\temit('close', false)\n\t}\n}\n<\/script>\n\n<template>\n\t<NcDialog :buttons=\"buttons\"\n\t\t:name=\"t('settings', 'Confirm enabling encryption')\"\n\t\tsize=\"normal\"\n\t\t@update:open=\"onUpdateOpen\">\n\t\t<NcNoteCard type=\"warning\">\n\t\t\t<p>\n\t\t\t\t{{ t('settings', 'Please read carefully before activating server-side encryption:') }}\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t{{ t('settings', 'Once encryption is enabled, all files uploaded to the server from that point forward will be encrypted at rest on the server. It will only be possible to disable encryption at a later date if the active encryption module supports that function, and all pre-conditions (e.g. setting a recover key) are met.') }}\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t{{ t('settings', 'Encryption alone does not guarantee security of the system. Please see documentation for more information about how the encryption app works, and the supported use cases.') }}\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t{{ t('settings', 'Be aware that encryption always increases the file size.') }}\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t{{ t('settings', 'It is always good to create regular backups of your data, in case of encryption make sure to backup the encryption keys along with your data.') }}\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t{{ textExistingFilesNotEncrypted }}\n\t\t\t\t\t\t{{ t('settings', 'Refer to the admin documentation on how to manually also encrypt existing files.') }}\n\t\t\t\t\t</li>\n\t\t\t\t</ul>\n\t\t\t</p>\n\t\t</NcNoteCard>\n\t\t<p>\n\t\t\t{{ t('settings', 'This is the final warning: Do you really want to enable encryption?') }}\n\t\t</p>\n\t</NcDialog>\n</template>\n\n<style scoped>\nli {\n\tlist-style-type: initial;\n\tmargin-inline-start: 1rem;\n\tpadding: 0.25rem 0;\n}\n\np + p,\ndiv + p {\n\tmargin-block: 0.75rem;\n}\n</style>\n"],sourceRoot:""}]);const a=s},73054:(t,e,n)=>{var o=n(18024);t.exports=function(t){return t&&t.length?o(t):[]}},93295:(e,n,o)=>{"use strict";var r=o(32981),i=o(85471),s=o(65043),a=o(67607),c=o(97012),l=o(32073),d=o(88837),p=o(73054),u=o.n(p),f=o(63375),g=o.n(f),m=o(38221),h=o.n(m),y=o(63814);const v={name:"AdminTwoFactor",components:{NcSelect:a.A,NcButton:c.A,NcCheckboxRadioSwitch:l.A,NcSettingsSection:d.A},data:()=>({loading:!1,dirty:!1,groups:[],loadingGroups:!1,twoFactorAdminDoc:(0,r.C)("settings","two-factor-admin-doc")}),computed:{enforced:{get(){return this.$store.state.enforced},set(t){this.dirty=!0,this.$store.commit("setEnforced",t)}},enforcedGroups:{get(){return this.$store.state.enforcedGroups},set(t){this.dirty=!0,this.$store.commit("setEnforcedGroups",t)}},excludedGroups:{get(){return this.$store.state.excludedGroups},set(t){this.dirty=!0,this.$store.commit("setExcludedGroups",t)}}},mounted(){this.groups=u()(g()(this.enforcedGroups.concat(this.excludedGroups))),this.searchGroup("")},methods:{searchGroup:h()((function(t){this.loadingGroups=!0,s.Ay.get((0,y.KT)("cloud/groups?offset=0&search={query}&limit=20",{query:t})).then((t=>t.data.ocs)).then((t=>t.data.groups)).then((t=>{this.groups=u()(g()(this.groups.concat(t)))})).catch((t=>console.error("could not search groups",t))).then((()=>{this.loadingGroups=!1}))}),500),saveChanges(){this.loading=!0;const t={enforced:this.enforced,enforcedGroups:this.enforcedGroups,excludedGroups:this.excludedGroups};s.Ay.put((0,y.Jv)("/settings/api/admin/twofactorauth"),t).then((t=>t.data)).then((t=>{this.state=t,this.dirty=!1})).catch((t=>{console.error("could not save changes",t)})).then((()=>{this.loading=!1}))}}};var b=o(85072),A=o.n(b),w=o(97825),x=o.n(w),C=o(77659),k=o.n(C),E=o(55056),_=o.n(E),N=o(10540),S=o.n(N),G=o(41113),T=o.n(G),O=o(21477),D={};D.styleTagTransform=T(),D.setAttributes=_(),D.insert=k().bind(null,"head"),D.domAPI=x(),D.insertStyleElement=S(),A()(O.A,D),O.A&&O.A.locals&&O.A.locals;var P=o(14486);const M=(0,P.A)(v,(function(){var t=this,e=t._self._c;return e("NcSettingsSection",{attrs:{name:t.t("settings","Two-Factor Authentication"),description:t.t("settings","Two-factor authentication can be enforced for all accounts and specific groups. If they do not have a two-factor provider configured, they will be unable to log into the system."),"doc-url":t.twoFactorAdminDoc}},[t.loading?e("p",[e("span",{staticClass:"icon-loading-small two-factor-loading"}),t._v(" "),e("span",[t._v(t._s(t.t("settings","Enforce two-factor authentication")))])]):e("NcCheckboxRadioSwitch",{attrs:{id:"two-factor-enforced",checked:t.enforced,type:"switch"},on:{"update:checked":function(e){t.enforced=e}}},[t._v("\n\t\t"+t._s(t.t("settings","Enforce two-factor authentication"))+"\n\t")]),t._v(" "),t.enforced?[e("h3",[t._v(t._s(t.t("settings","Limit to groups")))]),t._v("\n\t\t"+t._s(t.t("settings","Enforcement of two-factor authentication can be set for certain groups only."))+"\n\t\t"),e("p",{staticClass:"top-margin"},[t._v("\n\t\t\t"+t._s(t.t("settings","Two-factor authentication is enforced for all members of the following groups."))+"\n\t\t")]),t._v(" "),e("p",[e("label",{attrs:{for:"enforcedGroups"}},[e("span",[t._v(t._s(t.t("settings","Enforced groups")))])]),t._v(" "),e("NcSelect",{attrs:{"input-id":"enforcedGroups",options:t.groups,disabled:t.loading,multiple:!0,loading:t.loadingGroups,"close-on-select":!1},on:{search:t.searchGroup},model:{value:t.enforcedGroups,callback:function(e){t.enforcedGroups=e},expression:"enforcedGroups"}})],1),t._v(" "),e("p",{staticClass:"top-margin"},[t._v("\n\t\t\t"+t._s(t.t("settings","Two-factor authentication is not enforced for members of the following groups."))+"\n\t\t")]),t._v(" "),e("p",[e("label",{attrs:{for:"excludedGroups"}},[e("span",[t._v(t._s(t.t("settings","Excluded groups")))])]),t._v(" "),e("NcSelect",{attrs:{"input-id":"excludedGroups",options:t.groups,disabled:t.loading,multiple:!0,loading:t.loadingGroups,"close-on-select":!1},on:{search:t.searchGroup},model:{value:t.excludedGroups,callback:function(e){t.excludedGroups=e},expression:"excludedGroups"}})],1),t._v(" "),e("p",{staticClass:"top-margin"},[e("em",[t._v("\n\t\t\t\t"+t._s(t.t("settings","When groups are selected/excluded, they use the following logic to determine if an account has 2FA enforced: If no groups are selected, 2FA is enabled for everyone except members of the excluded groups. If groups are selected, 2FA is enabled for all members of these. If an account is both in a selected and excluded group, the selected takes precedence and 2FA is enforced."))+"\n\t\t\t")])])]:t._e(),t._v(" "),e("p",{staticClass:"top-margin"},[t.dirty?e("NcButton",{attrs:{type:"primary",disabled:t.loading},on:{click:t.saveChanges}},[t._v("\n\t\t\t"+t._s(t.t("settings","Save changes"))+"\n\t\t")]):t._e()],1)],2)}),[],!1,null,"086a272a",null).exports;var R=o(85168),B=o(53334),F=o(56760);const I=(0,B.t)("settings","For performance reasons, when you enable encryption on a Nextcloud server only new and changed files are encrypted."),j=(0,o(35947).YK)().setApp("settings").detectUser().build();var U=o(40083),q=o(94219);const $=(0,i.pM)({__name:"EncryptionWarningDialog",emits:["close"],setup(t,e){let{emit:n}=e;const o=[{label:(0,B.t)("settings","Cancel encryption"),type:"tertiary",callback:()=>n("close",!1)},{label:(0,B.t)("settings","Enable encryption"),type:"error",callback:()=>n("close",!0)}];return{__sfc:!0,emit:n,buttons:o,onUpdateOpen:function(t){t||n("close",!1)},t:B.t,textExistingFilesNotEncrypted:I,NcDialog:q.A,NcNoteCard:U.A}}});var W=o(67684),L={};L.styleTagTransform=T(),L.setAttributes=_(),L.insert=k().bind(null,"head"),L.domAPI=x(),L.insertStyleElement=S(),A()(W.A,L),W.A&&W.A.locals&&W.A.locals;const K=(0,P.A)($,(function(){var t=this,e=t._self._c,n=t._self._setupProxy;return e(n.NcDialog,{attrs:{buttons:n.buttons,name:n.t("settings","Confirm enabling encryption"),size:"normal"},on:{"update:open":n.onUpdateOpen}},[e(n.NcNoteCard,{attrs:{type:"warning"}},[e("p",[t._v("\n\t\t\t"+t._s(n.t("settings","Please read carefully before activating server-side encryption:"))+"\n\t\t\t"),e("ul",[e("li",[t._v("\n\t\t\t\t\t"+t._s(n.t("settings","Once encryption is enabled, all files uploaded to the server from that point forward will be encrypted at rest on the server. It will only be possible to disable encryption at a later date if the active encryption module supports that function, and all pre-conditions (e.g. setting a recover key) are met."))+"\n\t\t\t\t")]),t._v(" "),e("li",[t._v("\n\t\t\t\t\t"+t._s(n.t("settings","Encryption alone does not guarantee security of the system. Please see documentation for more information about how the encryption app works, and the supported use cases."))+"\n\t\t\t\t")]),t._v(" "),e("li",[t._v("\n\t\t\t\t\t"+t._s(n.t("settings","Be aware that encryption always increases the file size."))+"\n\t\t\t\t")]),t._v(" "),e("li",[t._v("\n\t\t\t\t\t"+t._s(n.t("settings","It is always good to create regular backups of your data, in case of encryption make sure to backup the encryption keys along with your data."))+"\n\t\t\t\t")]),t._v(" "),e("li",[t._v("\n\t\t\t\t\t"+t._s(n.textExistingFilesNotEncrypted)+"\n\t\t\t\t\t"+t._s(n.t("settings","Refer to the admin documentation on how to manually also encrypt existing files."))+"\n\t\t\t\t")])])])]),t._v(" "),e("p",[t._v("\n\t\t"+t._s(n.t("settings","This is the final warning: Do you really want to enable encryption?"))+"\n\t")])],1)}),[],!1,null,"2565ca49",null).exports,X=(0,i.pM)({__name:"EncryptionSettings",setup(t){const e=(0,r.C)("settings","encryption-modules"),n=Array.isArray(e)?[]:Object.entries(e).map((t=>{let[e,n]=t;return{...n,id:e}})),o=n.find((t=>t.default))?.id,a=(0,r.C)("settings","encryption-ready"),c=(0,r.C)("settings","external-backends-enabled"),p=(0,r.C)("settings","encryption-admin-doc"),u=(0,i.KR)((0,r.C)("settings","encryption-enabled")),f=(0,i.KR)(!1);async function g(t,e){await(0,F.C5)();const n=(0,y.KT)("/apps/provisioning_api/api/v1/config/apps/{appId}/{key}",{appId:"core",key:t});try{const{data:t}=await s.Ay.post(n,{value:e});if("ok"!==t.ocs.meta.status)throw new Error("Unsuccessful OCS response",{cause:t.ocs})}catch(t){return(0,R.Qg)((0,B.t)("settings","Unable to update server side encryption config")),j.error("Unable to update server side encryption config",{error:t}),!1}return!0}async function m(){u.value=await g("encryption_enabled","yes")}return{__sfc:!0,allEncryptionModules:e,encryptionModules:n,defaultCheckedModule:o,encryptionReady:a,externalBackendsEnabled:c,encryptionAdminDoc:p,encryptionEnabled:u,loadingEncryptionState:f,displayWarning:function(t){f.value||!1===t||(f.value=!0,(0,R.Ss)(K,{},(async t=>{try{t&&await m()}finally{f.value=!1}})))},update:g,checkDefaultModule:async function(){o&&await g("default_encryption_module",o)},enableEncryption:m,t:B.t,textExistingFilesNotEncrypted:I,NcCheckboxRadioSwitch:l.A,NcNoteCard:U.A,NcSettingsSection:d.A}}});var z=o(58671),Y={};Y.styleTagTransform=T(),Y.setAttributes=_(),Y.insert=k().bind(null,"head"),Y.domAPI=x(),Y.insertStyleElement=S(),A()(z.A,Y),z.A&&z.A.locals&&z.A.locals;const H=(0,P.A)(X,(function(){var t=this,e=t._self._c,n=t._self._setupProxy;return e(n.NcSettingsSection,{attrs:{name:n.t("settings","Server-side encryption"),description:n.t("settings","Server-side encryption makes it possible to encrypt files which are uploaded to this server. This comes with limitations like a performance penalty, so enable this only if needed."),"doc-url":n.encryptionAdminDoc}},[n.encryptionEnabled?e(n.NcNoteCard,{attrs:{type:"info"}},[e("p",[t._v("\n\t\t\t"+t._s(n.textExistingFilesNotEncrypted)+"\n\t\t\t"+t._s(n.t("settings","To encrypt all existing files run this OCC command:"))+"\n\t\t")]),t._v(" "),e("code",[e("pre",[t._v("occ encryption:encrypt-all")])])]):t._e(),t._v(" "),e(n.NcCheckboxRadioSwitch,{class:{disabled:n.encryptionEnabled},attrs:{checked:n.encryptionEnabled,"aria-disabled":n.encryptionEnabled?"true":void 0,"aria-describedby":n.encryptionEnabled?"server-side-encryption-disable-hint":void 0,loading:n.loadingEncryptionState,type:"switch"},on:{"update:checked":n.displayWarning}},[t._v("\n\t\t"+t._s(n.t("settings","Enable server-side encryption"))+"\n\t")]),t._v(" "),n.encryptionEnabled?e("p",{staticClass:"disable-hint",attrs:{id:"server-side-encryption-disable-hint"}},[t._v("\n\t\t"+t._s(n.t("settings","Disabling server side encryption is only possible using OCC, please refer to the documentation."))+"\n\t")]):t._e(),t._v(" "),0===n.encryptionModules.length?e(n.NcNoteCard,{attrs:{type:"warning",text:n.t("settings","No encryption module loaded, please enable an encryption module in the app menu.")}}):n.encryptionEnabled?[n.encryptionReady&&n.encryptionModules.length>0?e("div",[e("h3",[t._v(t._s(n.t("settings","Select default encryption module:")))]),t._v(" "),e("fieldset",t._l(n.encryptionModules,(function(o){return e(n.NcCheckboxRadioSwitch,{key:o.id,attrs:{checked:n.defaultCheckedModule,value:o.id,type:"radio",name:"default_encryption_module"},on:{"update:checked":[function(t){n.defaultCheckedModule=t},n.checkDefaultModule]}},[t._v("\n\t\t\t\t\t"+t._s(o.displayName)+"\n\t\t\t\t")])})),1)]):n.externalBackendsEnabled?e("div",[t._v("\n\t\t\t"+t._s(n.t("settings",'You need to migrate your encryption keys from the old encryption (ownCloud <= 8.0) to the new one. Please enable the "Default encryption module" and run {command}',{command:'"occ encryption:migrate"'}))+"\n\t\t")]):t._e()]:t._e()],2)}),[],!1,null,"641ed214",null).exports;var J=o(95353);i.Ay.use(J.Ay);const Q={setEnforced(t,e){i.Ay.set(t,"enforced",e)},setEnforcedGroups(t,e){i.Ay.set(t,"enforcedGroups",e)},setExcludedGroups(t,e){i.Ay.set(t,"excludedGroups",e)}},V=new J.il({strict:!1,state:{enforced:!1,enforcedGroups:[],excludedGroups:[]},mutations:Q});o.nc=btoa(OC.requestToken),i.Ay.prototype.t=t,window.OC=window.OC||{},window.OC.Settings=window.OC.Settings||{},V.replaceState((0,r.C)("settings","mandatory2FAState")),new(i.Ay.extend(M))({store:V}).$mount("#two-factor-auth-settings"),(new(i.Ay.extend(H))).$mount("#vue-admin-encryption")}},i={};function s(t){var e=i[t];if(void 0!==e)return e.exports;var n=i[t]={id:t,loaded:!1,exports:{}};return r[t].call(n.exports,n,n.exports,s),n.loaded=!0,n.exports}s.m=r,e=[],s.O=(t,n,o,r)=>{if(!n){var i=1/0;for(d=0;d<e.length;d++){n=e[d][0],o=e[d][1],r=e[d][2];for(var a=!0,c=0;c<n.length;c++)(!1&r||i>=r)&&Object.keys(s.O).every((t=>s.O[t](n[c])))?n.splice(c--,1):(a=!1,r<i&&(i=r));if(a){e.splice(d--,1);var l=o();void 0!==l&&(t=l)}}return t}r=r||0;for(var d=e.length;d>0&&e[d-1][2]>r;d--)e[d]=e[d-1];e[d]=[n,o,r]},s.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return s.d(e,{a:e}),e},s.d=(t,e)=>{for(var n in e)s.o(e,n)&&!s.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},s.f={},s.e=t=>Promise.all(Object.keys(s.f).reduce(((e,n)=>(s.f[n](t,e),e)),[])),s.u=t=>t+"-"+t+".js?v="+{640:"19a5506f19df079e3812",2983:"376e7eedfbb595bb39c4",5771:"a4e2a98efcfb7393c5bd"}[t],s.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),s.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),n={},o="nextcloud:",s.l=(t,e,r,i)=>{if(n[t])n[t].push(e);else{var a,c;if(void 0!==r)for(var l=document.getElementsByTagName("script"),d=0;d<l.length;d++){var p=l[d];if(p.getAttribute("src")==t||p.getAttribute("data-webpack")==o+r){a=p;break}}a||(c=!0,(a=document.createElement("script")).charset="utf-8",a.timeout=120,s.nc&&a.setAttribute("nonce",s.nc),a.setAttribute("data-webpack",o+r),a.src=t),n[t]=[e];var u=(e,o)=>{a.onerror=a.onload=null,clearTimeout(f);var r=n[t];if(delete n[t],a.parentNode&&a.parentNode.removeChild(a),r&&r.forEach((t=>t(o))),e)return e(o)},f=setTimeout(u.bind(null,void 0,{type:"timeout",target:a}),12e4);a.onerror=u.bind(null,a.onerror),a.onload=u.bind(null,a.onload),c&&document.head.appendChild(a)}},s.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},s.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),s.j=7584,(()=>{var t;s.g.importScripts&&(t=s.g.location+"");var e=s.g.document;if(!t&&e&&(e.currentScript&&"SCRIPT"===e.currentScript.tagName.toUpperCase()&&(t=e.currentScript.src),!t)){var n=e.getElementsByTagName("script");if(n.length)for(var o=n.length-1;o>-1&&(!t||!/^http(s?):/.test(t));)t=n[o--].src}if(!t)throw new Error("Automatic publicPath is not supported in this browser");t=t.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),s.p=t})(),(()=>{s.b=document.baseURI||self.location.href;var t={7584:0};s.f.j=(e,n)=>{var o=s.o(t,e)?t[e]:void 0;if(0!==o)if(o)n.push(o[2]);else{var r=new Promise(((n,r)=>o=t[e]=[n,r]));n.push(o[2]=r);var i=s.p+s.u(e),a=new Error;s.l(i,(n=>{if(s.o(t,e)&&(0!==(o=t[e])&&(t[e]=void 0),o)){var r=n&&("load"===n.type?"missing":n.type),i=n&&n.target&&n.target.src;a.message="Loading chunk "+e+" failed.\n("+r+": "+i+")",a.name="ChunkLoadError",a.type=r,a.request=i,o[1](a)}}),"chunk-"+e,e)}},s.O.j=e=>0===t[e];var e=(e,n)=>{var o,r,i=n[0],a=n[1],c=n[2],l=0;if(i.some((e=>0!==t[e]))){for(o in a)s.o(a,o)&&(s.m[o]=a[o]);if(c)var d=c(s)}for(e&&e(n);l<i.length;l++)r=i[l],s.o(t,r)&&t[r]&&t[r][0](),t[r]=0;return s.O(d)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),s.nc=void 0;var a=s.O(void 0,[4208],(()=>s(93295)));a=s.O(a)})();
//# sourceMappingURL=settings-vue-settings-admin-security.js.map?v=bdacbc33a3d1abb3fbec