/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.coyote.ActionCode;
import org.apache.coyote.BadRequestException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.parser.HttpHeaderParser;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class ChunkedInputFilter
implements InputFilter,
ApplicationBufferHandler,
HttpHeaderParser.HeaderDataSource {
    private static final StringManager sm = StringManager.getManager(ChunkedInputFilter.class);
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected ByteBuffer readChunk;
    protected final ByteBuffer trailingHeaders;
    private final Request request;
    private final long maxExtensionSize;
    private final int maxSwallowSize;
    private final Set<String> allowedTrailerHeaders;
    private volatile ParseState parseState = ParseState.CHUNK_HEADER;
    private volatile boolean crFound = false;
    private volatile int chunkSizeDigitsRead = 0;
    private volatile boolean parsingExtension = false;
    private volatile long extensionSize;
    private final HttpHeaderParser httpHeaderParser;

    public ChunkedInputFilter(Request request, int maxTrailerSize, Set<String> allowedTrailerHeaders, int maxExtensionSize, int maxSwallowSize) {
        this.request = request;
        this.trailingHeaders = ByteBuffer.allocate(maxTrailerSize);
        this.trailingHeaders.limit(0);
        this.allowedTrailerHeaders = allowedTrailerHeaders;
        this.maxExtensionSize = maxExtensionSize;
        this.maxSwallowSize = maxSwallowSize;
        this.httpHeaderParser = new HttpHeaderParser(this, request.getMimeTrailerFields(), false);
    }

    @Override
    public int doRead(ApplicationBufferHandler handler) throws IOException {
        block7: while (true) {
            switch (this.parseState.ordinal()) {
                case 0: {
                    if (this.parseChunkHeader()) continue block7;
                    return 0;
                }
                case 1: {
                    return this.parseChunkBody(handler);
                }
                case 2: {
                    if (!this.parseCRLF()) {
                        return 0;
                    }
                    this.parseState = ParseState.CHUNK_HEADER;
                    continue block7;
                }
                case 3: {
                    if (!this.parseTrailerFields()) {
                        return 0;
                    }
                    return -1;
                }
                case 4: {
                    return -1;
                }
            }
            break;
        }
        throw new IOException(sm.getString("chunkedInputFilter.error"));
    }

    @Override
    public void setRequest(Request request) {
    }

    @Override
    public long end() throws IOException {
        int read;
        long swallowed = 0L;
        while ((read = this.doRead(this)) >= 0) {
            if (this.maxSwallowSize <= -1 || (swallowed += (long)read) <= (long)this.maxSwallowSize) continue;
            this.throwBadRequestException(sm.getString("inputFilter.maxSwallow"));
        }
        if (this.trailingHeaders.remaining() > 0) {
            this.readChunk.position(this.readChunk.position() - this.trailingHeaders.remaining());
        }
        return this.readChunk.remaining();
    }

    @Override
    public int available() {
        int available = 0;
        if (this.readChunk != null) {
            available = this.readChunk.remaining();
        }
        if (available > 2 && (this.parseState == ParseState.CHUNK_BODY_CRLF || this.parseState == ParseState.CHUNK_HEADER)) {
            if (this.parseState == ParseState.CHUNK_BODY_CRLF && this.skipCRLF()) {
                this.parseState = ParseState.CHUNK_HEADER;
            }
            if (this.parseState == ParseState.CHUNK_HEADER) {
                this.skipChunkHeader();
            }
            available = this.readChunk.remaining();
        }
        if (available == 1 && this.parseState == ParseState.CHUNK_BODY_CRLF) {
            this.skipCRLF();
            available = this.readChunk.remaining();
        } else if (available == 2 && !this.crFound && this.parseState == ParseState.CHUNK_BODY_CRLF) {
            if (this.skipCRLF()) {
                this.parseState = ParseState.CHUNK_HEADER;
            }
            available = this.readChunk.remaining();
        }
        if (available == 0) {
            return this.buffer.available();
        }
        return available;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        if (this.readChunk != null) {
            this.readChunk.position(0).limit(0);
        }
        this.trailingHeaders.clear();
        this.trailingHeaders.limit(0);
        this.parseState = ParseState.CHUNK_HEADER;
        this.crFound = false;
        this.chunkSizeDigitsRead = 0;
        this.parsingExtension = false;
        this.extensionSize = 0L;
        this.httpHeaderParser.recycle();
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    @Override
    public boolean isFinished() {
        return this.parseState == ParseState.FINISHED;
    }

    protected int readBytes() throws IOException {
        return this.buffer.doRead(this);
    }

    @Override
    public boolean fillHeaderBuffer() throws IOException {
        if (this.fill()) {
            if (this.trailingHeaders.position() == this.trailingHeaders.capacity()) {
                throw new BadRequestException(sm.getString("chunkedInputFilter.maxTrailer"));
            }
            int originalPos = this.trailingHeaders.position();
            this.trailingHeaders.position(this.trailingHeaders.limit());
            this.trailingHeaders.limit(this.trailingHeaders.capacity());
            if (this.readChunk.remaining() > this.trailingHeaders.remaining()) {
                int originalLimit = this.readChunk.limit();
                this.readChunk.limit(this.readChunk.position() + this.trailingHeaders.remaining());
                this.trailingHeaders.put(this.readChunk);
                this.readChunk.limit(originalLimit);
            } else {
                this.trailingHeaders.put(this.readChunk);
            }
            this.trailingHeaders.limit(this.trailingHeaders.position());
            this.trailingHeaders.position(originalPos);
            return true;
        }
        return false;
    }

    private boolean fill() throws IOException {
        if (this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) {
            int read = this.readBytes();
            if (read < 0) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
            } else {
                return read != 0;
            }
        }
        return true;
    }

    private boolean parseChunkHeader() throws IOException {
        boolean eol = false;
        while (!eol) {
            if (!this.fill()) {
                return false;
            }
            byte chr = this.readChunk.get(this.readChunk.position());
            if (chr == 13 || chr == 10) {
                this.parsingExtension = false;
                if (!this.parseCRLF()) {
                    return false;
                }
                eol = true;
            } else if (chr == 59 && !this.parsingExtension) {
                this.parsingExtension = true;
                ++this.extensionSize;
            } else if (!this.parsingExtension) {
                int charValue = HexUtils.getDec((int)chr);
                if (charValue != -1 && this.chunkSizeDigitsRead < 8) {
                    ++this.chunkSizeDigitsRead;
                    this.remaining = this.remaining << 4 | charValue;
                } else {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
                }
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.maxExtension"));
                }
            }
            if (eol) continue;
            this.readChunk.position(this.readChunk.position() + 1);
        }
        if (this.chunkSizeDigitsRead == 0 || this.remaining < 0) {
            this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
        } else {
            this.chunkSizeDigitsRead = 0;
        }
        this.parseState = this.remaining == 0 ? ParseState.TRAILER_FIELDS : ParseState.CHUNK_BODY;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean skipChunkHeader() {
        boolean eol = false;
        while (!eol) {
            if (this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) {
                return false;
            }
            byte chr = this.readChunk.get(this.readChunk.position());
            if (chr == 13 || chr == 10) {
                this.parsingExtension = false;
                if (!this.skipCRLF()) {
                    return false;
                }
                eol = true;
            } else if (chr == 59 && !this.parsingExtension) {
                this.parsingExtension = true;
                ++this.extensionSize;
            } else if (!this.parsingExtension) {
                int charValue = HexUtils.getDec((int)chr);
                if (charValue == -1 || this.chunkSizeDigitsRead >= 8) return false;
                ++this.chunkSizeDigitsRead;
                this.remaining = this.remaining << 4 | charValue;
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    return false;
                }
            }
            if (eol) continue;
            this.readChunk.position(this.readChunk.position() + 1);
        }
        if (this.chunkSizeDigitsRead == 0 || this.remaining < 0) {
            return false;
        }
        this.chunkSizeDigitsRead = 0;
        this.parseState = this.remaining == 0 ? ParseState.TRAILER_FIELDS : ParseState.CHUNK_BODY;
        return true;
    }

    private int parseChunkBody(ApplicationBufferHandler handler) throws IOException {
        int result;
        if (!this.fill()) {
            return 0;
        }
        if (this.remaining > this.readChunk.remaining()) {
            result = this.readChunk.remaining();
            this.remaining -= result;
            if (this.readChunk != handler.getByteBuffer()) {
                handler.setByteBuffer(this.readChunk.duplicate());
            }
            this.readChunk.position(this.readChunk.limit());
        } else {
            result = this.remaining;
            if (this.readChunk != handler.getByteBuffer()) {
                handler.setByteBuffer(this.readChunk.duplicate());
                handler.getByteBuffer().limit(this.readChunk.position() + this.remaining);
            }
            this.readChunk.position(this.readChunk.position() + this.remaining);
            this.remaining = 0;
            this.parseState = ParseState.CHUNK_BODY_CRLF;
        }
        return result;
    }

    private boolean parseCRLF() throws IOException {
        boolean eol = false;
        while (!eol) {
            if (!this.fill()) {
                return false;
            }
            byte chr = this.readChunk.get(this.readChunk.position());
            if (chr == 13) {
                if (this.crFound) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfCRCR"));
                }
                this.crFound = true;
            } else if (chr == 10) {
                if (!this.crFound) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfNoCR"));
                }
                eol = true;
            } else {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlf"));
            }
            this.readChunk.position(this.readChunk.position() + 1);
        }
        this.crFound = false;
        return true;
    }

    private boolean skipCRLF() {
        boolean eol = false;
        while (!eol) {
            if (this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) {
                return false;
            }
            byte chr = this.readChunk.get(this.readChunk.position());
            if (chr == 13) {
                if (this.crFound) {
                    return false;
                }
                this.crFound = true;
            } else if (chr == 10) {
                if (!this.crFound) {
                    return false;
                }
                eol = true;
            } else {
                return false;
            }
            this.readChunk.position(this.readChunk.position() + 1);
        }
        this.crFound = false;
        return true;
    }

    private boolean parseTrailerFields() throws IOException {
        HttpHeaderParser.HeaderParseStatus status;
        do {
            try {
                status = this.httpHeaderParser.parseHeader();
            }
            catch (IllegalArgumentException iae) {
                this.parseState = ParseState.ERROR;
                throw new BadRequestException(iae);
            }
        } while (status == HttpHeaderParser.HeaderParseStatus.HAVE_MORE_HEADERS);
        if (status == HttpHeaderParser.HeaderParseStatus.DONE) {
            this.parseState = ParseState.FINISHED;
            this.request.getMimeTrailerFields().filter(this.allowedTrailerHeaders);
            if (this.request.getReadListener() != null) {
                this.request.action(ActionCode.DISPATCH_READ, null);
                this.request.action(ActionCode.DISPATCH_EXECUTE, null);
            }
            return true;
        }
        return false;
    }

    private void throwBadRequestException(String msg) throws IOException {
        this.parseState = ParseState.ERROR;
        throw new BadRequestException(msg);
    }

    @Override
    public void setByteBuffer(ByteBuffer buffer) {
        this.readChunk = buffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.readChunk;
    }

    @Override
    public ByteBuffer getHeaderByteBuffer() {
        return this.trailingHeaders;
    }

    @Override
    public void expand(int size) {
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(StandardCharsets.ISO_8859_1), 0, ENCODING_NAME.length());
    }

    private static enum ParseState {
        CHUNK_HEADER,
        CHUNK_BODY,
        CHUNK_BODY_CRLF,
        TRAILER_FIELDS,
        FINISHED,
        ERROR;

    }
}

