/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.util.Pack;

abstract class GCMUtil {
    GCMUtil() {
    }

    static int[] asInts(byte[] byArray) {
        int[] nArray = new int[]{Pack.bigEndianToInt(byArray, 0), Pack.bigEndianToInt(byArray, 4), Pack.bigEndianToInt(byArray, 8), Pack.bigEndianToInt(byArray, 12)};
        return nArray;
    }

    static void multiplyP(int[] nArray) {
        boolean bl = (nArray[3] & 1) != 0;
        GCMUtil.shiftRight(nArray);
        if (bl) {
            nArray[0] = nArray[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] nArray) {
        for (int i = 8; i != 0; --i) {
            GCMUtil.multiplyP(nArray);
        }
    }

    static void shiftRight(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3 = byArray[n] & 0xFF;
            byArray[n] = (byte)(n3 >>> 1 | n2);
            if (++n == 16) break;
            n2 = (n3 & 1) << 7;
        }
    }

    static void shiftRight(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3 = nArray[n];
            nArray[n] = n3 >>> 1 | n2;
            if (++n == 4) break;
            n2 = n3 << 31;
        }
    }

    static void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    static void xor(int[] nArray, int[] nArray2) {
        for (int i = 3; i >= 0; --i) {
            int n = i;
            nArray[n] = nArray[n] ^ nArray2[i];
        }
    }
}

