/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.repo.RelativeURLRepository;
import org.apache.ivy.plugins.repository.url.ChainedRepository;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.util.Message;

public class MirroredURLResolver
extends RepositoryResolver {
    private URL mirrorListUrl;

    public MirroredURLResolver() {
        this.setRepository(new ChainedRepository());
    }

    public void setMirrorListUrl(URL mirrorListUrl) {
        this.mirrorListUrl = mirrorListUrl;
    }

    private void setupMirrors() {
        List mirrorBaseUrls;
        File mirrorListFile = this.downloadMirrorList();
        try {
            mirrorBaseUrls = this.readMirrorList(mirrorListFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("The mirror list could not be read from " + this.mirrorListUrl + " (" + e.getMessage() + ")");
        }
        ArrayList<RelativeURLRepository> repositories = new ArrayList<RelativeURLRepository>();
        Iterator it = mirrorBaseUrls.iterator();
        while (it.hasNext()) {
            String baseUrl = (String)it.next();
            URL url = null;
            try {
                url = new URL(baseUrl);
            }
            catch (MalformedURLException e) {
                Message.warn("In the mirror list from " + this.mirrorListUrl + ", an incorrect url has been found and will then not be used: " + baseUrl);
            }
            if (url == null) continue;
            RelativeURLRepository repo = new RelativeURLRepository(url);
            repositories.add(repo);
        }
        ((ChainedRepository)this.getRepository()).setRepositories(repositories);
    }

    private File downloadMirrorList() {
        URLRepository urlRepository = new URLRepository();
        if (this.getEventManager() != null) {
            urlRepository.addTransferListener(this.getEventManager());
        }
        URLResource mirrorResource = new URLResource(this.mirrorListUrl);
        CacheResourceOptions options = new CacheResourceOptions();
        ArtifactDownloadReport report = this.getRepositoryCacheManager().downloadRepositoryResource(mirrorResource, "mirrorlist", "text", "txt", options, urlRepository);
        return report.getLocalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List readMirrorList(File mirrorListFile) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(mirrorListFile)));
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line = in.readLine();
            while (line != null) {
                list.add(line);
                line = in.readLine();
            }
        }
        finally {
            in.close();
        }
        return list;
    }

    public String getTypeName() {
        return "mirroredurl";
    }

    public void validate() {
        super.validate();
        this.setupMirrors();
    }
}

