/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.SenderInfoBuilder;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.RtpUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0016H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpSrPacketBuilder;", "", "rtcpHeader", "Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "senderInfo", "Lorg/jitsi/rtp/rtcp/SenderInfoBuilder;", "reportBlocks", "", "Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "<init>", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;Lorg/jitsi/rtp/rtcp/SenderInfoBuilder;Ljava/util/List;)V", "getRtcpHeader", "()Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "setRtcpHeader", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;)V", "getSenderInfo", "()Lorg/jitsi/rtp/rtcp/SenderInfoBuilder;", "setSenderInfo", "(Lorg/jitsi/rtp/rtcp/SenderInfoBuilder;)V", "getReportBlocks", "()Ljava/util/List;", "sizeBytes", "", "getSizeBytes", "()I", "build", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "writeTo", "", "buf", "", "offset", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "rtp"})
@SourceDebugExtension(value={"SMAP\nRtcpSrPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpSrPacket.kt\norg/jitsi/rtp/rtcp/RtcpSrPacketBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1#2:237\n1872#3,3:238\n*S KotlinDebug\n*F\n+ 1 RtcpSrPacket.kt\norg/jitsi/rtp/rtcp/RtcpSrPacketBuilder\n*L\n231#1:238,3\n*E\n"})
public final class RtcpSrPacketBuilder {
    @NotNull
    private RtcpHeaderBuilder rtcpHeader;
    @NotNull
    private SenderInfoBuilder senderInfo;
    @NotNull
    private final List<RtcpReportBlock> reportBlocks;

    public RtcpSrPacketBuilder(@NotNull RtcpHeaderBuilder rtcpHeader, @NotNull SenderInfoBuilder senderInfo, @NotNull List<RtcpReportBlock> reportBlocks) {
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        Intrinsics.checkNotNullParameter(senderInfo, "senderInfo");
        Intrinsics.checkNotNullParameter(reportBlocks, "reportBlocks");
        this.rtcpHeader = rtcpHeader;
        this.senderInfo = senderInfo;
        this.reportBlocks = reportBlocks;
        if (!(this.reportBlocks.size() <= 31)) {
            boolean bl = false;
            String string = "Too many report blocks " + this.reportBlocks.size() + ": SR can contain at most 31";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RtcpSrPacketBuilder(RtcpHeaderBuilder rtcpHeaderBuilder, SenderInfoBuilder senderInfoBuilder, List list, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            rtcpHeaderBuilder = new RtcpHeaderBuilder(0, false, 0, 0, 0, 0L, 63, null);
        }
        if ((n & 2) != 0) {
            senderInfoBuilder = new SenderInfoBuilder(0L, 0L, 0L, 0L, 0L, 31, null);
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(rtcpHeaderBuilder, senderInfoBuilder, list);
    }

    @NotNull
    public final RtcpHeaderBuilder getRtcpHeader() {
        return this.rtcpHeader;
    }

    public final void setRtcpHeader(@NotNull RtcpHeaderBuilder rtcpHeaderBuilder) {
        Intrinsics.checkNotNullParameter(rtcpHeaderBuilder, "<set-?>");
        this.rtcpHeader = rtcpHeaderBuilder;
    }

    @NotNull
    public final SenderInfoBuilder getSenderInfo() {
        return this.senderInfo;
    }

    public final void setSenderInfo(@NotNull SenderInfoBuilder senderInfoBuilder) {
        Intrinsics.checkNotNullParameter(senderInfoBuilder, "<set-?>");
        this.senderInfo = senderInfoBuilder;
    }

    @NotNull
    public final List<RtcpReportBlock> getReportBlocks() {
        return this.reportBlocks;
    }

    private final int getSizeBytes() {
        return 28 + this.reportBlocks.size() * 24;
    }

    @NotNull
    public final RtcpSrPacket build() {
        byte[] buf = BufferPool.Companion.getGetArray().invoke(this.getSizeBytes());
        this.writeTo(buf, 0);
        return new RtcpSrPacket(buf, 0, this.getSizeBytes());
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(@NotNull byte[] buf, int offset) {
        RtcpHeaderBuilder rtcpHeaderBuilder;
        Intrinsics.checkNotNullParameter(buf, "buf");
        RtcpHeaderBuilder $this$writeTo_u24lambda_u241 = rtcpHeaderBuilder = this.rtcpHeader;
        boolean bl = false;
        $this$writeTo_u24lambda_u241.setPacketType(200);
        $this$writeTo_u24lambda_u241.setReportCount(this.reportBlocks.size());
        $this$writeTo_u24lambda_u241.setLength(RtpUtils.Companion.calculateRtcpLengthFieldValue(this.getSizeBytes()));
        rtcpHeaderBuilder.writeTo(buf, offset);
        this.senderInfo.writeTo(buf, offset + 8);
        Iterable $this$forEachIndexed$iv = this.reportBlocks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void reportBlock;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RtcpReportBlock rtcpReportBlock = (RtcpReportBlock)item$iv;
            int index = n;
            boolean bl2 = false;
            reportBlock.writeTo(buf, offset + 28 + index * 24);
        }
    }

    @NotNull
    public final RtcpHeaderBuilder component1() {
        return this.rtcpHeader;
    }

    @NotNull
    public final SenderInfoBuilder component2() {
        return this.senderInfo;
    }

    @NotNull
    public final List<RtcpReportBlock> component3() {
        return this.reportBlocks;
    }

    @NotNull
    public final RtcpSrPacketBuilder copy(@NotNull RtcpHeaderBuilder rtcpHeader, @NotNull SenderInfoBuilder senderInfo, @NotNull List<RtcpReportBlock> reportBlocks) {
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        Intrinsics.checkNotNullParameter(senderInfo, "senderInfo");
        Intrinsics.checkNotNullParameter(reportBlocks, "reportBlocks");
        return new RtcpSrPacketBuilder(rtcpHeader, senderInfo, reportBlocks);
    }

    public static /* synthetic */ RtcpSrPacketBuilder copy$default(RtcpSrPacketBuilder rtcpSrPacketBuilder, RtcpHeaderBuilder rtcpHeaderBuilder, SenderInfoBuilder senderInfoBuilder, List list, int n, Object object) {
        if ((n & 1) != 0) {
            rtcpHeaderBuilder = rtcpSrPacketBuilder.rtcpHeader;
        }
        if ((n & 2) != 0) {
            senderInfoBuilder = rtcpSrPacketBuilder.senderInfo;
        }
        if ((n & 4) != 0) {
            list = rtcpSrPacketBuilder.reportBlocks;
        }
        return rtcpSrPacketBuilder.copy(rtcpHeaderBuilder, senderInfoBuilder, list);
    }

    @NotNull
    public String toString() {
        return "RtcpSrPacketBuilder(rtcpHeader=" + this.rtcpHeader + ", senderInfo=" + this.senderInfo + ", reportBlocks=" + this.reportBlocks + ")";
    }

    public int hashCode() {
        int result = this.rtcpHeader.hashCode();
        result = result * 31 + this.senderInfo.hashCode();
        result = result * 31 + ((Object)this.reportBlocks).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RtcpSrPacketBuilder)) {
            return false;
        }
        RtcpSrPacketBuilder rtcpSrPacketBuilder = (RtcpSrPacketBuilder)other;
        if (!Intrinsics.areEqual(this.rtcpHeader, rtcpSrPacketBuilder.rtcpHeader)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.senderInfo, rtcpSrPacketBuilder.senderInfo)) {
            return false;
        }
        return Intrinsics.areEqual(this.reportBlocks, rtcpSrPacketBuilder.reportBlocks);
    }

    public RtcpSrPacketBuilder() {
        this(null, null, null, 7, null);
    }
}

