/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public class IcmpV6MobilePrefixAdvertisementPacket
extends AbstractPacket {
    private static final long serialVersionUID = 7088081805293115326L;
    private final IcmpV6MobilePrefixAdvertisementHeader header;

    public static IcmpV6MobilePrefixAdvertisementPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6MobilePrefixAdvertisementPacket(rawData, offset, length);
    }

    private IcmpV6MobilePrefixAdvertisementPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6MobilePrefixAdvertisementHeader(rawData, offset, length);
    }

    private IcmpV6MobilePrefixAdvertisementPacket(Builder builder2) {
        this.header = new IcmpV6MobilePrefixAdvertisementHeader(builder2);
    }

    @Override
    public IcmpV6MobilePrefixAdvertisementHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6MobilePrefixAdvertisementHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -7395581536162987036L;
        private static final int IDENTIFIER_OFFSET = 0;
        private static final int IDENTIFIER_SIZE = 2;
        private static final int M_O_RESERVED_OFFSET = 2;
        private static final int M_O_RESERVED_SIZE = 2;
        private static final int OPTIONS_OFFSET = 4;
        private final short identifier;
        private final boolean managedAddressConfigurationFlag;
        private final boolean otherStatefulConfigurationFlag;
        private final short reserved;
        private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        private IcmpV6MobilePrefixAdvertisementHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newOne;
            if (length < 4) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The raw data must be more than ").append(3).append("bytes").append(" to build this header. raw data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.identifier = ByteArrays.getShort(rawData, 0 + offset);
            short tmp = ByteArrays.getShort(rawData, 2 + offset);
            this.managedAddressConfigurationFlag = (tmp & 0x8000) != 0;
            this.otherStatefulConfigurationFlag = (tmp & 0x4000) != 0;
            this.reserved = (short)(0x3FFF & tmp);
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();
            for (int currentOffsetInHeader = 4; currentOffsetInHeader < length; currentOffsetInHeader += newOne.length()) {
                IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                try {
                    newOne = PacketFactories.getFactory(IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class, IpV6NeighborDiscoveryOptionType.class).newInstance(rawData, currentOffsetInHeader + offset, length - currentOffsetInHeader, type);
                }
                catch (Exception e) {
                    break;
                }
                this.options.add(newOne);
            }
        }

        private IcmpV6MobilePrefixAdvertisementHeader(Builder builder2) {
            if ((builder2.reserved & 0xC000) != 0) {
                throw new IllegalArgumentException("Invalid reserved: " + builder2.reserved);
            }
            this.identifier = builder2.identifier;
            this.managedAddressConfigurationFlag = builder2.managedAddressConfigurationFlag;
            this.otherStatefulConfigurationFlag = builder2.otherStatefulConfigurationFlag;
            this.reserved = builder2.reserved;
            this.options = builder2.options != null ? new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(builder2.options) : new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(0);
        }

        public short getIdentifier() {
            return this.identifier;
        }

        public int getIdentifierAsInt() {
            return this.identifier & 0xFFFF;
        }

        public boolean getManagedAddressConfigurationFlag() {
            return this.managedAddressConfigurationFlag;
        }

        public boolean getOtherStatefulConfigurationFlag() {
            return this.otherStatefulConfigurationFlag;
        }

        public short getReserved() {
            return this.reserved;
        }

        public List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getOptions() {
            return new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.identifier));
            short tmp = (short)(0x3FFF & this.reserved);
            if (this.managedAddressConfigurationFlag) {
                tmp = (short)(tmp | 0x8000);
            }
            if (this.otherStatefulConfigurationFlag) {
                tmp = (short)(tmp | 0x4000);
            }
            rawFields.add(ByteArrays.toByteArray(tmp));
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                rawFields.add(o.getRawData());
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            int len = 0;
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                len += o.length();
            }
            return len + 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Mobile Prefix Advertisement Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Identifier: ").append(this.getIdentifierAsInt()).append(ls);
            sb.append("  ManagedAddressConfigurationFlag: ").append(this.managedAddressConfigurationFlag).append(ls);
            sb.append("  OtherStatefulConfigurationFlag: ").append(this.otherStatefulConfigurationFlag).append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6MobilePrefixAdvertisementHeader other = (IcmpV6MobilePrefixAdvertisementHeader)obj;
            return this.identifier == other.identifier && this.managedAddressConfigurationFlag == other.managedAddressConfigurationFlag && this.otherStatefulConfigurationFlag == other.otherStatefulConfigurationFlag && this.reserved == other.reserved && this.options.equals(other.options);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.identifier;
            result = 31 * result + (this.managedAddressConfigurationFlag ? 1231 : 1237);
            result = 31 * result + (this.otherStatefulConfigurationFlag ? 1231 : 1237);
            result = 31 * result + this.reserved;
            result = 31 * result + this.options.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private short identifier;
        private boolean managedAddressConfigurationFlag;
        private boolean otherStatefulConfigurationFlag;
        private short reserved;
        private List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        public Builder() {
        }

        private Builder(IcmpV6MobilePrefixAdvertisementPacket packet) {
            this.identifier = packet.header.identifier;
            this.managedAddressConfigurationFlag = packet.header.managedAddressConfigurationFlag;
            this.otherStatefulConfigurationFlag = packet.header.otherStatefulConfigurationFlag;
            this.reserved = packet.header.reserved;
            this.options = packet.header.options;
        }

        public Builder identifier(short identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder managedAddressConfigurationFlag(boolean managedAddressConfigurationFlag) {
            this.managedAddressConfigurationFlag = managedAddressConfigurationFlag;
            return this;
        }

        public Builder otherStatefulConfigurationFlag(boolean otherStatefulConfigurationFlag) {
            this.otherStatefulConfigurationFlag = otherStatefulConfigurationFlag;
            return this;
        }

        public Builder reserved(short reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder options(List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options2) {
            this.options = options2;
            return this;
        }

        @Override
        public IcmpV6MobilePrefixAdvertisementPacket build() {
            return new IcmpV6MobilePrefixAdvertisementPacket(this);
        }
    }
}

