/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.function.Supplier;
import org.keycloak.client.admin.cli.operations.LocalSearch;
import org.keycloak.client.admin.cli.operations.RoleOperations;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.common.util.ObjectUtil;

public class OperationUtils {
    private static final String[] DEFAULT_QUERY_PARAMS = new String[]{"first", "0", "max", "2"};

    public static String getIdForType(String rootUrl, String realm, String auth, String resourceEndpoint, String attrName, String attrValue, String inputAttrName) {
        return OperationUtils.getAttrForType(rootUrl, realm, auth, resourceEndpoint, attrName, attrValue, inputAttrName, "id", null);
    }

    public static String getIdForType(String rootUrl, String realm, String auth, String resourceEndpoint, String attrName, String attrValue, String inputAttrName, Supplier<String[]> endpointParams) {
        return OperationUtils.getAttrForType(rootUrl, realm, auth, resourceEndpoint, attrName, attrValue, inputAttrName, "id", endpointParams);
    }

    public static String getAttrForType(String rootUrl, String realm, String auth, String resourceEndpoint, String attrName, String attrValue, String inputAttrName, String returnAttrName) {
        return OperationUtils.getAttrForType(rootUrl, realm, auth, resourceEndpoint, attrName, attrValue, inputAttrName, returnAttrName, null);
    }

    public static String getAttrForType(String rootUrl, String realm, String auth, String resourceEndpoint, String attrName, String attrValue, String inputAttrName, String returnAttrName, Supplier<String[]> endpointParams) {
        ObjectNode match;
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, resourceEndpoint);
        String[] defaultParams = endpointParams == null ? DEFAULT_QUERY_PARAMS : endpointParams.get();
        resourceUrl = HttpUtil.addQueryParamsToUri(resourceUrl, attrName, attrValue);
        resourceUrl = HttpUtil.addQueryParamsToUri(resourceUrl, defaultParams);
        List results = HttpUtil.doGetJSON(RoleOperations.LIST_OF_NODES.class, resourceUrl, auth);
        try {
            match = new LocalSearch(results).exactMatchOne(attrValue, inputAttrName);
        }
        catch (Exception e) {
            throw new RuntimeException("Multiple " + resourceEndpoint + " found for " + inputAttrName + ": " + attrValue, e);
        }
        String typeName = HttpUtil.singularize(resourceEndpoint);
        if (match == null) {
            if (results.size() > 1) {
                throw new RuntimeException("Some matches, but not an exact match, found for " + ObjectUtil.capitalize(typeName) + " with " + inputAttrName + ": " + attrValue + ". Try using a more unique search, such as an id.");
            }
            throw new RuntimeException(ObjectUtil.capitalize(typeName) + " not found for " + inputAttrName + ": " + attrValue);
        }
        JsonNode attr = match.get(returnAttrName);
        if (attr == null) {
            throw new RuntimeException("Returned " + typeName + " info has no '" + returnAttrName + "' attribute");
        }
        return attr.asText();
    }
}

