/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.common;

import org.keycloak.client.cli.common.Globals;
import org.keycloak.client.cli.util.IoUtil;
import picocli.CommandLine;

public abstract class BaseGlobalOptionsCmd
implements Runnable {
    @CommandLine.Option(names={"--help"}, description={"Print command specific help"})
    public void setHelp(boolean help) {
        Globals.help = help;
    }

    @CommandLine.Option(names={"-x"}, description={"Print full stack trace when exiting with error"})
    public void setDumpTrace(boolean dumpTrace) {
        Globals.dumpTrace = dumpTrace;
    }

    protected void printHelpIfNeeded() {
        if (Globals.help) {
            IoUtil.printOut(this.help());
            System.exit(0);
        } else if (this.nothingToDo()) {
            IoUtil.printOut(this.help());
            System.exit(2);
        }
    }

    protected boolean nothingToDo() {
        return false;
    }

    protected abstract String help();

    @Override
    public void run() {
        this.printHelpIfNeeded();
        this.checkUnsupportedOptions(this.getUnsupportedOptions());
        this.processOptions();
        this.process();
    }

    protected String[] getUnsupportedOptions() {
        return new String[0];
    }

    protected void processOptions() {
    }

    protected void process() {
    }

    protected void checkUnsupportedOptions(String ... options) {
        if (options.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of argument required");
        }
        for (int i = 0; i < options.length; ++i) {
            String value;
            String name = options[i];
            if ((value = options[++i]) == null) continue;
            throw new IllegalArgumentException("Unsupported option: " + name);
        }
    }

    protected static String booleanOptionForCheck(boolean value) {
        return value ? "true" : null;
    }
}

