/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of La reunion
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://commons.wikimedia.org/wiki/File:La_R%C3%A9union_arrondissement_commune_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_04 : {
					width : 50.338017,
					height : 40.711559,
					getCoords : function (lat, lon) {
						var xfactor = 81.213304068446;
						var xoffset = -4484.1898776775;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -78.260903254801;
						var yoffset = -1633.3839553525;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-974" : "m 4.88,10.07 c 0,0.07 -0.08,0.07 -0.09,0.13 -0.07,0.01 -0.05,0.09 -0.11,0.11 -0.02,0.05 -0.08,0.07 -0.11,0.11 -0.06,0.01 -0.06,0.09 -0.09,0.13 -0.04,0.03 -0.06,0.09 -0.11,0.11 -0.03,0.05 -0.11,0.05 -0.14,0.1 -0.04,0.03 -0.1,0.05 -0.14,0.09 -0.05,0.03 -0.1,0.06 -0.15,0.09 -0.06,0.02 -0.08,0.08 -0.15,0.09 -0.09,-0.01 -0.08,0.07 -0.14,0.09 -0.04,0.05 -0.15,0.03 -0.18,0.08 -0.03,0.04 -0.1,0.05 -0.14,0.09 -0.09,0 -0.13,0.05 -0.2,0.07 -0.02,0.07 -0.13,0.05 -0.18,0.09 -0.07,0.02 -0.12,0.05 -0.16,0.09 -0.08,0.01 -0.12,0.06 -0.21,0.07 -0.07,0.07 -0.16,-0.03 -0.26,0 -0.04,-0.05 -0.2,0 -0.25,-0.04 -0.1,-0.01 -0.17,0.05 -0.21,-0.02 -0.05,-0.03 -0.13,-0.04 -0.11,-0.13 -0.06,0.02 -0.12,0.04 -0.17,0.07 -0.1,-0.01 -0.07,0.1 -0.19,0.06 -0.13,-0.01 0.01,0.09 -0.07,0.13 -0.02,0.05 -0.08,0.07 -0.09,0.13 -0.07,0.01 -0.09,0.07 -0.16,0.09 -0.08,0.01 -0.05,0.12 -0.11,0.15 -0.04,0.04 -0.02,0.14 -0.1,0.14 -0.04,-0.04 -0.23,-0.04 -0.14,0.04 0.08,0.01 0.04,0.13 0,0.15 -0.01,0.06 -0.1,0.05 -0.11,0.12 -0.05,0.03 -0.12,0.04 -0.14,0.11 -0.1,-0.04 -0.12,0.01 -0.09,0.08 0,0.08 -0.06,0.1 -0.13,0.12 -0.02,0.06 -0.06,0.1 -0.14,0.11 -0.12,-0.07 -0.1,0.06 -0.1,0.16 10e-4,0.09 -0.05,0.15 0,0.22 0.04,0.05 0.04,0.13 0.07,0.2 0.04,0.05 0.04,0.12 0.09,0.16 -0.01,0.09 0.05,0.11 0.07,0.17 0.02,0.05 0.08,0.07 0.09,0.14 0.06,0.03 0.07,0.09 0.09,0.15 0.04,0.03 0.06,0.09 0.11,0.11 0.01,0.06 0.1,0.06 0.09,0.14 -0.03,0.08 -0.12,0.01 -0.2,0.02 -0.02,0.1 0.04,0.13 0.07,0.19 0.01,0.09 -0.08,0.11 -0.05,0.22 -0.05,0.06 0.02,0.12 0,0.22 -0.05,0.04 -0.03,0.15 -0.07,0.19 0,0.1 0,0.2 -0.02,0.27 -0.06,0.06 0.03,0.12 0,0.21 -0.03,0.07 -0.02,0.18 -0.02,0.27 0.01,0.08 -0.04,0.21 0.05,0.23 -0.02,0.1 0.05,0.12 0.07,0.19 0.04,0.03 0.06,0.08 0.11,0.1 0.02,0.06 0.03,0.12 0.11,0.13 0.06,0.02 0.05,0.11 0.14,0.11 0.02,0.06 0.07,0.09 0.07,0.17 0.01,0.08 0.1,0.08 0.09,0.17 0.08,0.01 0.09,0.06 0.11,0.12 0.04,0.04 0.08,0.07 0.11,0.12 -0,0.08 0.11,0.06 0.14,0.11 0.05,0.03 0.04,0.11 0.12,0.11 0.05,0.04 0.12,0.06 0.14,0.13 0.08,0 0.1,0.06 0.15,0.09 0.03,0.04 0.07,0.08 0.14,0.09 0.02,0.06 0.1,0.05 0.11,0.11 0.06,0.02 0.09,0.06 0.14,0.09 0.03,0.05 0.1,0.07 0.17,0.09 0.04,0.04 0.11,0.06 0.14,0.11 0,0.08 0.08,0.09 0.07,0.17 0.02,0.05 0.08,0.08 0.14,0.1 0.05,0.03 0.09,0.06 0.13,0.09 0.06,0.03 0.12,0.06 0.16,0.1 0.06,0.02 0.12,0.04 0.14,0.1 0.02,0.1 -0.07,0.09 -0.11,0.14 0.01,0.08 -0.07,0.15 0.04,0.15 0.05,0.03 0.05,0.11 0.1,0.13 0.08,0.01 0.13,0.05 0.14,0.13 -0.01,0.08 0.1,0.06 0.13,0.12 0.08,0.01 0.09,0.08 0.14,0.11 0.03,0.05 0.02,0.15 0.07,0.17 -0,0.07 0.08,0.07 0.09,0.13 0.06,0.01 0.09,0.1 0.05,0.15 0.05,0.04 0.11,0.06 0.18,0.07 0.03,0.08 0.11,-0.02 0.18,0.04 0.06,0.02 0.08,0.08 0.09,0.14 -0.01,0.08 -0.08,0.1 0.04,0.12 0.1,-0.02 0.13,0.04 0.19,0.07 -0,0.07 -0.05,0.14 0.02,0.18 -0.04,0.09 0.1,0.12 0.03,0.2 -0.07,0.03 -0.04,0.09 0.02,0.11 -0.01,0.09 -0.01,0.17 -0.04,0.24 -0.05,0.04 -0.06,0.09 -0.01,0.13 9e-4,0.06 -0.1,0.12 -0.01,0.16 0.02,0.09 -0.07,0.07 -0.02,0.15 0.1,-0.03 0.18,0.05 0.11,0.1 0.04,0.1 -0.07,0.13 -0.02,0.17 0.04,0.04 0.13,0.05 0.19,0.07 0.11,-0.01 0.17,0.02 0.23,0.04 0.01,0.07 0.11,0.05 0.14,0.1 0.06,0.03 0.18,0.01 0.2,0.07 0.02,0.04 0.13,0.07 0.07,0.13 0.01,0.07 0.11,0.05 0.11,0.13 0.03,0.05 0.1,0.06 0.09,0.14 0.04,0.03 0.06,0.09 0.11,0.11 0.06,0.03 0.09,0.08 0.09,0.16 0,0.09 -0,0.18 -0.07,0.21 -0.05,0.04 -0.02,0.15 -0.07,0.18 -0.04,0.07 -0.01,0.13 0.02,0.19 0.04,0.05 0.05,0.12 0.05,0.21 0.07,0.01 0.05,0.14 0.02,0.17 0.07,0.05 -0.04,0.14 0.04,0.17 10e-4,0.07 -0.03,0.15 -0.02,0.24 -0.03,0.11 0.05,0.14 0.04,0.23 0.03,0.11 -0.05,0.12 -0.07,0.19 0.01,0.09 -0.02,0.16 -0.05,0.22 0.02,0.1 -0.07,0.1 -0.07,0.19 0.02,0.1 0.01,0.11 0,0.21 -0.04,0.06 -0.05,0.15 -0.05,0.24 -0.03,0.08 -0.11,-0.02 -0.14,0.06 -0.04,0.11 0.03,0.09 0.02,0.21 -0.03,0.05 -0.09,0.07 -0.14,0.1 -0.02,0.06 -0.08,0.08 -0.09,0.16 0.03,0.05 -0,0.17 0.07,0.19 0.05,0.03 0.15,0.02 0.16,0.09 0.1,-0.01 0.1,0.07 0.16,0.1 -0.02,0.1 0.03,0.13 0.07,0.17 0.07,0.08 -0.04,0.1 -0.02,0.2 0.08,0.01 0.08,0.09 0.09,0.16 0.02,0.06 0.06,0.1 0.07,0.17 0.04,0.05 0.05,0.12 0.07,0.18 0.01,0.07 0.08,0.09 0.11,0.15 0.02,0.05 0.08,0.06 0.09,0.11 0.06,0.03 0.08,0.09 0.09,0.16 0,0.1 0,0.2 0,0.3 0.07,0.02 0.05,0.11 0.07,0.17 0.04,0.04 0.09,0.07 0.13,0.11 0.02,0.05 0.09,0.06 0.14,0.09 0.03,0.04 0.09,0.05 0.11,0.11 0.03,0.05 0.14,0.03 0.16,0.09 0.05,0.03 0.1,0.06 0.15,0.09 0.02,0.06 0.11,0.05 0.16,0.08 0.04,0.03 0.18,0.06 0.2,-0.01 0.11,-0.04 0.16,0.03 0.14,0.13 0.03,0.06 0.1,-0.01 0.15,0.06 0.05,0.05 0.16,0.04 0.12,0.16 -0.05,0.14 0.17,0.02 0.14,0.15 0.03,0.05 0.03,0.13 0.12,0.13 0.06,0.03 0.19,0.01 0.19,0.09 0.06,0.03 0.1,0.07 0.17,0.09 0.05,0.04 0.14,0.04 0.14,0.12 0.02,0.04 0.09,0.13 0.05,0.16 -0.02,0.06 -0.12,0.14 0.02,0.09 0.07,-0.01 0.1,0.07 0.19,0.06 0.05,0.03 0.11,0.06 0.14,0.11 0.02,0.05 0.09,0.06 0.12,0.1 0.09,0.01 0.12,0.06 0.19,0.07 0.06,0.03 0.09,0.08 0.1,0.15 0.06,0.02 0.05,0.1 0.11,0.11 0.02,0.06 0.02,0.15 0.06,0.2 0.03,0.09 -0.07,0.1 -0.06,0.18 -8.8e-4,0.07 0.09,0.07 0.09,0.14 0.03,0.04 0.06,0.1 0.09,0.14 0.03,0.04 0.07,0.15 0.02,0.19 -0.09,-0.01 -0.1,0.06 -0.16,0.09 0.01,0.07 -0.12,0.08 -0.07,0.13 0.05,0.02 0.07,0.08 0.09,0.14 0.05,0.04 0.06,0.1 0.09,0.15 0.07,0.01 0.08,0.07 0.15,0.09 0.03,0.05 0.09,0.07 0.14,0.09 0.03,0.05 0.07,0.08 0.11,0.11 0.03,0.06 0.14,0.04 0.23,0.04 0.06,0.04 0.15,0.04 0.26,0.04 0.08,0.02 0.18,0.02 0.25,0.04 0.05,0.04 0.19,0 0.25,0.04 0.1,0.01 0.25,-0.02 0.32,0.02 0.09,-0.02 0.14,0.08 0.2,0.03 0.09,0 0.13,0.08 0.22,0.02 0.1,-0.05 0.11,0.03 0.22,0.02 0.07,0.02 0.15,0.04 0.22,0.07 0.08,0.02 0.17,0.01 0.21,0.07 0.1,-0 0.14,0.07 0.22,0.02 0.09,0.01 0.17,0.03 0.23,0.06 0.07,0.02 0.14,0.04 0.2,0.07 0.1,0 0.17,0.03 0.26,0.04 0.06,0.04 0.16,0.04 0.23,0.07 0.04,0.04 0.14,0.04 0.17,0.09 0.09,0.01 0.18,0.02 0.23,0.07 0.07,0.01 0.13,0.05 0.18,0.08 0.07,0.02 0.12,0.06 0.19,0.07 0.06,0.03 0.1,0.08 0.19,0.09 0.02,0.05 0.1,0.06 0.14,0.1 0.06,0.02 0.13,0.04 0.18,0.07 0.01,0.07 0.07,0.09 0.09,0.15 0.03,0.04 0.05,0.1 0.09,0.13 0.03,0.05 0.07,0.08 0.11,0.11 0.02,0.05 0.08,0.06 0.09,0.11 0.05,0.02 0.07,0.08 0.15,0.09 0.03,0.04 0.08,0.06 0.1,0.11 0.04,0.03 0.06,0.09 0.11,0.11 0.03,0.05 0.07,0.08 0.11,0.11 0.09,0.01 0.03,0.11 0.09,0.11 0.03,0.05 0.08,0.09 0.1,0.16 0.02,0.06 0.01,0.16 0.05,0.21 0.09,-0 0.06,0.1 0.11,0.13 0.06,0.02 0.05,0.1 0.11,0.11 0.01,0.07 0.08,0.08 0.11,0.13 0.04,0.04 0.13,0.03 0.14,0.09 0.06,0.03 0.11,0.05 0.15,0.09 0.03,0.05 0.09,0.07 0.15,0.09 0.04,0.04 0.09,0.07 0.16,0.09 0.06,0.02 0.09,0.07 0.16,0.09 0.03,0.05 0.14,0.03 0.17,0.09 0.11,-0.01 0.13,0.05 0.22,0.07 0.04,0.06 0.15,0.04 0.25,0.04 0.07,0.03 0.16,0.03 0.25,0.04 0.11,-0.01 0.19,0.01 0.27,0.04 0.09,0.01 0.16,0.04 0.26,0.04 0.12,-0.01 0.17,0.04 0.29,0.02 0.13,0 0.25,0 0.38,0 0.04,0.05 0.05,0.11 0.14,0.11 0.03,0.05 0.12,0.05 0.17,0.09 0.07,0.06 -0.03,0.15 0,0.24 -0.03,0.11 0.08,0.09 0.09,0.15 0.12,-0.02 0.11,0.13 0.07,0.13 0.03,0.05 0.07,0.09 0.11,0.13 0.05,0.03 0.09,0.06 0.13,0.09 0.07,0.01 0.09,0.08 0.14,0.11 0.06,-0.02 0.14,-0.01 0.2,0.02 0.09,-4.8e-4 0.16,0.02 0.21,0.07 0.1,-0 0.11,0.07 0.19,0.09 0.12,-0.02 0.13,0.07 0.26,0.04 0.09,0.01 0.19,-0.07 0.25,0 0.11,0.01 -0.04,0.16 0.08,0.13 0.07,0.06 0.18,-0.01 0.26,0 0.08,-0.03 -0.02,-0.11 0.06,-0.13 0.07,0 0.11,0.1 0.05,0.15 -0.08,-8.3e-4 -0.12,0.08 -0.07,0.14 0.07,-0 0.2,-0.07 0.2,0.03 0.05,0.03 0.06,0.09 0.13,0.1 0.05,0.04 0.04,0.15 0.05,0.22 0.08,-0.01 0.28,0.04 0.2,-0.05 -0,-0.08 0.13,-0.05 0.19,-0.08 0.08,-0.07 0.12,0.05 0.22,0.02 0.07,-0.02 0.13,-0.05 0.21,-0.07 0.08,0.01 0.18,0.02 0.24,0.04 -0.01,0.08 0.27,-0.01 0.25,0.02 0.06,-0.04 0.16,-8.2e-4 0.23,0.02 0.05,0.03 0.09,0.06 0.13,0.09 0.02,0.06 0.11,0.06 0.16,0.09 0.04,0.05 0.16,0.02 0.18,0.08 0.07,0.02 0.15,0.03 0.2,0.07 0.06,0.01 0.06,0.09 0.14,0.09 0.04,0.05 0.14,0.04 0.18,0.09 0.07,0.02 0.11,0.05 0.16,0.09 0.11,0 0.23,-0.01 0.31,0.02 0.05,0.03 0.09,0.07 0.16,0.09 0.06,0.03 0.1,0.06 0.16,0.09 0.01,0.07 0.15,0.04 0.23,0.04 0.05,0.05 0.2,0.01 0.26,0.04 0.08,0.02 0.16,0.04 0.26,0.04 0.04,0.08 0.17,-0.05 0.21,0.02 0.11,-0.02 0.12,0.06 0.2,0.07 0.07,0.02 0.01,0.16 0.14,0.13 0.03,0.05 0.12,0.05 0.14,0.1 0.06,0.01 0.06,0.12 0.11,0.07 0.08,-0 0.16,-0.07 0.23,-0.02 0.04,0.04 0.1,0.05 0.14,0.09 0.02,0.06 0.11,0.05 0.11,0.12 0.05,0.02 0.07,0.15 0.01,0.16 -0.03,0.08 0.06,0.09 0.09,0.13 0.02,0.07 0.15,0.03 0.11,-0.08 0.05,-0.04 0.13,-0.05 0.23,-0.05 -6.5e-4,-0.11 0.1,-0.05 0.15,-0.02 0.07,0.02 0.14,0.07 0.19,0.01 0.05,-0.06 0.1,0.03 0.14,0.01 0.07,0.02 0.11,0.08 0.16,0.01 0.1,-0.03 0.15,0.03 0.23,0.04 0.06,0.03 0.07,0.1 0.16,0.09 0.08,-5.3e-4 0.07,0.08 0.14,0.09 0.06,0.05 0.11,0.01 0.17,0.04 0.12,0.01 0.21,-0.01 0.3,-0.02 0.1,0.01 0.19,-8.2e-4 0.22,-0.06 0.05,-0.03 0.14,-0.04 0.19,-0.07 0.04,-0.05 0.12,-0.06 0.19,-0.08 0.08,-0.02 0.18,-0.01 0.23,-0.05 0.06,-0.01 0.12,-0.08 0.18,-0.02 0.02,0.06 0.07,0.09 0.09,0.15 0.04,0.03 0.17,0.05 0.09,0.13 0.06,0.02 0.11,0.04 0.14,0.09 0.1,-0.01 0.15,0.05 0.22,0.07 0.05,0.03 0.15,0.02 0.16,0.09 0.07,0.05 0.15,-0.03 0.22,0.02 0.05,0.02 0.09,0.06 0.14,0.09 -0.03,0.1 0.04,0.12 0.07,0.17 0.08,0 0.09,0.07 0.13,0.11 0.02,0.06 0.13,0.04 0.16,0.09 0.1,-0.01 0.12,0.04 0.16,0.09 0.07,0.02 0.13,0.05 0.2,0.07 0.01,0.09 0.2,0.02 0.29,0.04 0.06,-0.02 0.1,-0.06 0.16,-0.09 0.14,0 0.27,0 0.41,0 0.04,-0.04 0.08,-0.08 0.11,-0.13 0.04,-0.04 0.09,-0.06 0.13,-0.09 0.07,-0.03 0.14,-0.05 0.26,-0.04 0.13,0.02 0.19,-0.02 0.31,-0.02 0.09,0.02 0.25,-0.03 0.3,0.02 0.07,-0.03 0.19,-0.02 0.3,-0.02 0.07,0.03 0.15,0.04 0.24,0.04 0.06,0.03 0.14,0.04 0.18,0.08 0.04,0.04 0.1,0.05 0.09,0.14 -0.03,0.06 -0.03,0.13 0.04,0.15 0.05,0.02 0.07,0.08 0.14,0.09 2.3e-4,0.07 0.18,0.05 0.23,0.03 0.09,3.8e-4 0.15,-0.03 0.2,-0.07 -0.02,-0.09 0.06,-0.1 0.11,-0.14 0.08,-0.01 0.09,-0.09 0.19,-0.09 0.09,0.01 0.09,-0.07 0.15,-0.09 0.03,-0.05 0.09,-0.07 0.15,-0.09 0.07,-0.02 0.1,-0.08 0.21,-0.07 0.09,0.01 0.16,0.03 0.27,0.02 0.05,0.05 0.16,0.04 0.27,0.04 0.05,0.05 0.2,0.01 0.29,0.02 0.06,-0.03 0.16,-0.02 0.18,-0.09 0.02,-0.05 0.09,-0.06 0.14,-0.09 0.06,-0.03 0.07,-0.09 0.11,-0.13 0.06,-0.05 0.13,0.03 0.18,-0.04 0.04,-0.06 0.03,-0.15 0.03,-0.24 0.05,-0.04 0.12,-0.06 0.21,-0.07 0.05,-0.04 0.19,4.8e-4 0.24,-0.04 0.12,-0.02 0.17,0.03 0.29,0.02 0.06,0.03 0.13,0.06 0.22,0.07 0.1,-0.02 0.09,-0 0.2,-0.02 0.06,0.07 0.16,-0.04 0.22,0.02 0.06,-0.06 0.15,0.03 0.2,-0.02 0.05,0.03 0.05,-2.6e-4 0.15,0 0.05,0.04 0.14,0.05 0.2,0.08 0.08,0 0.23,0.03 0.29,-0.01 0.12,-0.01 0.27,-0 0.4,-0.01 0.04,-0.05 0.08,-0.09 0.16,-0.09 0.1,0.01 0.24,-0.02 0.31,0.02 0.03,-0.02 0.17,-0 0.16,-0.08 0.05,-0.04 0.15,-0.03 0.2,-0.07 0.05,-0.03 0.15,-0.02 0.18,-0.07 0.02,-0.06 0.11,-0.06 0.17,-0.09 0.06,-0.03 0.13,-0.04 0.17,-0.09 0.1,-0 0.15,-0.05 0.27,-0.04 0.1,0.01 0.12,-0.06 0.2,-0.07 0.07,-0.05 0.17,0 0.26,0 0.12,0 0.24,0 0.36,0 0.01,0.03 0.14,-0.01 0.16,-0.04 0.09,-0.01 0.24,0.02 0.29,-0.02 0.1,0.01 0.14,-0.04 0.2,-0.07 0.09,-0.01 0.19,0.07 0.25,0 0.05,-0.03 0.09,-0.07 0.13,-0.11 0.02,-0.06 0.04,-0.11 0.07,-0.15 0.09,-0 0.07,-0.1 0.2,-0.07 0.12,-0.02 0.12,0.07 0.25,0.04 0.05,0.01 0.21,0.05 0.25,0 0.1,-0.01 0.16,0.02 0.2,0.07 0.07,0.02 0.16,0.03 0.22,0.07 0.1,-0 0.22,0.01 0.29,-0.02 0.02,-0.07 0.15,-0.03 0.2,-0.07 0.04,-0.04 0.14,-0.04 0.17,-0.09 0.05,-0.04 0.11,-0.06 0.18,-0.08 0.07,-0.03 0.17,-0.02 0.24,-0.05 0.03,-0.05 0.05,-0.1 0.12,-0.11 0.05,-0.04 0.06,-0.1 0.11,-0.13 0.05,-0.03 0.12,-0.05 0.16,-0.09 0.02,-0.05 0.08,-0.06 0.09,-0.11 0.06,-0.03 0.14,-0.04 0.15,-0.11 0.01,-0.07 0.15,-0.03 0.2,-0.07 0.03,-0.05 0.09,-0.06 0.12,-0.1 0.04,-0.04 0.12,-0.04 0.11,-0.12 0.07,-0.03 0.17,-0.02 0.25,-0.04 0.02,-0.07 0.05,-0.12 0.09,-0.17 0.05,-0.02 0.06,-0.07 0.11,-0.09 0.04,-0.05 0.04,-0.13 0.09,-0.17 -0.01,-0.09 0.12,-0.05 0.12,-0.14 0.03,-0.05 0.07,-0.09 0.09,-0.15 0.06,-0.01 0.09,-0.06 0.14,-0.09 -0,-0.07 0.08,-0.07 0.09,-0.13 0.08,-0.01 0.07,-0.09 0.11,-0.13 0.04,-0.05 0.02,-0.17 0.04,-0.24 0.03,-0.05 0.09,-0.08 0.07,-0.18 -0.03,-0.06 -0.01,-0.16 -0.07,-0.19 -0.02,-0.06 -0.05,-0.12 -0.07,-0.17 -0.06,-0.02 -0.06,-0.09 -0.11,-0.13 0.01,-0.1 -0.02,-0.17 -0.03,-0.26 -0,-0.1 -0.04,-0.16 -0.02,-0.27 0.04,-0.04 0.04,-0.17 -0.04,-0.17 -0.06,-0.05 0.01,-0.12 -0.01,-0.2 -0.05,-0.05 -0.01,-0.19 -0.02,-0.28 0,-0.08 -0.08,-0.11 -0.02,-0.18 0.08,-0.01 0.06,-0.12 0.07,-0.2 0.07,-0.06 -0.01,-0.16 0,-0.23 0,-0.08 -0.02,-0.19 0.05,-0.22 0.03,-0.04 -0.02,-0.13 0,-0.22 0.01,-0.09 -0.03,-0.22 0.02,-0.28 0.02,-0.06 0.09,-0.11 0.01,-0.15 -0.07,-0.02 -0.07,-0.11 -0.07,-0.2 -0.06,-0.03 -0.02,-0.14 -0.07,-0.18 -0.02,-0.06 -0.05,-0.12 -0.07,-0.19 -0.07,-0.02 -0.02,-0.14 -0.07,-0.18 -0,-0.1 -0,-0.2 0.02,-0.27 0,-0.09 0.04,-0.15 0.02,-0.26 0.04,-0.05 0.02,-0.14 0.06,-0.19 0.06,-0.08 -0.02,-0.08 -0.02,-0.17 -0.04,-0.04 -0.03,-0.18 0,-0.22 -0.08,-0.02 -0.03,-0.16 -0.05,-0.23 -0.03,-0.05 -0.05,-0.13 -0.07,-0.19 0.03,-0.12 -0.06,-0.12 -0.05,-0.22 0.05,-0.04 0.02,-0.15 0.07,-0.18 -0,-0.09 0.02,-0.15 0.04,-0.22 0.1,0.01 0.07,-0.1 0.11,-0.15 0.01,-0.07 0.02,-0.15 0.05,-0.21 -0.03,-0.07 -0.02,-0.17 -0.02,-0.27 0.05,-0.05 0.01,-0.19 0.02,-0.28 0.02,-0.06 0.1,-0.07 0.14,-0.12 0.04,-0.05 -0,-0.19 0.04,-0.24 0.01,-0.08 0.06,-0.12 0.05,-0.21 0.03,-0.04 0.07,-0.13 0.02,-0.18 -0.04,-0.06 -0.02,-0.18 -0.02,-0.27 0.05,-0.04 0.01,-0.16 0.07,-0.19 0.03,-0.05 0.03,-0.13 0.07,-0.17 0.01,-0.07 0.11,-0.06 0.14,-0.11 0.01,-0.07 -0.04,-0.21 0.05,-0.22 0.03,-0.05 0.07,-0.08 0.11,-0.11 0.03,-0.05 0.06,-0.11 0.05,-0.2 0.02,-0.08 0.03,-0.16 0.02,-0.26 0.07,-0.01 0.05,-0.09 0.11,-0.11 0.03,-0.05 0.08,-0.07 0.09,-0.13 0.04,-0.03 0.06,-0.09 0.11,-0.11 0.03,-0.05 0.13,-0.04 0.18,-0.09 0.06,-0.02 0.13,-0.04 0.16,-0.09 0.07,-0.01 0.07,-0.09 0.13,-0.11 0.03,-0.04 0.08,-0.07 0.07,-0.15 0.05,-0.04 0.01,-0.16 0.06,-0.2 -0,-0.1 0.02,-0.17 0.03,-0.26 1e-5,-0.09 -0.02,-0.19 0.04,-0.22 0.1,-0.01 -0,-0.1 -0.02,-0.13 -0.07,-0.02 -0.14,-0.04 -0.11,-0.15 -0.03,-0.09 0.04,-0.18 0.01,-0.23 -0.03,-0.1 0.03,-0.15 0.02,-0.24 0.02,-0.07 0.13,-0.03 0.16,0 0.05,0.02 0.14,0.09 0.2,0.05 0.07,-0.02 0.23,0.03 0.25,-0.04 0.05,-0.02 0.09,-0.06 0.13,-0.09 0.06,-0.03 0.14,-0.04 0.18,-0.08 0.08,0.01 0.09,-0.12 0.03,-0.14 -0.05,-0.04 -0.04,-0.12 -0.07,-0.17 -0.09,-0.02 -0.01,-0.13 -0.04,-0.16 -0.02,-0.06 -0.04,-0.12 -0.09,-0.15 -0.04,-0.05 -0.03,-0.13 0.01,-0.18 0.03,-0.09 -0.07,-0.1 -0.06,-0.18 0.07,-0.05 0.02,-0.09 0.02,-0.18 -0.03,-0.06 -0.02,-0.16 -0.02,-0.25 0.06,-0.02 0.07,-0.08 0.11,-0.11 0.03,-0.06 0.07,-0.11 0.07,-0.2 0.03,-0.11 -0.06,-0.13 -0.05,-0.23 -0.05,-0.04 -0.13,-0.05 -0.22,-0.05 -0.04,-0.03 -0.05,-0.1 -0.09,-0.13 -0.02,-0.06 -0.03,-0.13 -0.07,-0.17 0,-0.08 -0.04,-0.12 -0.09,-0.15 -0.02,-0.05 -0.09,-0.07 -0.14,-0.09 0,-0.13 0,-0.26 0,-0.39 -0.06,-0.02 -0.08,-0.09 -0.04,-0.14 0.06,-0.08 -0.04,-0.09 -0.05,-0.16 -0.05,-0.03 -0.08,-0.09 -0.19,-0.07 -0.09,8.1e-4 -0.12,-0.05 -0.14,-0.1 -0.04,-0.06 -0.1,-0.04 -0.18,-0.03 -0.05,-0.02 -0.04,-0.1 -0.11,-0.11 -0.04,-0.05 -0.11,-0.08 -0.22,-0.07 -0.03,0.03 -0.11,0.11 -0.14,0.02 -0.05,-0.04 -0.14,-0.05 -0.25,-0.04 -0.01,-0.08 -0.15,-0.03 -0.16,-0.11 -0.07,-0.02 -0.1,-0.07 -0.13,-0.12 0.04,-0.07 -0,-0.12 -0.04,-0.16 -0.03,-0.04 -0.07,-0.07 -0.12,-0.1 -0.08,-0.01 -0.12,-0.05 -0.18,-0.07 -0.07,-0.02 -0.09,-0.08 -0.14,-0.11 -0.04,-0.04 -0.03,-0.12 -0.09,-0.15 -0.07,-0.02 -0.14,-0.03 -0.16,-0.09 -0.08,-0.01 -0.09,-0.09 -0.2,-0.07 -0.03,-0.06 -0.14,-0.04 -0.2,-0.07 -0.05,-0.04 -0.12,-0.06 -0.18,-0.09 -0.04,-0.05 -0.15,-0 -0.16,0.04 -0.06,0.03 -0.12,0.05 -0.18,0.08 -0.02,0.04 -0.18,0.05 -0.18,-0.02 -0.07,-0.02 -0.15,-0.03 -0.2,-0.06 -0.05,-0.03 -0.04,-0.11 -0.12,-0.11 -0.01,-0.06 -0.1,-0.05 -0.11,-0.11 -0.05,-0.04 -0.07,-0.1 -0.09,-0.16 -0.03,-0.05 -0.07,-0.1 -0.09,-0.15 -0.03,-0.05 -0.07,-0.09 -0.09,-0.14 -0.06,-0.03 -0.04,-0.12 -0.09,-0.15 -0.02,-0.07 -0.05,-0.12 -0.09,-0.17 -0.01,-0.07 -0.07,-0.1 -0.07,-0.17 -0.05,-0.03 -0.06,-0.1 -0.11,-0.13 -0.04,-0.04 -0.04,-0.12 -0.13,-0.11 -0.03,-0.04 -0.09,-0.06 -0.1,-0.12 -0.05,-0.03 -0.1,-0.06 -0.16,-0.09 -0.08,-0.01 -0.12,-0.05 -0.18,-0.07 -0.03,-0.05 -0.04,-0.13 -0.13,-0.13 -0.02,-0.05 -0.09,-0.06 -0.12,-0.1 -0.05,-0.03 -0.08,-0.07 -0.09,-0.14 -0.06,-0.03 -0.04,-0.12 -0.09,-0.15 -0.01,-0.08 -0.03,-0.14 -0.07,-0.19 -0.02,-0.07 -0.05,-0.12 -0.07,-0.18 -0.05,-0.04 -0.09,-0.09 -0.14,-0.13 -0.04,-0.05 0.01,-0.18 -0.09,-0.18 -0.13,0.04 -0.11,-0.07 -0.16,-0.1 -0.04,-0.04 -0.06,-0.09 -0.11,-0.11 -0.05,-0.03 -0.04,-0.11 -0.12,-0.11 -0.05,-0.03 -0.11,-0.06 -0.17,-0.09 -0.03,-0.05 -0.09,-0.07 -0.14,-0.09 0.01,-0.08 -0.05,-0.1 -0.09,-0.13 -0.01,-0.07 -0.06,-0.1 -0.09,-0.15 -0.06,-0.02 -0.13,-0.03 -0.16,-0.09 0.01,-0.08 -0.07,-0.08 -0.09,-0.13 -0.02,-0.06 -0.09,-0.07 -0.09,-0.15 -0.04,-0.04 -0.09,-0.07 -0.09,-0.14 -0.06,-0.02 -0.07,-0.08 -0.11,-0.11 -0.01,-0.07 -0.11,-0.05 -0.14,-0.1 -0.01,-0.07 -0.03,-0.13 -0.09,-0.16 -0.04,-0.03 -0.06,-0.09 -0.11,-0.11 -0.02,-0.06 -0.03,-0.13 -0.09,-0.15 -0.02,-0.06 -0.06,-0.11 -0.09,-0.15 -0,-0.09 -0.05,-0.14 -0.04,-0.23 0.01,-0.09 -0.02,-0.23 0.02,-0.29 0.02,-0.06 0.06,-0.1 0.09,-0.15 -0.03,-0.11 0.18,-0.01 0.14,-0.13 -0.07,-0.05 0.03,-0.16 -0.02,-0.2 -0.03,-0.02 -0.13,-0.13 -0.12,1.6e-4 -0.05,0.09 -0.11,0.02 -0.05,-0.05 -0.05,-0 -0.16,-0.12 -0.14,0.01 -0.13,0.01 0.02,-0.12 -0.13,-0.11 -0.06,-0.09 -0.1,0.05 -0.12,-0.04 -0.1,-0.02 0.01,-0.11 -0.04,-0.15 -0.01,-0.07 -0.06,-0.11 -0.09,-0.16 -0,-0.08 -0.05,-0.13 -0.06,-0.2 -0.02,-0.05 -0.09,-0.06 -0.09,-0.12 -0.04,-0.04 -0.01,-0.15 -0.09,-0.16 -0.03,-0.04 -0.08,-0.07 -0.09,-0.13 -0.04,-0.04 -0.08,-0.07 -0.11,-0.11 -0.05,-0.02 -0.08,-0.07 -0.11,-0.1 -0.03,-0.05 -0.14,-0.03 -0.18,-0.07 -0.05,-0.03 -0.11,-0.05 -0.15,-0.09 -0.09,-1.7e-4 -0.14,-0.04 -0.2,-0.07 -0.12,0.01 -0.2,-0.02 -0.3,-0.02 -0.03,-0.05 -0.08,-0.07 -0.09,-0.14 -0.02,-0.06 -0.09,-0.07 -0.09,-0.15 -0.01,-0.07 -0.02,-0.22 -0.02,-0.19 -0.04,-0.06 -0.01,-0.12 -0,-0.2 0.06,-0.05 -0.06,-0.1 -0.13,-0.09 -0.09,-0 -0.09,-0.09 -0.09,-0.18 -0.04,-0.05 -0.01,-0.16 -0.04,-0.22 -0.04,-0.04 -0.02,-0.15 -0.07,-0.19 0.02,-0.11 -0.03,-0.16 -0.02,-0.27 0,-0.1 0,-0.19 -0.02,-0.26 0,-0.09 -0.01,-0.2 0.02,-0.27 -0,-0.09 -0.02,-0.16 -0.04,-0.22 0,-0.1 0,-0.21 0,-0.31 -0.05,-0.05 -0.01,-0.19 -0.02,-0.28 -0.02,-0.08 0.03,-0.22 -0.02,-0.27 -0.06,-0.06 0.01,-0.14 0,-0.22 0.08,-0.04 0.03,-0.12 0.02,-0.2 0.04,-0.04 0.09,-0.08 0.04,-0.14 -0.01,-0.07 -0.04,-0.12 -0.07,-0.18 -0.02,-0.07 -0.01,-0.18 -0.04,-0.25 -0.01,-0.08 -0.04,-0.13 -0.05,-0.22 -0.04,-0.05 -0.04,-0.13 -0.05,-0.22 -0.04,-0.04 -0.04,-0.12 -0.09,-0.15 -0,-0.07 -0.08,-0.08 -0.07,-0.17 -0.04,-0.04 -0.07,-0.09 -0.13,-0.11 -0.04,-0.03 -0.05,-0.1 -0.09,-0.13 -0.01,-0.07 -0.08,-0.08 -0.09,-0.15 -0.04,-0.04 -0.1,-0.05 -0.09,-0.14 -0.07,-0.01 -0.03,-0.11 -0.09,-0.13 -0.01,-0.07 -0.06,-0.1 -0.09,-0.15 -0.05,-0.03 -0.07,-0.09 -0.09,-0.15 -0.05,-0.04 0.01,-0.17 -0.09,-0.16 -0.03,-0.05 -0.04,-0.12 -0.09,-0.15 -0.03,-0.05 -0.07,-0.08 -0.11,-0.11 -0.08,-0.01 -0.06,-0.1 -0.09,-0.15 -0.02,-0.05 -0.07,-0.08 -0.11,-0.11 -0.02,-0.05 -0.08,-0.06 -0.09,-0.11 -0.06,-0.01 -0.09,-0.06 -0.14,-0.09 -0.03,-0.04 -0.1,-0.06 -0.11,-0.11 -0.06,-0.01 -0.09,-0.06 -0.14,-0.09 -0.01,-0.07 -0.09,-0.07 -0.11,-0.13 -0.05,-0.03 -0.08,-0.07 -0.11,-0.11 -0.06,-0.01 -0.09,-0.06 -0.14,-0.09 -0.02,-0.06 -0.07,-0.08 -0.09,-0.13 -0.06,-0.02 -0.07,-0.08 -0.11,-0.11 -0.03,-0.05 -0.06,-0.1 -0.09,-0.15 -0.01,-0.06 -0.07,-0.08 -0.09,-0.13 -0.01,-0.07 -0.07,-0.09 -0.09,-0.15 -0.03,-0.05 -0.09,-0.07 -0.15,-0.09 -0.04,-0.03 -0.1,-0.05 -0.14,-0.09 -0.05,-0.04 -0.09,-0.07 -0.16,-0.09 -0.01,-0.06 -0.11,-0.05 -0.14,-0.1 -0.09,0 -0.12,-0.04 -0.16,-0.09 -0.07,-0.02 -0.11,-0.06 -0.16,-0.09 -0.06,-0.02 -0.1,-0.06 -0.16,-0.09 -0.07,-0.01 -0.1,-0.07 -0.19,-0.07 -0.06,-0.03 -0.09,-0.07 -0.16,-0.09 -0.06,-0.02 -0.07,-0.08 -0.14,-0.09 -0.03,-0.05 -0.09,-0.07 -0.17,-0.09 -0.1,0 -0.19,-0 -0.24,-0.04 -0.09,-0 -0.1,-0.07 -0.2,-0.07 -0.03,-0.06 -0.14,-0.05 -0.2,-0.08 -0.11,-0.01 -0.24,-0 -0.36,-0.01 -0.04,0.05 -0.14,-0.02 -0.18,-0.04 -0.04,-0.04 -0.05,-0.12 -0.13,-0.07 -0.05,0.05 -0.15,0.05 -0.26,0.04 -0.08,0.02 -0.17,0.04 -0.25,0 -0.03,0.09 -0.1,0.01 -0.16,0 -0.04,-0.05 -0.08,-0.09 -0.16,-0.09 -0.04,-0.05 -0.08,-0.09 -0.15,-0.11 -0.11,0.01 -0.16,-0.03 -0.25,-0.04 -0.03,-0.04 -0.09,-0.05 -0.11,-0.11 -0.08,-0.01 -0.09,-0.07 -0.15,-0.09 -0.05,-0.05 -0.19,-0.01 -0.23,-0.06 -0.05,-0.02 -0.11,-0.05 -0.14,-0.09 -0.08,-0 -0.1,-0.06 -0.15,-0.09 -0.07,-0.02 -0.12,-0.05 -0.16,-0.09 -0.02,-0.05 -0.09,-0.06 -0.12,-0.1 -0.07,-0.01 -0.08,-0.07 -0.13,-0.09 -0.05,-0.03 -0.12,-0.04 -0.16,-0.09 -0.08,-0.01 -0.11,-0.07 -0.18,-0.08 -0.06,0.05 -0.08,-0.05 -0.18,-0.03 -0.14,0 -0.27,0 -0.41,0 -0.02,0.05 -0.08,0.07 -0.11,0.11 -0.16,0 -0.32,0 -0.47,0 -0.06,-0.02 -0.09,-0.07 -0.16,-0.09 -0.05,-0.04 -0.09,-0.07 -0.16,-0.09 -0.03,-0.05 -0.12,-0.05 -0.14,-0.1 -0.05,-0.06 -0.07,-0.02 -0.18,-0.03 -0.04,-0.05 -0.19,-0.01 -0.27,-0.02 -0.04,-0.05 -0.21,0.01 -0.26,-0.04 -0.07,-0.02 -0.17,-0.02 -0.21,-0.07 -0.09,-0.01 -0.16,-0.04 -0.25,-0.04 -0.04,-0.04 -0.2,-0.03 -0.24,0 -0.04,0.04 -0.11,0.07 -0.17,0.09 -0.04,0.04 -0.08,0.07 -0.14,0.09 -0.05,0.04 -0.14,0.04 -0.18,0.09 -0.02,0.06 -0.09,0.08 -0.19,0.07 -0.1,0 -0.14,-0.05 -0.21,-0.07 -0.07,-0.03 -0.2,0 -0.23,-0.06 -0.08,-0 -0.17,-0 -0.18,-0.07 -0.08,-0.01 -0.13,-0.06 -0.25,-0.04 -0.04,-0.04 -0.16,-0.01 -0.16,-0.09 -0.08,-0.01 -0.14,-0.05 -0.22,-0.07 -0.08,-0.02 -0.19,-0.01 -0.25,-0.04 -0.12,0.02 -0.18,-0.02 -0.29,-0.02 -0.09,-0.01 -0.14,-0.06 -0.26,-0.04 -0.06,-0.04 -0.15,-0.03 -0.19,-0.08 -0.09,-0.01 -0.13,-0.06 -0.24,-0.05 -0.05,-0.04 -0.12,-0.04 -0.16,-0.09 -0.05,-0.03 -0.12,-0.04 -0.16,-0.09 -0.08,-0.01 -0.17,-0.03 -0.23,-0.06 -0.07,-0.01 -0.11,-0.06 -0.18,-0.07 -0.03,-0.07 -0.24,0.02 -0.27,-0.04 -0.11,0.02 -0.16,-0.02 -0.2,-0.07 -0.07,0.03 -0.19,0.02 -0.29,0.02 -0.05,0.04 -0.08,0.08 -0.17,0.09 -0.11,-0.01 -0.2,0.01 -0.26,0.04 -0.04,0.05 -0.13,0.06 -0.21,0.07 -0.04,0.06 -0.18,0.03 -0.24,0.06 -0.05,0.04 -0.18,0.02 -0.24,0.05 -0.07,-0.02 -0.15,-0.04 -0.23,-0.07 -0.08,-0.02 -0.17,-0.03 -0.26,-0.04 -0.06,-0.06 -0.12,0.04 -0.22,0.02 -0.11,0.01 -0.17,-0.04 -0.29,-0.02 -0.07,-0.03 -0.19,-0.01 -0.26,-0.04 -0.12,0.02 -0.12,-0.06 -0.2,-0.07 -0.04,-0.03 -0.1,-0.05 -0.14,-0.09 -0.02,-0.05 -0.08,-0.07 -0.11,-0.11 -0.07,-0.02 -0.15,-0.03 -0.2,-0.06 -0.04,-0.04 -0.11,-0.06 -0.16,-0.09 -0.04,-0.04 -0.05,-0.11 -0.13,-0.11 -0.06,-0.03 -0.12,-0.05 -0.14,-0.13 -0.07,-0.01 -0.08,-0.07 -0.13,-0.09 0.01,-0.08 -0.12,-0.05 -0.12,-0.13 -0.07,-0.02 -0.12,-0.06 -0.21,-0.06 -0.05,-0.02 -0.22,-0.05 -0.26,0 -0.04,0.04 -0.11,0.05 -0.15,0.09 -0.05,0.03 -0.08,0.07 -0.15,0.09 -0.04,0.03 -0.1,0.05 -0.14,0.09 -0.02,0.07 -0.15,0.03 -0.21,0.07 -0.05,0.04 -0.2,0.02 -0.25,0 -0.13,0.02 -0.19,-0.02 -0.3,-0.02 -0.04,-0.04 -0.08,-0.08 -0.15,-0.09 -0.08,0.02 -0.17,0.03 -0.25,0 -0.1,-0 -0.13,-0.06 -0.25,-0.04 -0.12,-0.01 -0.2,0.02 -0.3,0.02 -0.06,0.03 -0.15,0.03 -0.2,0.07 -0.06,0.03 -0.14,0.05 -0.21,0.07 -0.07,0.03 -0.15,0.05 -0.23,0.07 -0.07,0.03 -0.14,0.05 -0.23,0.07 -0.06,0.04 -0.12,0.07 -0.22,0.07 -0.09,0 -0.16,0.02 -0.24,0.04 -0.09,0.01 -0.18,0.03 -0.29,0.02 0.01,0.1 -0.13,0.07 -0.19,0.1 -0.1,-0.01 -0.11,0.06 -0.23,0.05 -0.1,8.1e-4 -0.13,0.06 -0.22,0.06 0,0.08 -0.04,0.12 -0.1,0.15 -0.05,0.02 -0.05,0.1 -0.11,0.11 -0.03,0.04 -0.08,0.07 -0.09,0.13 -0.1,-0 -0.17,0.01 -0.18,0.09 -0.03,0.05 -0.06,0.11 -0.16,0.09 -0.06,0.03 -0.15,0.04 -0.22,0.07 -0.06,0.03 -0.13,0.04 -0.2,0.07 -0.05,0.02 -0.1,0.05 -0.14,0.09 -0.01,0.07 -0.07,0.09 -0.14,0.11 -0.03,0.05 -0.04,0.12 -0.14,0.11 -0.05,0.03 -0.02,0.13 -0.1,0.13 -0.07,0.03 -0.17,0.03 -0.26,0.04 -0.04,0.04 -0.11,0.05 -0.15,0.09 -0.06,0.02 -0.1,0.06 -0.16,0.09 -0,0.08 -0.01,0.15 -0.07,0.17 -0,0.08 -0.14,0.03 -0.11,0.13 -0.06,0.02 -0.05,0.1 -0.11,0.11 -0.03,0.05 -0.06,0.08 -0.09,0.13 -0.14,-0.04 -0.05,0.13 -0.17,0.11 -0.05,0.03 -0.09,0.07 -0.16,0.09 -0.11,-0.01 -0.14,0.04 -0.21,0.07 -0.07,0.01 -0.08,0.07 -0.15,0.09 -0.04,0.04 -0.11,0.05 -0.16,0.09 -0.06,0.01 -0.09,0.06 -0.14,0.09 -0.01,0.07 -0.08,0.08 -0.09,0.15 -0.04,0.05 -0.02,0.14 -0.07,0.18 -0,0.07 -0.06,0.1 -0.09,0.15 -0.04,0.04 -0.14,0.03 -0.14,0.1 -0.04,0.03 -0.06,0.08 -0.11,0.1 -0.03,0.04 -0.09,0.05 -0.11,0.11 -0.08,0.01 -0.12,0.06 -0.21,0.07 -0.1,-0.01 -0.19,8.2e-4 -0.22,0.06 -0.05,0.04 -0.18,0.01 -0.18,0.1 -0.04,0.04 -0.06,0.1 -0.16,0.08 -0.05,0.04 -0.18,-5e-5 -0.2,0.07 -0.12,0 -0.24,0 -0.36,0 -0.03,0.04 -0.21,0.03 -0.25,0 -0.02,-0.05 -0.08,-0.07 -0.09,-0.13 -0.09,-0 0.01,0.12 0.04,0.13 0.02,0.07 -0.1,0.06 -0.04,0.16 0.06,0.03 0.14,0.04 0.11,0.15 0.03,0.03 0.11,0.1 0.03,0.13 -0.09,0 -0.07,-0.09 -0.14,-0.11 -0.02,0.07 -0.12,0.08 -0.23,0.07 -0.1,0 -0.21,-0.01 -0.24,0.04 -0.05,-0.02 -0.15,-0.06 -0.1,-0.11 0.03,-0.06 0.22,0.02 0.25,-0.04 0.03,-0.03 0.15,-0.06 0.09,-0.11 0.03,-0.07 3.5e-4,-0.12 -0.05,-0.16 -0.05,-0 -0.11,0.05 -0.19,0.01 -0.11,-0.01 -0.11,0.07 -0.25,0.04 -0.07,0.02 -0.14,0.03 -0.19,0.07 -0.02,0.06 -0.09,0.07 -0.14,0.1 -0.04,0.01 -0.15,-0.07 -0.18,-0.02 -0.11,0 -0.22,0 -0.3,-0.02 -0.06,-0.04 -0.19,-0.02 -0.26,-0.04 -0.03,-0.04 -0.1,-0.05 -0.11,-0.11 -0.07,-0.01 -0.13,-0.04 -0.16,-0.1 -0.09,-0.05 -0.1,0.1 -0.16,0.04 -0.07,-0.01 -0.08,-0.08 -0.18,-0.07 -0.04,0.04 -0.2,0.03 -0.24,0 0.05,-0.08 -0.01,-0.11 -0.09,-0.13 -0.05,-0.04 -0.14,-0.01 -0.16,0.04 -0.08,0.01 -0.14,0.05 -0.24,0.04 -0.06,0.01 -0.1,0.1 -0.05,0.15 0.08,0.01 0.08,0.09 0.09,0.16 -0.02,0.08 0.03,0.22 -0.02,0.26 0.04,0.09 -0.09,0.22 0.05,0.2 0.08,0.06 0.13,-0.04 0.18,-0.01 0.04,0.02 0.14,0.07 0.07,0.14 0.02,0.09 -0.08,0.07 -0.07,0.16 0.01,0.07 -0.15,-0.01 -0.16,-0.05 0.14,0.03 0.12,-0.05 0.03,-0.07 -0.03,-0.1 -0.05,0.05 -0.13,0.02 -0.07,0.02 -0.14,0.04 -0.15,0.12 -0.03,0.06 -0.05,0.14 -0.05,0.23 0.01,0.1 -0.01,0.18 -0.02,0.26 -0.02,0.07 -0.01,0.18 -0.04,0.24 0.02,0.09 -0.05,0.1 -0.07,0.15 -0.09,0.01 -0.05,0.13 -0.11,0.15 0.01,0.09 2.3e-4,0.16 -0.07,0.17 -0.04,0.05 -0.04,0.12 -0.07,0.19 0,0.07 0.06,0.1 0.09,0.14 0.05,0.01 0.09,0.12 0.05,0.15 0,0.08 0.04,0.12 0.07,0.18 0.04,0.04 0.07,0.09 0.09,0.15 -10e-4,0.08 0.04,0.13 0.05,0.2 0.06,0.03 0.02,0.14 0.09,0.15 -0.02,0.11 0.03,0.16 0.02,0.27 -0.04,0.09 0.08,0.15 0.02,0.19 0,0.1 0,0.19 -0.02,0.27 -0,0.09 -0.03,0.15 -0.04,0.22 -0.02,0.07 -0,0.16 -0.07,0.19 0.05,0.08 -0.01,0.12 -0.02,0.2 -0,0.09 0.01,0.21 -0.02,0.27 -0.03,0.06 5e-5,0.18 -0.05,0.23 0,0.08 -0.09,0.07 -0.09,0.14 -0.03,0.06 -0.02,0.16 -0.02,0.25 -0.06,0.02 -0.06,0.1 -0.13,0.11 l -0,0 z"
					}
				}
			}
		}
	);
})(jQuery);