/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.util.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import lucee.loader.util.Util;

public class Logging {
    public static void dumpThreadPositions(File target) throws IOException {
        for (Map.Entry<Thread, StackTraceElement[]> e : Thread.getAllStackTraces().entrySet()) {
            StackTraceElement[] stes = e.getValue();
            if (stes == null || stes.length == 0) continue;
            ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
            for (int i = 0; i < stes.length; ++i) {
                elements.add(stes[i]);
            }
            if (elements.size() == 0) continue;
            String line = "{\"stack\":[";
            String del = "";
            for (StackTraceElement ste : elements) {
                line = line + del + "\"" + ste.getClassName() + "." + (Util.isEmpty(ste.getMethodName(), true) ? "<init>" : ste.getMethodName()) + "():" + ste.getLineNumber() + "\"";
                del = ",";
            }
            line = line + "],\"thread\":\"" + e.getKey().getName() + "\",\"id\":" + e.getKey().getId() + ",\"time\":" + System.currentTimeMillis() + "}\n";
            Util.write(target, line, Util.UTF8, true);
        }
    }

    public static void startupLog() {
        String dumpPath = Util._getSystemPropOrEnvVar("lucee.dump.threads", null);
        if (!Util.isEmpty(dumpPath, true)) {
            long start = System.currentTimeMillis();
            int tmp = 100;
            try {
                tmp = Integer.parseInt(Util._getSystemPropOrEnvVar("lucee.dump.threads.interval", null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int interval = tmp;
            tmp = 10000;
            try {
                tmp = Integer.parseInt(Util._getSystemPropOrEnvVar("lucee.dump.threads.max", null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int max = tmp;
            Thread thread = new Thread(() -> {
                while (true) {
                    try {
                        while (start + (long)max >= System.currentTimeMillis()) {
                            File target = new File(dumpPath);
                            Logging.dumpThreadPositions(target);
                            if (interval <= 0) continue;
                            Util.sleep(interval);
                        }
                    }
                    catch (IOException e) {
                        Util.sleep(1000);
                        continue;
                    }
                    break;
                }
            });
            thread.start();
        }
    }
}

