/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.datafile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.openide.windows.WindowManager;
import tr.prefs.datafile.DataOptionsPanelController;
import tr.prefs.datafile.DataPrefs;
import tr.prefs.datafile.Resources;

final class DataPrefsPanel
extends JPanel {
    private final DataOptionsPanelController controller;
    private JButton browseButton;
    private JLabel folderLabel;
    private JTextField folderText;

    DataPrefsPanel(DataOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    void load() {
        this.folderText.setText(DataPrefs.getRecoveryPath());
    }

    void store() {
        if (this.valid()) {
            DataPrefs.setRecoveryPath(this.tidyPath(this.folderText.getText()));
        }
    }

    boolean valid() {
        String path = this.tidyPath(this.folderText.getText());
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String tidyPath(String path) {
        path = path.trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private void initForm() {
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.folderLabel = new JLabel(Resources.getText("CTL_Folder"));
        this.folderText = new JTextField();
        this.folderText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent arg0) {
                DataPrefsPanel.this.controller.changed();
            }

            public void removeUpdate(DocumentEvent arg0) {
                DataPrefsPanel.this.controller.changed();
            }

            public void changedUpdate(DocumentEvent arg0) {
                DataPrefsPanel.this.controller.changed();
            }
        });
        this.browseButton = new JButton(Resources.getText("CTL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPrefsPanel.this.browse();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[grow]2[]0", "0[]0"));
        panel.add((Component)this.folderLabel, "align left");
        panel.add((Component)this.folderText, "align left, growx 100");
        panel.add((Component)this.browseButton, "align left");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private void browse() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderText.getText()));
        Frame p = WindowManager.getDefault().getMainWindow();
        int returnVal = fc.showOpenDialog(p);
        if (returnVal == 0) {
            try {
                this.folderText.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderText.setText("");
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

