/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.ResizeControlPointResolver;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public final class ResizeAction
extends WidgetAction.LockedAdapter {
    private ResizeStrategy strategy;
    private ResizeControlPointResolver resolver;
    private ResizeProvider provider;
    private Widget resizingWidget = null;
    private ResizeProvider.ControlPoint controlPoint;
    private Rectangle originalSceneRectangle = null;
    private Insets insets;
    private Point dragSceneLocation = null;

    public ResizeAction(ResizeStrategy resizeStrategy, ResizeControlPointResolver resizeControlPointResolver, ResizeProvider resizeProvider) {
        this.strategy = resizeStrategy;
        this.resolver = resizeControlPointResolver;
        this.provider = resizeProvider;
    }

    protected boolean isLocked() {
        return this.resizingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1) {
            this.insets = widget.getBorder().getInsets();
            this.controlPoint = this.resolver.resolveControlPoint(widget, widgetMouseEvent.getPoint());
            if (this.controlPoint != null) {
                this.resizingWidget = widget;
                this.originalSceneRectangle = null;
                if (widget.isPreferredBoundsSet()) {
                    this.originalSceneRectangle = widget.getPreferredBounds();
                }
                if (this.originalSceneRectangle == null) {
                    this.originalSceneRectangle = widget.getBounds();
                }
                if (this.originalSceneRectangle == null) {
                    this.originalSceneRectangle = widget.getPreferredBounds();
                }
                this.dragSceneLocation = widget.convertLocalToScene(widgetMouseEvent.getPoint());
                this.provider.resizingStarted(widget);
                return WidgetAction.State.createLocked(widget, this);
            }
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        boolean bl = this.resize(widget, widgetMouseEvent.getPoint());
        if (bl) {
            this.resizingWidget = null;
            this.provider.resizingFinished(widget);
        }
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.resize(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean resize(Widget widget, Point point) {
        if (this.resizingWidget != widget) {
            return false;
        }
        point = widget.convertLocalToScene(point);
        int n = point.x - this.dragSceneLocation.x;
        int n2 = point.y - this.dragSceneLocation.y;
        int n3 = this.insets.left + this.insets.right;
        int n4 = this.insets.top + this.insets.bottom;
        Rectangle rectangle = new Rectangle(this.originalSceneRectangle);
        switch (this.controlPoint) {
            case BOTTOM_CENTER: {
                ResizeAction.resizeToBottom(n4, rectangle, n2);
                break;
            }
            case BOTTOM_LEFT: {
                ResizeAction.resizeToLeft(n3, rectangle, n);
                ResizeAction.resizeToBottom(n4, rectangle, n2);
                break;
            }
            case BOTTOM_RIGHT: {
                ResizeAction.resizeToRight(n3, rectangle, n);
                ResizeAction.resizeToBottom(n4, rectangle, n2);
                break;
            }
            case CENTER_LEFT: {
                ResizeAction.resizeToLeft(n3, rectangle, n);
                break;
            }
            case CENTER_RIGHT: {
                ResizeAction.resizeToRight(n3, rectangle, n);
                break;
            }
            case TOP_CENTER: {
                ResizeAction.resizeToTop(n4, rectangle, n2);
                break;
            }
            case TOP_LEFT: {
                ResizeAction.resizeToLeft(n3, rectangle, n);
                ResizeAction.resizeToTop(n4, rectangle, n2);
                break;
            }
            case TOP_RIGHT: {
                ResizeAction.resizeToRight(n3, rectangle, n);
                ResizeAction.resizeToTop(n4, rectangle, n2);
            }
        }
        widget.setPreferredBounds(this.strategy.boundsSuggested(widget, this.originalSceneRectangle, rectangle, this.controlPoint));
        return true;
    }

    private static void resizeToTop(int n, Rectangle rectangle, int n2) {
        if (rectangle.height - n2 < n) {
            n2 = rectangle.height - n;
        }
        rectangle.y += n2;
        rectangle.height -= n2;
    }

    private static void resizeToBottom(int n, Rectangle rectangle, int n2) {
        if (rectangle.height + n2 < n) {
            n2 = n - rectangle.height;
        }
        rectangle.height += n2;
    }

    private static void resizeToLeft(int n, Rectangle rectangle, int n2) {
        if (rectangle.width - n2 < n) {
            n2 = rectangle.width - n;
        }
        rectangle.x += n2;
        rectangle.width -= n2;
    }

    private static void resizeToRight(int n, Rectangle rectangle, int n2) {
        if (rectangle.width + n2 < n) {
            n2 = n - rectangle.width;
        }
        rectangle.width += n2;
    }
}

