/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import au.com.thinkingrock.tr.resource.Icons;
import au.com.trgtd.tr.appl.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.awt.Toolbar;
import org.openide.cookies.ViewCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.model.project.ProjectProjects;
import tr.prefs.gui.GUIPrefs;
import tr.util.Utils;
import tr.view.ReprocessAction;
import tr.view.Window;
import tr.view.projects.ActionNode;
import tr.view.projects.AddActionAction;
import tr.view.projects.AddProjectAction;
import tr.view.projects.EditCookie;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectRootNode;
import tr.view.projects.ProjectiseAction;
import tr.view.projects.ToggleShowDoneAction;

public class ProjectsTreeTopComponent
extends Window
implements ExplorerManager.Provider,
LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    private static final String PREFERRED_ID = "ProjectsTopComponent";
    private static ProjectsTreeTopComponent instance;
    private final ExplorerManager manager = new ExplorerManager();
    private boolean initialised;
    private Lookup.Result dataResult;
    private Lookup.Result itemResult;
    private JToolBar toolbar;
    private JScrollPane projectsPane;

    protected ProjectsTreeTopComponent() {
        this.setName(this.getText("CTL_ProjectsTopComponent"));
        this.setToolTipText(this.getText("TTT_ProjectsTopComponent"));
        this.setIcon(Icons.Projects.getImage());
        this.initComponents();
        this.initialise();
    }

    private void initComponents() {
        this.projectsPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.projectsPane, "Center");
    }

    private void initialise() {
        Data data;
        if (this.initialised) {
            return;
        }
        this.add(this.getToolbar(), GUIPrefs.getBorderLayoutButtonsPosition());
        if (this.dataResult == null) {
            this.dataResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ProjectsTreeTopComponent.this.initialised = false;
                }
            });
        }
        if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
            return;
        }
        this.manager.setRootContext((Node)new ProjectRootNode((ProjectProjects)data.getRootProjects(), false));
        this.manager.getRootContext().setDisplayName(this.getText("CTL_ProjectsNode"));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        try {
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.initialised = true;
    }

    private JToolBar getToolbar() {
        SystemAction[] actions = new SystemAction[]{SystemAction.get(AddActionAction.class), SystemAction.get(AddProjectAction.class), SystemAction.get(ReprocessAction.class), SystemAction.get(ProjectiseAction.class), SystemAction.get(ToggleShowDoneAction.class)};
        this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
        this.toolbar.setUI(new Toolbar().getUI());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(GUIPrefs.getToolBarOrientation());
        Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            component.setPreferredSize(buttonSize);
            component.setMinimumSize(buttonSize);
            component.setMaximumSize(buttonSize);
            component.setSize(buttonSize);
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.initialise();
    }

    private void addItemListener() {
        this.itemResult = this.getLookup().lookup(new Lookup.Template(Item.class));
        this.itemResult.addLookupListener((LookupListener)this);
        this.itemResult.allInstances();
    }

    private void removeItemListener() {
        if (this.itemResult != null) {
            this.itemResult.removeLookupListener((LookupListener)this);
            this.itemResult = null;
        }
    }

    public void componentActivated() {
        super.componentActivated();
        this.initialise();
        this.addItemListener();
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length == 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext()});
                this.takeFocus();
            }
            catch (Exception ex) {}
        } else if (selectedNodes[0] instanceof ProjectNode) {
            final ProjectNode projectNode = (ProjectNode)selectedNodes[0];
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.findInstance().view((Node)projectNode);
                    ProjectsTreeTopComponent.this.takeFocus();
                }
            });
        } else if (selectedNodes[0] instanceof ActionNode) {
            final ActionNode actionNode = (ActionNode)selectedNodes[0];
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.findInstance().view((Node)actionNode);
                    ProjectsTreeTopComponent.this.takeFocus();
                }
            });
        }
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.removeItemListener();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Node[] nodes = ProjectsTreeTopComponent.this.manager.getSelectedNodes();
                Node node = nodes.length > 0 ? nodes[0] : null;
                EditorTopComponent.findInstance().view(node);
            }
        });
    }

    public void clearSelection() {
        try {
            this.manager.setSelectedNodes(new Node[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getText(String key) {
        return NbBundle.getMessage(ProjectsTreeTopComponent.class, (String)key);
    }

    public TreeView getTreeView() {
        return (TreeView)this.projectsPane;
    }

    public static synchronized ProjectsTreeTopComponent getDefault() {
        if (instance == null) {
            instance = new ProjectsTreeTopComponent();
        }
        return instance;
    }

    public static synchronized ProjectsTreeTopComponent findInstance() {
        return ProjectsTreeTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects");
    }

    public void setShowDone(boolean b) {
        ProjectRootNode rootNode = (ProjectRootNode)this.manager.getRootContext();
        rootNode.setShowDone(b);
    }

    public boolean isSelected(Action action) {
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes != null && nodes.length > 0 && nodes[0] instanceof ActionNode) {
            return Utils.equal((Object)((ActionNode)nodes[0]).action, (Object)action);
        }
        return false;
    }

    public synchronized void select(Action action) {
        if (!this.isOpened()) {
            return;
        }
        if (action.isSingleAction()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(action);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            ViewCookie cookie = (ViewCookie)node.getCookie(ViewCookie.class);
            if (cookie != null) {
                cookie.view();
            }
        }
        catch (Exception ex) {
            LOG.severe("Action node could not be selected in the tree.");
        }
    }

    public synchronized void select(Project project) {
        if (!this.isOpened()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(project);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            ViewCookie cookie = (ViewCookie)node.getCookie(ViewCookie.class);
            if (cookie != null) {
                cookie.view();
            }
        }
        catch (Exception ex) {
            LOG.severe("Project node could not be selected in the tree.");
        }
    }

    public void edit(Project project) {
        if (!this.isOpened()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(project);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            EditCookie cookie = (EditCookie)node.getCookie(EditCookie.class);
            if (cookie != null) {
                cookie.edit();
            }
        }
        catch (Exception ex) {
            LOG.severe("Project node could not be selected in the tree.");
        }
    }

    public void edit(Action action) {
        if (!this.isOpened()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(action);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            EditCookie cookie = (EditCookie)node.getCookie(EditCookie.class);
            if (cookie != null) {
                cookie.edit();
            }
        }
        catch (Exception ex) {
            LOG.severe("Action node could not be selected in the tree.");
        }
    }

    public void takeFocus() {
        this.getTreeView().requestFocusInWindow();
    }
}

