/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import tr.swing.date.combo.DateItem;
import tr.swing.date.combo.DateType;

public class PersistenceInputStream {
    private final ObjectInputStream in;

    public PersistenceInputStream(File file) throws IOException {
        this.in = new ObjectInputStream(new FileInputStream(file));
    }

    public String readString() throws IOException {
        byte[] bytes = this.readBytes();
        return bytes == null ? null : new String(bytes);
    }

    public String[] readStrings() throws IOException {
        int length = this.in.readInt();
        if (length < 0) {
            return null;
        }
        String[] ss = new String[length];
        for (int i = 0; i < length; ++i) {
            ss[i] = this.readString();
        }
        return ss;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public byte[] readBytes() throws IOException {
        int length = this.in.readInt();
        if (length < 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.in.readByte();
        }
        return bytes;
    }

    public DateItem readDateItem() throws Exception {
        int id = this.in.readInt();
        if (id == -1) {
            return null;
        }
        String label = this.readString();
        long value = this.readLong();
        return new DateItem(DateType.getDateType((int)id), label, value);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

