/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import au.com.trgtd.tr.appl.InitialAction;
import java.awt.EventQueue;
import java.util.logging.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.future.screen.FutureTopComponent;
import tr.view.future.screen.FuturesTopComponent;

public class FuturesAction
extends CallableSystemAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.view.future");

    public FuturesAction() {
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                FuturesAction.this.enableDisable();
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_FutureAction");
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/SomedayMaybes.png";
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public String getID() {
        return "future";
    }

    public void performAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowUtils.closeWindows();
                FuturesTopComponent tcFutures = FuturesTopComponent.findInstance();
                FutureTopComponent tcFuture = FutureTopComponent.findInstance();
                Mode mode = WindowManager.getDefault().findMode("futures");
                if (mode == null) {
                    LOG.severe("Futures mode was not found.");
                } else {
                    mode.dockInto((TopComponent)tcFutures);
                }
                mode = WindowManager.getDefault().findMode("future");
                if (mode == null) {
                    LOG.severe("Future mode was not found.");
                } else {
                    mode.dockInto((TopComponent)tcFuture);
                }
                tcFutures.open();
                tcFuture.open();
                tcFutures.requestActive();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.future");
    }
}

