/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class G1rusProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_HEARTBEAT = 0;
    public static final int MSG_REGULAR = 1;
    public static final int MSG_SMS_FORWARD = 2;
    public static final int MSG_SERIAL = 3;
    public static final int MSG_MIXED = 4;

    public G1rusProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String readString(ByteBuf buf) {
        int length = buf.readUnsignedByte() & 0xF;
        return buf.readCharSequence(length, StandardCharsets.US_ASCII).toString();
    }

    private Position decodeRegular(DeviceSession deviceSession, ByteBuf buf, int type) {
        int dataMask;
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date((buf.readUnsignedIntLE() + 946684800L) * 1000L));
        if (BitUtil.check(type, 6)) {
            position.set("event", buf.readUnsignedByte());
        }
        if (BitUtil.check(dataMask = buf.readUnsignedShort(), 0)) {
            buf.readUnsignedByte();
            this.readString(buf);
            position.set("versionFw", this.readString(buf));
            position.set("versionHw", this.readString(buf));
        }
        if (BitUtil.check(dataMask, 1)) {
            buf.readUnsignedByte();
            int locationMask = buf.readUnsignedShort();
            if (BitUtil.check(locationMask, 0)) {
                short validity = buf.readUnsignedByte();
                position.set("sat", BitUtil.to(validity, 5));
                position.setValid(BitUtil.between(validity, 5, 7) == 2);
            }
            if (BitUtil.check(locationMask, 1)) {
                position.setLatitude((double)buf.readInt() / 1000000.0);
                position.setLongitude((double)buf.readInt() / 1000000.0);
            }
            if (BitUtil.check(locationMask, 2)) {
                position.setSpeed(buf.readUnsignedShort());
            }
            if (BitUtil.check(locationMask, 3)) {
                position.setCourse(buf.readUnsignedShort());
            }
            if (BitUtil.check(locationMask, 4)) {
                position.setAltitude(buf.readShort());
            }
            if (BitUtil.check(locationMask, 5)) {
                position.set("hdop", buf.readUnsignedShort());
            }
            if (BitUtil.check(locationMask, 6)) {
                position.set("vdop", buf.readUnsignedShort());
            }
        }
        if (BitUtil.check(dataMask, 2)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(dataMask, 3)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(dataMask, 4)) {
            buf.readUnsignedByte();
            position.set("power", buf.readUnsignedShort() * 110 / 4096 - 10);
            position.set("battery", buf.readUnsignedShort() * 110 / 4096 - 10);
            position.set("deviceTemp", buf.readUnsignedShort() * 110 / 4096 - 10);
        }
        if (BitUtil.check(dataMask, 5)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(dataMask, 7)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        String imei = String.valueOf(buf.readLong());
        buf.readerIndex(buf.readerIndex() - 1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        if (BitUtil.to(type, 6) == 1) {
            return this.decodeRegular(deviceSession, buf, type);
        }
        if (BitUtil.to(type, 6) == 4) {
            LinkedList<Position> positions = new LinkedList<Position>();
            while (buf.readableBytes() > 5) {
                int length = buf.readUnsignedShort();
                short subtype = buf.readUnsignedByte();
                if (BitUtil.to(subtype, 6) == 1) {
                    positions.add(this.decodeRegular(deviceSession, buf, subtype));
                    continue;
                }
                buf.skipBytes(length - 1);
            }
            return positions.isEmpty() ? null : positions;
        }
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        return null;
    }
}

