/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.RAFFile;
import java.io.IOException;

class Block {
    public static final int HEADERLEN = 8;
    public static final int IDLEN = 4;
    public int number;
    public boolean isLeaf = true;
    public int free = 0;
    public byte[] data = null;
    private static boolean debug = false;

    public Block(int n) {
        this.data = new byte[n - 8];
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("Block: " + string);
        }
    }

    public int integerAt(int n) {
        return (((this.data[n++] & 0xFF) << 8 | this.data[n++] & 0xFF) << 8 | this.data[n++] & 0xFF) << 8 | this.data[n] & 0xFF;
    }

    public static Block readIn(RAFFile rAFFile, Block block) throws IOException {
        Block.debug("readIn");
        block.number = rAFFile.readInt();
        int n = rAFFile.readInt();
        block.isLeaf = (n & Integer.MIN_VALUE) != 0;
        block.free = n & Integer.MAX_VALUE;
        rAFFile.readFully(block.data);
        return block;
    }

    public void setBlockNumber(int n) {
        this.number = n;
    }

    public void setFree(int n) {
    }

    public void setIntegerAt(int n, int n2) {
        int n3 = n + 3;
        while (n3 >= n) {
            this.data[n3] = (byte)(n2 & 0xFF);
            --n3;
            n2 >>>= 8;
        }
    }

    public void writeOut(RAFFile rAFFile) throws IOException {
        rAFFile.writeInt(this.number);
        rAFFile.writeInt(this.free | (this.isLeaf ? Integer.MIN_VALUE : 0));
        rAFFile.write(this.data);
    }
}

