/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.expression;

import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.expression.Expression;

public class EventValueExpression
extends Expression {
    private final String fieldName;

    public EventValueExpression(SourceWithMetadata meta, String fieldName) {
        super(meta);
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (this == sourceComponent) {
            return true;
        }
        if (sourceComponent instanceof EventValueExpression) {
            EventValueExpression other = (EventValueExpression)sourceComponent;
            return this.getFieldName().equals(other.getFieldName());
        }
        return false;
    }

    @Override
    public String toString() {
        return "event.get('" + this.fieldName + "')";
    }

    @Override
    public String toRubyString() {
        return "event.getField('" + this.fieldName + "')";
    }

    @Override
    public String hashSource() {
        return this.getClass().getCanonicalName() + "|" + this.fieldName;
    }
}

