/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.config.ir.CompiledPipeline;
import org.logstash.execution.AbortedBatchException;
import org.logstash.execution.ObservedExecution;
import org.logstash.execution.QueueBatch;
import org.logstash.execution.QueueReadClient;
import org.logstash.execution.WorkerObserver;

public final class WorkerLoop
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(WorkerLoop.class);
    private final ObservedExecution<QueueBatch> execution;
    private final QueueReadClient readClient;
    private final AtomicBoolean flushRequested;
    private final AtomicBoolean flushing;
    private final AtomicBoolean shutdownRequested;
    private final LongAdder consumedCounter;
    private final LongAdder filteredCounter;
    private final boolean drainQueue;

    public WorkerLoop(QueueReadClient readClient, CompiledPipeline compiledPipeline, WorkerObserver workerObserver, LongAdder consumedCounter, LongAdder filteredCounter, AtomicBoolean flushRequested, AtomicBoolean flushing, AtomicBoolean shutdownRequested, boolean drainQueue, boolean preserveEventOrder) {
        this.execution = workerObserver.ofExecution(compiledPipeline.buildExecution(preserveEventOrder));
        this.readClient = readClient;
        this.consumedCounter = consumedCounter;
        this.filteredCounter = filteredCounter;
        this.drainQueue = drainQueue;
        this.flushRequested = flushRequested;
        this.flushing = flushing;
        this.shutdownRequested = shutdownRequested;
    }

    @Override
    public void run() {
        try {
            QueueBatch batch;
            boolean isShutdown = false;
            boolean isNackBatch = false;
            do {
                isShutdown = isShutdown || this.shutdownRequested.get();
                batch = this.readClient.readBatch();
                boolean isFlush = this.flushRequested.compareAndSet(true, false);
                if (batch.filteredSize() <= 0 && !isFlush) continue;
                this.consumedCounter.add(batch.filteredSize());
                isNackBatch = this.abortableCompute(batch, isFlush, false);
                if (isNackBatch) continue;
                this.filteredCounter.add(batch.filteredSize());
                this.readClient.closeBatch(batch);
                if (!isFlush) continue;
                this.flushing.set(false);
            } while ((!isShutdown || this.isDraining()) && !isNackBatch);
            if (!isNackBatch) {
                batch = this.readClient.newBatch();
                this.abortableCompute(batch, true, true);
                this.readClient.closeBatch(batch);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private boolean abortableCompute(QueueBatch batch, boolean flush, boolean shutdown) {
        boolean isNackBatch = false;
        try {
            this.execution.compute(batch, flush, shutdown);
        }
        catch (Exception ex) {
            if (ex instanceof AbortedBatchException) {
                isNackBatch = true;
                LOGGER.info("Received signal to abort processing current batch. Terminating pipeline worker {}", (Object)Thread.currentThread().getName());
            }
            throw ex;
        }
        return isNackBatch;
    }

    public boolean isDraining() {
        return this.drainQueue && !this.readClient.isEmpty();
    }
}

