/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import co.elastic.logstash.api.DeprecationLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.log.DefaultDeprecationLogger;
import org.logstash.settings.SettingDelegator;
import org.logstash.settings.SettingWithDeprecatedAlias;

public final class DeprecatedAlias<T>
extends SettingDelegator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DeprecationLogger DEPRECATION_LOGGER = new DefaultDeprecationLogger(LOGGER);
    private final SettingWithDeprecatedAlias<T> canonicalProxy;
    private final String obsoletedVersion;

    DeprecatedAlias(SettingWithDeprecatedAlias<T> canonicalProxy, String aliasName, String obsoletedVersion) {
        super(canonicalProxy.getCanonicalSetting().deprecate(aliasName));
        this.canonicalProxy = canonicalProxy;
        this.obsoletedVersion = obsoletedVersion;
    }

    public void observePostProcess() {
        if (this.isSet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("The setting `").append(this.getName()).append("` is a deprecated alias for `").append(this.canonicalProxy.getName()).append("`");
            if (this.obsoletedVersion != null && !this.obsoletedVersion.isEmpty()) {
                sb.append(" and will be removed in version ").append(this.obsoletedVersion).append(".");
            } else {
                sb.append(" and will be removed in a future release of Logstash.");
            }
            sb.append(" Please use `").append(this.canonicalProxy.getName()).append("` instead");
            DEPRECATION_LOGGER.deprecated(sb.toString(), new Object[0]);
        }
    }

    @Override
    public T value() {
        LOGGER.warn("The value of setting `{}` has been queried by its deprecated alias `{}`. Code should be updated to query `{}` instead", (Object)this.canonicalProxy.getName(), (Object)this.getName(), (Object)this.canonicalProxy.getName());
        return super.value();
    }

    @Override
    public void validateValue() {
        if (this.isSet()) {
            this.getDelegate().validateValue();
        }
    }
}

