/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.Event;
import org.logstash.dissect.Delimiter;
import org.logstash.dissect.DissectResult;
import org.logstash.dissect.FieldDelimiterHolder;
import org.logstash.dissect.ValueRef;
import org.logstash.dissect.ValueResolver;
import org.logstash.dissect.fields.Field;
import org.logstash.dissect.fields.FieldComparator;
import org.logstash.dissect.fields.FieldFactory;

public class Dissector {
    private static final Pattern DELIMITER_FIELD_PATTERN = Pattern.compile("(.*?)%\\{([^}]*?)}", 32);
    private static final Pattern FINAL_DELIMITER_PATTERN = Pattern.compile("[^}]+$");
    private final List<Field> fields = new ArrayList<Field>(10);
    private final List<Field> saveableFields = new ArrayList<Field>(10);
    private int offsetOfFirstField = 0;
    private String mapping = "";

    public static Dissector create(String mapping) {
        Dissector dissector = new Dissector();
        dissector.handleMapping(mapping);
        return dissector;
    }

    public final String getMapping() {
        return this.mapping;
    }

    private void handleMapping(String mapping) {
        this.mapping = mapping;
        if (mapping.isEmpty()) {
            throw new IllegalArgumentException("The mapping string cannot be empty");
        }
        List<FieldDelimiterHolder> list = this.createFieldAssociations(mapping);
        this.createFieldList(list);
    }

    private List<FieldDelimiterHolder> createFieldAssociations(String mapping) {
        ArrayList<FieldDelimiterHolder> list = new ArrayList<FieldDelimiterHolder>(10);
        Matcher matcher = DELIMITER_FIELD_PATTERN.matcher(mapping);
        int fieldIndex = 0;
        while (matcher.find()) {
            Delimiter delimiter = Delimiter.create(matcher.group(1));
            FieldDelimiterHolder temp = new FieldDelimiterHolder(fieldIndex, matcher.group(2), delimiter);
            if (list.isEmpty()) {
                if (delimiter.size() > 0) {
                    this.offsetOfFirstField = delimiter.size();
                }
            } else {
                ((FieldDelimiterHolder)list.get(fieldIndex - 1)).setNext(delimiter);
            }
            list.add(fieldIndex, temp);
            ++fieldIndex;
        }
        Matcher endsWithDelimiterMatcher = FINAL_DELIMITER_PATTERN.matcher(mapping);
        if (endsWithDelimiterMatcher.find()) {
            Delimiter finalDelimiter = Delimiter.create(endsWithDelimiterMatcher.group(0));
            FieldDelimiterHolder holder = new FieldDelimiterHolder(fieldIndex, "?auto_added_skip", finalDelimiter);
            list.add(fieldIndex, holder);
            ((FieldDelimiterHolder)list.get(fieldIndex - 1)).setNext(finalDelimiter);
        }
        return list;
    }

    private void createFieldList(Iterable<FieldDelimiterHolder> list) {
        for (FieldDelimiterHolder holder : list) {
            Field field = FieldFactory.create(holder.getId(), holder.getName(), holder.getPrevious(), holder.getNext());
            this.fields.add(field);
            if (!field.saveable()) continue;
            this.saveableFields.add(field);
        }
        this.saveableFields.sort(new FieldComparator());
    }

    public final DissectResult dissect(byte[] source, Map<String, Object> keyValueMap) {
        ValueRef[] valueRefs = this.createValueRefArray();
        DissectResult result = new DissectResult();
        if (this.fields.isEmpty() || source == null || source.length == 0) {
            result.bail();
        } else {
            this.dissectValues(source, valueRefs, result);
            ValueResolver resolver = new ValueResolver(source, valueRefs);
            if (result.matched()) {
                for (Field field : this.saveableFields) {
                    field.append(keyValueMap, resolver);
                }
            }
        }
        return result;
    }

    public final DissectResult dissect(byte[] source, Event event) {
        ValueRef[] valueRefs = this.createValueRefArray();
        DissectResult result = new DissectResult();
        if (this.fields.isEmpty() || source.length == 0) {
            result.bail();
        } else {
            this.dissectValues(source, valueRefs, result);
            ValueResolver resolver = new ValueResolver(source, valueRefs);
            if (result.matched()) {
                for (Field field : this.saveableFields) {
                    field.append(event, resolver);
                }
            }
        }
        return result;
    }

    private ValueRef[] createValueRefArray() {
        ValueRef[] array = new ValueRef[this.fields.size()];
        for (Field field : this.fields) {
            array[field.id()] = new ValueRef(field.name());
        }
        return array;
    }

    private void dissectValues(byte[] source, ValueRef[] fieldValueRefs, DissectResult result) {
        Position position = new Position(source, this.offsetOfFirstField);
        int numFields = this.fields.size();
        int lastFieldIndex = numFields - 1;
        for (int idx = 0; idx < lastFieldIndex; ++idx) {
            Field field = this.fields.get(idx);
            fieldValueRefs[field.id()].clear();
            position.moveBeyondDelimiter(field.previousDelimiter(), result);
            if (result.notMatched()) break;
            position.moveNext(field.nextDelimiter(), result);
            if (result.notMatched()) break;
            fieldValueRefs[field.id()].update(position.start, position.length);
        }
        if (result.matched()) {
            Field lastField = this.fields.get(lastFieldIndex);
            fieldValueRefs[lastField.id()].clear();
            position.moveBeyondDelimiter(lastField.previousDelimiter(), result);
            position.repositionToEnd();
            fieldValueRefs[lastField.id()].update(position.start, position.length);
        }
    }

    private static final class Position {
        int pos;
        final int firstFieldOffset;
        int left;
        final byte[] source;
        int start;
        int length;

        Position(byte[] sourceBytes, int offsetFirstField) {
            this.source = sourceBytes;
            this.firstFieldOffset = offsetFirstField;
            this.left = 0;
            this.pos = 0;
            this.start = 0;
            this.length = 0;
        }

        void setStart() {
            this.start = this.left;
        }

        void setLength() {
            this.length = this.pos - this.left;
        }

        void repositionToEnd() {
            this.pos = this.source.length;
            this.setLength();
        }

        void moveNext(Delimiter next, DissectResult result) {
            this.length = 0;
            this.pos = next.indexOf(this.source, this.left);
            if (this.pos == -1) {
                result.bail();
            } else if (this.pos > 0) {
                this.setLength();
                this.left = this.pos + next.size();
            }
        }

        void moveBeyondDelimiter(Delimiter prev, DissectResult result) {
            if (prev == null) {
                this.setStart();
            } else if (prev.isGreedy()) {
                while (true) {
                    this.pos = prev.indexOf(this.source, this.left);
                    if (this.pos != this.left) break;
                    this.left = this.pos + prev.size();
                }
                if (this.pos == -1) {
                    this.setStart();
                } else {
                    this.setStart();
                }
            } else {
                if (this.left == 0 && this.firstFieldOffset > 0) {
                    this.pos = prev.indexOf(this.source, this.left);
                    if (this.pos == 0) {
                        this.left = this.pos + prev.size();
                    } else {
                        result.bail();
                    }
                }
                this.setStart();
            }
        }
    }
}

