/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class NumericTypeCompiler
extends BaseTypeCompiler {
    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.NumberDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 6: {
                return "double";
            }
            case 7: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 8: {
                return "float";
            }
            case 10: {
                return "short";
            }
            case 195: {
                return "byte";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId));
        return null;
    }

    @Override
    public String getPrimitiveMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 6: {
                return "getDouble";
            }
            case 7: {
                return "getInt";
            }
            case 11: {
                return "getLong";
            }
            case 8: {
                return "getFloat";
            }
            case 10: {
                return "getShort";
            }
            case 195: {
                return "getByte";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getPrimitiveMethodName() - " + formatId));
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 197: {
                return dts.getPrecision() + 2;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 11;
            }
            case 11: {
                return 20;
            }
            case 8: {
                return 25;
            }
            case 10: {
                return 6;
            }
            case 195: {
                return 4;
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCastToCharWidth() - " + formatId));
        return 0;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator) throws StandardException {
        int maximumWidth;
        int scale;
        NumericTypeCompiler higherTC;
        DataTypeDescriptor higherType;
        SanityManager.ASSERT((boolean)leftType.getTypeId().isNumericTypeId(), (String)"The left type is supposed to be a number because we're resolving an arithmetic operator");
        TypeId leftTypeId = leftType.getTypeId();
        TypeId rightTypeId = rightType.getTypeId();
        boolean supported = true;
        if (!rightTypeId.isNumericTypeId()) {
            supported = false;
        }
        if ("mod".equals(operator)) {
            switch (leftTypeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    supported = false;
                }
            }
            switch (rightTypeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    supported = false;
                }
            }
        }
        if (!supported) {
            throw StandardException.newException((String)"42Y95", (Object[])new Object[]{operator, leftType.getTypeId().getSQLTypeName(), rightType.getTypeId().getSQLTypeName()});
        }
        if (rightTypeId.typePrecedence() > leftTypeId.typePrecedence()) {
            higherType = rightType;
            higherTC = (NumericTypeCompiler)this.getTypeCompiler(rightTypeId);
        } else {
            higherType = leftType;
            higherTC = (NumericTypeCompiler)this.getTypeCompiler(leftTypeId);
        }
        int precision = higherTC.getPrecision(operator, leftType, rightType);
        if (higherType.getTypeId().isDecimalTypeId()) {
            scale = higherTC.getScale(operator, leftType, rightType);
            int n = maximumWidth = scale > 0 ? precision + 3 : precision + 1;
            if (maximumWidth < precision) {
                maximumWidth = Integer.MAX_VALUE;
            }
        } else {
            scale = 0;
            maximumWidth = higherType.getMaximumWidth();
        }
        boolean nullable = leftType.isNullable() || rightType.isNullable();
        return new DataTypeDescriptor(higherType.getTypeId(), precision, scale, nullable, maximumWidth);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return this.numberConvertible(otherType, forDataTypeFunction);
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return otherType.isNumericTypeId();
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        return this.numberStorable(this.getTypeId(), otherType, cf);
    }

    @Override
    String dataValueMethodName() {
        if (this.getStoredFormatIdFromTypeId() == 197) {
            return "getDecimalDataValue";
        }
        return super.dataValueMethodName();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 197: {
                return "getNullDecimal";
            }
            case 6: {
                return "getNullDouble";
            }
            case 7: {
                return "getNullInteger";
            }
            case 11: {
                return "getNullLong";
            }
            case 8: {
                return "getNullFloat";
            }
            case 10: {
                return "getNullShort";
            }
            case 195: {
                return "getNullByte";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in nullMethodName() - " + formatId));
        return null;
    }

    private int getPrecision(String operator, DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        long val;
        if (this.getStoredFormatIdFromTypeId() != 197) {
            return leftType.getPrecision();
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        if (operator == null) {
            val = (long)this.getScale(operator, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale);
        } else if (operator.equals("*")) {
            val = lprec + rprec;
        } else if (operator.equals("sum")) {
            val = lprec - lscale + rprec - rscale + (long)this.getScale(operator, leftType, rightType);
        } else if (operator.equals("/")) {
            val = Math.min(31L, (long)this.getScale(operator, leftType, rightType) + lprec - lscale + rprec);
        } else {
            val = (long)this.getScale(operator, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale) + 1L;
            if (val > 31L) {
                val = 31L;
            }
        }
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        val = Math.min(31L, val);
        return (int)val;
    }

    private int getScale(String operator, DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long val = "*".equals(operator) ? lscale + rscale : ("/".equals(operator) ? Math.max(31L - lprec + lscale - rscale, 0L) : ("avg".equals(operator) ? Math.max(Math.max(lscale, rscale), 4L) : Math.max(lscale, rscale)));
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        val = Math.min(31L, val);
        return (int)val;
    }

    @Override
    public void generateDataValue(MethodBuilder mb, int collationType, LocalField field) {
        if (this.getTypeId().isDecimalTypeId()) {
            mb.upCast("java.lang.Number");
        }
        super.generateDataValue(mb, collationType, field);
    }
}

