/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.ForeignKeyRIChecker;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.ReferencedKeyRIChecker;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class RISetChecker {
    private GenericRIChecker[] checkers;
    LanguageConnectionContext lcc;

    public RISetChecker(LanguageConnectionContext lcc, TransactionController tc, FKInfo[] fkInfo) throws StandardException {
        if (fkInfo == null) {
            return;
        }
        this.checkers = new GenericRIChecker[fkInfo.length];
        this.lcc = lcc;
        for (int i = 0; i < fkInfo.length; ++i) {
            this.checkers[i] = fkInfo[i].type == 1 ? new ForeignKeyRIChecker(lcc, tc, fkInfo[i]) : new ReferencedKeyRIChecker(lcc, tc, fkInfo[i]);
        }
    }

    void reopen() throws StandardException {
    }

    public void doPKCheck(Activation a, ExecRow row, boolean restrictCheckOnly, int deferredRowReq) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (GenericRIChecker checker : this.checkers) {
            if (!(checker instanceof ReferencedKeyRIChecker)) continue;
            checker.doCheck(a, row, restrictCheckOnly, deferredRowReq);
        }
    }

    public void postCheck() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            this.postCheck(i);
        }
    }

    public void postCheck(int index) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        if (this.checkers[index] instanceof ReferencedKeyRIChecker) {
            ((ReferencedKeyRIChecker)this.checkers[index]).postCheck();
        }
    }

    public void doFKCheck(Activation a, ExecRow row) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            if (!(this.checkers[i] instanceof ForeignKeyRIChecker)) continue;
            this.checkers[i].doCheck(a, row, false, 0);
        }
    }

    public void doRICheck(Activation a, int index, ExecRow row, boolean restrictCheckOnly, int deferredRowReq) throws StandardException {
        if (this.checkers == null) {
            SanityManager.THROWASSERT((String)("no checkers, how can i execute checker " + index));
        }
        if (index >= this.checkers.length) {
            SanityManager.THROWASSERT((String)("there are only " + this.checkers.length + " checkers, " + index + " is invalid"));
        }
        this.checkers[index].doCheck(a, row, restrictCheckOnly, deferredRowReq);
    }

    public void close() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            this.checkers[i].close();
        }
    }
}

