/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortScan;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class MergeScan
extends SortScan {
    protected SortBuffer sortBuffer;
    protected Vector<Long> mergeRuns;
    protected StreamContainerHandle[] openScans;
    private SortObserver sortObserver;

    MergeScan(MergeSort sort, TransactionManager tran, SortBuffer sortBuffer, Vector<Long> mergeRuns, SortObserver sortObserver, boolean hold) {
        super(sort, tran, hold);
        this.sortBuffer = sortBuffer;
        this.mergeRuns = mergeRuns;
        this.tran = tran;
        this.sortObserver = sortObserver;
    }

    @Override
    public boolean next() throws StandardException {
        this.current = this.sortBuffer.removeFirst();
        if (this.current != null) {
            this.mergeARow(this.sortBuffer.getLastAux());
        }
        return this.current != null;
    }

    @Override
    public void close() {
        if (this.openScans != null) {
            for (int i = 0; i < this.openScans.length; ++i) {
                if (this.openScans[i] != null) {
                    this.openScans[i].close();
                }
                this.openScans[i] = null;
            }
            this.openScans = null;
        }
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer, this.mergeRuns);
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        super.close();
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) {
        if (!this.hold || closeHeldScan) {
            this.close();
            return true;
        }
        return false;
    }

    public boolean init(TransactionManager tran) throws StandardException {
        SanityManager.ASSERT((this.mergeRuns != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.mergeRuns.size() > 0 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.sortBuffer.capacity() >= this.mergeRuns.size() ? 1 : 0) != 0);
        this.sortBuffer.reset();
        this.openScans = new StreamContainerHandle[this.mergeRuns.size()];
        if (this.openScans == null) {
            return false;
        }
        int scanindex = 0;
        Enumeration<Long> e = this.mergeRuns.elements();
        while (e.hasMoreElements()) {
            long id = e.nextElement();
            Transaction rawTran = tran.getRawStoreXact();
            int segmentId = -1;
            this.openScans[scanindex++] = rawTran.openStreamContainer(segmentId, id, this.hold);
        }
        for (scanindex = 0; scanindex < this.openScans.length; ++scanindex) {
            this.mergeARow(scanindex);
        }
        return true;
    }

    void mergeARow(int scanindex) throws StandardException {
        DataValueDescriptor[] row;
        SanityManager.ASSERT((this.openScans[scanindex] != null ? 1 : 0) != 0);
        do {
            if (!this.openScans[scanindex].fetchNext(row = this.sortObserver.getArrayClone())) {
                this.openScans[scanindex].close();
                this.openScans[scanindex] = null;
                return;
            }
            this.sortBuffer.setNextAux(scanindex);
        } while (this.sortBuffer.insert(row) == 1);
    }
}

