/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisAtomizingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AtomizedValueIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AtomizingIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.iter.UntypedAtomizingIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Atomizer
extends UnaryExpression {
    private boolean untyped = false;
    private boolean singleValued = false;
    private ItemType operandItemType = null;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public Atomizer(Expression sequence) {
        super(sequence);
        sequence.setFlattened(true);
    }

    public static Expression makeAtomizer(Expression sequence) {
        if (sequence instanceof Literal && ((Literal)sequence).getValue() instanceof AtomicSequence) {
            return sequence;
        }
        Atomizer a2 = new Atomizer(sequence);
        ExpressionTool.copyLocationInfo(sequence, a2);
        return a2;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.ATOMIC_SEQUENCE;
    }

    @Override
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    public ItemType getOperandItemType(TypeHierarchy th) {
        if (this.operandItemType == null) {
            this.operandItemType = this.operand.getItemType();
        }
        return this.operandItemType;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.untyped = !visitor.getStaticContext().isSchemaAware();
        this.computeSingleValued();
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            Item i;
            GroundedValue val = ((Literal)this.operand).getValue();
            if (val instanceof AtomicValue) {
                return this.operand;
            }
            UnfailingIterator iter = val.iterate();
            do {
                if ((i = iter.next()) == null) {
                    return this.operand;
                }
                if (!(i instanceof NodeInfo)) continue;
                return this;
            } while (!(i instanceof FunctionItem));
            XPathException err = new XPathException("Cannot atomize a function item", "FOTY0013");
            err.setLocator(this);
            throw err;
        }
        if (this.operand instanceof ValueOf && (((ValueOf)this.operand).getOptions() & 1) == 0) {
            return ((ValueOf)this.operand).convertToCastAsString();
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.untyped = !visitor.getStaticContext().isSchemaAware();
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.computeSingleValued();
        visitor.resetStaticProperties();
        ItemType operandType = this.operand.getItemType();
        if (th.isSubType(operandType, BuiltInAtomicType.ANY_ATOMIC)) {
            return this.operand;
        }
        if (!operandType.isAtomizable()) {
            XPathException err = operandType instanceof FunctionItemType ? new XPathException("Cannot atomize a function item", "FOTY0013") : new XPathException("Cannot atomize an element that is defined in the schema to have element-only content", "FOTY0012");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.operand.setFlattened(true);
        return this;
    }

    private void computeSingleValued() {
        ItemType nodeType;
        this.singleValued = this.untyped;
        if (!this.singleValued && (nodeType = this.operand.getItemType()) instanceof NodeTest) {
            int mask;
            SchemaType st = ((NodeTest)nodeType).getContentType();
            if (st == Untyped.getInstance() || st.isAtomicType() || st.isComplexType() && st != AnyType.getInstance()) {
                this.singleValued = true;
            }
            if (((mask = ((NodeTest)nodeType).getNodeKindMask()) & 6) == 0) {
                this.singleValued = true;
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.operand.getItemType(), BuiltInAtomicType.ANY_ATOMIC)) {
                return this.operand;
            }
            if (this.operand instanceof ValueOf && (((ValueOf)this.operand).getOptions() & 1) == 0) {
                Expression cast = ((ValueOf)this.operand).convertToCastAsString();
                return cast.optimize(visitor, contextItemType);
            }
            if (this.operand instanceof LetExpression || this.operand instanceof ForExpression) {
                Expression action = ((Assignation)this.operand).getAction();
                ((Assignation)this.operand).setAction(new Atomizer(action));
                return this.operand.optimize(visitor, contextItemType);
            }
            if (this.operand instanceof Choose) {
                Expression[] actions = ((Choose)this.operand).getActions();
                for (int i = 0; i < actions.length; ++i) {
                    actions[i] = new Atomizer(actions[i]);
                }
                return this.operand.optimize(visitor, contextItemType);
            }
            if (this.operand instanceof Block) {
                Expression[] children = ((Block)this.operand).getChildren();
                Expression[] atomizedChildren = new Expression[children.length];
                for (int i = 0; i < children.length; ++i) {
                    atomizedChildren[i] = new Atomizer(children[i]);
                }
                Block newBlock = new Block();
                newBlock.setChildren(atomizedChildren);
                return newBlock.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        return exp;
    }

    public boolean isUntyped() {
        return this.untyped;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return (p &= 0xFB40FFFF) | 0x400000;
    }

    @Override
    public Expression copy() {
        Atomizer copy = new Atomizer(this.getBaseExpression().copy());
        copy.untyped = this.untyped;
        copy.singleValued = this.singleValued;
        ExpressionTool.copyLocationInfo(this, copy);
        return copy;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.getBaseExpression(), OperandRole.SINGLE_ATOMIC));
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return Atomizer.getAtomizingIterator(base, this.untyped);
    }

    @Override
    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        Item i = this.operand.evaluateItem(context);
        if (i == null) {
            return null;
        }
        if (i instanceof NodeInfo) {
            return ((NodeInfo)i).atomize().head();
        }
        if (i instanceof AtomicValue) {
            return (AtomicValue)i;
        }
        if (i instanceof ObjectValue) {
            return StringValue.makeStringValue(i.getStringValue());
        }
        throw new XPathException("Cannot atomize a function item", "FOTY0013");
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        super.process(context);
    }

    @Override
    public ItemType getItemType() {
        this.operandItemType = this.operand.getItemType();
        if (this.getConfiguration() == null) {
            throw new NullPointerException(this.toString());
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return Atomizer.getAtomizedItemType(this.operand, this.untyped, th);
    }

    public static ItemType getAtomizedItemType(Expression operand, boolean alwaysUntyped, TypeHierarchy th) {
        ItemType in = operand.getItemType();
        if (in.isPlainType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            int kinds = ((NodeTest)in).getNodeKindMask();
            if (alwaysUntyped) {
                if ((kinds | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((kinds | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((kinds | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        if (in instanceof JavaExternalObjectType) {
            return in.getAtomizedItemType();
        }
        if (in instanceof FunctionItemType) {
            return null;
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public int computeCardinality() {
        SchemaType schemaType;
        if (this.untyped || this.singleValued) {
            return this.operand.getCardinality();
        }
        if (Cardinality.allowsMany(this.operand.getCardinality())) {
            return 57344;
        }
        ItemType in = this.operandItemType;
        if (in == null) {
            try {
                in = this.operand.getItemType();
            }
            catch (NullPointerException npe) {
                return 57344;
            }
        }
        if (in.isPlainType()) {
            return this.operand.getCardinality();
        }
        if (in instanceof NodeTest && (schemaType = ((NodeTest)in).getContentType()).isAtomicType()) {
            return this.operand.getCardinality();
        }
        return 57344;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        ItemType operandItemType;
        TypeHierarchy th;
        PathMap.PathMapNodeSet result = this.operand.addToPathMap(pathMap, pathMapNodeSet);
        if (result != null && ((th = this.getContainer().getConfiguration().getTypeHierarchy()).relationship(NodeKindTest.ELEMENT, operandItemType = this.operand.getItemType()) != 4 || th.relationship(NodeKindTest.DOCUMENT, operandItemType) != 4)) {
            result.setAtomized();
        }
        return null;
    }

    public static SequenceIterator getAtomizingIterator(SequenceIterator base, boolean untyped) throws XPathException {
        int properties = base.getProperties();
        if ((properties & 2) != 0) {
            int count = ((LastPositionFinder)((Object)base)).getLength();
            if (count == 0) {
                return EmptyIterator.emptyIterator();
            }
            if (count == 1) {
                Item first = base.next();
                assert (first != null);
                if (first instanceof NodeInfo) {
                    return ((NodeInfo)first).atomize().iterate();
                }
                if (first instanceof AtomicValue) {
                    return ((AtomicValue)first).iterate();
                }
                if (first instanceof ObjectValue) {
                    return StringValue.makeStringValue(first.getStringValue()).iterate();
                }
                throw new XPathException("Attempting to atomize a function item", "FOTY0013");
            }
        } else if ((properties & 8) != 0) {
            return new AxisAtomizingIterator((AtomizedValueIterator)base);
        }
        if (untyped) {
            return new UntypedAtomizingIterator(base);
        }
        return new AtomizingIterator(base);
    }

    @Override
    public String getExpressionName() {
        return "data";
    }

    @Override
    public String toString() {
        return "data(" + this.operand.toString() + ")";
    }

    @Override
    public String toShortString() {
        return this.operand.toShortString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomizingFunction
    implements MappingFunction<Item, AtomicValue> {
        private static final AtomizingFunction theInstance = new AtomizingFunction();

        private AtomizingFunction() {
        }

        public static AtomizingFunction getInstance() {
            return theInstance;
        }

        public AtomicIterator map(Item item) throws XPathException {
            if (item instanceof NodeInfo) {
                return ((NodeInfo)item).atomize().iterate();
            }
            if (item instanceof AtomicValue) {
                return new SingleAtomicIterator((AtomicValue)item);
            }
            throw new XPathException("Cannot atomize a function item or external object", "FOTY0013");
        }
    }
}

