/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class LogicalStatementEntity
implements Statement {
    private final boolean hasCallableStmt;
    private PreparedStatement physicalPs;
    private CallableStatement physicalCs;
    private StatementCacheInteractor owner;
    private final StatementKey stmtKey;
    private final JDBCStatementCache cache;

    protected LogicalStatementEntity(PreparedStatement physicalPs, StatementKey stmtKey, StatementCacheInteractor cacheInteractor) {
        if (cacheInteractor.getCache() == null) {
            throw new IllegalArgumentException("statement cache reference cannot be <null>");
        }
        this.stmtKey = stmtKey;
        this.cache = cacheInteractor.getCache();
        this.owner = cacheInteractor;
        this.physicalPs = physicalPs;
        if (physicalPs instanceof CallableStatement) {
            this.hasCallableStmt = true;
            this.physicalCs = (CallableStatement)physicalPs;
        } else {
            this.hasCallableStmt = false;
            this.physicalCs = null;
        }
        ((ClientPreparedStatement)physicalPs).setOwner(this);
    }

    synchronized PreparedStatement getPhysPs() throws SQLException {
        if (this.physicalPs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "PreparedStatement").getSQLException();
        }
        return this.physicalPs;
    }

    synchronized CallableStatement getPhysCs() throws SQLException {
        SanityManager.ASSERT((boolean)this.hasCallableStmt, (String)"called getPhysCs(), but created with PreparedStatement");
        if (this.physicalCs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "CallableStatement").getSQLException();
        }
        return this.physicalCs;
    }

    private synchronized Statement getPhysStmt() throws SQLException {
        if (this.hasCallableStmt) {
            return this.getPhysCs();
        }
        return this.getPhysPs();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.physicalPs != null) {
            ClientPreparedStatement temporaryPsRef = (ClientPreparedStatement)this.physicalPs;
            this.physicalPs = null;
            this.physicalCs = null;
            this.owner.markClosed(this);
            this.owner = null;
            temporaryPsRef.setOwner(null);
            if (!temporaryPsRef.openOnClient_) {
                return;
            }
            if (!temporaryPsRef.isPoolable) {
                temporaryPsRef.close();
                return;
            }
            try {
                temporaryPsRef.resetForReuse();
            }
            catch (SqlException sqle) {
                throw sqle.getSQLException();
            }
            if (!this.cache.cacheStatement(this.stmtKey, temporaryPsRef)) {
                temporaryPsRef.close();
            }
        }
    }

    synchronized boolean isLogicalEntityClosed() {
        return this.physicalPs == null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.getPhysStmt();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (((ClientStatement)this.getPhysStmt()).isClosed()) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), this.hasCallableStmt ? "CallableStatement" : "PreparedStatement").getSQLException();
        }
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), iface).getSQLException();
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((ClientStatement)this.getPhysStmt()).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).isCloseOnCompletion();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(sql, columnNames);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long maxRows) throws SQLException {
        ((ClientStatement)this.getPhysStmt()).setLargeMaxRows(maxRows);
    }
}

