<?php
/******************************************************************************
 * wolfram.php
 * ----------
 * Author: Mysterious Light (youngmysteriouslight@gmail.com)
 * Copyright: (c) 2018 Mysterious Light (youngmysteriouslight@gmail.com)
 * Release Version: 1.0.9.1
 * Date Started: 2018/01/12
 *
 * Wolfram language file for GeSHi.
 *
 ******************************************************************************
 *
 *   This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/

$language_data = array (
    'LANG_NAME' => 'Wolfram',
    'COMMENT_SINGLE' => array(),
    'COMMENT_MULTI' => array('(*' => '*)'),
    'COMMENT_REGEXP' => array(
        2 => '/\\(\\*.*\\*\\)/',
        3 => '/\\\\\\[\\w+]/'
        ),
    'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
    'QUOTEMARKS' => array('"'),
    'ESCAPE_CHAR' => '\\',
    'KEYWORDS' => array(
        /* main wolfram keywords */
        1 => array(
            'AbelianGroup', '$Aborted', 'AbortKernels', 'Abort', 'Abs', 'All',
            'AbortProtect', 'AbsoluteCurrentValue', 'AbsoluteDashing', 'AddTo',
            'AbsoluteFileName', 'AbsoluteOptions', 'AbsolutePointSize', 'And',
            'AbsoluteThickness', 'AbsoluteTime', 'AbsoluteTiming', 'Accuracy',
            'AccountingForm', 'Accumulate', 'AccuracyGoal', 'ActionMenu', 'C',
            'Active', 'ActiveStyle', 'AcyclicGraphQ', 'AddOnHelpPath', 'Alias',
            'AdjacencyGraph', 'AdjacencyMatrix', 'AdjustmentBox', 'AiryAi',
            'AffineTransform', 'AiryAiPrime', 'AiryAiZero', 'AiryBi', 'AngerJ',
            'AiryBiPrime', 'AiryBiZero', 'AlgebraicIntegerQ', 'AlgebraicRules',
            'AlgebraicNumberDenominator', 'AlgebraicNumber', 'Algebraics', 'D',
            'AlgebraicNumberNorm', 'AlgebraicNumberPolynomial', 'Alignment',
            'AlgebraicNumberTrace', 'AlgebraicUnitQ', 'AlignmentPoint', 'Arg',
            'AllowGroupClose', 'AllowInlineCells', 'AllowReverseGroupClose',
            'AllowScriptLevelChange', 'AlphaChannel', 'AlternatingGroup', 'Do',
            'AlternativeHypothesis', 'Alternatives', 'AmbientLight', 'Animate',
            'AnchoredSearch', 'AndersonDarlingTest', 'AngleBracket', 'Annuity',
            'AnimationCycleOffset', 'AnimationCycleRepetitions', 'Animator',
            'AnimationDirection', 'AnimationDisplayTime', 'AnimationRate', 'E',
            'AnimationRepetitions', 'AnimationRunning', 'Annotation', 'Apart',
            'AnnuityDue', 'Antialiasing', 'ApartSquareFree', 'Appearance', 'I',
            'AppearanceElements', 'AppellF1', 'Append', 'AppendTo', 'Apply',
            'ArcCosh', 'ArcCos', 'ArcCoth', 'ArcCot', 'ArcCsch', 'ArcCsc', 'N',
            'ArcSech', 'ArcSec', 'ArcSinDistribution', 'ArcSinh', 'ArcSin',
            'ArcTanh', 'ArcTan', 'ArgMax', 'ArgMin', 'ArithmeticGeometricMean',
            'ArrayComponents', 'ArrayDepth', 'ArrayFlatten', 'Array', 'ArrayQ',
            'ArrayPad', 'ArrayPlot', 'ArrayRules', 'Arrowheads', 'Arrow', 'Dt',
            'AspectRatioFixed', 'AspectRatio', '$AssertFunction', 'Assert',
            'Assuming', '$Assumptions', 'Assumptions', 'AstronomicalData', 'O',
            'Asynchronous', 'AtomQ', 'Attributes', 'AutoAction', 'AutoDelete',
            'AugmentedSymmetricPolynomial', 'AutoGeneratedPackage', 'AxesEdge',
            'AutoIndent', 'AutoItalicWords', 'AutoloadPath', 'Automatic', 'If',
            'AutoMultiplicationSymbol', 'AutoOpenNotebooks', 'AutoScroll',
            'AutoOpenPalettes', 'AutorunSequencing', 'AutoSpacing', 'Axes',
            'AxesLabel', 'AxesOrigin', 'AxesStyle', 'Axis', 'Background', 'Im',
            'BabyMonsterGroupB', 'Back', 'Backslash', 'Backward', 'Band', 'In',
            'BarabasiAlbertGraphDistribution', 'BarChart3D', 'BarChart', 'Cap',
            'BarnesG', 'BarOrigin', 'BarSpacing', '$BaseDirectory', 'BaseForm',
            'Baseline', 'BaselinePosition', 'BaseStyle', '$BatchInput', 'Beep',
            '$BatchOutput', 'BatesDistribution', 'BattleLemarieWavelet', 'CDF',
            'Because', 'BeckmannDistribution', 'BeginDialogPacket', 'Begin',
            'BeginPackage', 'BellB', 'BellY', 'BenfordDistribution', 'BesselI',
            'BeniniDistribution', 'BenktanderGibratDistribution', 'BernoulliB',
            'BenktanderWeibullDistribution', 'BernoulliDistribution', 'Beta',
            'BernoulliGraphDistribution', 'BernsteinBasis', 'BesselJ', 'BitOr',
            'BesselJZero', 'BesselK', 'BesselY', 'BesselYZero', 'BezierCurve',
            'BetaBinomialDistribution', 'BetaDistribution', 'BetaRegularized',
            'BetaNegativeBinomialDistribution', 'BetaPrimeDistribution', 'Cos',
            'BetweennessCentrality', 'BezierFunction', 'BilateralFilter', 'On',
            'Binarize', 'BinaryFormat', 'BinaryImageQ', 'BinaryReadList', 'Or',
            'BinaryRead', 'BinaryWrite', 'BinCounts', 'BinLists', 'Binomial',
            'BinomialDistribution', 'BinormalDistribution', 'BipartiteGraphQ',
            'BiorthogonalSplineWavelet', 'BirnbaumSaundersDistribution', 'Cot',
            'BitAnd', 'BitClear', 'BitGet', 'BitLength', 'BitNot', 'BitSet',
            'BitShiftLeft', 'BitShiftRight', 'BitXor', 'Black', 'Blank', 'Csc',
            'BlankNullSequence', 'BlankSequence', 'Blend', 'Block', 'Blue',
            'BlockRandom', 'Blur', 'BodePlot', 'Bold', 'Bookmarks', 'Booleans',
            'BooleanConvert', 'BooleanCountingFunction', 'BooleanFunction',
            'BooleanGraph', 'BooleanMaxterms', 'BooleanMinimize', 'Boole',
            'BooleanMinterms', 'BooleanTable', 'BooleanVariables', 'Bottom',
            'BorderDimensions', 'BorelTannerDistribution', 'BoundaryStyle',
            'BottomHatTransform', 'BoxBaselineShift', 'BoxData', 'Boxed', 'Pi',
            'BoxFormFormatTypes', 'BoxFrame', 'BoxMargins', 'BoxMatrix', 'Cup',
            'BoxRatios', 'BoxStyle', 'BoxWhiskerChart', 'BracketingBar', 'Del',
            'BrayCurtisDistance', 'BreadthFirstScan', 'Break', 'Brown', 'Byte',
            'BrownForsytheTest', 'BSplineBasis', 'BSplineCurve', 'BubbleChart',
            'BSplineFunction', 'BSplineSurface', 'BubbleChart3D', 'ButtonBar',
            'BubbleScale', 'BubbleSizes', 'ButterflyGraph', 'ButtonBox', 'Det',
            'ButtonBoxOptions', 'ButtonData', 'ButtonEvaluator', 'ButtonFrame',
            'ButtonExpandable', 'ButtonFunction', 'ButtonMargins', 'Button',
            'ButtonMinHeight', 'ButtonNotebook', 'ButtonNote', 'ButtonSource',
            'ButtonStyle', 'ByteCount', '$ByteOrdering', 'ByteOrdering', 'Dot',
            'CallPacket', 'CanberraDistance', 'CancelButton', '$Canceled',
            'Cancel', 'CandlestickChart', 'CapForm', 'CapitalDifferentialD',
            'CarmichaelLambda', 'Cases', 'Cashflow', 'Casoratian', 'Catalan',
            'CatalanNumber', 'Catch', 'CauchyDistribution', 'CayleyGraph',
            'CDFWavelet', 'Ceiling', 'CellArray', 'CellAutoOverwrite', 'Cell',
            'CellBaseline', 'CellBracketOptions', 'CellChangeTimes', 'Center',
            'CellContext', 'CellDingbat', 'CellDynamicExpression', 'CellFrame',
            'CellEditDuplicate', 'CellEpilog', 'CellEvaluationDuplicate', 'Re',
            'CellEvaluationFunction', 'CellEventActions', 'CellFrameColor',
            'CellFrameLabelMargins', 'CellFrameLabels', 'CellFrameMargins',
            'CellGroupData', 'CellGrouping', 'CellGroupingRules', 'CellGroup',
            'CellHorizontalScrolling', 'CellLabelAutoDelete', 'CellLabel',
            'CellLabelMargins', 'CellLabelPositioning', 'CellMargins', 'CForm',
            'CellOpen', 'CellPrint', 'CellProlog', 'CellSize', 'CellTags',
            'CellularAutomaton', 'CensoredDistribution', 'Censoring', 'Check',
            'CenterDot', 'CentralMomentGeneratingFunction', 'CentralMoment',
            'ChampernowneNumber', 'ChanVeseBinarize', '$CharacterEncoding',
            'CharacterEncoding', '$CharacterEncodings', 'Character', 'Chop',
            'CharacterEncodingsPath', 'CharacteristicFunction', 'Characters',
            'CharacteristicPolynomial', 'CharacterRange', 'ChartBaseStyle',
            'ChartElementFunction', 'ChartElements', 'ChartLabels', 'Checkbox',
            'ChartLayout', 'ChartLegends', 'ChartStyle', 'ChebyshevDistance',
            'ChebyshevT', 'ChebyshevU', 'CheckAbort', 'CheckboxBar', 'Circle',
            'ChemicalData', 'ChessboardDistance', 'ChiDistribution', 'Clear',
            'ChineseRemainder', 'ChiSquareDistribution', 'ChoiceButtons', 'Tr',
            'ChoiceDialog', 'CholeskyDecomposition', 'CircleDot', 'CirclePlus',
            'CircleMinus', 'CircleTimes', 'CirculantGraph', 'CityData', 'Clip',
            'ClearAll', 'ClearAttributes', 'ClearSystemCache', 'ClebschGordan',
            'ClickPane', 'ClipFill', 'ClippingStyle', 'Clock', 'CloseKernels',
            'Close', 'ClosenessCentrality', 'ClosingAutoSave', 'Closing',
            'ClusteringComponents', 'CMYKColor', 'CoefficientArrays', 'Colon',
            'CoefficientList', 'Coefficient', 'CoefficientRules', 'Collect',
            'CoifletWavelet', 'ColorCombine', 'ColorConvert', 'ColorData',
            'ColorDataFunction', 'ColorFunction', 'ColorFunctionScaling',
            'Colorize', 'ColorNegate', 'ColorOutput', 'ColorQuantize', 'Cone',
            'ColorRules', 'ColorSelectorSettings', 'ColorSeparate', 'Column',
            'ColorSetter', 'ColorSlider', 'ColorSpace', 'ColumnAlignments',
            'ColumnForm', 'ColumnLines', 'ColumnsEqual', 'ColumnSpacings',
            'ColumnWidths', '$CommandLine', 'CommonDefaultFormatTypes', 'Cosh',
            'CommonestFilter', 'Commonest', 'CompilationOptions', 'Compiled',
            '$CompilationTarget', 'CompilationTarget', 'CompiledFunction',
            'Compile', 'Complement', 'CompleteGraph', 'CompleteGraphQ', 'Coth',
            'CompleteKaryTree', 'Complexes', 'ComplexExpand', 'Complex', 'End',
            'ComplexInfinity', 'ComplexityFunction', 'ComponentMeasurements',
            'ComposeList', 'Compose', 'ComposeSeries', 'Composition', 'Count',
            'CompoundExpression', 'Compress', 'ConditionalExpression', 'Cross',
            'Conditioned', 'Condition', 'ConfidenceLevel', 'ConfigurationPath',
            '$ConfiguredKernels', 'Congruent', 'Conjugate', 'Conjunction',
            'ConjugateTranspose', 'ConnectedComponents', 'ConnectedGraphQ',
            'ConoverTest', 'ConstantArray', 'Constant', 'Constants', 'Context',
            'ConstrainedMax', 'ConstrainedMin', 'ContentPadding', '$Context',
            'ContentSelectable', 'ContentSize', '$ContextPath', 'Contexts',
            'ContextToFileName', 'ContinuedFractionK', 'ContinuedFraction',
            'Continue', 'ContinuousAction', 'ContinuousTimeModelQ', 'Contours',
            'ContinuousWaveletData', 'ContinuousWaveletTransform', 'Control',
            'ContourDetect', 'ContourGraphics', 'ContourLabels', 'ContourPlot',
            'ContourLevels', 'ContourLines', 'ContourPlot3D', 'ContourShading',
            'ContourSpacing', 'ContourStyle', 'ContraharmonicMean', 'Convolve',
            'ControlActive', '$ControlActiveSetting', 'ControllabilityGramian',
            'ControllabilityMatrix', 'ControllableDecomposition', 'CoprimeQ',
            'ControllableModelQ', 'ControllerInformation', 'ControllerLinking',
            'ControllerManipulate', 'ControllerMethod', 'ControllerPath',
            'ControllerState', 'ControlPlacement', 'ControlsRendering', 'Csch',
            'ControlType', 'Convergents', 'ConversionOptions', 'Coproduct',
            'ConversionRules', 'ConwayGroupCo1', 'ConwayGroupCo2', 'Copyable',
            'ConwayGroupCo3', 'CoordinatesToolOptions', 'CopulaDistribution',
            'CopyDirectory', 'CopyFile', 'CopyToClipboard', 'CornerFilter',
            'CornerNeighbors', 'CorrelationDistance', 'Correlation', 'Cubics',
            'CoshIntegral', 'CosineDistance', 'CosIntegral', 'CounterFunction',
            'CounterAssignments', 'CounterIncrements', 'CountRoots', 'Cuboid',
            'CounterStyleMenuListing', 'CountryData', 'Covariance', 'Cumulant',
            'CovarianceEstimatorFunction', 'CramerVonMisesTest', 'CrossMatrix',
            'CreateArchive', 'CreateDialog', 'CreateDirectory', 'CreateWindow',
            'CreateDocument', 'CreateIntermediateDirectories', 'CreatePalette',
            'CreateScheduledTask', '$CreationDate', 'CriticalSection', 'Cyan',
            'CrossingDetect', 'CumulantGeneratingFunction', 'CupCap', 'Cycles',
            'CurrentImage', '$CurrentLink', 'CurrentValue', 'CurveClosed',
            'CurvatureFlowFilter', 'CycleGraph', 'CyclicGroup', 'Cyclotomic',
            'Cylinder', 'CylindricalDecomposition', 'DagumDistribution', 'Erf',
            'DamerauLevenshteinDistance', 'Darker', 'Dashed', 'Dashing', 'Exp',
            'DataDistribution', 'DataRange', 'DataReversed', 'DateDifference',
            'DateFunction', 'DateListLogPlot', 'DateList', 'DateListPlot',
            'Date', 'DatePattern', 'DatePlus', '$DateStringFormat', 'DawsonF',
            'DateString', 'DateTicksFormat', 'DaubechiesWavelet', 'Debug',
            'DavisDistribution', 'DeBruijnGraph', 'DeclarePackage', 'Default',
            'Decompose', 'Decrement', 'DedekindEta', 'DefaultAxesStyle', 'Fit',
            'DefaultBaseStyle', 'DefaultBoxStyle', 'DefaultButton', 'Defer',
            'DefaultColor', 'DefaultDuplicateCellStyle', 'DefaultDuration',
            'DefaultElement', 'DefaultFaceGridsStyle', 'DefaultFieldHintStyle',
            '$DefaultFont', 'DefaultFont', 'DefaultFontProperties', 'Degree',
            'DefaultFormatType', 'DefaultFrameStyle', 'DefaultFrameTicksStyle',
            'DefaultGridLinesStyle', '$DefaultImagingDevice', 'DefaultOptions',
            'DefaultInlineFormatType', 'DefaultLabelStyle', 'DefaultMenuStyle',
            'DefaultNaturalLanguage', 'DefaultNewCellStyle', 'DefaultNotebook',
            'DefaultNewInlineCellStyle', 'DefaultStyleDefinitions', 'Delete',
            'DefaultTicksStyle', 'Definition', 'DegreeCentrality', 'Deletable',
            'DegreeGraphDistribution', 'Deinitialization', 'DeleteCases',
            'DeleteBorderComponents', 'DeleteContents', 'DeleteDirectory',
            'DeleteDuplicates', 'DeleteFile', 'DeleteSmallComponents', 'Depth',
            'DeletionWarning', 'DelimiterFlashTime', 'DelimiterMatching',
            'Delimiter', 'Denominator', 'DensityGraphics', 'DensityHistogram',
            'DensityPlot', 'DependentVariables', 'Deployed', 'Deploy', 'Disk',
            'DepthFirstScan', 'DerivativeFilter', 'Derivative', 'DesignMatrix',
            'DGaussianWavelet', 'DiacriticalPositioning', 'DiagonalMatrix',
            'Diagonal', 'DialogInput', 'Dialog', 'DialogNotebook', 'Diamond',
            'DialogProlog', 'DialogReturn', 'DialogSymbols', 'DiamondMatrix',
            'DiceDissimilarity', 'DictionaryLookup', 'DifferenceDelta', 'Drop',
            'DifferenceRoot', 'DifferenceRootReduce', 'Differences', 'DigitQ',
            'DifferentialD', 'DifferentialRoot', 'DifferentialRootReduce',
            'DigitBlock', 'DigitCharacter', 'DigitCount', 'DihedralGroup',
            'Dilation', 'Dimensions', 'DiracComb', 'DiracDelta', 'Direction',
            'DirectedEdge', 'DirectedEdges', 'DirectedGraph', 'DirectedGraphQ',
            'DirectedInfinity', 'Directive', 'DirectoryName', 'Directory',
            'DirectoryQ', 'DirectoryStack', 'DirichletCharacter', 'DirichletL',
            'DirichletConvolve', 'DirichletDistribution', 'DirichletTransform',
            'DiscreteConvolve', 'DiscreteDelta', 'DiscreteIndicator', 'Divide',
            'DiscreteLQEstimatorGains', 'DiscreteLQRegulatorGains', 'Dispatch',
            'DiscreteLyapunovSolve', 'DiscretePlot3D', 'DiscretePlot', 'Dump',
            'DiscreteRatio', 'DiscreteRiccatiSolve', 'DiscreteShift', 'Dotted',
            'DiscreteTimeModelQ', 'DiscreteUniformDistribution', 'Disjunction',
            'DiscreteWaveletData', 'DiscreteWaveletPacketTransform', 'Display',
            'DiscreteWaveletTransform', 'Discriminant', 'DiskMatrix', 'DSolve',
            'DispersionEstimatorFunction', 'DisplayAllSteps', 'DisplayForm',
            'DisplayEndPacket', '$DisplayFunction', 'DisplayFunction', '$Echo',
            '$Display', 'DisplayPacket', 'DisplayString', 'DistanceFunction',
            'DistanceTransform', '$DistributedContexts', 'DistributedContexts',
            'DistributeDefinitions', 'Distributed', 'Distribute', 'Dithering',
            'DistributionChart', 'DistributionFitTest', 'DivideBy', 'Dividers',
            'DistributionParameterAssumptions', 'DistributionParameterQ',
            'Divisible', 'DivisorSigma', 'Divisors', 'DivisorSum', 'DMSList',
            'DMSString', 'DockedCells', 'DocumentNotebook', 'DotDashed', 'For',
            'DotEqual', 'DoubleBracketingBar', 'DoubleDownArrow', 'DownArrow',
            'DoubleLeftArrow', 'DoubleLeftRightArrow', 'DoubleLongLeftArrow',
            'DoubleLongLeftRightArrow', 'DoubleLongRightArrow', 'DownArrowBar',
            'DoubleRightArrow', 'DoubleUpArrow', 'DoubleUpDownArrow', 'EdgeQ',
            'DoubleVerticalBar', 'DownArrowUpArrow', 'DownLeftRightVector',
            'DownLeftTeeVector', 'DownLeftVectorBar', 'DownLeftVector', 'Erfc',
            'DownRightTeeVector', 'DownRightVectorBar', 'DownRightVector',
            'DownTeeArrow', 'DownValues', 'DragAndDrop', 'DSolveConstants',
            'DualSystemsModel', 'DumpSave', '$DynamicEvaluation', 'Dynamic',
            'DynamicEvaluationTimeout', 'DynamicModule', 'DynamicModuleValues',
            'DynamicSetting', 'DynamicWrapper', 'EdgeAdd', 'EdgeCount', 'Erfi',
            'EdgeCoverQ', 'EdgeDelete', 'EdgeDetect', 'EdgeForm', 'EdgeIndex',
            'EdgeLabeling', 'EdgeLabels', 'EdgeLabelStyle', 'EdgeList', 'Exit',
            'EdgeRenderingFunction', 'EdgeRules', 'EdgeShapeFunction', 'Equal',
            'EdgeStyle', 'EdgeWeight', 'Editable', 'EditCellTagsSettings',
            'EditDistance', 'EffectiveInterest', 'Eigensystem', 'Eigenvalues',
            'EigenvectorCentrality', 'Eigenvectors', 'ElementData', 'Element',
            'Eliminate', 'EllipticE', 'EllipticExp', 'EllipticExpPrime', 'GCD',
            'EllipticF', 'EllipticK', 'EllipticLog', 'EllipticNomeQ', 'Encode',
            'EllipticPi', 'EllipticTheta', 'EllipticThetaPrime', 'EmitSound',
            'EmpiricalDistribution', 'EmptyGraphQ', 'Enabled', 'EndOfFile',
            'EndDialogPacket', 'EndOfLine', 'EndOfString', 'EndPackage', 'Get',
            'EngineeringForm', 'EnterExpressionPacket', 'EnterTextPacket',
            'EntropyFilter', 'Entropy', 'Environment', '$Epilog', 'Epilog',
            'EqualTilde', 'Equilibrium', 'Equivalent', 'ErlangDistribution',
            'Erosion', 'ErrorBox', 'ErrorBoxOptions', 'EstimatedDistribution',
            'EstimatorGains', 'EstimatorRegulator', 'EuclideanDistance', 'Hue',
            'EulerE', 'EulerGamma', 'EulerianGraphQ', 'EulerPhi', 'Evaluate',
            'Evaluatable', 'EvaluatePacket', 'EvaluationCompletionAction',
            'EvaluationElements', 'EvaluationMonitor', 'EvaluationNotebook',
            'EvaluationObject', 'EvaluatorNames', 'Evaluator', 'EvenQ', 'Find',
            'EventHandler', 'EventLabels', 'ExactNumberQ', 'ExampleData',
            'Except', 'ExcludedForms', 'ExcludePods', 'Exclusions', 'Exists',
            'ExclusionsStyle', 'ExpandAll', 'ExpandDenominator', 'Expand',
            'ExpandFileName', 'ExpandNumerator', 'Expectation', 'ExpIntegralE',
            'ExpectedValue', 'ExpGammaDistribution', 'ExpIntegralEi', 'Export',
            'ExponentFunction', 'ExponentialDistribution', 'ExponentialFamily',
            'ExponentialGeneratingFunction', 'ExponentialMovingAverage', 'LCM',
            'ExponentialPowerDistribution', 'Exponent', 'ExponentPosition',
            'ExponentStep', 'ExportAutoReplacements', '$ExportFormats', 'Flat',
            'ExportString', 'ExpressionCell', 'Expression', 'ExpToTrig', 'Log',
            'ExtendedGCD', 'Extension', 'ExtentElementFunction', 'ExtentSize',
            'ExtentMarkers', 'ExternalDataCharacterEncoding', 'ExtractArchive',
            'Extract', 'ExtremeValueDistribution', 'FaceForm', 'FaceGrids',
            'FaceGridsStyle', 'FactorComplete', 'Factorial2', 'Factorial',
            'FactorialMomentGeneratingFunction', 'FactorialMoment', 'Factor',
            'FactorialPower', 'FactorInteger', 'FactorList', 'FactorTermsList',
            'FactorSquareFreeList', 'FactorSquareFree', 'FactorTerms', 'False',
            '$Failed', 'FeedbackType', 'Fibonacci', 'FieldHint', 'FieldMasked',
            'FieldHintStyle', 'FieldSize', 'FileBaseName', 'FileByteCount',
            'FileDate', 'FileExistsQ', 'FileExtension', 'FileFormat', 'First',
            'FileHash', 'FileNameDepth', 'FileNameDialogSettings', 'FileNames',
            'FileNameDrop', 'FileNameJoin', 'FileNameSetter', 'FileNameSplit',
            'FileNameTake', 'FilePrint', 'FileType', 'FilledCurve', 'Filling',
            'FillingStyle', 'FillingTransform', 'FilterRules', 'FinancialBond',
            'FinancialData', 'FinancialDerivative', 'FinancialIndicator',
            'FindArgMax', 'FindArgMin', 'FindClique', 'FindClusters', 'Floor',
            'FindCurvePath', 'FindDistributionParameters', 'FindDivisions',
            'FindEdgeCover', 'FindEulerianCycle', 'FindFile', 'FindFit', 'Map',
            'FindGeneratingFunction', 'FindGeoLocation', 'FindInstance', 'Max',
            'FindGeometricTransform', 'FindGraphIsomorphism', 'FindLibrary',
            'FindHamiltonianCycle', 'FindIndependentEdgeSet', 'FindList',
            'FindIndependentVertexSet', 'FindIntegerNullVector', 'FindMaximum',
            'FindLinearRecurrence', 'FindMaxValue', 'FindMinimum', 'FindRoot',
            'FindMinValue', 'FindPermutation', 'FindSequenceFunction', 'Fold',
            'FindSettings', 'FindShortestPath', 'FindShortestTour', 'Flatten',
            'FindThreshold', 'FindVertexCover', 'FinishDynamic', 'FittedModel',
            'FiniteAbelianGroupCount', 'FiniteGroupCount', 'FiniteGroupData',
            'FischerGroupFi22', 'FischerGroupFi23', 'FischerGroupFi24Prime',
            'FisherHypergeometricDistribution', 'FisherRatioTest', 'FlattenAt',
            'FisherZDistribution', 'FixedPointList', 'FixedPoint', 'FlipView',
            'FoldList', 'FontColor', 'FontFamily', 'FontForm', 'FontSize',
            'FontProperties', 'FontSlant', 'FontSubstitutions', 'FontTracking',
            'FontVariations', 'FontWeight', 'ForAll', 'Format', '$FormatType',
            'FormatTypeAutoConvert', 'FormatType', 'FormBox', 'FormBoxOptions',
            'FortranForm', 'ForwardBackward', 'Forward', 'FourierCoefficient',
            'FourierCosCoefficient', 'FourierCosSeries', 'FourierCosTransform',
            'FourierDCT', 'FourierDST', 'Fourier', 'FourierParameters', 'Full',
            'FourierSequenceTransform', 'FourierSeries', 'FourierSinSeries',
            'FourierSinCoefficient', 'FourierSinTransform', 'FourierTransform',
            'FourierTrigSeries', 'FractionalPart', 'FractionBox', 'FrameBox',
            'FractionBoxOptions', 'FractionLine', 'FrameBoxOptions', 'Framed',
            'FrameLabel', 'FrameMargins', 'Frame', 'FrameStyle', 'FrameTicks',
            'FrameTicksStyle', 'FRatioDistribution', 'FrechetDistribution',
            'FreeQ', 'FresnelC', 'FresnelS', 'FrobeniusNumber', 'FromASCII',
            'FrobeniusSolve', 'FromCharacterCode', 'FromCoefficientRules',
            'FromContinuedFraction', 'FromDate', 'FromDigits', 'FromDMS',
            'FrontEndDynamicExpression', 'FrontEndEventActions', '$FrontEnd',
            'FrontEndExecute', '$FrontEndSession', 'FrontEndStackSize', 'Glow',
            'FrontEndTokenExecute', 'FrontEndToken', 'Front', 'FullDefinition',
            'FullForm', 'FullGraphics', 'FullOptions', 'FullSimplify', 'Gamma',
            'FunctionExpand', 'FunctionInterpolation', 'Function', 'GatherBy',
            'FunctionSpace', 'GaborWavelet', 'GainMargins', 'GainPhaseMargins',
            'GammaDistribution', 'GammaRegularized', 'GapPenalty', 'Gather',
            'GaussianFilter', 'GaussianIntegers', 'GaussianMatrix', 'General',
            'GegenbauerC', 'GeneralizedLinearModelFit', 'GenerateConditions',
            'GeneratedCell', 'GeneratedParameters', 'GeneratingFunction',
            'GenericCylindricalDecomposition', 'GenomeData', 'GenomeLookup',
            'GeodesicDilation', 'GeodesicErosion', 'GeoDestination', 'Goto',
            'GeodesyData', 'GeoDirection', 'GeoDistance', 'GeoGridPosition',
            '$GeoLocation', 'GeometricDistribution', 'GeometricMeanFilter',
            'GeometricMean', 'GeometricTransformation', 'GeoPositionENU',
            'GeoPosition', 'GeoPositionXYZ', 'GeoProjectionData', 'Glaisher',
            'GoldenRatio', 'GompertzMakehamDistribution', 'GradientFilter',
            'Gradient', 'GraphCenter', 'GraphComplement', 'GraphData', 'Graph',
            'GraphDiameter', 'GraphDifference', 'GraphDisjointUnion', 'GraphQ',
            'GraphDistanceMatrix', 'GraphDistance', 'GraphHighlight', 'Gray',
            'GraphHighlightStyle', 'Graphics3D', 'GraphicsArray', 'Graphics',
            'GraphicsColumn', 'GraphicsComplex', 'GraphicsGrid', 'GraphicsRow',
            'GraphicsGroup', 'GraphicsSpacing', 'GraphIntersection', 'Greater',
            'GraphLayout', 'GraphPeriphery', 'GraphPlot3D', 'GraphPlot', 'Min',
            'GraphPower', 'GraphRadius', 'GraphStyle', 'GraphUnion', 'Green',
            'GrayLevel', 'GreaterEqualLess', 'GreaterEqual', 'GreaterGreater',
            'GreaterFullEqual', 'GreaterLess', 'GreaterSlantEqual', 'GridBox',
            'GreaterTilde', 'GridBaseline', 'GridCreationSettings', 'Grid',
            'GridDefaultElement', 'GridFrameMargins', 'GridFrame', 'GridGraph',
            'GridLines', 'GridLinesStyle', 'GroebnerBasis', 'GroupActionBase',
            'GroupCentralizer', 'GroupElementPosition', 'GroupElementQ', 'Mod',
            'GroupElements', 'GroupGenerators', 'GroupMultiplicationTable',
            'GroupOrbits', 'GroupOrder', 'GroupPageBreakWithin', 'HaarWavelet',
            'GroupSetwiseStabilizer', 'GroupStabilizerChain', 'Gudermannian',
            'GroupStabilizer', 'GumbelDistribution', 'HalfNormalDistribution',
            'HamiltonianGraphQ', 'HammingDistance', 'HankelH1', 'HankelH2',
            'HankelMatrix', 'HaradaNortonGroupHN', 'HararyGraph', 'Hash',
            'HarmonicMeanFilter', 'HarmonicMean', 'HarmonicNumber', 'Head',
            'Haversine', 'HazardFunction', 'Heads', 'HeavisideLambda', 'Hold',
            'HeavisidePi', 'HeavisideTheta', 'HeldGroupHe', 'HeldPart', 'Item',
            'HelpBrowserSettings', 'HermiteDecomposition', 'HermiteH', 'Image',
            'HermitianMatrixQ', 'HessenbergDecomposition', 'HiddenSurface',
            'HexadecimalCharacter', 'HighlightGraph', 'HigmanSimsGroupHS',
            'HilbertMatrix', 'Histogram3D', 'HistogramDistribution', 'HoldAll',
            'HistogramList', 'Histogram', '$HistoryLength', 'HitMissTransform',
            'HITSCentrality', 'HoldAllComplete', 'HoldComplete', 'HoldFirst',
            'HoldForm', 'HoldPattern', 'HoldRest', '$HomeDirectory', 'ImageQ',
            'HomeDirectory', 'HornerForm', 'HotellingTSquareDistribution',
            'HoytDistribution', 'HTMLSave', 'HumpDownHump', 'HumpEqual', 'Nor',
            'HurwitzLerchPhi', 'HurwitzZeta', 'HyperbolicDistribution', 'Join',
            'HypercubeGraph', 'Hyperfactorial', 'Hypergeometric0F1', 'Implies',
            'Hypergeometric0F1Regularized', 'Hypergeometric1F1', 'Hyperlink',
            'Hypergeometric1F1Regularized', 'Hypergeometric2F1', 'Hyphenation',
            'Hypergeometric2F1Regularized', 'HypergeometricDistribution',
            'HypergeometricPFQ', 'HypergeometricPFQRegularized', 'Identity',
            'HypergeometricU', 'HypothesisTestData', 'IdentityMatrix', 'Infix',
            'IgnoreCase', '$IgnoreEOF', 'ImageAdd', 'ImageAdjust', 'ImageClip',
            'ImageAlign', 'ImageApply', 'ImageAspectRatio', 'ImageAssemble',
            'ImageCapture', 'ImageChannels', 'ImageColorSpace', 'ImageCompose',
            'ImageConvolve', 'ImageCooccurrence', 'ImageCorrelate', 'ImagePad',
            'ImageCorrespondingPoints', 'ImageCrop', 'ImageData', 'ImageLines',
            'ImageDeconvolve', 'ImageDifference', 'ImageDimensions', 'Import',
            'ImageEffect', 'ImageFilter', 'ImageForestingComponents', 'Inner',
            'ImageForwardTransformation', 'ImageHistogram', 'ImageKeypoints',
            'ImageLevels', 'ImageMargins', 'ImageMultiply', 'ImagePadding',
            'ImagePartition', 'ImagePerspectiveTransformation', 'ImageReflect',
            'ImageRegion', 'ImageResize', 'ImageResolution', 'ImageRotated',
            'ImageRotate', 'ImageScaled', 'ImageSizeAction', 'ImageSize',
            'ImageSizeMultipliers', 'ImageSubtract', 'ImageTake', 'ImageTrim',
            'ImageTransformation', 'ImageType', 'ImageValue', '$ImportFormats',
            '$ImagingDevices', 'ImportAutoReplacements', 'ImportString', 'Not',
            'IncidenceGraph', 'IncidenceMatrix', 'IncludeConstantBasis', 'Off',
            'IncludeFileExtension', 'IncludePods', 'Increment', 'IndexGraph',
            'IndependentEdgeSetQ', 'IndependentVertexSetQ', 'Indeterminate',
            'InexactNumberQ', 'Infinity', 'Information', 'Inherited', '$Input',
            '$InitialDirectory', 'InitializationCellEvaluation', 'Inpaint',
            'InitializationCell', 'InitializationCellWarning', 'InputAliases',
            'InitializationGroup', 'Initialization', 'InputAssumptions', 'Out',
            'InputAutoReplacements', 'InputField', '$InputFileName', 'Input',
            'InputForm', 'InputNamePacket', 'InputNotebook', 'InputPacket',
            'InputStream', 'InputString', 'InputStringPacket', 'Insert', 'PDF',
            'InsertResults', 'Inset', '$Inspector', '$InstallationDate', 'Put',
            '$InstallationDirectory', 'Install', 'InstallService', 'InString',
            'IntegerDigits', 'IntegerExponent', 'IntegerLength', 'Integer',
            'IntegerPartitions', 'IntegerPart', 'IntegerQ', 'Integers', 'Last',
            'IntegerString', 'Integrate', 'InteractiveTradingChart', 'Inverse',
            'Interleaving', 'InternallyBalancedDecomposition', 'Interpolation',
            'InterpolatingFunction', 'InterpolatingPolynomial', 'Interrupt',
            'InterpolationOrder', 'InterpolationPoints', 'InterpretationBox',
            'InterpretationBoxOptions', 'Interpretation', 'InterquartileRange',
            'Intersection', 'IntervalIntersection', 'IntervalMemberQ', 'Label',
            'Interval', 'IntervalUnion', 'InverseBetaRegularized', 'Invisible',
            'InverseCDF', 'InverseChiSquareDistribution', 'InverseErfc', 'Raw',
            'InverseContinuousWaveletTransform', 'InverseDistanceTransform',
            'InverseEllipticNomeQ', 'InverseErf', 'InverseFourierCosTransform',
            'InverseFourier', 'InverseFourierSequenceTransform', 'IsotopeData',
            'InverseFourierSinTransform', 'InverseFourierTransform', 'Italic',
            'InverseFunction', 'InverseFunctions', 'InverseGammaDistribution',
            'InverseGammaRegularized', 'InverseGaussianDistribution', 'Joined',
            'InverseGudermannian', 'InverseHaversine', 'InverseJacobiCD',
            'InverseJacobiCN', 'InverseJacobiCS', 'InverseJacobiDC', 'JacobiP',
            'InverseJacobiDN', 'InverseJacobiDS', 'InverseJacobiNC', 'Kernels',
            'InverseJacobiND', 'InverseJacobiNS', 'InverseJacobiSC', 'Labeled',
            'InverseJacobiSD', 'InverseJacobiSN', 'InverseLaplaceTransform',
            'InversePermutation', 'InverseRadon', 'InverseSeries', 'ItemSize',
            'InverseSurvivalFunction', 'InverseWaveletTransform', 'ItemStyle',
            'InverseWeierstrassP', 'InverseZTransform', 'IsolatingInterval',
            'IrreduciblePolynomialQ', 'IsomorphicGraphQ', 'ItemAspectRatio',
            '$IterationLimit', 'JaccardDissimilarity', 'JacobiAmplitude',
            'JacobiCD', 'JacobiCN', 'JacobiCS', 'JacobiDC', 'JacobiDN', 'Left',
            'JacobiDS', 'JacobiNC', 'JacobiND', 'JacobiNS', 'JacobiSC', 'Less',
            'JacobiSD', 'JacobiSN', 'JacobiSymbol', 'JacobiZeta', 'JoinForm',
            'JankoGroupJ1', 'JankoGroupJ2', 'JankoGroupJ3', 'JankoGroupJ4',
            'JarqueBeraALMTest', 'JohnsonDistribution', 'JoinedCurve', 'Large',
            'JordanDecomposition', 'JordanModelDecomposition', 'KagiChart',
            'KalmanEstimator', 'KarhunenLoeveDecomposition', 'KaryTree', 'Red',
            'KatzCentrality', 'KCoreComponents', 'KDistribution', 'KelvinBei',
            'KelvinBer', 'KelvinKei', 'KelvinKer', '$KernelCount', '$KernelID',
            'KernelMixtureDistribution', 'KernelObject', 'Khinchin', 'Larger',
            'KirchhoffGraph', 'KirchhoffMatrix', 'KleinInvariantJ', 'KnotData',
            'KnightTourGraph', 'KolmogorovSmirnovTest', 'KroneckerDelta',
            'KroneckerProduct', 'KroneckerSymbol', 'KuiperTest', 'Kurtosis',
            'KumaraswamyDistribution', 'KuwaharaFilter', 'LabelingFunction',
            'LabelStyle', 'LaguerreL', 'LandauDistribution', '$Language',
            'LanguageCategory', 'Language', 'LaplaceDistribution', 'Latitude',
            'LaplaceTransform', 'LaplacianFilter', 'LaplacianGaussianFilter',
            'LatitudeLongitude', 'LatticeData', 'LatticeReduce', 'LeafCount',
            'LaunchKernels', 'LayeredGraphPlot', 'LayerSizeFunction', 'Length',
            'LeastSquares', 'LeftArrowBar', 'LeftArrow', 'LeftArrowRightArrow',
            'LeftDownTeeVector', 'LeftDownVectorBar', 'LeftDownVector', 'Line',
            'LeftRightArrow', 'LeftRightVector', 'LeftTeeArrow', 'LeftVector',
            'LeftTeeVector', 'LeftTriangleBar', 'LeftTriangleEqual', 'LetterQ',
            'LeftTriangle', 'LeftUpDownVector', 'LeftUpTeeVector', 'Legended',
            'LeftUpVectorBar', 'LeftUpVector', 'LeftVectorBar', 'LegendreP',
            'LegendAppearance', 'LegendreQ', 'LegendreType', 'LengthWhile',
            'LerchPhi', 'LessEqualGreater', 'LessEqual', 'LessFullEqual',
            'LessGreater', 'LessLess', 'LessSlantEqual', 'LessTilde', 'Level',
            'LetterCharacter', 'LeveneTest', 'LeviCivitaTensor', 'LibraryLoad',
            'LevyDistribution', 'LibraryFunctionError', 'LibraryFunctionLoad',
            'LibraryFunctionInformation', 'LibraryFunction', '$LibraryPath',
            'LibraryFunctionUnload', 'LibraryUnload', '$LicenseExpirationDate',
            '$LicenseID', '$LicenseServer', 'LiftingFilterData', 'LightBlue',
            'LiftingWaveletTransform', 'LightBrown', 'LightCyan', 'Lighter',
            'LightGray', 'LightGreen', 'LightingAngle', 'Lighting', 'LightRed',
            'LightMagenta', 'LightOrange', 'LightPink', 'LightPurple', 'Limit',
            'LightSources', 'LightYellow', 'Likelihood', 'LimitsPositioning',
            'LimitsPositioningTokens', 'LindleyDistribution', 'LinearModelFit',
            'LinearFractionalTransform', 'LinearOffsetFunction', 'LinearSolve',
            'LinearProgramming', 'LinearRecurrence', 'LinearSolveFunction',
            'LinebreakAdjustments', 'LineBreakChart', 'LineBreakWithin', 'Row',
            'LineGraph', 'LineIndentMaxFraction', 'LineIndent', '$Line', 'Run',
            'LineIntegralConvolutionPlot', 'LineIntegralConvolutionScale',
            'LineSpacing', 'LinkClose', 'LinkConnect', 'LinkCreate', '$Linked',
            'LinkFunction', 'LinkInterrupt', 'LinkLaunch', 'LinkObject', 'Sec',
            'LinkOpen', 'LinkPatterns', 'LinkProtocol', 'LinkRead', 'Links',
            'LinkReadyQ', 'LinkWrite', 'LiouvilleLambda', 'Listable', 'List',
            'ListAnimate', 'ListContourPlot3D', 'ListContourPlot', 'ListPlay',
            'ListConvolve', 'ListCorrelate', 'ListCurvePathPlot', 'ListPlot3D',
            'ListDeconvolve', 'ListDensityPlot', 'ListInterpolation', 'Locked',
            'ListLineIntegralConvolutionPlot', 'ListLinePlot', 'ListLogPlot',
            'ListLogLinearPlot', 'ListLogLogPlot', 'ListPlot', 'ListPolarPlot',
            'ListPointPlot3D', 'ListStreamDensityPlot', 'ListStreamPlot',
            'ListSurfacePlot3D', 'ListVectorDensityPlot', 'ListVectorPlot3D',
            'ListVectorPlot', 'Literal', 'LocalizeVariables', 'LocationTest',
            'LocationEquivalenceTest', 'LocatorAutoCreate', 'Locator', 'Log10',
            'LocatorPane', 'LocatorRegion', 'Log2', 'LogBarnesG', 'LogGamma',
            'LogGammaDistribution', 'LogicalExpand', 'LogIntegral', 'LogPlot',
            'LogisticDistribution', 'LogitModelFit', 'LogLikelihood', 'LucasL',
            'LogLinearPlot', 'LogLogisticDistribution', 'LogLogPlot', 'Manual',
            'LogNormalDistribution', 'LogSeriesDistribution', 'LongestMatch',
            'LongestCommonSequence', 'LongestCommonSubsequence', 'Longest',
            'Longitude', 'LongLeftArrow', 'LongLeftRightArrow', 'LowerCaseQ',
            'LongRightArrow', 'LoopFreeGraphQ', 'LowerLeftArrow', '$MachineID',
            'LowerRightArrow', 'LowerTriangularize', 'LQEstimatorGains', 'Set',
            'LQGRegulator', 'LQOutputRegulatorGains', 'LQRegulatorGains',
            'LUBackSubstitution', 'LUDecomposition', 'LyapunovSolve', 'MapAll',
            'LyonsGroupLy', '$MachineAddresses', '$MachineDomain', 'Magenta',
            '$MachineDomains', '$MachineEpsilon', '$MachineName', 'Magnify',
            'MachineNumberQ', '$MachinePrecision', 'MachinePrecision', 'MapAt',
            '$MachineType', 'Magnification', 'Majority', 'MakeBoxes', 'MatchQ',
            'MakeExpression', 'MangoldtLambda', 'ManhattanDistance', 'MarcumQ',
            'Manipulate', 'Manipulator', 'MannWhitneyTest', 'MantissaExponent',
            'MapIndexed', 'MapThread', 'MardiaCombinedTest', 'Masking', 'Mean',
            'MardiaKurtosisTest', 'MardiaSkewnessTest', 'MarginalDistribution',
            'MatchingDissimilarity', 'MatchLocalNames', 'MathieuC', 'MathieuS',
            'MathieuCharacteristicA', 'MathieuCharacteristicB', 'MathMLForm',
            'MathieuCharacteristicExponent', 'MathieuCPrime', 'MathieuSPrime',
            'MathieuGroupM11', 'MathieuGroupM12', 'MathieuGroupM22', 'MatrixQ',
            'MathieuGroupM23', 'MathieuGroupM24', 'MatrixExp', 'MatrixForm',
            'MatrixPlot', 'MatrixPower', 'MatrixRank', 'MaxDetect', 'Maximize',
            'MaxExtraBandwidths', 'MaxExtraConditions', '$MaxExtraPrecision',
            'MaxFilter', 'MaxIterations', '$MaxMachineNumber', 'MaxMemoryUsed',
            'MaxMixtureKernels', '$MaxNumber', '$MaxPiecewiseCases', '$$Media',
            'MaxPlotPoints', '$MaxPrecision', 'MaxRecursion', '$MaxRootDegree',
            'MaxStableDistribution', 'MaxStepFraction', 'MaxStepSize', 'Mesh',
            'MaxSteps', 'MaxValue', 'MaxwellDistribution', 'MeanDeviation',
            'McLaughlinGroupMcL', 'MeanFilter', 'MeanShiftFilter', 'MeanShift',
            'MedianDeviation', 'MedianFilter', 'Median', 'Medium', 'MeijerG',
            'MemberQ', 'MemoryConstrained', 'MemoryInUse', 'MenuCommandKey',
            'MenuPacket', 'MenuSortingValue', 'MenuStyle', 'MenuView', 'Minus',
            'MeshFunctions', 'MeshRange', 'MeshShading', 'MeshStyle', 'Method',
            'MessageDialog', '$MessageGroups', '$MessageList', 'MessageList',
            'MessageName', 'Message', 'MessagePacket', '$MessagePrePrint',
            '$Messages', 'Messages', 'MexicanHatWavelet', 'MeyerWavelet',
            'MinDetect', 'MinFilter', 'MinimalPolynomial', 'Minimize', 'Modal',
            'MinimalStateSpaceModel', '$MinMachineNumber', '$MinNumber', 'Sin',
            'Minors', '$MinPrecision', 'MinStableDistribution', 'MinusPlus',
            'MinValue', 'Missing', 'MixtureDistribution', 'ModularLambda',
            'Module', '$ModuleNumber', 'Modulus', 'MoebiusMu', 'MomentConvert',
            'MomentEvaluate', 'MomentGeneratingFunction', 'Moment', 'Monitor',
            'MonomialList', 'MonsterGroupM', 'MorletWavelet', 'Most', 'NameQ',
            'MorphologicalBinarize', 'MorphologicalBranchPoints', 'Mouseover',
            'MorphologicalComponents', 'MorphologicalEulerNumber', 'Names',
            'MorphologicalGraph', 'MorphologicalPerimeter', 'MouseAnnotation',
            'MorphologicalTransform', 'MouseAppearance', 'MousePosition',
            'MovingAverage', 'MovingMedian', 'MoyalDistribution', 'Nand',
            'MultiedgeStyle', 'MultilaunchWarning', 'MultilineFunction', 'Sow',
            'MultinomialDistribution', 'Multinomial', 'MultiplicativeOrder',
            'MultinormalDistribution', 'MultivariatePoissonDistribution',
            'MultivariateHypergeometricDistribution', 'NakagamiDistribution',
            'MultivariateTDistribution', 'NArgMax', 'NArgMin', 'NCache', 'Sum',
            'NDSolve', 'NearestFunction', 'Nearest', 'Needs', 'Negative',
            'NeedlemanWunschSimilarity', 'NegativeBinomialDistribution', 'Tan',
            'NegativeMultinomialDistribution', 'NeighborhoodGraph', 'NestList',
            'NestedGreaterGreater', 'NestedLessLess', 'Nest', 'NestWhileList',
            'NestWhile', 'NevilleThetaC', 'NevilleThetaD', 'NevilleThetaN',
            'NevilleThetaS', '$NewMessage', '$NewSymbol', 'NExpectation',
            'NextPrime', 'NHoldAll', 'NHoldFirst', 'NHoldRest', 'NicholsPlot',
            'NicholsGridLines', 'NIntegrate', 'NMaximize', 'NMaxValue', 'None',
            'NMinimize', 'NMinValue', 'NominalVariables', 'NonConstants',
            'NoncentralBetaDistribution', 'NoncentralChiSquareDistribution',
            'NoncentralFRatioDistribution', 'NoncentralStudentTDistribution',
            'NonCommutativeMultiply', 'NonlinearModelFit', 'NonNegative',
            'NonPositive', 'NorlundB', 'NormalDistribution', 'Normalize',
            'NormalizedSquaredEuclideanDistance', 'Normal', 'NormalsFunction',
            'NormFunction', 'Norm', 'NotCongruent', 'NotCupCap', 'NotebookGet',
            'NotDoubleVerticalBar', 'NotebookApply', 'NotebookAutoSave', 'Top',
            'NotebookBrowseDirectory', 'NotebookClose', 'NotebookCreate',
            'NotebookConvertSettings', 'NotebookDelete', 'NotebookDirectory',
            'NotebookDynamicExpression', 'NotebookEvaluate', 'NotebookFind',
            'NotebookEventActions', 'NotebookFileName', 'NotebookInformation',
            'NotebookLocate', 'Notebook', 'NotebookObject', 'NotebookOpen',
            'NotebookPath', 'NotebookPrint', 'NotebookPut', 'NotebookRead',
            'NotebookSave', 'NotebookSelection', 'NotebooksMenu', '$Notebooks',
            'Notebooks', 'NotebookWrite', 'NotElement', 'NotEqualTilde', 'Vee',
            'NotExists', 'NotGreaterEqual', 'NotGreaterFullEqual', 'NotLess',
            'NotGreaterGreater', 'NotGreaterLess', 'NotGreater', 'NotLessLess',
            'NotGreaterSlantEqual', 'NotGreaterTilde', 'NotHumpDownHump',
            'NotHumpEqual', 'NotLeftTriangleBar', 'NotLeftTriangleEqual',
            'NotLeftTriangle', 'NotLessEqual', 'NotLessFullEqual', 'NotSubset',
            'NotLessGreater', 'NotLessSlantEqual', 'NotLessTilde', 'NotTilde',
            'NotNestedGreaterGreater', 'NotNestedLessLess', 'NotPrecedesEqual',
            'NotPrecedes', 'NotPrecedesSlantEqual', 'NotPrecedesTilde', 'NSum',
            'NotReverseElement', 'NotRightTriangleBar', 'NotRightTriangle',
            'NotRightTriangleEqual', 'NotSquareSubsetEqual', 'NotSquareSubset',
            'NotSquareSupersetEqual', 'NotSquareSuperset', 'NotSubsetEqual',
            'NotSucceedsEqual', 'NotSucceeds', 'NotSucceedsSlantEqual', 'Null',
            'NotSucceedsTilde', 'NotSupersetEqual', 'NotSuperset', 'NProduct',
            'NotTildeEqual', 'NotTildeFullEqual', 'NotTildeTilde', 'NRoots',
            'NotVerticalBar', 'NProbability', 'NSolve', 'NullRecords', 'OddQ',
            'NullSpace', 'NullWords', 'NumberFieldClassNumber', 'NumberFormat',
            'NumberFieldDiscriminant', 'NumberFieldFundamentalUnits', 'Number',
            'NumberFieldIntegralBasis', 'NumberFieldNormRepresentatives',
            'NumberFieldRegulator', 'NumberFieldRootsOfUnity', 'NumberForm',
            'NumberFieldSignature', '$NumberMarks', 'NumberMarks', 'NumberQ',
            'NumberMultiplier', 'NumberPadding', 'NumberPoint', 'NumberSigns',
            'NumberSeparator', 'NumberString', 'Numerator', 'NumericFunction',
            'NumericQ', 'NyquistGridLines', 'NyquistPlot', 'ObservableModelQ',
            'ObservabilityGramian', 'ObservabilityMatrix', 'Offset', 'Opacity',
            'ObservableDecomposition', 'ONanGroupON', 'OneIdentity', 'Opener',
            'OpenAppend', 'OpenerView', 'Opening', 'OpenRead', 'OpenTemporary',
            'OpenWrite', 'Operate', '$OperatingSystem', 'OperatingSystem',
            'Optional', 'OptionInspectorSettings', 'Options', 'OptionsPattern',
            'OptionValue', 'Orange', 'OrderDistribution', 'OrderedQ', 'Order',
            'Ordering', 'Orderless', 'Orthogonalize', 'Outer', 'OutputForm',
            'OutputAutoOverwrite', 'OutputControllabilityMatrix', '$Output',
            'OutputControllableModelQ', 'OutputNamePacket', 'OutputResponse',
            '$OutputSizeLimit', 'OutputSizeLimit', 'OutputStream', 'OverBar',
            'OverDot', 'Overflow', 'OverHat', 'Overlaps', 'Overlay', 'OwenT',
            'OverscriptBox', 'OverscriptBoxOptions', 'Overscript', 'OverTilde',
            'OverVector', 'OwnValues', '$Packages', 'PackingMethod', 'Padding',
            'PaddedForm', 'PadeApproximant', 'PadLeft', 'PadRight', 'Paneled',
            'PageBreakAbove', 'PageBreakBelow', 'PageBreakWithin', 'PageWidth',
            'PageFooterLines', 'PageFooters', 'PageHeaderLines', 'PageHeaders',
            'PageRankCentrality', 'PairedBarChart', 'PairedHistogram', 'Panel',
            'PairedTTest', 'PairedZTest', 'PaletteNotebook', 'PalettePath',
            'Pane', 'PaneSelector', 'ParabolicCylinderD', 'ParagraphIndent',
            'ParagraphSpacing', 'ParallelArray', 'ParallelCombine', 'Part',
            'ParallelDo', 'ParallelEvaluate', 'Parallelization', 'Parallelize',
            'ParallelMap', 'ParallelNeeds', 'ParallelProduct', 'ParallelSum',
            'ParallelSubmit', 'ParallelTable', 'ParallelTry', 'ParametricPlot',
            'ParameterEstimator', 'ParameterMixtureDistribution', 'Partition',
            'ParametricPlot3D', 'ParentDirectory', '$ParentLink', 'Paste',
            '$ParentProcessID', 'ParetoDistribution', 'ParticleData', '$Path',
            'PartitionsP', 'PartitionsQ', 'PascalDistribution', 'PassEventsUp',
            'PassEventsDown', 'PasteBoxFormInlineCells', 'PasteButton', 'Path',
            'PathGraph', 'PathGraphQ', '$PathnameSeparator', 'Pattern', 'Pick',
            'PatternSequence', 'PatternTest', 'PauliMatrix', 'PaulWavelet',
            'Pause', 'PearsonChiSquareTest', 'PearsonDistribution', 'Permute',
            '$PerformanceGoal', 'PerformanceGoal', 'PermutationCycles', 'Pink',
            'PermutationCyclesQ', 'PermutationGroup', 'PermutationLength',
            'PermutationList', 'PermutationListQ', 'PermutationMax', 'Placed',
            'PermutationMin', 'PermutationOrder', 'PermutationPower', 'Plain',
            'PermutationProduct', 'PermutationReplace', 'Permutations', 'Play',
            'PermutationSupport', 'PeronaMalikFilter', 'PERTDistribution',
            'PetersenGraph', 'PhaseMargins', 'PiecewiseExpand', 'Piecewise',
            'PieChart3D', 'PieChart', 'PixelConstrained', 'PixelValue', 'Plot',
            'Placeholder', 'PlaceholderReplace', 'PlayRange', 'Plot3D', 'Plus',
            'Plot3Matrix', 'PlotDivision', 'PlotJoined', 'PlotLabel', 'Point',
            'PlotLayout', 'PlotMarkers', 'PlotPoints', 'PlotRangeClipping',
            'PlotRange', 'PlotRangePadding', 'PlotRegion', 'PlotStyle', '$Pre',
            'PlusMinus', 'Pochhammer', 'PodStates', 'PodWidth', 'PointSize',
            'PointFigureChart', 'PoissonConsulDistribution', 'PolarAxes',
            'PoissonDistribution', 'PolarAxesOrigin', 'PolarGridLines', 'Quit',
            'PolarPlot', 'PolarTicks', 'PoleZeroMarkers', 'PolyGamma', '$Post',
            'PolyaAeppliDistribution', 'PolygonIntersections', 'Polygon',
            'PolyhedronData', 'PolyLog', 'PolynomialExtendedGCD', 'PopupMenu',
            'PolynomialGCD', 'PolynomialLCM', 'PolynomialMod', 'PolynomialQ',
            'PolynomialQuotient', 'PolynomialQuotientRemainder', 'PopupView',
            'PolynomialReduce', 'PolynomialRemainder', 'PopupWindow', 'Power',
            'Position', 'PositiveDefiniteMatrixQ', 'Positive', 'PossibleZeroQ',
            'Postfix', 'PowerDistribution', 'PowerExpand', 'PowerModList',
            'PowerMod', 'PowersRepresentations', 'PowerSymmetricPolynomial',
            'PrecedenceForm', 'PrecedesEqual', 'Precedes', 'PrecedesTilde',
            'PrecedesSlantEqual', 'PrecisionGoal', 'Precision', 'PreDecrement',
            'PreemptProtect', 'PreferencesPath', 'Prefix', 'PreIncrement',
            'Prepend', 'PrependTo', '$PrePrint', '$PreRead', 'Prime', 'PrimeQ',
            'PreserveImageOptions', 'PriceGraphDistribution', 'PrimeNu', 'Xor',
            'PrimeOmega', 'PrimePi', 'PrimePowerQ', 'Primes', 'PrimeZetaP',
            'PrimitiveRoot', 'PrincipalComponents', 'PrincipalValue', 'Print',
            'PrintAction', 'PrintingCopies', 'PrintingOptions', 'PrivatePaths',
            'PrintingPageRange', 'PrintingStartingPageNumber', 'Probability',
            'PrintingStyleEnvironment', 'PrintPrecision', 'PrintTemporary',
            'PrivateEvaluationOptions', 'PrivateFontOptions', 'ProbitModelFit',
            'PrivateNotebookOptions', 'ProbabilityDistribution', '$ProcessID',
            'ProbabilityPlot', 'ProbabilityScalePlot', '$ProcessorCount',
            '$ProcessorType', 'ProductDistribution', '$ProductInformation',
            'ProductLog', 'Product', 'ProgressIndicator', 'Projection', 'Read',
            'Prolog', 'Properties', 'PropertyList', 'Property', 'Proportional',
            'PropertyValue', 'Proportion', 'Protected', 'Protect', 'Pruning',
            'ProteinData', 'PseudoInverse', 'Purple', 'PutAppend', 'QBinomial',
            'QFactorial', 'QGamma', 'QHypergeometricPFQ', 'QPochhammer',
            'QPolyGamma', 'QRDecomposition', 'QuadraticIrrationalQ', 'Quiet',
            'Quantile', 'QuantilePlot', 'Quartics', 'QuartileDeviation',
            'QuartileSkewness', 'Quartiles', 'Quotient', 'QuotientRemainder',
            'RadicalBox', 'RadicalBoxOptions', 'RadioButtonBar', 'RadioButton',
            'Radon', 'RamanujanTauL', 'RamanujanTau', 'RamanujanTauTheta',
            'RamanujanTauZ', 'RandomChoice', 'RandomComplex', 'RandomGraph',
            'RandomImage', 'RandomInteger', 'Random', 'RandomPermutation',
            'RandomPrime', 'RandomReal', 'RandomSample', '$RandomState',
            'RandomVariate', 'RangeFilter', 'Range', 'RankedMax', 'RankedMin',
            'RasterArray', 'Rasterize', 'Raster', 'RasterSize', 'Rationalize',
            'Rational', 'Rationals', 'Ratios', 'RawBoxes', 'RawData', 'Real',
            'RayleighDistribution', 'ReadList', 'ReadProtected', 'RealDigits',
            'RealBlockDiagonalForm', 'RealExponent', 'Reals', 'Reap', 'Record',
            'RecordLists', 'RecordSeparators', 'RectangleChart3D', 'Rectangle',
            'RectangleChart', 'RecurrenceTable', '$RecursionLimit', 'Reduce',
            'ReferenceLineStyle', 'Refine', 'ReflectionMatrix', 'Refresh',
            'ReflectionTransform', 'RefreshRate', 'RegionBinarize', 'Release',
            'RegionFunction', 'RegionPlot3D', 'RegionPlot', 'Regularization',
            'RegularExpression', 'ReleaseHold', '$ReleaseNumber', 'ReliefPlot',
            'ReliefImage', 'RemoveAlphaChannel', 'Remove', 'RemoveProperty',
            'RemoveScheduledTask', 'RenameDirectory', 'RenameFile', 'Repeated',
            'RenderAll', 'RenkoChart', 'RepeatedNull', 'ReplaceAll', 'Replace',
            'ReplaceHeldPart', 'ReplaceList', 'ReplacePart', 'ReplaceRepeated',
            'Resampling', 'Rescale', 'RescalingTransform', 'ResetDirectory',
            'ResetMedium', 'ResetScheduledTask', 'Residue', 'Resolve', 'Rest',
            'Resultant', 'ResumePacket', 'ReturnExpressionPacket', 'Return',
            'ReturnPacket', 'ReturnTextPacket', 'ReverseElement', 'Reverse',
            'ReverseBiorthogonalSplineWavelet', 'ReverseEquilibrium', 'Riffle',
            'ReverseGraph', 'ReverseUpEquilibrium', 'RevolutionAxis', 'Right',
            'RevolutionPlot3D', 'RGBColor', 'RiccatiSolve', 'RiceDistribution',
            'RidgeFilter', 'RiemannR', 'RiemannSiegelTheta', 'RiemannSiegelZ',
            'RightArrowBar', 'RightArrowLeftArrow', 'RightArrow', 'Root',
            'RightCosetRepresentative', 'RightDownTeeVector', 'RightTeeArrow',
            'RightDownVectorBar', 'RightDownVector', 'RightTeeVector', 'Roots',
            'RightTriangleBar', 'RightTriangleEqual', 'RightTriangle', 'Round',
            'RightUpDownVector', 'RightUpTeeVector', 'RightUpVectorBar',
            'RightUpVector', 'RightVectorBar', 'RightVector', '$RootDirectory',
            'RogersTanimotoDissimilarity', 'RootApproximant', 'RootIntervals',
            'RootLocusPlot', 'RootMeanSquare', 'RootOfUnityQ', 'RootReduce',
            'RootSum', 'RotateLabel', 'RotateLeft', 'Rotate', 'RotateRight',
            'RotationAction', 'RotationMatrix', 'RotationTransform', 'RowBox',
            'RoundingRadius', 'RowAlignments', 'RowLines', 'RowMinHeight',
            'RowReduce', 'RowsEqual', 'RowSpacings', 'RSolve', 'RuleDelayed',
            'RudvalisGroupRu', 'Rule', 'RulerUnits', 'RunScheduledTask',
            'RunThrough', 'RuntimeAttributes', 'RuntimeOptions', 'SameQ',
            'RussellRaoDissimilarity', 'SameTest', 'SampleDepth', 'SampleRate',
            'SampledSoundFunction', 'SampledSoundList', 'SamplingPeriod',
            'SatisfiabilityCount', 'SatisfiabilityInstances', 'SatisfiableQ',
            'Saveable', 'SaveAutoDelete', 'SaveDefinitions', 'Save', 'Scaled',
            'SawtoothWave', 'Scale', 'ScalingFunctions', 'ScalingMatrix',
            'ScalingTransform', 'Scan', '$ScheduledTask', 'ScheduledTasks',
            'ScheduledTaskObject', 'SchurDecomposition', 'ScientificForm',
            'ScreenRectangle', 'ScreenStyleEnvironment', '$ScriptCommandLine',
            'ScriptBaselineShifts', 'ScriptLevel', 'ScriptMinSize', 'Sech',
            'ScriptSizeMultipliers', 'Scrollbars', 'ScrollingOptions', 'Share',
            'ScrollPosition', 'SechDistribution', 'SectorChart3D', 'Select',
            'SectorChart', 'SectorOrigin', 'SectorSpacing', 'SeedRandom',
            'Selectable', 'SelectComponents', 'SelectedNotebook', 'SendMail',
            'SelectionAnimate', 'SelectionCreateCell', 'SelectionEvaluate',
            'SelectionEvaluateCreateCell', 'SelectionMove', 'SelfLoopStyle',
            'SemialgebraicComponentInstances', 'SequenceAlignment', 'Sequence',
            'SequenceForm', 'SequenceHold', 'SeriesCoefficient', 'SeriesData',
            'Series', '$SessionID', 'SessionTime', 'SetAccuracy', 'SetDelayed',
            'SetAlphaChannel', 'SetAttributes', 'SetDirectory', 'SetFileDate',
            'SetOptions', 'SetPrecision', 'SetProperty', 'SetSelectedNotebook',
            'SetSharedFunction', 'SetSharedVariable', 'SetStreamPosition',
            'SetSystemOptions', 'SetterBar', 'Setter', 'Setting', 'Shading',
            'Shallow', 'ShannonWavelet', 'ShapiroWilkTest', '$SharedFunctions',
            '$SharedVariables', 'Sharpen', 'ShearingMatrix', 'ShortDownArrow',
            'ShearingTransform', 'ShortestMatch', 'Shortest', 'ShortLeftArrow',
            'ShortestPathFunction', 'Short', 'ShortRightArrow', 'ShortUpArrow',
            'ShowAutoStyles', 'ShowCellBracket', 'ShowCellLabel', 'Show',
            'ShowCellTags', 'ShowClosedCellArea', 'ShowContents', 'Signature',
            'ShowCursorTracker', 'ShowGroupOpener', 'ShowPageBreaks', 'Sign',
            'ShowSelection', 'ShowShortBoxForm', 'ShowSpecialCharacters',
            'ShowStringCharacters', 'ShrinkingDelay', 'SiegelTheta', 'Sinc',
            'SiegelTukeyTest', 'SignedRankTest', 'SignificanceLevel', 'Sinh',
            'SignPadding', 'SignTest', 'SimilarityRules', 'SimpleGraph',
            'SimpleGraphQ', 'Simplify', 'SinghMaddalaDistribution', 'Skeleton',
            'SingleLetterItalics', 'SingularValueDecomposition', 'SinIntegral',
            'SingularValueList', 'SingularValuePlot', 'SingularValues', 'Skip',
            'SinhIntegral', 'SixJSymbol', 'SkeletonTransform', 'Skewness',
            'SkellamDistribution', 'SkewNormalDistribution', 'Slider2D',
            'Slider', 'SlideView', 'Slot', 'SlotSequence', 'SmallCircle',
            'Smaller', 'Small', 'SmithWatermanSimilarity', 'SmoothHistogram3D',
            'SmoothDensityHistogram', 'SmoothHistogram', 'SolveAlways', 'Sort',
            'SmoothKernelDistribution', 'SokalSneathDissimilarity', 'Solve',
            'SortBy', '$SoundDisplayFunction', 'Sound', 'SoundNote', 'Spacer',
            'SoundVolume', 'Spacings', 'SpanAdjustments', 'SpanFromAbove',
            'SpanCharacterRounding', 'SpanFromBoth', 'SpanFromLeft', 'Span',
            'SpanLineThickness', 'SpanMaxSize', 'SpanMinSize', 'SpanSymmetric',
            'SparseArray', 'Speak', 'Specularity', 'SpellingCorrection',
            'SpellingDictionaries', 'SpellingDictionariesPath', 'Sphere',
            'SpellingOptions', 'SphericalBesselJ', 'SphericalBesselY', 'Split',
            'SphericalHankelH1', 'SphericalHankelH2', 'SphericalHarmonicY',
            'SphericalPlot3D', 'SphericalRegion', 'SpheroidalEigenvalue',
            'SpheroidalJoiningFactor', 'SpheroidalPS', 'SpheroidalPSPrime',
            'SpheroidalQS', 'SpheroidalQSPrime', 'SpheroidalRadialFactor',
            'SpheroidalS1', 'SpheroidalS1Prime', 'SpheroidalS2', 'Splice',
            'SpheroidalS2Prime', 'SplineClosed', 'SplineDegree', 'SplineKnots',
            'SplineWeights', 'SplitBy', 'SpokenString', 'SqrtBox', 'Sqrt',
            'SquaredEuclideanDistance', 'SquareFreeQ', 'SquareIntersection',
            'Square', 'SquaresR', 'SquareSubsetEqual', 'SquareSubset', 'Stack',
            'SquareSupersetEqual', 'SquareSuperset', 'SquareUnion', 'Star',
            'SquareWave', 'StabilityMargins', 'StabilityMarginsStyle', 'Stub',
            'StableDistribution', 'StackBegin', 'StackComplete', 'Standardize',
            'StackInhibit', 'StandardDeviationFilter', 'StandardDeviation',
            'StandardForm', 'StarGraph', 'StartingStepSize', 'StartOfLine',
            'StartOfString', 'StartProcess', 'StartScheduledTask', 'Streams',
            'StartupSound', 'StateFeedbackGains', 'StateOutputEstimator',
            'StateResponse', 'StateSpaceModel', 'StateSpaceRealization',
            'StateSpaceTransform', 'StationaryWaveletPacketTransform', 'Style',
            'StationaryWaveletTransform', 'StatusArea', 'StepMonitor', 'Table',
            'StieltjesGamma', 'StirlingS1', 'StirlingS2', 'StopScheduledTask',
            'StreamColorFunction', 'StreamColorFunctionScaling', 'StreamPlot',
            'StreamDensityPlot', 'StreamPoints', 'StreamPosition', 'String',
            'StreamScale', 'StreamStyle', 'StringCases', 'StringCount', 'Take',
            'StringDrop', 'StringExpression', 'StringFormat', 'StringForm',
            'StringFreeQ', 'StringInsert', 'StringJoin', 'StringLength',
            'StringMatchQ', 'StringPosition', 'StringQ', 'StringReplaceList',
            'StringReplace', 'StringReplacePart', 'StringReverse', 'StruveH',
            'StringSkeleton', 'StringSplit', 'StringTake', 'StringToStream',
            'StringTrim', 'StructuredSelection', 'StruveL', 'StyleBox', 'Tanh',
            'StudentTDistribution', 'StyleBoxAutoDelete', 'StyleData', 'Tally',
            'StyleDefinitions', 'StyleForm', 'StyleMenuListing', 'StylePrint',
            'StyleNameDialogSettings', 'StyleSheetPath', 'Subfactorial',
            'Subgraph', 'SubMinus', 'SubPlus', 'Subresultants', 'SubscriptBox',
            'SubscriptBoxOptions', 'Subscripted', 'Subscript', 'SubsetEqual',
            'Subset', 'Subsets', 'SubStar', 'SubsuperscriptBox', 'Subtract',
            'SubsuperscriptBoxOptions', 'Subsuperscript', 'SubtractFrom',
            'SucceedsEqual', 'Succeeds', 'SucceedsSlantEqual', 'SucceedsTilde',
            'SuchThat', 'SumConvergence', 'SuperDagger', 'SuperMinus', 'Text',
            'SuperPlus', 'SuperscriptBox', 'SuperscriptBoxOptions', 'Superset',
            'Superscript', 'SupersetEqual', 'SuperStar', 'SurfaceColor',
            'SurfaceGraphics', 'SurvivalDistribution', 'SurvivalFunction',
            'SuspendPacket', 'SuzukiDistribution', 'SuzukiGroupSuz', 'Switch',
            'SymbolName', 'Symbol', 'SymletWavelet', 'SymmetricGroup', 'Thick',
            'SymmetricMatrixQ', 'SymmetricPolynomial', 'SymmetricReduction',
            'SynchronousInitialization', 'SynchronousUpdating', 'SyntaxForm',
            '$SyntaxHandler', 'SyntaxInformation', 'SyntaxLength', 'SyntaxQ',
            'SyntaxPacket', '$SystemCharacterEncoding', 'SystemDialogInput',
            'SystemHelpPath', '$SystemID', 'SystemInformation', '$System',
            'SystemOpen', 'SystemOptions', 'SystemsModelDelete', 'TabFilling',
            'SystemsModelDimensions', 'SystemsModelExtract', 'TableAlignments',
            'SystemsModelFeedbackConnect', 'SystemsModelLabels', 'TableDepth',
            'SystemsModelOrder', 'SystemsModelParallelConnect', 'TableForm',
            'SystemsModelSeriesConnect', 'SystemsModelStateFeedbackConnect',
            '$SystemWordLength', 'TableDirections', 'TableHeadings', 'TabView',
            'TableSpacing', 'TabSpacings', 'TagBox', 'TaggingRules', 'TagSet',
            'TagSetDelayed', 'TagUnset', 'TakeWhile', 'TargetFunctions',
            'TautologyQ', '$TemporaryDirectory', 'Temporary', 'TensorRank',
            '$TemporaryPrefix', 'TeXForm', 'TeXSave', 'TextAlignment', 'Thin',
            'TextCell', 'TextClipboardType', 'TextData', 'TextJustification',
            'TextPacket', 'TextRecognize', '$TextStyle', 'TextStyle', 'Thread',
            'TextureCoordinateFunction', 'TextureCoordinateScaling', 'Texture',
            'Therefore', 'Thickness', 'Thinning', 'ThompsonGroupTh', 'Through',
            'ThreeJSymbol', 'Threshold', 'Throw', 'Thumbnail', 'Ticks', 'Tiny',
            'TicksStyle', 'TildeEqual', 'TildeFullEqual', 'Tilde', '$TimedOut',
            'TildeTilde', 'TimeConstrained', 'TimeConstraint', 'TimesBy',
            'Times', '$TimeUnit', 'TimeUsed', 'TimeValue', '$TimeZone', 'Trig',
            'TimeZone', 'Timing', 'TitsGroupT', 'ToASCII', 'ToBoxes', 'ToDate',
            'ToCharacterCode', 'ToContinuousTimeModel', 'ToDiscreteTimeModel',
            'ToeplitzMatrix', 'ToExpression', 'ToFileName', 'Together', 'True',
            'TogglerBar', 'Toggler', 'ToHeldExpression', 'TokenWords', 'Total',
            'Tolerance', 'ToLowerCase', 'ToNumberField', 'TooltipDelay',
            'Tooltip', '$TopDirectory', 'TopHatTransform', 'TopologicalSort',
            'ToRadicals', 'ToRules', 'ToString', 'TotalVariationFilter',
            'TotalWidth', 'ToUpperCase', 'TraceAbove', 'TraceBackward', 'Tube',
            'TraceDepth', 'TraceDialog', 'TraceForward', 'Trace', 'TraceOff',
            'TraceOn', 'TraceOriginal', 'TracePrint', 'TraceScan', 'Translate',
            'TrackedSymbols', 'TradingChart', 'TraditionalForm', 'Transparent',
            'TraditionalFunctionNotation', 'TransferFunctionCancel', 'Trigger',
            'TransferFunctionExpand', 'TransferFunctionFactor', 'Transpose',
            'TransferFunctionModel', 'TransferFunctionPoles', 'TreeForm',
            'TransferFunctionZeros', 'TransformationFunction', 'TreeGraph',
            'TransformationFunctions', 'TransformationMatrix', 'TreeGraphQ',
            'TransformedDistribution', 'TranslationTransform', 'TreePlot',
            'TrendStyle', 'TriangleWave', 'TriangularDistribution', 'TrueQ',
            'TrigExpand', 'TrigFactorList', 'TrigFactor', 'TrigReduce', 'With',
            'TrigToExp', 'TrimmedMean', 'TruncatedDistribution', 'TTest',
            'TukeyLambdaDistribution', 'Tuples', 'TuranGraph', 'TuringMachine',
            'Uncompress', 'Undefined', 'UnderBar', 'Underflow', 'Underlined',
            'UnderoverscriptBox', 'UnderoverscriptBoxOptions', 'Underscript',
            'Underoverscript', 'UnderscriptBox', 'UnderscriptBoxOptions',
            'UndirectedEdge', 'UndirectedGraph', 'UndirectedGraphQ', 'Unequal',
            'Unevaluated', 'UniformDistribution', 'UniformGraphDistribution',
            'UniformSumDistribution', 'Uninstall', 'Union', 'UnionPlus',
            'Unique', 'UnitBox', 'Unitize', 'UnitStep', 'UnitTriangle', 'Word',
            'UnitVector', 'Unprotect', 'UnsameQ', 'UnsavedVariables', 'Unset',
            'UnsetShared', 'UpArrowBar', 'UpArrowDownArrow', 'UpArrow', 'Xnor',
            'UpdateInterval', 'Update', 'UpDownArrow', 'UpEquilibrium', 'Zeta',
            'UpperCaseQ', 'UpperLeftArrow', 'UpperRightArrow', 'UpSetDelayed',
            'UpperTriangularize', 'UpSet', 'UpTeeArrow', 'UpValues', '$Urgent',
            '$UserAddOnsDirectory', '$UserBaseDirectory', '$UserName', 'Wedge',
            '$UserDocumentsDirectory', 'UsingFrontEnd', 'ValidationLength',
            'ValueQ', 'Variables', 'VarianceEquivalenceTest', 'Variance',
            'VarianceEstimatorFunction', 'VarianceTest', 'VectorAngle',
            'VectorColorFunction', 'VectorColorFunctionScaling', 'VectorPlot',
            'VectorDensityPlot', 'VectorPlot3D', 'VectorPoints', 'VectorQ',
            'VectorScale', 'VectorStyle', 'Verbatim', 'VerifyConvergence',
            'VerifyTestAssumptions', '$Version', '$VersionNumber', 'VertexAdd',
            'VertexColors', 'VertexComponent', 'VertexCoordinateRules',
            'VertexCoordinates', 'VertexCount', 'VertexCoverQ', 'VertexDegree',
            'VertexDelete', 'VertexEccentricity', 'VertexInComponent', 'Which',
            'VertexInDegree', 'VertexIndex', 'VertexLabeling', 'VertexLabels',
            'VertexLabelStyle', 'VertexList', 'VertexNormals', 'VertexQ',
            'VertexOutComponent', 'VertexOutDegree', 'VertexRenderingFunction',
            'VertexReplace', 'VertexShapeFunction', 'VertexShape', 'ViewAngle',
            'VertexSize', 'VertexStyle', 'VertexTextureCoordinates', 'Visible',
            'VertexWeight', 'VerticalBar', 'VerticalSeparator', 'ViewCenter',
            'VerticalSlider', 'VerticalTilde', 'ViewMatrix', 'ViewPoint',
            'ViewRange', 'ViewVector', 'ViewVertical', 'VonMisesDistribution',
            'WaitAll', 'WaitNext', 'WakebyDistribution', 'WatershedComponents',
            'WalleniusHypergeometricDistribution', 'WaringYuleDistribution',
            'WatsonUSquareTest', 'WattsStrogatzGraphDistribution', 'WeberE',
            'WaveletBestBasis', 'WaveletFilterCoefficients', 'WaveletListPlot',
            'WaveletImagePlot', 'WaveletMapIndexed', 'WaveletMatrixPlot',
            'WaveletPhi', 'WaveletPsi', 'WaveletScale', 'WaveletScalogram',
            'WaveletThreshold', 'WeatherData', 'WeibullDistribution', 'While',
            'WeierstrassHalfPeriods', 'WeierstrassInvariants', 'WeierstrassP',
            'WeierstrassPPrime', 'WeierstrassSigma', 'WeierstrassZeta',
            'WeightedAdjacencyGraph', 'WeightedAdjacencyMatrix', 'Weights',
            'WeightedGraphQ', 'WheelGraph', 'White', 'WhitespaceCharacter',
            'Whitespace', 'WhittakerM', 'WhittakerW', 'WienerFilter', 'Write',
            'WignerD', 'WignerSemicircleDistribution', 'WindowClickSelect',
            'WindowElements', 'WindowFloating', 'WindowFrameElements', 'ZTest',
            'WindowFrame', 'WindowMargins', 'WindowMovable', 'WindowOpacity',
            'WindowSize', 'WindowStatusArea', 'WindowTitle', 'WindowToolbars',
            'WolframAlpha', 'WordBoundary', 'WordCharacter', 'WordData',
            'WordSearch', 'WordSeparators', 'WorkingPrecision', 'WriteString',
            'Wronskian', 'XMLElement', 'XMLObject', 'Yellow', 'ZernikeR',
            'YuleDissimilarity', 'ZeroTest', 'ZeroWidthTimes', 'ZetaZero',
            'ZipfDistribution', 'ZTransform'
            )
        ),
    /* Most symbol combinations can be valid Wolfram operators */
    'SYMBOLS' => array(
        '!', '@', '#', '$', '%', '&', '*', '-', '+', '=',
        '^', '~', '|', '\\', '>', '<', ':', '?', '/'
        ),
    'CASE_SENSITIVE' => array(
        GESHI_COMMENTS => false,
        1 => true /* Wolfram is a case sensitive language */
        ),
    'STYLES' => array(
        'KEYWORDS' => array(
            1 => 'font-weight: bold;', /* make the system functions bold */
            ),
        'COMMENTS' => array(
            'MULTI' => 'color: grey;',
            2 => 'color: grey;', /* nested comments are grey as well */
            3 => 'color: #000aa; font-weight: bold;' /* complex symbols */
            ),
        'ESCAPE_CHAR' => array(
            0 => 'background-color: #3cb371; font-weight: bold;'
            ),
        'BRACKETS' => array(
            0 => 'color: green; font-weight: bold;'
            ),
        'STRINGS' => array(
            0 => 'color: grey; font-weight: bold;'
            ),
        'NUMBERS' => array(
            0 => 'color: red;'
            ),
        'METHODS' => array(
            1 => 'color: #060;'
            ),
        'REGEXPS' => array(
            ),
        'SYMBOLS' => array(
            0 => 'color: #339933; font-weight: bold;'
            ),
        'SCRIPT' => array(
            )
        ),
    'URLS' => array(
        /* online documentation for system functions */
        1 => 'http://reference.wolfram.com/language/ref/{FNAME}.html'
        ),
    'OOLANG' => false,
    'OBJECT_SPLITTERS' => array(
        ),
    'REGEXPS' => array(
        ),
    'STRICT_MODE_APPLIES' => GESHI_NEVER,
    'SCRIPT_DELIMITERS' => array(
        ),
    'HIGHLIGHT_STRICT_BLOCK' => array(
        )
);
