/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;

public class TileImprovement
extends TileItem {
    private static final Logger logger = Logger.getLogger(TileImprovement.class.getName());
    public static final String TAG = "tileImprovement";
    public static final String EMPTY_RIVER_STYLE = "0000";
    public static final String EMPTY_ROAD_STYLE = "00000000";
    public static final int NO_RIVER = 0;
    public static final int SMALL_RIVER = 1;
    public static final int LARGE_RIVER = 2;
    public static final int FJORD_RIVER = 3;
    private TileImprovementType type;
    private int turnsToComplete;
    private int magnitude;
    private TileImprovementStyle style;
    private boolean virtual;
    private static final String MAGNITUDE_TAG = "magnitude";
    private static final String STYLE_TAG = "style";
    private static final String TILE_TAG = "tile";
    private static final String TURNS_TAG = "turns";
    private static final String TYPE_TAG = "type";
    private static final String VIRTUAL_TAG = "virtual";

    public TileImprovement(Game game, Tile tile, TileImprovementType type, TileImprovementStyle style) {
        super(game, tile);
        if (type == null) {
            throw new RuntimeException("Type must not be null: " + this);
        }
        this.type = type;
        if (!type.isNatural()) {
            this.turnsToComplete = tile.getType().getBasicWorkTurns() + type.getAddWorkTurns();
        }
        this.magnitude = type.getMagnitude();
        this.style = style;
    }

    public TileImprovement(Game game, String id) {
        super(game, id);
    }

    public TileImprovementType getType() {
        return this.type;
    }

    public boolean isRiver() {
        return "model.improvement.river".equals(this.type.getId());
    }

    public boolean isRoad() {
        return "model.improvement.road".equals(this.type.getId());
    }

    public List<Direction> getConnectionDirections() {
        return this.isRoad() ? Direction.allDirections : (this.isRiver() ? Direction.longSides : null);
    }

    public int getTurnsToComplete() {
        return this.turnsToComplete;
    }

    public void setTurnsToComplete(int turns) {
        this.turnsToComplete = turns;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(int magnitude) {
        this.magnitude = magnitude;
    }

    public TileImprovementStyle getStyle() {
        return this.style;
    }

    public void setStyle(TileImprovementStyle style) {
        this.style = style;
    }

    public final boolean getVirtual() {
        return this.virtual;
    }

    public final void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public int getRiverConnection(Direction direction) {
        int index = Direction.longSides.indexOf(direction);
        if (index == -1 || this.style == null) {
            return 0;
        }
        int mag = Character.digit(this.style.getString().charAt(index), 10);
        return mag == -1 ? 0 : mag;
    }

    public boolean isConnectedTo(Direction direction) {
        int index;
        int n = this.isRoad() ? direction.ordinal() : (index = this.isRiver() ? Direction.longSides.indexOf(direction) : -1);
        return index == -1 || this.style == null ? false : this.style.getString().charAt(index) != '0';
    }

    private void setConnected(Direction direction, boolean value) {
        if (this.style == null || this.isConnectedTo(direction) != value) {
            this.setConnected(direction, value, Integer.toString(this.magnitude));
        }
    }

    private void setConnected(Direction direction, boolean value, String magnitude) {
        if (this.style == null) {
            this.style = TileImprovementStyle.getInstance(EMPTY_ROAD_STYLE);
        }
        String old = this.style.toString();
        List<Direction> directions = this.getConnectionDirections();
        int end = directions.size();
        StringBuilder updated = new StringBuilder();
        for (int index = 0; index != end; ++index) {
            if (directions.get(index) == direction) {
                updated.append(value ? magnitude : "0");
                continue;
            }
            updated.append(old.charAt(index));
        }
        this.style = TileImprovementStyle.getInstance(updated.toString());
    }

    public Map<Direction, Integer> getConnections() {
        List<Direction> dirns = this.getConnectionDirections();
        return dirns == null ? Collections.emptyMap() : CollectionUtils.transform(dirns, d -> this.isConnectedTo((Direction)d), Function.identity(), Collectors.toMap(Function.identity(), d -> this.magnitude));
    }

    private Modifier getProductionModifier(GoodsType goodsType) {
        Modifier modifier;
        Modifier modifier2 = modifier = this.isComplete() ? this.type.getProductionModifier(goodsType) : null;
        if (modifier == null || modifier.getValue() == 0.0f || this.magnitude <= 0) {
            return modifier;
        }
        Modifier modifierWithMagnitudeBonus = Modifier.makeModifier(modifier);
        modifierWithMagnitudeBonus.setValue(modifierWithMagnitudeBonus.getValue() * (float)this.magnitude);
        return modifierWithMagnitudeBonus;
    }

    public int getMoveCost(Direction direction, int moveCost) {
        return this.isComplete() && this.isConnectedTo(direction) ? this.type.getMoveCost(moveCost) : moveCost;
    }

    public TileType getChange(TileType tileType) {
        return this.isComplete() ? this.type.getChange(tileType) : null;
    }

    public boolean isWorkerAllowed(Unit unit) {
        return unit == null || this.isComplete() ? false : this.type.isWorkerAllowed(unit);
    }

    public final long getConnectionsFromStyle() {
        List<Direction> directions;
        long conn = 0L;
        if (this.style != null && (directions = this.getConnectionDirections()) != null) {
            String mask = this.style.getMask();
            for (int i = 0; i < directions.size(); ++i) {
                if (mask.charAt(i) == '0') continue;
                conn |= 1L << directions.get(i).ordinal();
            }
        }
        return conn;
    }

    public void setRiverStyle(String conns) {
        if (!this.isRiver()) {
            return;
        }
        Tile tile = this.getTile();
        int i = 0;
        int[] counts = new int[]{0, 0};
        for (Direction d : Direction.longSides) {
            String c;
            Direction dReverse = d.getReverseDirection();
            Tile t = tile.getNeighbourOrNull(d);
            TileImprovement river = t == null ? null : t.getRiver();
            String string = c = conns == null ? "0" : conns.substring(i, i + 1);
            if ("0".equals(c)) {
                if (river != null) {
                    river.setConnected(dReverse, false);
                }
                this.setConnected(d, false);
            } else {
                int mag = Integer.parseInt(c);
                if (river != null) {
                    river.setConnected(dReverse, true);
                    this.setConnected(d, true, c);
                    int n = mag - 1;
                    counts[n] = counts[n] + 1;
                } else if (t != null) {
                    if (!t.getType().isWater()) {
                        t.addRiver(mag, EMPTY_RIVER_STYLE);
                        t.getRiver().setConnected(dReverse, true);
                    }
                    this.setConnected(d, true, c);
                    int n = mag - 1;
                    counts[n] = counts[n] + 1;
                }
            }
            ++i;
        }
        this.magnitude = counts[1] >= counts[0] ? 2 : 1;
    }

    public String updateRiverConnections(String conns) {
        if (!this.isRiver()) {
            return null;
        }
        Tile tile = this.getTile();
        int i = 0;
        for (Direction d : Direction.longSides) {
            String c;
            Direction dReverse = d.getReverseDirection();
            Tile t = tile.getNeighbourOrNull(d);
            TileImprovement river = t == null ? null : t.getRiver();
            String string = c = conns == null ? "0" : conns.substring(i, i + 1);
            if ("0".equals(c)) {
                if (river != null) {
                    river.setConnected(dReverse, false);
                }
                this.setConnected(d, false);
            } else if (river != null) {
                river.setConnected(dReverse, true);
                this.setConnected(d, true);
            } else if (t != null && t.getType().isWater()) {
                this.setConnected(d, true);
            }
            ++i;
        }
        return this.style == null ? null : this.style.getString();
    }

    public String updateRoadConnections(boolean connect) {
        if (!this.isRoad() || !this.isComplete()) {
            return null;
        }
        Tile tile = this.getTile();
        for (Direction d : Direction.values()) {
            TileImprovement road;
            Tile t = tile.getNeighbourOrNull(d);
            TileImprovement tileImprovement = road = t == null ? null : t.getRoad();
            if (road != null && road.isComplete()) {
                road.setConnected(d.getReverseDirection(), connect);
                this.setConnected(d, connect);
                continue;
            }
            this.setConnected(d, false);
        }
        return this.style == null ? null : this.style.getString();
    }

    public Stream<RandomChoice<Disaster>> getDisasterChoices() {
        return this.type == null ? Stream.empty() : this.type.getDisasterChoices();
    }

    @Override
    public String getNameKey() {
        return this.type == null ? null : this.type.getNameKey();
    }

    @Override
    public final int getZIndex() {
        return this.type.getZIndex();
    }

    @Override
    public boolean isTileTypeAllowed(TileType tileType) {
        return this.type.isTileTypeAllowed(tileType);
    }

    @Override
    public int applyBonus(GoodsType goodsType, UnitType unitType, int potential) {
        int result = potential;
        if (potential > 0 && this.isComplete()) {
            result += this.getBonus(goodsType);
        }
        return result;
    }

    private int getBonus(GoodsType goodsType) {
        Modifier result = this.getProductionModifier(goodsType);
        if (result == null) {
            return 0;
        }
        return (int)result.getValue();
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return false;
    }

    @Override
    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null || !this.isComplete()) {
            return Stream.empty();
        }
        Specification spec = this.getSpecification();
        if (unitType == null && this.isNatural() && goodsType.isFoodType()) {
            return Stream.empty();
        }
        if (unitType == null && !this.isNatural() && !goodsType.isFoodType() && spec.getBoolean("model.option.onlyNaturalImprovements")) {
            return Stream.empty();
        }
        Modifier m = this.getProductionModifier(goodsType);
        if (m == null) {
            return Stream.empty();
        }
        if (unitType != null && unitType.getExpertProduction() != null && unitType.getExpertProduction().equals(goodsType)) {
            Stream<Modifier> expertMultiplicativeModifier = unitType.getModifiers(goodsType.getId(), this.tile.getType(), null).filter(mod -> mod.getType() == Modifier.ModifierType.MULTIPLICATIVE);
            float expertBonus = FeatureContainer.applyModifiers(m.getValue(), null, expertMultiplicativeModifier);
            m = Modifier.makeModifier(m);
            m.setValue(expertBonus);
        }
        return Stream.of(m);
    }

    @Override
    public boolean isNatural() {
        return this.type.isNatural();
    }

    @Override
    public boolean isComplete() {
        return this.turnsToComplete <= 0;
    }

    @Override
    public Map.Layer getLayer() {
        return Map.Layer.RIVERS;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        Tile tile = this.getTile();
        if (this.isRiver()) {
            if (this.style == null) {
                lb.add("\n  Broken null style river at ", tile);
                return result.fail();
            }
            String conns = this.style.getString();
            int i = 0;
            for (Direction d : Direction.longSides) {
                TileImprovement river;
                Direction dReverse = d.getReverseDirection();
                Tile t = tile.getNeighbourOrNull(d);
                TileImprovement tileImprovement = river = t == null ? null : t.getRiver();
                if (conns.charAt(i) != '0') {
                    if (river != null) {
                        if (!river.isConnectedTo(dReverse)) {
                            if (fix) {
                                this.setConnected(d, false);
                                lb.add("\n  Removed broken river connection to ", d, " at ", tile);
                                result = result.fix();
                            } else {
                                lb.add("\n  Broken river connection to ", d, " at ", tile);
                                result = result.fail();
                            }
                        }
                    } else if (t == null || !t.getType().isWater()) {
                        if (fix) {
                            this.setConnected(d, false);
                            lb.add("\n  Removed broken river connection to ", d, " at ", tile);
                            result = result.fix();
                        } else {
                            lb.add("\n  Broken river connection to ", d, " at ", tile);
                            result = result.fail();
                        }
                    }
                }
                ++i;
            }
        } else if (this.isRoad() && this.isComplete()) {
            if (fix) {
                TileImprovementStyle oldStyle = this.style;
                this.updateRoadConnections(true);
                if (this.style != oldStyle) {
                    lb.add("\n  Bad road style from ", oldStyle, " to ", this.style, " fixed at ", tile);
                    result = result.fix();
                }
            }
            if (this.style == null) {
                lb.add("\n  Broken road with null style at ", tile);
                result = result.fail();
            }
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TileImprovement o = this.copyInCast(other, TileImprovement.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.type = o.getType();
        this.turnsToComplete = o.getTurnsToComplete();
        this.magnitude = o.getMagnitude();
        this.style = o.getStyle();
        this.virtual = o.getVirtual();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.getTile());
        xw.writeAttribute(TYPE_TAG, this.getType());
        xw.writeAttribute(TURNS_TAG, this.turnsToComplete);
        xw.writeAttribute(MAGNITUDE_TAG, this.magnitude);
        if (this.style != null) {
            xw.writeAttribute(STYLE_TAG, this.style);
        }
        if (this.virtual) {
            xw.writeAttribute(VIRTUAL_TAG, this.virtual);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.tile = xr.makeFreeColObject(game, TILE_TAG, Tile.class, true);
        this.type = xr.getType(spec, TYPE_TAG, TileImprovementType.class, null);
        this.turnsToComplete = xr.getAttribute(TURNS_TAG, 0);
        this.magnitude = xr.getAttribute(MAGNITUDE_TAG, 0);
        this.virtual = xr.getAttribute(VIRTUAL_TAG, false);
        this.style = null;
        String str = xr.getAttribute(STYLE_TAG, null);
        List<Direction> dirns = this.getConnectionDirections();
        if (dirns == null) {
            if (str != null && !str.isEmpty()) {
                logger.warning("At " + this.tile + " ignored nonempty style for " + this.type + ": " + str);
            }
        } else if (str != null) {
            if (str.length() != dirns.size()) {
                logger.warning("At " + this.tile + " ignored bogus style for " + this.type + ": " + str);
            } else {
                this.style = TileImprovementStyle.getInstance(str);
            }
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        TileImprovementType ty = this.getType();
        sb.append('[').append(ty == null ? "NOTYPE" : ty.getId());
        if (this.turnsToComplete > 0) {
            sb.append(" (").append(this.turnsToComplete).append(" turns left)");
        }
        if (this.style != null) {
            sb.append(' ').append(this.style.getString());
        }
        sb.append(']');
        return sb.toString();
    }
}

