/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InternetGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AttachInternetGateway
extends BaseCmd {
    public static final String[] VPC_DESC = new String[]{"The ID of the network to which to attach the internet gateway."};

    public AttachInternetGateway(String[] args) {
        super("ec2attigw", "ec2-attach-internet-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)AttachInternetGateway.joinDescription(VPC_DESC));
        result.addOption(OptionBuilder.create((String)"c"));
        return result;
    }

    @Override
    public String getOptionString() {
        return "INTERNET_GATEWAY -c VPC";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Attaches an internet gateway to a specified network.");
        System.out.println("     INTERNET_GATEWAY is the ID of the internet gateway that you wish to attach.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("vpc");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INTERNET_GATEWAY");
        this.assertOptionSet("vpc");
        this.warnIfTooManyNonOptions();
        String gatewayId = this.getNonOptions()[0];
        String vpcId = this.getOptionValue("vpc");
        RequestResultPair result = jec2.attachInternetGateway(gatewayId, vpcId);
        out.output(System.out, (InternetGatewayAttachmentDescription)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new AttachInternetGateway(args).invoke();
    }
}

