/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class EnableVgwRoutePropagation
extends BaseCmd {
    private static final String ROUTE_TABLE_DESC = "The ID of the route table.";
    private static final String VGW_DESC = "The ID of the VGW.";
    private String routeTableId;
    private String vpnGatewayId;

    public EnableVgwRoutePropagation(String[] args) {
        super("ec2erp", "ec2-enable-vgw-route-propagation");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"route-table");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ROUTE_TABLE");
        OptionBuilder.withDescription((String)this.joinDescription(ROUTE_TABLE_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"vgw");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VGW");
        OptionBuilder.withDescription((String)this.joinDescription(VGW_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Enable the propogation of routes from the virtual private gateway");
        System.out.println("     into the route table.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("route-table");
        this.printOption("vgw");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.routeTableId = this.getOptionValue("route-table");
        this.vpnGatewayId = this.getOptionValue("vgw");
        RequestResultPair rsp = jec2.enableVgwRoutePropagation(this.routeTableId, this.vpnGatewayId);
        out.output(System.out, (Boolean)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertOptionSet("route-table");
        this.assertOptionSet("vgw");
    }

    public static void main(String[] args) {
        new EnableVgwRoutePropagation(args).invoke();
    }
}

