/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class SignaturePropertiesTest
extends TestCase {
    private XMLSignatureFactory factory;
    private String id = "id";
    private SignatureProperty prop;

    public SignaturePropertiesTest() {
        super("SignaturePropertiesTest");
    }

    public SignaturePropertiesTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.factory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        this.prop = this.factory.newSignatureProperty(Collections.singletonList(new TestUtils.MyOwnXMLStructure()), "propTarget", "propId");
    }

    public void tearDown() {
    }

    public void testConstructor() {
        SignatureProperties signatureProperties;
        try {
            signatureProperties = this.factory.newSignatureProperties(null, this.id);
            SignaturePropertiesTest.fail((String)"Should raise a NPE for null content");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            SignaturePropertiesTest.fail((String)("Should raise a NPE for null content instead of " + exception));
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            signatureProperties = this.factory.newSignatureProperties(vector, this.id);
            SignaturePropertiesTest.fail((String)"Should raise an IAE for empty content");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            SignaturePropertiesTest.fail((String)("Should raise an IAE for empty content instead of " + exception));
        }
        String string = "wrong type";
        vector.add(string);
        try {
            signatureProperties = this.factory.newSignatureProperties(vector, this.id);
            SignaturePropertiesTest.fail((String)"Should raise a CCE for content containing invalid, i.e. non-SignatureProperty, entries");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            SignaturePropertiesTest.fail((String)("Should raise a CCE for content with invalid entries instead of " + exception));
        }
        vector.remove(string);
        vector.add(this.prop);
        signatureProperties = this.factory.newSignatureProperties(vector, this.id);
        SignaturePropertiesTest.assertNotNull((Object)signatureProperties);
        List<SignatureProperty> list = signatureProperties.getProperties();
        SignaturePropertiesTest.assertNotNull(list);
        try {
            list.add(this.prop);
            SignaturePropertiesTest.fail((String)"Should return an unmodifiable List object");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SignaturePropertiesTest.assertTrue((boolean)Arrays.equals(list.toArray(), vector.toArray()));
        SignaturePropertiesTest.assertNotNull((Object)signatureProperties);
        SignaturePropertiesTest.assertEquals((String)signatureProperties.getId(), (String)this.id);
    }

    public void testisFeatureSupported() {
        Vector<SignatureProperty> vector = new Vector<SignatureProperty>();
        vector.add(this.prop);
        SignatureProperties signatureProperties = this.factory.newSignatureProperties(vector, this.id);
        try {
            signatureProperties.isFeatureSupported(null);
            SignaturePropertiesTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SignaturePropertiesTest.assertTrue((!signatureProperties.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

