/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.helper;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttrCompareTest
extends TestCase {
    static /* synthetic */ Class class$org$apache$xml$security$test$c14n$helper$AttrCompareTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$c14n$helper$AttrCompareTest == null ? (class$org$apache$xml$security$test$c14n$helper$AttrCompareTest = AttrCompareTest.class$("org.apache.xml.security.test.c14n.helper.AttrCompareTest")) : class$org$apache$xml$security$test$c14n$helper$AttrCompareTest);
    }

    public AttrCompareTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$c14n$helper$AttrCompareTest == null ? (class$org$apache$xml$security$test$c14n$helper$AttrCompareTest = AttrCompareTest.class$("org.apache.xml.security.test.c14n.helper.AttrCompareTest")) : class$org$apache$xml$security$test$c14n$helper$AttrCompareTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    private static Attr createAttr(Document document, String string, String string2, String string3) {
        Attr attr = null;
        attr = string3 != null && string3.length() > 0 ? document.createAttributeNS(string3, string) : document.createAttributeNS(null, string);
        attr.appendChild(document.createTextNode(string2));
        return attr;
    }

    private static Document createDoc(String string) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS(null, string);
        document.appendChild(element);
        return document;
    }

    public static void testA1() throws ParserConfigurationException {
        Document document = AttrCompareTest.createDoc("documentElement");
        Element element = document.getDocumentElement();
        Attr attr = AttrCompareTest.createAttr(document, "xmlns", "http://default/", "http://www.w3.org/2000/xmlns/");
        Attr attr2 = AttrCompareTest.createAttr(document, "xmlns:b", "http://val1/", "http://www.w3.org/2000/xmlns/");
        element.setAttributeNode(attr);
        element.setAttributeNode(attr2);
        NamedNodeMap namedNodeMap = element.getAttributes();
        AttrCompareTest.assertEquals((String)"nnm.getLength()", (int)namedNodeMap.getLength(), (int)2);
        Attr attr3 = (Attr)namedNodeMap.item(0);
        Attr attr4 = (Attr)namedNodeMap.item(1);
        AttrCompareTest.assertNotNull((String)"Attribute attr00", (Object)attr3);
        AttrCompareTest.assertNotNull((String)"Attribute attr10", (Object)attr4);
        AttrCompare attrCompare = new AttrCompare();
        AttrCompareTest.assertTrue((String)(attr + " < " + attr2), (attrCompare.compare((Object)attr, (Object)attr2) < 0 ? 1 : 0) != 0);
        AttrCompareTest.assertTrue((String)(attr2 + " < " + attr), (attrCompare.compare((Object)attr2, (Object)attr) > 0 ? 1 : 0) != 0);
    }

    public static void testA2() throws ParserConfigurationException {
        Document document = AttrCompareTest.createDoc("documentElement");
        Attr attr = document.createAttributeNS(null, "foo");
        Attr attr2 = document.createAttributeNS("http://goo", "goo:foo");
        AttrCompare attrCompare = new AttrCompare();
        AttrCompareTest.assertTrue((String)(attr + " < " + attr2), (attrCompare.compare((Object)attr, (Object)attr2) < 0 ? 1 : 0) != 0);
        AttrCompareTest.assertTrue((String)(attr2 + " < " + attr), (attrCompare.compare((Object)attr2, (Object)attr) > 0 ? 1 : 0) != 0);
    }

    public static void _testA2() throws ParserConfigurationException {
        Document document = AttrCompareTest.createDoc("documentElement");
        Element element = document.getDocumentElement();
        Attr attr = AttrCompareTest.createAttr(document, "aAttr", "val0", null);
        Attr attr2 = AttrCompareTest.createAttr(document, "bAttr", "val1", null);
        element.setAttributeNode(attr);
        element.setAttributeNode(attr2);
        NamedNodeMap namedNodeMap = element.getAttributes();
        AttrCompareTest.assertEquals((String)"nnm.getLength()", (int)namedNodeMap.getLength(), (int)2);
        Attr attr3 = (Attr)namedNodeMap.item(0);
        Attr attr4 = (Attr)namedNodeMap.item(1);
        AttrCompareTest.assertNotNull((String)"Attribute attr00", (Object)attr3);
        AttrCompareTest.assertNotNull((String)"Attribute attr10", (Object)attr4);
        AttrCompare attrCompare = new AttrCompare();
        AttrCompareTest.assertTrue((String)(attr + " < " + attr2), (attrCompare.compare((Object)attr, (Object)attr2) < 0 ? 1 : 0) != 0);
        AttrCompareTest.assertTrue((String)(attr2 + " < " + attr), (attrCompare.compare((Object)attr2, (Object)attr) > 0 ? 1 : 0) != 0);
    }

    public static void testComplete() throws ParserConfigurationException {
        Document document = AttrCompareTest.createDoc("documentElement");
        Element element = document.getDocumentElement();
        Attr[] attrArray = new Attr[]{AttrCompareTest.createAttr(document, "xmlns", "http://example.org", "http://www.w3.org/2000/xmlns/"), AttrCompareTest.createAttr(document, "xmlns:a", "http://www.w3.org", "http://www.w3.org/2000/xmlns/"), AttrCompareTest.createAttr(document, "xmlns:b", "http://www.ietf.org", "http://www.w3.org/2000/xmlns/"), AttrCompareTest.createAttr(document, "attr", "I'm", null), AttrCompareTest.createAttr(document, "attr2", "all", null), AttrCompareTest.createAttr(document, "b:attr", "sorted", "http://www.ietf.org"), AttrCompareTest.createAttr(document, "a:attr", "out", "http://www.w3.org")};
        for (int i = 0; i < attrArray.length; ++i) {
            element.setAttributeNode(attrArray[i]);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        AttrCompareTest.assertEquals((String)"nnm.getLength()", (int)namedNodeMap.getLength(), (int)attrArray.length);
        for (int i = 0; i < attrArray.length; ++i) {
            Attr attr = attrArray[i];
            AttrCompareTest.assertNotNull((String)"Attribute attr", (Object)attr);
        }
        AttrCompare attrCompare = new AttrCompare();
        for (int i = 0; i < attrArray.length; ++i) {
            for (int j = i + 1; j < attrArray.length; ++j) {
                Attr attr = attrArray[i];
                Attr attr2 = attrArray[j];
                AttrCompareTest.assertTrue((String)(attr + " < " + attr2), (attrCompare.compare((Object)attr, (Object)attr2) < 0 ? 1 : 0) != 0);
                AttrCompareTest.assertTrue((String)(attr2 + " < " + attr), (attrCompare.compare((Object)attr2, (Object)attr) > 0 ? 1 : 0) != 0);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

