/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.util.Async;

public class ScheduledAction
implements Delayed {
    private final Runnable action;
    final Date releaseTime;
    final SmackReactor smackReactor;
    final Kind kind;

    ScheduledAction(Runnable action, Date releaseTime, SmackReactor smackReactor, Kind kind) {
        this.action = action;
        this.releaseTime = releaseTime;
        this.smackReactor = smackReactor;
        this.kind = kind;
    }

    public boolean cancel() {
        return this.smackReactor.cancel(this);
    }

    public boolean isDue() {
        Date now = new Date();
        return now.after(this.releaseTime);
    }

    public long getTimeToDueMillis() {
        long now = System.currentTimeMillis();
        return this.releaseTime.getTime() - now;
    }

    @Override
    public int compareTo(Delayed otherDelayed) {
        if (this == otherDelayed) {
            return 0;
        }
        long thisDelay = this.getDelay(TimeUnit.MILLISECONDS);
        long otherDelay = otherDelayed.getDelay(TimeUnit.MILLISECONDS);
        return Long.compare(thisDelay, otherDelay);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long delayInMillis = this.getTimeToDueMillis();
        return unit.convert(delayInMillis, TimeUnit.MILLISECONDS);
    }

    void run() {
        switch (this.kind) {
            case NonBlocking: {
                this.action.run();
                break;
            }
            case Blocking: {
                Async.go(() -> this.action.run());
            }
        }
    }

    static enum Kind {
        NonBlocking,
        Blocking;

    }
}

