/* GStreamer
 * Copyright (C) <2007> Wim Taymans <wim.taymans@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
/**
 * SECTION:plugin-playback:
 * @short_description: Set of elements to create dynamic pipelines (or part of it) to play
 * media files.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <gst/gst.h>

#include <gst/gst-i18n-plugin.h>
#include <gst/pbutils/pbutils.h>

#include "gstplayback.h"
#include "gstplaysink.h"
#include "gstsubtitleoverlay.h"
#include "gststreamsynchronizer.h"

static gboolean
plugin_init (GstPlugin * plugin)
{
  gboolean res;

  gst_pb_utils_init ();

#ifdef ENABLE_NLS
  GST_DEBUG ("binding text domain %s to locale dir %s", GETTEXT_PACKAGE,
      LOCALEDIR);
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif /* ENABLE_NLS */

  /* Swap in playbin3 as 'playbin' if USE_PLAYBIN3=1 */
  {
    const gchar *env = g_getenv ("USE_PLAYBIN3");
    if (env && g_str_has_prefix (env, "1"))
      res = gst_play_bin3_plugin_init (plugin, TRUE);
    else
      res = gst_play_bin2_plugin_init (plugin);
  }

  res &= gst_play_bin3_plugin_init (plugin, FALSE);
  res &= gst_play_sink_plugin_init (plugin);
  res &= gst_subtitle_overlay_plugin_init (plugin);
  res &= gst_stream_synchronizer_plugin_init (plugin);

  res &= gst_decode_bin_plugin_init (plugin);
  res &= gst_decodebin3_plugin_init (plugin);
  res &= gst_uri_decode_bin_plugin_init (plugin);
  res &= gst_uri_decode_bin3_plugin_init (plugin);
  res &= gst_uri_source_bin_plugin_init (plugin);
  res &= gst_parse_bin_plugin_init (plugin);

  return res;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    playback,
    "various playback elements", plugin_init, VERSION, GST_LICENSE,
    GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN)
