; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -opaque-pointers=0 -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=8 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -opaque-pointers=0 -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

define i32 @leaf() {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@leaf
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    ret i32 1
;
  ret i32 1
}

define i32 @self_rec() {
; CHECK: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@self_rec
; CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    ret i32 4
;
  %a = call i32 @self_rec()
  ret i32 4
}

define i32 @indirect_rec() {
; TUNIT: Function Attrs: nofree nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@indirect_rec
; TUNIT-SAME: () #[[ATTR1]] {
; TUNIT-NEXT:    ret i32 undef
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@indirect_rec
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    ret i32 undef
;
  %a = call i32 @indirect_rec2()
  ret i32 %a
}
define i32 @indirect_rec2() {
; TUNIT: Function Attrs: nofree nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@indirect_rec2
; TUNIT-SAME: () #[[ATTR1]] {
; TUNIT-NEXT:    ret i32 undef
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@indirect_rec2
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    ret i32 undef
;
  %a = call i32 @indirect_rec()
  ret i32 %a
}

define i32 @extern() {
; CHECK: Function Attrs: nosync memory(none)
; CHECK-LABEL: define {{[^@]+}}@extern
; CHECK-SAME: () #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[A:%.*]] = call i32 @k()
; CHECK-NEXT:    ret i32 [[A]]
;
  %a = call i32 @k()
  ret i32 %a
}

; CHECK: Function Attrs
; CHECK-NEXT: declare i32 @k()
declare i32 @k() readnone

define void @intrinsic(i8* %dest, i8* %src, i32 %len) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(argmem: readwrite)
; CHECK-LABEL: define {{[^@]+}}@intrinsic
; CHECK-SAME: (i8* nocapture nofree writeonly [[DEST:%.*]], i8* nocapture nofree readonly [[SRC:%.*]], i32 [[LEN:%.*]]) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* noalias nocapture nofree writeonly [[DEST]], i8* noalias nocapture nofree readonly [[SRC]], i32 [[LEN]], i1 noundef false) #[[ATTR9:[0-9]+]]
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* %dest, i8* %src, i32 %len, i1 false)
  ret void
}

; CHECK: Function Attrs
; CHECK-NEXT: declare void @llvm.memcpy.p0i8.p0i8.i32
declare void @llvm.memcpy.p0i8.p0i8.i32(i8*, i8*, i32, i1)

define internal i32 @called_by_norecurse() {
; CHECK: Function Attrs: norecurse nosync memory(none)
; CHECK-LABEL: define {{[^@]+}}@called_by_norecurse
; CHECK-SAME: () #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    [[A:%.*]] = call i32 @k()
; CHECK-NEXT:    ret i32 undef
;
  %a = call i32 @k()
  ret i32 %a
}
define void @m() norecurse {
; TUNIT: Function Attrs: norecurse nosync memory(none)
; TUNIT-LABEL: define {{[^@]+}}@m
; TUNIT-SAME: () #[[ATTR6]] {
; TUNIT-NEXT:    [[A:%.*]] = call i32 @called_by_norecurse() #[[ATTR10:[0-9]+]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: norecurse nosync memory(none)
; CGSCC-LABEL: define {{[^@]+}}@m
; CGSCC-SAME: () #[[ATTR6]] {
; CGSCC-NEXT:    [[A:%.*]] = call i32 @called_by_norecurse()
; CGSCC-NEXT:    ret void
;
  %a = call i32 @called_by_norecurse()
  ret void
}

define internal i32 @called_by_norecurse_indirectly() {
; TUNIT: Function Attrs: norecurse nosync memory(none)
; TUNIT-LABEL: define {{[^@]+}}@called_by_norecurse_indirectly
; TUNIT-SAME: () #[[ATTR6]] {
; TUNIT-NEXT:    [[A:%.*]] = call i32 @k()
; TUNIT-NEXT:    ret i32 [[A]]
;
; CGSCC: Function Attrs: nosync memory(none)
; CGSCC-LABEL: define {{[^@]+}}@called_by_norecurse_indirectly
; CGSCC-SAME: () #[[ATTR2]] {
; CGSCC-NEXT:    [[A:%.*]] = call i32 @k()
; CGSCC-NEXT:    ret i32 [[A]]
;
  %a = call i32 @k()
  ret i32 %a
}
define internal i32 @o() {
; TUNIT: Function Attrs: norecurse nosync memory(none)
; TUNIT-LABEL: define {{[^@]+}}@o
; TUNIT-SAME: () #[[ATTR6]] {
; TUNIT-NEXT:    [[A:%.*]] = call i32 @called_by_norecurse_indirectly() #[[ATTR10]]
; TUNIT-NEXT:    ret i32 [[A]]
;
; CGSCC: Function Attrs: norecurse nosync memory(none)
; CGSCC-LABEL: define {{[^@]+}}@o
; CGSCC-SAME: () #[[ATTR6]] {
; CGSCC-NEXT:    [[A:%.*]] = call i32 @called_by_norecurse_indirectly()
; CGSCC-NEXT:    ret i32 [[A]]
;
  %a = call i32 @called_by_norecurse_indirectly()
  ret i32 %a
}
define i32 @p() norecurse {
; TUNIT: Function Attrs: norecurse nosync memory(none)
; TUNIT-LABEL: define {{[^@]+}}@p
; TUNIT-SAME: () #[[ATTR6]] {
; TUNIT-NEXT:    [[A:%.*]] = call i32 @o() #[[ATTR10]]
; TUNIT-NEXT:    ret i32 [[A]]
;
; CGSCC: Function Attrs: norecurse nosync memory(none)
; CGSCC-LABEL: define {{[^@]+}}@p
; CGSCC-SAME: () #[[ATTR6]] {
; CGSCC-NEXT:    [[A:%.*]] = call i32 @o()
; CGSCC-NEXT:    ret i32 [[A]]
;
  %a = call i32 @o()
  ret i32 %a
}

define void @f(i32 %x)  {
; TUNIT: Function Attrs: nofree nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@f
; TUNIT-SAME: (i32 [[X:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[X_ADDR:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    store i32 [[X]], i32* [[X_ADDR]], align 4
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[X]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    br label [[IF_END]]
; TUNIT:       if.end:
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@f
; CGSCC-SAME: (i32 [[X:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[X_ADDR:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[X]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    br label [[IF_END]]
; CGSCC:       if.end:
; CGSCC-NEXT:    ret void
;
entry:
  %x.addr = alloca i32, align 4
  store i32 %x, i32* %x.addr, align 4
  %0 = load i32, i32* %x.addr, align 4
  %tobool = icmp ne i32 %0, 0
  br i1 %tobool, label %if.then, label %if.end

if.then:
  call void @g() norecurse
  br label %if.end

if.end:
  ret void
}

define void @g() norecurse {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@g
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  call void @f(i32 0)
  ret void
}

define linkonce_odr i32 @leaf_redefinable() {
; CHECK-LABEL: define {{[^@]+}}@leaf_redefinable() {
; CHECK-NEXT:    ret i32 1
;
  ret i32 1
}

; Call through a function pointer
define i32 @eval_func1(i32 (i32)* , i32) local_unnamed_addr {
; CHECK-LABEL: define {{[^@]+}}@eval_func1
; CHECK-SAME: (i32 (i32)* nocapture nofree noundef nonnull [[TMP0:%.*]], i32 [[TMP1:%.*]]) local_unnamed_addr {
; CHECK-NEXT:    [[TMP3:%.*]] = tail call i32 [[TMP0]](i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %3 = tail call i32 %0(i32 %1) #2
  ret i32 %3
}

define i32 @eval_func2(i32 (i32)* , i32) local_unnamed_addr null_pointer_is_valid{
; CHECK: Function Attrs: null_pointer_is_valid
; CHECK-LABEL: define {{[^@]+}}@eval_func2
; CHECK-SAME: (i32 (i32)* nocapture nofree noundef [[TMP0:%.*]], i32 [[TMP1:%.*]]) local_unnamed_addr #[[ATTR7:[0-9]+]] {
; CHECK-NEXT:    [[TMP3:%.*]] = tail call i32 [[TMP0]](i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %3 = tail call i32 %0(i32 %1) #2
  ret i32 %3
}

; Call an unknown function in a dead block.
declare void @unknown()
define i32 @call_unknown_in_dead_block() local_unnamed_addr {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@call_unknown_in_dead_block
; CHECK-SAME: () local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    ret i32 0
; CHECK:       Dead:
; CHECK-NEXT:    unreachable
;
  ret i32 0
Dead:
  tail call void @unknown()
  ret i32 1
}

define i1 @test_rec_neg(i1 %c) norecurse {
; TUNIT: Function Attrs: norecurse
; TUNIT-LABEL: define {{[^@]+}}@test_rec_neg
; TUNIT-SAME: (i1 [[C:%.*]]) #[[ATTR8:[0-9]+]] {
; TUNIT-NEXT:    [[RC1:%.*]] = call i1 @rec(i1 noundef true)
; TUNIT-NEXT:    br i1 [[RC1]], label [[T:%.*]], label [[F:%.*]]
; TUNIT:       t:
; TUNIT-NEXT:    [[RC2:%.*]] = call i1 @rec(i1 [[C]])
; TUNIT-NEXT:    ret i1 [[RC2]]
; TUNIT:       f:
; TUNIT-NEXT:    ret i1 [[RC1]]
;
; CGSCC: Function Attrs: norecurse
; CGSCC-LABEL: define {{[^@]+}}@test_rec_neg
; CGSCC-SAME: (i1 [[C:%.*]]) #[[ATTR8:[0-9]+]] {
; CGSCC-NEXT:    [[RC1:%.*]] = call noundef i1 @rec(i1 noundef true)
; CGSCC-NEXT:    br i1 [[RC1]], label [[T:%.*]], label [[F:%.*]]
; CGSCC:       t:
; CGSCC-NEXT:    [[RC2:%.*]] = call noundef i1 @rec(i1 noundef [[C]])
; CGSCC-NEXT:    ret i1 [[RC2]]
; CGSCC:       f:
; CGSCC-NEXT:    ret i1 [[RC1]]
;
  %rc1 = call i1 @rec(i1 true)
  br i1 %rc1, label %t, label %f
t:
  %rc2 = call i1 @rec(i1 %c)
  ret i1 %rc2
f:
  ret i1 %rc1
}

define internal i1 @rec(i1 %c1) {
; CHECK-LABEL: define {{[^@]+}}@rec
; CHECK-SAME: (i1 noundef [[C1:%.*]]) {
; CHECK-NEXT:    br i1 [[C1]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    ret i1 true
; CHECK:       f:
; CHECK-NEXT:    [[R:%.*]] = call i1 @rec(i1 noundef true)
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret i1 false
;
  br i1 %c1, label %t, label %f
t:
  ret i1 true
f:
  %r = call i1 @rec(i1 true)
  call void @unknown()
  ret i1 false
}

;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR2]] = { nosync memory(none) }
; TUNIT: attributes #[[ATTR3:[0-9]+]] = { memory(none) }
; TUNIT: attributes #[[ATTR4]] = { nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR5:[0-9]+]] = { nocallback nofree nounwind willreturn memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR6]] = { norecurse nosync memory(none) }
; TUNIT: attributes #[[ATTR7]] = { null_pointer_is_valid }
; TUNIT: attributes #[[ATTR8]] = { norecurse }
; TUNIT: attributes #[[ATTR9]] = { willreturn }
; TUNIT: attributes #[[ATTR10]] = { nosync }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nosync memory(none) }
; CGSCC: attributes #[[ATTR3:[0-9]+]] = { memory(none) }
; CGSCC: attributes #[[ATTR4]] = { nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR5:[0-9]+]] = { nocallback nofree nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR6]] = { norecurse nosync memory(none) }
; CGSCC: attributes #[[ATTR7]] = { null_pointer_is_valid }
; CGSCC: attributes #[[ATTR8]] = { norecurse }
; CGSCC: attributes #[[ATTR9]] = { willreturn }
;.
