; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=loop-deletion -verify-dom-info -S | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64"

; loop1 contains an irreducible cycle, which may loop infinitely. Do not remove
; the loop.
define void @irreducible_subloop_no_mustprogress(i1 %c1, i1 %c2, i1 %c3) {
; CHECK-LABEL: @irreducible_subloop_no_mustprogress(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP1:%.*]]
; CHECK:       loop1:
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[LOOP1_BB1:%.*]], label [[IRR_BB1:%.*]]
; CHECK:       loop1.bb1:
; CHECK-NEXT:    br label [[IRR_BB2:%.*]]
; CHECK:       irr.bb1:
; CHECK-NEXT:    br i1 [[C2:%.*]], label [[LOOP1_LATCH:%.*]], label [[IRR_BB2]]
; CHECK:       irr.bb2:
; CHECK-NEXT:    br i1 [[C3:%.*]], label [[LOOP1_LATCH]], label [[IRR_BB1]]
; CHECK:       loop1.latch:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop1

loop1:
  br i1 %c1, label %loop1.bb1, label %irr.bb1

loop1.bb1:
  br label %irr.bb2

irr.bb1:
  br i1 %c2, label %loop1.latch, label %irr.bb2

irr.bb2:
  br i1 %c3, label %loop1.latch, label %irr.bb1

loop1.latch:
  br i1 false, label %loop1, label %exit

exit:
  ret void
}

define void @irreducible_subloop_with_mustprogress(i1 %c1, i1 %c2, i1 %c3) mustprogress {
; CHECK-LABEL: @irreducible_subloop_with_mustprogress(
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
  br label %loop1

loop1:
  br i1 %c1, label %loop1.bb1, label %irr.bb1

loop1.bb1:
  br label %irr.bb2

irr.bb1:
  br i1 %c2, label %loop1.latch, label %irr.bb2

irr.bb2:
  br i1 %c3, label %loop1.latch, label %irr.bb1

loop1.latch:
  br i1 false, label %loop1, label %exit

exit:
  ret void
}
