#!/usr/bin/perl

use strict;
my $config_file = "$ENV{SCRIPT_OUTPUT_FILE_0}";

# Define the tests we need to run during this configuration
my @config_tests = (
	{
		NAME => "HAVE_64_BIT_MACH_EXCEPTIONS",
		TEST => "-e '$ENV{SDKROOT}/usr/include/mach/mach_exc.defs'",
		COMMENT => "// Defined if we can use 64 bit mach exceptions",
		FAIL => "#undef HAVE_64_BIT_MACH_EXCEPTIONS\
#define mach_exception_data_t exception_data_t\
#define mach_exception_data_type_t exception_data_type_t\
#define mach_exc_server exc_server\
#define MACH_EXCEPTION_CODES 0\n",
		SUCCESS => "#define HAVE_64_BIT_MACH_EXCEPTIONS 1\n",
	}
);

#----------------------------------------------------------------------
# Open the config file
#----------------------------------------------------------------------
open(CONFIG, "> $config_file") || die "Couldn't open '$config_file' for writing: $!\n";
print CONFIG "//" . "-" x 72 . "\n";
print CONFIG "// This file is auto generated by a dbgnub-config.pl, do not edit by hand!\n";
print CONFIG "//" . "-" x 72 . "\n";
print CONFIG "// COMMAND LINE\n";
print CONFIG "//	" . join(' ', @ARGV) . "\n";
print CONFIG "//" . "-" x 72 . "\n";
print CONFIG "// ENVIRONMENT\n";
my $key;
my $val;
while (($key, $val) = each %ENV) 
{
	$val =~ s/\n/\n\/\/	/g;
	printf CONFIG "//	%s = %s\n", $key, $val;
}
print CONFIG "//" . "-" x 72 . "\n";
print CONFIG "// SETTINGS\n";
print CONFIG "//	config_file: '$config_file'\n";
print CONFIG "//" . "-" x 72 . "\n";
print CONFIG "\n\n";
print CONFIG "#ifndef __DBGNUB_CONFIG__\n";
print CONFIG "#define __DBGNUB_CONFIG__\n";


#----------------------------------------------------------------------
# Run the tests
#----------------------------------------------------------------------
foreach my $test_href (@config_tests)
{
	if (exists $test_href->{COMMENT}) {
		print CONFIG "\n$test_href->{COMMENT}\n";
	} else {
		print CONFIG "\n// $test_href->{NAME}\n";
	}
	
	my $test_result = eval "$test_href->{TEST}";
	if ($test_result != 0)
	{
		print CONFIG "$test_href->{SUCCESS}\n";		
	}
	else
	{
		print CONFIG "$test_href->{FAIL}\n";		
	}
}

print CONFIG "#endif // #ifndef __DBGNUB_CONFIG__\n";
close(CONFIG);

