/*********************************************************************
* File:        sidl_string_fStub.c
* Copyright:   (C) 2001-2004 Lawrence Livermore National Security, LLC
* Description: FORTRAN API for arrays of string
* Revision:    $Revision: 6313 $
*
* AUTOMATICALLY GENERATED BY genfortranarrays.py
**********************************************************************/

#include "sidl_header.h"
#ifndef included_babel_config_h
#include "babel_config.h"
#endif
#include "sidlfortran.h"
#ifndef included_sidlType_h
#include "sidlType.h"
#endif
#ifndef included_sidlArray_h
#include "sidlArray.h"
#endif
#ifndef FORTRAN90_DISABLED
#include "sidlf90array.h"
#endif
#include <stdlib.h>
#include <stddef.h>


#ifndef FORTRAN90_DISABLED
/*---------------------------------------------------------------------*
 * Fortran 03 Array Routines
 *---------------------------------------------------------------------*/

#include "sidl_string_fAbbrev.h"

void
SIDLFortran90Symbol(sidl_string__array_createcol_m,
                    SIDL_STRING__ARRAY_CREATECOL_M,
                    sidl_string__array_createCol_m)
  (int32_t *dimen, int32_t lower[], int32_t upper[], int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_createCol(*dimen, lower, upper);
}


void
SIDLFortran90Symbol(sidl_string__array_createrow_m,
                    SIDL_STRING__ARRAY_CREATEROW_M,
                    sidl_string__array_createRow_m)
  (int32_t *dimen, int32_t lower[], int32_t upper[], int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_createRow(*dimen, lower, upper);
}


void
SIDLFortran90Symbol(sidl_string__array_create1d_m,
                    SIDL_STRING__ARRAY_CREATE1D_M,
                    sidl_string__array_create1d_m)
  (int32_t *len, int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_create1d(*len);
}


void
SIDLFortran90Symbol(sidl_string__array_create2drow_m,
                    SIDL_STRING__ARRAY_CREATE2DROW_M,
                    sidl_string__array_create2dRow_m)
  (int32_t *m, int32_t *n, int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_create2dRow(*m, *n);
}


void
SIDLFortran90Symbol(sidl_string__array_create2dcol_m,
                    SIDL_STRING__ARRAY_CREATE2DCOL_M,
                    sidl_string__array_create2dCol_m)
  (int32_t *m, int32_t *n, int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_create2dCol(*m, *n);
}


void
SIDLFortran90Symbol(sidl_string__array_copy_m,
                    SIDL_STRING__ARRAY_COPY_M,
                    sidl_string__array_copy_m)
  (int64_t *src, int64_t *dest)
{
  sidl_string__array_copy((struct sidl_string__array*)(ptrdiff_t)*src,
                      (struct sidl_string__array*)(ptrdiff_t)*dest);
}


void
SIDLFortran90Symbol(sidl_string__array_ensure_m,
                    SIDL_STRING__ARRAY_ENSURE_M,
                    sidl_string__array_ensure_m)
  (int64_t *src, int32_t *dimen, int32_t *ordering, int64_t *result)
{
  *result = (ptrdiff_t)
     sidl_string__array_ensure((struct sidl_string__array*)(ptrdiff_t)*src,
                           *dimen, (int)*ordering);
}


void
SIDLFortran90Symbol(sidl_string__array_smartcopy_m,
                    SIDL_STRING__ARRAY_SMARTCOPY_M,
                    sidl_string__array_smartCopy_m)
  (int64_t *src, int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_smartCopy((struct sidl_string__array*)(ptrdiff_t)*src);
}


void
SIDLFortran90Symbol(sidl_string__array_slice_m,
                    SIDL_STRING__ARRAY_SLICE_M,
                    sidl_string__array_slice_m)
  (int64_t *src, int32_t *dimen, int32_t numElem[], int32_t srcStart[],
   int32_t srcStride[], int32_t newStart[], int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_slice((struct sidl_string__array *)(ptrdiff_t)*src,
                         *dimen, numElem, srcStart, srcStride, newStart);
}


void
SIDLFortran90Symbol(sidl_string__array_cast_m,
                    SIDL_STRING__ARRAY_CAST_M,
                    sidl_string__array_cast_m)
  (int64_t *array, int64_t *result)
{
  *result = (ptrdiff_t)
    sidl_string__array_cast((struct sidl__array *)(ptrdiff_t)*array);
}


void
SIDLFortran90Symbol(sidl_string__array_iscolumnorder_m,
                    SIDL_STRING__ARRAY_ISCOLUMNORDER_M,
                    sidl_string__array_isColumnOrder_m)
  (int64_t *array, SIDL_F90_Bool *result)
{
  *result = (
    sidl_string__array_isColumnOrder((struct sidl_string__array *)(ptrdiff_t)*array)
    ? SIDL_F90_TRUE : SIDL_F90_FALSE);
}

void
SIDLFortran90Symbol(sidl_string__array_isroworder_m,
                    SIDL_STRING__ARRAY_ISROWORDER_M,
                    sidl_string__array_isRowOrder_m)
  (int64_t *array, SIDL_F90_Bool *result)
{
  *result = (
    sidl_string__array_isRowOrder((struct sidl_string__array *)(ptrdiff_t)*array)
    ? SIDL_F90_TRUE : SIDL_F90_FALSE);
}


void
SIDLFortran90Symbol(sidl_string__array_dimen_m,
                    SIDL_STRING__ARRAY_DIMEN_M,
                    sidl_string__array_dimen_m)
  (int64_t *array, int32_t *result)
{
  *result =
    sidl_string__array_dimen((struct sidl_string__array *)(ptrdiff_t)*array);
}


void
SIDLFortran90Symbol(sidl_string__array_stride_m,
                    SIDL_STRING__ARRAY_STRIDE_M,
                    sidl_string__array_stride_m)
  (int64_t *array, int32_t *index, int32_t *result)
{
  *result =
    sidl_string__array_stride((struct sidl_string__array *)(ptrdiff_t)*array, *index);
}


void
SIDLFortran90Symbol(sidl_string__array_lower_m,
                    SIDL_STRING__ARRAY_LOWER_M,
                    sidl_string__array_lower_m)
  (int64_t *array, int32_t*ind, int32_t *result)
{
  *result =
    sidl_string__array_lower((struct sidl_string__array *)(ptrdiff_t)*array, *ind);
}


void
SIDLFortran90Symbol(sidl_string__array_upper_m,
                    SIDL_STRING__ARRAY_UPPER_M,
                    sidl_string__array_upper_m)
  (int64_t *array, int32_t *ind, int32_t *result)
{
  *result =
    sidl_string__array_upper((struct sidl_string__array *)(ptrdiff_t)*array, *ind);
}

void
SIDLFortran90Symbol(sidl_string__array_length_m,
                    SIDL_STRING__ARRAY_LENGTH_M,
                    sidl_string__array_length_m)
  (int64_t *array, int32_t *ind, int32_t *result)
{
  *result =
    sidl_string__array_length((struct sidl_string__array *)(ptrdiff_t)*array, *ind);
}

void
SIDLFortran90Symbol(sidl_string__array_deleteref_m,
                    SIDL_STRING__ARRAY_DELETEREF_M,
                    sidl_string__array_deleteRef_m)
  (int64_t *array)
{
  sidl_string__array_deleteRef((struct sidl_string__array*)(ptrdiff_t)*array);
}


void
SIDLFortran90Symbol(sidl_string__array_addref_m,
                    SIDL_STRING__ARRAY_ADDREF_M,
                    sidl_string__array_addRef_m)
  (int64_t *array)
{
  sidl_string__array_addRef((struct sidl_string__array*)(ptrdiff_t)*array);
}


void
SIDLFortran90Symbol(sidl_string__array_get1_m,
                    SIDL_STRING__ARRAY_GET1_M,
                    sidl_string__array_get1_m)
  (int64_t *array,   int32_t *i1,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get1((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set1_m,
                    SIDL_STRING__ARRAY_SET1_M,
                    sidl_string__array_set1_m)
  (int64_t *array,
   int32_t *i1,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set1((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get2_m,
                    SIDL_STRING__ARRAY_GET2_M,
                    sidl_string__array_get2_m)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get2((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1,
     *i2);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set2_m,
                    SIDL_STRING__ARRAY_SET2_M,
                    sidl_string__array_set2_m)
  (int64_t *array,
   int32_t *i1,
   int32_t *i2,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set2((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   *i2,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get3_m,
                    SIDL_STRING__ARRAY_GET3_M,
                    sidl_string__array_get3_m)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get3((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1,
     *i2,
     *i3);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set3_m,
                    SIDL_STRING__ARRAY_SET3_M,
                    sidl_string__array_set3_m)
  (int64_t *array,
   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set3((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   *i2,
   *i3,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get4_m,
                    SIDL_STRING__ARRAY_GET4_M,
                    sidl_string__array_get4_m)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get4((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1,
     *i2,
     *i3,
     *i4);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set4_m,
                    SIDL_STRING__ARRAY_SET4_M,
                    sidl_string__array_set4_m)
  (int64_t *array,
   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set4((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   *i2,
   *i3,
   *i4,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get5_m,
                    SIDL_STRING__ARRAY_GET5_M,
                    sidl_string__array_get5_m)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get5((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1,
     *i2,
     *i3,
     *i4,
     *i5);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set5_m,
                    SIDL_STRING__ARRAY_SET5_M,
                    sidl_string__array_set5_m)
  (int64_t *array,
   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set5((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   *i2,
   *i3,
   *i4,
   *i5,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get6_m,
                    SIDL_STRING__ARRAY_GET6_M,
                    sidl_string__array_get6_m)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get6((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1,
     *i2,
     *i3,
     *i4,
     *i5,
     *i6);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set6_m,
                    SIDL_STRING__ARRAY_SET6_M,
                    sidl_string__array_set6_m)
  (int64_t *array,
   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set6((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   *i2,
   *i3,
   *i4,
   *i5,
   *i6,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get7_m,
                    SIDL_STRING__ARRAY_GET7_M,
                    sidl_string__array_get7_m)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   int32_t *i7,
   SIDL_F90_String result
   SIDL_F90_STR_NEAR_LEN_DECL(result)
   SIDL_F90_STR_FAR_LEN_DECL(result))
{
  char *tmp =
    sidl_string__array_get7((struct sidl_string__array *)(ptrdiff_t)
	                     *array,
     *i1,
     *i2,
     *i3,
     *i4,
     *i5,
     *i6,
     *i7);
  sidl_copy_c_str(
    SIDL_F90_STR(result),
    (size_t)SIDL_F90_STR_LEN(result),
    tmp);
  free((void *)tmp);
}


void
SIDLFortran90Symbol(sidl_string__array_set7_m,
                    SIDL_STRING__ARRAY_SET7_M,
                    sidl_string__array_set7_m)
  (int64_t *array,
   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   int32_t *i7,
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set7((struct sidl_string__array *)(ptrdiff_t)
                           *array,
   *i1,
   *i2,
   *i3,
   *i4,
   *i5,
   *i6,
   *i7,
   tmp);
  free(tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_get_m,
                    SIDL_STRING__ARRAY_GET_M,
                    sidl_string__array_get_m)
  (int64_t *array, int32_t indices[], SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp =
     sidl_string__array_get((struct sidl_string__array *)(ptrdiff_t)
                            *array, indices);
  sidl_copy_c_str(
    SIDL_F90_STR(value),
    (size_t)SIDL_F90_STR_LEN(value),
    tmp);
  free((void *)tmp);
}

void
SIDLFortran90Symbol(sidl_string__array_set_m,
                    SIDL_STRING__ARRAY_SET_M,
                    sidl_string__array_set_m)
  (int64_t *array, int32_t indices[], 
   SIDL_F90_String value
   SIDL_F90_STR_NEAR_LEN_DECL(value)
   SIDL_F90_STR_FAR_LEN_DECL(value))
{
  char *tmp = sidl_copy_fortran_str(SIDL_F90_STR(value),
                                    (ptrdiff_t)SIDL_F90_STR_LEN(value));
  sidl_string__array_set((struct sidl_string__array *)(ptrdiff_t)
                     *array, indices, tmp);
  free(tmp);
}


#endif /* not FORTRAN90_DISABLED */
