//
// BAGEL - Parallel electron correlation program.
// Filename: _spin2root_10.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root10(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[10] = {1.340082713899064e+00,4.503706126056571e-01,2.697407534140551e+00,4.553249915846232e+00,6.954922092313122e+00,
    9.974440034780212e+00,1.372484212198560e+01,1.839665897662831e+01,2.435750272470101e+01,3.255052327310024e+01};
  constexpr double aw[10] = {2.273449385490049e-01,6.387885277410635e-02,2.388428294200524e-01,1.084346993907713e-01,2.358474554503382e-02,
    2.465933306103423e-03,1.160704546409024e-04,2.113813713699647e-06,1.082930556661453e-08,6.836071644043847e-12};
  constexpr double x[3840] = {  7.555984559787694e-02, -1.583239661708848e-03,  2.389673719445496e-05, -3.022438277992729e-07,  3.278986460779753e-09,
 -2.942771602154609e-11,  1.840930028913957e-13,  6.823566184497278e-17, -2.605678585643053e-17,  5.291559991680125e-19, -7.335821500927974e-21,  7.719971192632835e-23,
  2.182247086262226e-01, -4.246532713052913e-03,  5.448814136322435e-05, -4.913581380015317e-07,  2.108347118114710e-09,  2.522896635975888e-11, -7.134546777791536e-13,
  8.724302561362886e-15, -4.479443376111848e-17, -5.966511039340738e-19,  1.835479168022670e-20, -2.368258713148873e-22,  4.197157301916614e-01, -7.275370265970495e-03,
  6.987762305612993e-05, -2.131588712203657e-07, -5.251135816457380e-09,  9.378929654682378e-11, -4.243414341471709e-13, -9.549475067154340e-15,  2.018594475535047e-16,
 -1.066353956029133e-18, -2.266909365390395e-20,  5.258740221200800e-22,  6.657529224043459e-01, -9.795809365048310e-03,  5.499360815166150e-05,  4.274657812570767e-07,
 -9.501203077061169e-09,  9.356299789662259e-12,  1.448047259392264e-12, -1.305375786621765e-14, -1.612051909353711e-16,  3.844956704316172e-18, -1.453791213769618e-22,
 -7.865799830803340e-22,  9.383957997000110e-01, -1.105215006375370e-02,  1.242961102004636e-05,  8.922112238382850e-07, -2.904568619170873e-09, -1.269444467116020e-10,
  6.964185680681647e-13,  2.162996715168905e-14, -1.726185351293191e-16, -3.988547891147867e-18,  4.311065303268254e-20,  7.655192700105326e-22,  1.217107699426978e+00,
 -1.063719082205083e-02, -3.765489531531174e-05,  7.308691891538828e-07,  7.639894201646267e-09, -7.478868916794249e-11, -1.615362442126415e-12,  5.988448658517192e-15,
  3.370934700160161e-16,  4.356905224771456e-19, -6.775611672372559e-20, -4.292252456617630e-22,  1.480136117147673e+00, -8.641009965175576e-03, -6.925003271322089e-05,
  7.466189974930941e-08,  8.934565152053788e-09,  7.970176911842974e-11, -6.089701068393783e-13, -2.050384203201733e-14, -1.136631169472754e-16,  2.698118706951820e-18,
  5.349593676050073e-20,  5.934808019980722e-23,  1.706199884510670e+00, -5.658419709389700e-03, -6.743277589652687e-05, -4.678228664063305e-07,  8.189147598168281e-10,
  7.508461331804687e-11,  1.043548018759884e-12,  4.469966563297878e-15, -1.072314862888055e-16, -2.591509469258629e-18, -2.375788889747654e-20,  9.199024979052485e-23,
  1.876388019128356e+00, -2.628442991368010e-03, -3.914233501648973e-05, -4.643778744904673e-07, -4.275350256388932e-09, -2.339095333503078e-11,  1.236201170322862e-13,
  5.806100005216897e-15,  9.750798598678507e-17,  1.063293446402752e-18,  5.880025147407144e-21, -5.767401078290086e-23,  1.976097945868759e+00, -5.364912093727891e-04,
 -8.932219284300560e-06, -1.299103542662636e-07, -1.733535046439988e-09, -2.157279481555630e-11, -2.514211543229617e-13, -2.724694212429755e-15, -2.692927946452164e-17,
 -2.307050466968359e-19, -1.458597783692649e-21, -5.626435641137895e-25,  6.958746633412785e-02, -1.405724756996474e-03,  2.056594742581891e-05, -2.542492604719029e-07,
  2.734350095258332e-09, -2.506504494644539e-11,  1.768264250037588e-13, -5.112324473896413e-16, -1.153955486439281e-17,  2.960968954582638e-19, -4.498395766983185e-21,
  5.240920270414069e-23,  2.020738978553023e-01, -3.833606598946066e-03,  4.880810197551614e-05, -4.544383614807162e-07,  2.460579585115344e-09,  1.086017791239555e-11,
 -4.915735086440608e-13,  7.069653826399286e-15, -5.539581783227120e-17, -5.139675069314065e-20,  9.430043827898188e-21, -1.660103025077002e-22,  3.917142575225979e-01,
 -6.727870651325920e-03,  6.687549819328419e-05, -2.828023840702580e-07, -3.495247544973132e-09,  8.108574083328316e-11, -6.080648987134686e-13, -3.836930007653917e-15,
  1.522625613287456e-16, -1.562384596110449e-18, -3.554887651800099e-21,  3.331377789441778e-22,  6.274784550192228e-01, -9.337900634049894e-03,  5.922301249053919e-05,
  2.786986595138944e-07, -8.998626736216399e-09,  3.926675171706205e-11,  1.030762059804955e-12, -1.606004307783754e-14, -3.024344803571814e-17,  3.257827501164066e-18,
 -2.621533494473107e-20, -3.802640926029456e-22,  8.944525201412686e-01, -1.091086316381979e-02,  2.277699761104445e-05,  8.265282611016790e-07, -5.231001177364969e-09,
 -1.037062497456962e-10,  1.205843549207318e-12,  1.419732347694368e-14, -2.786129146729297e-16, -1.765439187268851e-18,  6.335687938662126e-20,  1.289787659861638e-22,
  1.174014770926958e+00, -1.090139720425793e-02, -2.820701044154524e-05,  8.391138096268513e-07,  5.776305899610415e-09, -1.103312488457778e-10, -1.298196113513358e-12,
  1.647813025019262e-14,  3.012543626951934e-16, -2.449409608739511e-18, -7.103778275131310e-20,  3.133746258512915e-22,  1.444473333952222e+00, -9.188881261164312e-03,
 -6.744688912946632e-05,  2.293718313544583e-07,  1.033425537283339e-08,  5.789065113622223e-11, -1.216471032949453e-12, -2.217882865996389e-14,  2.107287197160230e-17,
  4.716741841893212e-18,  4.266242482018229e-20, -5.915308009808701e-22,  1.682452203009683e+00, -6.219991520876807e-03, -7.291397374042312e-05, -4.413114935722950e-07,
  2.578803748119117e-09,  1.011514681824688e-10,  1.105409400798471e-12, -6.236463757417717e-16, -2.157243988290926e-16, -3.355307198082731e-18, -1.140994835648739e-20,
  5.063045995090811e-22,  1.865210990160601e+00, -2.965068909881320e-03, -4.514005167561785e-05, -5.363027452784438e-07, -4.698354540456332e-09, -1.808380227249214e-11,
  3.359132308430816e-13,  9.577025242898038e-15,  1.390619407723655e-16,  1.208051676114619e-18,  1.631833182484432e-22, -2.226740292079869e-22,  1.973798480577392e+00,
 -6.146912391217354e-04, -1.067293826201423e-05, -1.614542085841965e-07, -2.232048905767233e-09, -2.862785041573568e-11, -3.411050730018763e-13, -3.730422524899886e-15,
 -3.625862261128431e-17, -2.857902728310209e-19, -1.173376018049301e-21,  1.647812501854831e-23,  6.427530113571973e-02, -1.252694026470100e-03,  1.776164304136223e-05,
 -2.142849873454590e-07,  2.274150025311647e-09, -2.102599943841939e-11,  1.587213454614092e-13, -7.405395012392135e-16, -3.619837419989663e-18,  1.561475974393083e-19,
 -2.639299759941662e-21,  3.315705814560641e-23,  1.874868255459268e-01, -3.464272884488023e-03,  4.359632380801552e-05, -4.139087712185229e-07,  2.574805393815683e-09,
  1.238069548960383e-12, -3.182760093310050e-13,  5.327193374705461e-15, -5.202045480084517e-17,  2.010956479358638e-19,  3.697661595048611e-21, -9.718414491135576e-23,
  3.658501035627303e-01, -6.207273932192634e-03,  6.319719652010918e-05, -3.265728348961951e-07, -2.025547001071595e-09,  6.570124647565646e-11, -6.557884124442507e-13,
  1.331413960089966e-16,  9.644143745705195e-17, -1.471086081337332e-18,  6.721418310469768e-21,  1.420804305147314e-22,  5.910922350695379e-01, -8.853118969325188e-03,
  6.173337861784007e-05,  1.421938779086989e-07, -8.002466869277514e-09,  5.859996782973556e-11,  5.835676155797837e-13, -1.537895848636392e-14,  6.526015888543018e-17,
  1.997117245040975e-18, -3.399451201800337e-20,  5.287670313076425e-24,  8.512341126607292e-01, -1.069054348099044e-02,  3.213013236402636e-05,  7.279281157209697e-07,
 -6.988916167797776e-09, -7.104434705610593e-11,  1.472489849710508e-12,  4.753484223554618e-15, -2.969258725706801e-16,  6.938077988108141e-19,  5.532899245160081e-20,
 -4.532575398634543e-22,  1.130023626775103e+00, -1.108538251731660e-02, -1.766094840893250e-05,  9.123640977312938e-07,  3.300701840202282e-09, -1.349621280438726e-10,
 -7.187884216062550e-13,  2.419973364156501e-14,  1.673280591032454e-16, -4.790368402588712e-18, -4.092484850128465e-20,  1.003472620820995e-21,  1.406660161062452e+00,
 -9.714558956372046e-03, -6.366983820016558e-05,  4.021884850792309e-07,  1.115091148657605e-08,  2.148662916458309e-11, -1.800521802988666e-12, -1.852230567987141e-14,
  2.133350066035998e-16,  5.686307126635568e-18,  7.321927154444993e-22, -1.280145917420416e-21,  1.656373278328294e+00, -6.823621804123789e-03, -7.789077045516358e-05,
 -3.824463666755334e-07,  4.861204378911760e-09,  1.265781847211230e-10,  9.728154517101647e-13, -9.494338419139320e-15, -3.378832003624353e-16, -3.202316418505703e-18,
  2.326309883027673e-20,  1.078109254995140e-21,  1.852585878460105e+00, -3.353233957846963e-03, -5.203697105513499e-05, -6.138310645732412e-07, -4.954923007901124e-09,
 -6.261483819556760e-12,  6.727834172716078e-13,  1.470035520896964e-14,  1.795965321903965e-16,  9.380934135423508e-19, -1.596070557895373e-20, -5.387775414185834e-22,
  1.971155759744716e+00, -7.084782550341193e-04, -1.284510365469188e-05, -2.022302452026401e-07, -2.895650708796460e-09, -3.820869031535705e-11, -4.634010536529634e-13,
 -5.062375718080066e-15, -4.712627081471640e-17, -3.077236724410110e-19,  4.061282505857154e-22,  6.225973202073131e-23,  5.953325844727645e-02, -1.120298643303402e-03,
  1.539531517690870e-05, -1.810629997505886e-07,  1.889995569657066e-09, -1.747406641541081e-11,  1.370795746913950e-13, -7.842192523157286e-16,  4.130708648269718e-19,
  7.547440433814419e-20, -1.490083339783860e-21,  1.998941325677225e-23,  1.742968062230314e-01, -3.134670144180231e-03,  3.887620322766846e-05, -3.728814008986225e-07,
  2.534321948401879e-09, -4.791202474046719e-12, -1.911714674987213e-13,  3.799537769775289e-15, -4.300107243510449e-17,  2.794424536822992e-19,  5.753954116427774e-22,
 -4.832306666697319e-23,  3.420066903350241e-01, -5.717828465177321e-03,  5.912448000148138e-05, -3.493176003681555e-07, -8.670070940616784e-10,  5.030896653986196e-11,
 -6.163885225985733e-13,  2.433404118622875e-15,  4.943365028287876e-17, -1.119510136564023e-18,  9.942346669036786e-21,  1.638156555233176e-23,  5.566753498371207e-01,
 -8.354509996247070e-03,  6.271222115655984e-05,  2.414997226610438e-08, -6.723823140558002e-09,  6.773139401875818e-11,  1.911575724662477e-13, -1.239741205994914e-14,
  1.134600931094772e-16,  7.187022580808755e-19, -2.837933302430004e-20,  2.178451374493105e-22,  8.090385331714097e-01, -1.040055822251704e-02,  4.015374240690868e-05,
  6.066848616282562e-07, -8.051023519812353e-09, -3.514384414667707e-11,  1.479106274383503e-12, -3.966863978878606e-15, -2.378714628735355e-16,  2.409068726413206e-18,
  2.870379226154300e-20, -6.908683133390201e-22,  1.085469851975783e+00, -1.118218888840193e-02, -6.487171981598063e-06,  9.428832200075445e-07,  4.862520391516133e-10,
 -1.436452515865865e-10,  6.124136539797475e-15,  2.657225319088992e-14, -2.296045953320766e-17, -5.444600108364477e-18,  9.518535238361601e-21,  1.180677158771074e-21,
  1.366818078954100e+00, -1.020156297181686e-02, -5.776695624977817e-05,  5.815329971995288e-07,  1.111129121972609e-08, -2.699149357110602e-11, -2.193434231689558e-12,
 -8.532361991476931e-15,  4.039005298888329e-16,  4.478936234110986e-18, -6.249448236183018e-20, -1.463931551674467e-21,  1.627805602949088e+00, -7.463583047752902e-03,
 -8.192610315585815e-05, -2.832596849156169e-07,  7.597975530164738e-09,  1.454162425595967e-10,  5.401350957469575e-13, -2.186953242651324e-14, -4.236094106597741e-16,
 -1.177143163705895e-18,  8.087379006164858e-20,  1.462154716494067e-21,  1.838291792777472e+00, -3.800344430600029e-03, -5.987949590305134e-05, -6.930823829573182e-07,
 -4.881875686263344e-09,  1.549957116480735e-11,  1.168745386241390e-12,  2.081058582133882e-14,  1.949922639677178e-16, -3.050563154062429e-19, -4.966829906125494e-20,
 -1.012726913630757e-21,  1.968099761814892e+00, -8.217960083460969e-04, -1.557716355127269e-05, -2.553297104009886e-07, -3.783445458701946e-09, -5.121164794654836e-11,
 -6.278651772885931e-13, -6.737722753585467e-15, -5.702468937959460e-17, -2.105942312107028e-19,  5.251712908422449e-21,  1.734276836115912e-22,  5.528532028714928e-02,
 -1.005338503179967e-03,  1.339302462307685e-05, -1.534475799614617e-07,  1.571651733101482e-09, -1.444402195233716e-11,  1.156420551067812e-13, -7.374829351443142e-16,
  2.243420494188489e-18,  3.068243286308027e-20, -8.110783580976136e-22,  1.151161543123462e-23,  1.623527676552891e-01, -2.840878223628582e-03,  3.464104398282308e-05,
 -3.333146357288853e-07,  2.400470219727519e-09, -8.248802140387264e-12, -1.025259213489051e-13,  2.585357884121107e-15, -3.294767515976135e-17,  2.697332148712681e-19,
 -8.508646490586992e-22, -1.939549131525474e-23,  3.200545814809902e-01, -5.261764321827739e-03,  5.488010646201235e-05, -3.559181177674030e-07, -2.466228349767112e-12,
  3.647753126650421e-11, -5.316172445008351e-13,  3.447223751183957e-15,  1.625800472063673e-17, -7.291211543802306e-19,  9.144334121775150e-21, -4.343609926416447e-23,
  5.242600959364041e-01, -7.853377892147750e-03,  6.240173977949237e-05, -7.245531441633981e-08, -5.349239923070110e-09,  6.858048562527642e-11, -1.026957520477476e-13,
 -8.551512640581855e-15,  1.214319686848456e-16, -2.026049190763588e-19, -1.740608859764763e-20,  2.575654988336163e-22,  7.681217216740824e-01, -1.005243842252371e-02,
  4.664397723227482e-05,  4.741220777026521e-07, -8.411992916812354e-09, -1.751714675650046e-12,  1.275742227079004e-12, -1.002862486508481e-14, -1.377214356659520e-16,
  2.962775601879917e-18, -1.443759210625324e-22, -5.741458657089791e-22,  1.040708861231076e+00, -1.118891265612232e-02,  4.780009485268750e-06,  9.279371982103307e-07,
 -2.326097507081146e-09, -1.348290667791410e-10,  7.114849547833806e-13,  2.287177000959143e-14, -2.003662922794400e-16, -4.118094612812518e-18,  5.348577531115439e-20,
  7.304786536048509e-22,  1.325135941153507e+00, -1.063282266709087e-02, -4.974911069110379e-05,  7.520815423152587e-07,  1.003379353899576e-08, -8.091154163630876e-11,
 -2.231288038612319e-12,  6.371225593790436e-15,  5.058230134666613e-16,  8.365190121803215e-19, -1.142910238790408e-19, -7.352064726999097e-22,  1.596622138777954e+00,
 -8.130297226389615e-03, -8.449819328955433e-05, -1.379571554148663e-07,  1.057834143304549e-08,  1.494858173608040e-10, -2.631844916682919e-13, -3.535431473727033e-14,
 -3.925594618234532e-16,  3.295294426963908e-18,  1.394814732729114e-19,  1.003584566621686e-21,  1.822077839012759e+00, -4.313941727235746e-03, -6.864940679422829e-05,
 -7.669778991228603e-07, -4.240643368747054e-09,  5.122072959093011e-11,  1.833864925953378e-12,  2.639514700769743e-14,  1.361708756866815e-16, -3.327728832283917e-18,
 -1.046800020365532e-19, -1.443766270329340e-21,  1.964542375528409e+00, -9.597817347769944e-04, -1.904096698326253e-05, -3.249453626822968e-07, -4.974735976374395e-09,
 -6.875561436893300e-11, -8.428165073235727e-13, -8.624988368817173e-15, -5.846108626109272e-17,  2.121645977566840e-19,  1.769793893207032e-20,  4.242741078695138e-22,
  5.146716841315054e-02, -9.051533101804158e-04,  1.169346883983411e-05, -1.304682623403122e-07,  1.308898289811195e-09, -1.190747543604958e-11,  9.612419681681336e-14,
 -6.533996538008033e-16,  2.869815190245597e-18,  6.622479648631573e-21, -4.302346042799615e-22,  6.240793745932914e-24,  1.515190838470813e-01, -2.579109339279798e-03,
  3.086589855229740e-05, -2.963380328797647e-07,  2.216172925290261e-09, -9.951180450126733e-12, -4.349155042188022e-14,  1.678484022234978e-15, -2.400741113957502e-17,
  2.237499897254370e-19, -1.342377979610908e-21, -4.736500711278752e-24,  2.998586228032353e-01, -4.839757102392711e-03,  5.063077349623711e-05, -3.507808126770235e-07,
  6.075243378943862e-10,  2.491394213811730e-11, -4.312781575003616e-13,  3.613885004965944e-15, -3.936592280942790e-18, -4.087124142837334e-19,  6.760388485204005e-21,
 -5.963774419772406e-23,  4.938375873764477e-01, -7.358993822489447e-03,  6.106337460735658e-05, -1.472778304712380e-07, -4.019447062122564e-09,  6.367057063733162e-11,
 -2.896659919739837e-13, -4.895292087493800e-15,  1.042252304772507e-16, -6.854711590591685e-19, -7.183776276437464e-21,  1.975344191509852e-22,  7.286910841804796e-01,
 -9.658809167549513e-03,  5.152984375164482e-05,  3.408103050451102e-07, -8.165753364499305e-09,  2.509585472222067e-11,  9.490044918891599e-13, -1.277504634180097e-14,
 -3.654008421729858e-17,  2.531478019393372e-18, -1.929928865184006e-20, -2.860461188218068e-22,  9.960990594079845e-01, -1.110696218328142e-02,  1.560652867750855e-05,
  8.702778694371656e-07, -4.804316916316066e-09, -1.109139359457564e-10,  1.243088960016542e-12,  1.455105937143283e-14, -3.043140979259174e-16, -1.552168603746067e-18,
  6.927292220641472e-20, -2.147050030448232e-23,  1.281869490455483e+00, -1.099212790072080e-02, -3.982346950347423e-05,  8.968603905003478e-07,  7.903955672234627e-09,
 -1.304975428663818e-10, -1.828305020152303e-12,  2.211633320280501e-14,  4.493213104523006e-16, -3.994767793034387e-18, -1.169958398627314e-19,  6.601230279017155e-22,
  1.562742850726202e+00, -8.809804187183782e-03, -8.504158668961002e-05,  5.451053022931391e-08,  1.341798478701810e-08,  1.300206702690160e-10, -1.403075746154804e-12,
 -4.487895591064350e-14, -1.666313519486932e-16,  9.323283265295296e-18,  1.486392501521147e-19, -8.115857789157129e-22,  1.803663886642147e+00, -4.901010706077323e-03,
 -7.821798721711612e-05, -8.239831018623380e-07, -2.714277236702861e-09,  1.044519463659273e-10,  2.609432691105255e-12,  2.790178805842140e-14, -7.447769638422124e-17,
 -8.789373866726763e-18, -1.664635816065204e-19, -1.156280502824843e-21,  1.960371839675743e+00, -1.129172047727657e-03, -2.346705795114327e-05, -4.167268361079093e-07,
 -6.572727193880526e-09, -9.207962579910680e-11, -1.108137979535727e-12, -1.019316493477823e-14, -3.245540756141548e-17,  1.421758029261347e-18,  4.656596061917439e-20,
  9.468505693684818e-22,  4.802421482938400e-02, -8.175293308352246e-04,  1.024603447958533e-05, -1.113117717336631e-07,  1.092390850739012e-09, -9.809546080429607e-12,
  7.912964540279565e-14, -5.605973941121571e-16,  2.855413372620070e-18, -6.069146625345880e-21, -2.234594288726576e-22,  3.634073882279593e-24,  1.416748098699500e-01,
 -2.345818998350182e-03,  2.751588337269898e-05, -2.625136589674939e-07,  2.010099705835736e-09, -1.051075267024073e-11, -6.113852754675680e-15,  1.028512169202260e-15,
 -1.694576421831979e-17,  1.683993904355921e-19, -1.368952724841306e-21,  3.134579818486946e-24,  2.812833062485046e-01, -4.451348762193095e-03,  4.649444060638760e-05,
 -3.376025879567868e-07,  1.010367842028484e-09,  1.575144088659243e-11, -3.337224075497163e-13,  3.299592003189199e-15, -1.440748527829203e-17, -1.896370344329328e-19,
  4.259113661012617e-21, -5.065176942414422e-23,  4.653660137513438e-01, -6.878555330775173e-03,  5.895086106679679e-05, -2.018195476435096e-07, -2.824812951629950e-09,
  5.542625647073019e-11, -3.840552387727583e-13, -1.994854589886404e-15,  7.624546186971775e-17, -8.236689820070967e-19, -3.232112593492272e-22,  1.165429015308799e-22,
  6.909031506205580e-01, -9.232387032022766e-03,  5.485589116129941e-05,  2.152881161629530e-07, -7.465395604550868e-09,  4.352578603838405e-11,  5.874546020133753e-13,
 -1.265457135144862e-14,  3.845618201248420e-17,  1.593912113835511e-18, -2.556136725737946e-20, -9.966219569208172e-24,  9.519850031296541e-01, -1.094180084245535e-02,
  2.552102607332679e-05,  7.774018102617054e-07, -6.697089782428422e-09, -7.732382963967320e-11,  1.509527427575405e-12,  4.439760968511453e-15, -3.123629661189827e-16,
  1.004771672628914e-18,  5.439010014060669e-20, -5.908939481666829e-22,  1.237334720228247e+00, -1.126572917054812e-02, -2.839557488143085e-05,  1.000297738583877e-06,
  4.913092748318117e-09, -1.654843396947733e-10, -1.035360840536459e-12,  3.337165869278189e-14,  2.319431700452355e-16, -7.698804316168785e-18, -5.958409072628804e-20,
  1.830250295045014e-21,  1.526152506863496e+00, -9.483687089025110e-03, -8.302063077908936e-05,  2.877382505961947e-07,  1.557821801255427e-08,  8.101358431658291e-11,
 -2.676323660442729e-12, -4.380832948407339e-14,  2.605387746491878e-16,  1.379468100418478e-17,  5.585962291056804e-20, -3.392334885100840e-21,  1.782744929761405e+00,
 -5.566861917413553e-03, -8.828568952222699e-05, -8.470399582905718e-07,  6.150025346935058e-11,  1.758436755907003e-10,  3.300128788976743e-12,  1.909625134488029e-14,
 -5.189974537984656e-16, -1.598938549148489e-17, -1.771033020723780e-19,  1.121351570248660e-21,  1.955445286442552e+00, -1.338849018247263e-03, -2.916448374055586e-05,
 -5.381666240985565e-07, -8.703742715041727e-09, -1.221547813154449e-10, -1.397288709770617e-12, -9.957726621713054e-15,  6.448231883627323e-17,  4.364897257911508e-18,
  1.076286124127840e-19,  1.914534134959704e-21,  4.490997499587173e-02, -7.406211556063273e-04,  9.009008541831797e-06, -9.530501469345180e-08,  9.139719141864161e-10,
 -8.088726131068089e-12,  6.466876845773571e-14, -4.741392018347704e-16,  2.513865484910137e-18, -1.182808288627716e-20, -5.731992540361104e-23,  4.638909008031811e-24,
  1.327125877761447e-01, -2.137761823647401e-03,  2.455175036419455e-05, -2.320329994544738e-07,  1.800455734530176e-09, -1.036794784010354e-11,  1.593108134101264e-14,
  5.730922219143347e-16, -1.181326965290611e-17,  1.189578497030563e-19, -1.028109316757966e-21,  1.356135332416234e-23,  2.641965806237331e-01, -4.095302074719475e-03,
  4.254927458938781e-05, -3.193212411916375e-07,  1.252494695484465e-09,  8.793435311029182e-12, -2.486035722238958e-13,  2.758248948826986e-15, -1.864125135926624e-17,
 -5.652202639334689e-20,  2.619977636386612e-21, -1.990540901271422e-23,  4.387786900746868e-01, -6.417323210812719e-03,  5.629276281809837e-05, -2.386635425843596e-07,
 -1.811676384872912e-09,  4.578710348338733e-11, -4.101759327275207e-13, -2.296409806808218e-17,  4.743903083623008e-17, -7.505114613334497e-19,  3.682032089956406e-21,
  7.602057805095270e-23,  6.548648847162977e-01, -8.785166110447258e-03,  5.675355719871553e-05,  1.034545934082491e-07, -6.481673234863515e-09,  5.355783531994261e-11,
  2.575888898626774e-13, -1.070012660144914e-14,  7.792104069479141e-17,  6.268781418856817e-19, -2.132794296244859e-20,  1.915908141789150e-22,  9.086825083447123e-01,
 -1.070224356968389e-02,  3.416233747373462e-05,  6.598674950235986e-07, -7.876855677234850e-09, -4.068583107308915e-11,  1.502015637567710e-12, -4.612626980111957e-15,
 -2.439445634555129e-16,  2.596830729554313e-18,  2.461328930990156e-20, -6.734659140509794e-22,  1.191895042905994e+00, -1.144380179793568e-02, -1.603304117775606e-05,
  1.051408996232446e-06,  1.433807339124702e-09, -1.785498622148661e-10, -4.102724006229168e-14,  3.606655247498438e-14, -6.732545522220679e-17, -8.335787156362035e-18,
  2.908384534915445e-20,  2.017900740458852e-21,  1.486917409928689e+00, -1.012970493809349e-02, -7.803118439436383e-05,  5.460678465768869e-07,  1.646366174244153e-08,
  3.470702322531901e-12, -3.710373042639075e-12, -2.742143945708828e-14,  7.562045813357456e-16,  1.250802170779472e-17, -1.287927348381493e-19, -4.529911738221960e-21,
  1.759000948156443e+00, -6.313492642080487e-03, -9.831386875701231e-05, -8.134768293159189e-07,  4.401592563092018e-09,  2.590094123008828e-10,  3.506956771529994e-12,
 -7.916362350131168e-15, -1.198421658828701e-15, -2.074403674154895e-17, -2.183698896795275e-20,  6.423982322962312e-21,  1.949578755474142e+00, -1.600562263394215e-03,
 -3.654481104263985e-05, -6.988817534010123e-07, -1.150282801799275e-08, -1.586229349435363e-10, -1.616602640976052e-12, -4.361227005400385e-15,  3.229815530401742e-16,
  1.075260306178826e-17,  2.222753314024560e-19,  3.347924171239524e-21,  4.208472674799787e-02, -6.728868963694558e-04,  7.948012320139299e-06, -8.189568754401723e-08,
  7.666878356887593e-10, -6.687294435084651e-12,  5.245457064189990e-14, -4.004801164659542e-16,  2.107219388147626e-18, -8.747045529481943e-21,  2.500782637610720e-22,
  9.879400015276544e-24,  1.245374047765838e-01, -1.952011280926880e-03,  2.193343573125874e-05, -2.048590697590870e-07,  1.598015110396822e-09, -9.832052317068161e-12,
  2.728069380142759e-14,  2.571063585236532e-16, -8.082495818848771e-18,  9.480590910023571e-20, -3.986083451489650e-23,  3.254374698299757e-23,  2.484723883838837e-01,
 -3.769883233794357e-03,  3.884248154119439e-05, -2.981735268832098e-07,  1.374600447502235e-09,  3.685130109473219e-12, -1.798914540684420e-13,  2.148516454136467e-15,
 -1.887251527477001e-17,  4.513092463220288e-20,  2.852033986352745e-21,  3.308682473184395e-23,  4.139913347158472e-01, -5.978863602529741e-03,  5.328337243611217e-05,
 -2.608567384767278e-07, -9.936437941131058e-10,  3.608291924109905e-11, -3.933870198413164e-13,  1.097873770914283e-15,  2.390124547237978e-17, -5.327863333486255e-19,
  7.410420698622405e-21,  1.035115484723294e-22,  6.206377602639154e-01, -8.327851741672542e-03,  5.740894226016531e-05,  8.556388095416912e-09, -5.371438369914292e-09,
  5.644191736721101e-11, -4.777239796965863e-15, -7.990793849518710e-15,  8.760873664674161e-17, -9.276896813657173e-21, -9.343086862871329e-21,  3.473026169662134e-22,
  8.664671908398879e-01, -1.039946313071169e-02,  4.130390547549627e-05,  5.292280794349778e-07, -8.344721912619665e-09, -6.977581776145941e-12,  1.278670090420036e-12,
 -1.078636199966876e-14, -1.391337084698414e-16,  3.076325163709692e-18,  2.229695705367373e-21, -2.853653079855361e-22,  1.145943408512627e+00, -1.152147856846326e-02,
 -3.395583835002211e-06,  1.046063970717635e-06, -2.067629665255947e-09, -1.679247068541439e-10,  8.961269924786305e-13,  2.950034069744504e-14, -3.264404544201469e-16,
 -5.556221243415156e-18,  1.048082238882081e-19,  1.331610159899234e-21,  1.445197880464276e+00, -1.072329227842950e-02, -6.991182473582906e-05,  8.049964689980824e-07,
  1.559613238231532e-08, -9.168620265990187e-11, -4.080948345342978e-12,  2.619268581388619e-15,  1.069379887389683e-15,  3.831076107257926e-18, -2.860716924830961e-19,
 -1.935088057906331e-21,  1.732114377273003e+00, -7.137430562890405e-03, -1.074676910016774e-04, -6.971988720733555e-07,  1.038020042445372e-08,  3.355028144088858e-10,
  2.638724611833921e-12, -5.771097937714170e-14, -1.874691227297632e-15, -1.398037495795597e-17,  4.074815330499331e-19,  1.280832603815272e-20,  1.942533922083023e+00,
 -1.929850750694000e-03, -4.614723477751131e-05, -9.104299854719630e-07, -1.506536113452190e-08, -1.972922358865567e-10, -1.521799856013787e-12,  1.419701556798931e-14,
  9.093820565905517e-16,  2.298960533124019e-17,  3.973421830707793e-19,  4.360013532508514e-21,  3.951440483154638e-02, -6.130349903934542e-04,  7.034663961910768e-06,
 -7.063392687415266e-08,  6.446612251755747e-10, -5.555525217531887e-12,  4.215704562345318e-14, -3.351991458851570e-16,  2.093157211784317e-18,  1.164466711846102e-20,
  8.015093115712752e-22,  1.401146766060147e-23,  1.170653195732248e-01, -1.785957073754741e-03,  1.962216793497992e-05, -1.808264196276447e-07,  1.408367087360182e-09,
 -9.116935612245205e-12,  3.138758750345509e-14,  5.592063462586186e-17, -4.300520508205510e-18,  1.274079374532822e-19,  1.774768219587299e-21,  4.615148268835444e-23,
  2.339922073950824e-01, -3.473077645422798e-03,  3.539808617638184e-05, -2.758056236206904e-07,  1.409658764270506e-09,  2.377086559670787e-14, -1.277653459964333e-13,
  1.596426818067013e-15, -1.469834798211488e-17,  2.037931157755127e-19,  5.391912689054900e-21,  7.409781401754028e-23,  3.909082757752467e-01, -5.565336446854204e-03,
  5.007988667981418e-05, -2.714829471228419e-07, -3.635286456594688e-10,  2.708150389897388e-11, -3.543581732523051e-13,  1.622874092452805e-15,  1.129335880902580e-17,
 -1.304248086910663e-19,  1.299751426856833e-20,  1.401710250403951e-22,  5.882435966521304e-01, -7.869545131560671e-03,  5.703299813576681e-05, -6.843254458510177e-08,
 -4.260240648275577e-09,  5.395704261817987e-11, -1.896516307292505e-13, -5.232812857639318e-15,  8.453727140967832e-17, -4.556440936201773e-20,  8.048743623083737e-21,
  4.144606612931468e-22,  8.255672167683556e-01, -1.004589901849245e-02,  4.685404552452546e-05,  3.961530768064884e-07, -8.204021288619355e-09,  1.968568982535600e-11,
  9.309965427129506e-13, -1.346448028979941e-14, -2.835838696084233e-17,  3.072417830283873e-18,  1.275159515424203e-21,  2.113242830474861e-22,  1.099881546420639e+00,
 -1.149924091663134e-02,  8.852357985862404e-06,  9.875400364588420e-07, -5.150917745481416e-09, -1.378393110062196e-10,  1.552173038038491e-12,  1.676120404276148e-14,
 -4.393822770094144e-16, -4.679292388394732e-19,  1.426301466134509e-19,  3.740495429376033e-22,  1.401253064001168e+00, -1.123987842503614e-02, -5.883215165847683e-05,
  1.034638577815056e-06,  1.280915039526952e-08, -1.848360474904259e-10, -3.524071801217184e-12,  3.675959705404763e-14,  9.944289918059685e-16, -7.794789590222499e-18,
 -2.552170290207207e-19,  3.464830803955420e-21,  1.701796867421536e+00, -8.027285142374947e-03, -1.146068055097864e-04, -4.746703134045309e-07,  1.755615556944014e-08,
  3.723383414312404e-10,  1.364102409237336e-13, -1.214475461241740e-13, -1.940791496268274e-15,  1.431353362722582e-17,  1.004102012258934e-18,  1.218010421967057e-20,
  1.934000775079732e+00, -2.347138874499962e-03, -5.865477483750467e-05, -1.184821689410465e-06, -1.932357059814397e-08, -2.248734492482645e-10, -5.684848903080757e-13,
  5.996612364267619e-14,  2.066420133757097e-15,  4.231089254016653e-17,  5.460772273937075e-19,  1.088296751153888e-21,  3.716968816282830e-02, -5.599808618439635e-04,
  6.245447366005527e-06, -6.115630607965344e-08,  5.429498395173548e-10, -4.648176888215205e-12,  3.382299323430137e-14, -2.541928750545509e-16,  3.224637070488187e-18,
  5.423099384291449e-20,  1.238468776086642e-21,  1.427581287805068e-24,  1.102222260369749e-01, -1.637289912683510e-03,  1.758157045421020e-05, -1.597100140793124e-07,
  1.233627932100900e-09, -8.355571925228663e-12,  3.183597147439090e-14,  9.139097161014026e-18,  2.013333154283926e-18,  2.335860574511243e-19,  3.262282559252582e-21,
  7.859953697820112e-24,  2.206458450456945e-01, -3.202749173138082e-03,  3.222326138792260e-05, -2.533995416369171e-07,  1.382851198414434e-09, -2.550925642125758e-12,
 -8.821473001754687e-14,  1.291186881850211e-15, -2.748990919782896e-18,  4.764273798481269e-19,  7.741576957501691e-21,  3.652272833817766e-24,  3.694274864623284e-01,
 -5.177789173296871e-03,  4.680361348500842e-05, -2.734122814764261e-07,  9.694278090296180e-11,  1.916256481386705e-11, -3.037826658533090e-13,  2.020680176940857e-15,
  1.729086946876410e-17,  4.924767290810918e-19,  1.714805408667370e-20, -9.060609866484586e-25,  5.576712131212529e-01, -7.417644511063277e-03,  5.583751219600591e-05,
 -1.282548813795246e-07, -3.236899957051313e-09,  4.795442286375416e-11, -2.979035834256363e-13, -2.458031481619705e-15,  9.274981386746176e-17,  5.975510336926549e-19,
  2.215634995325714e-20,  1.407622188507433e-22,  7.861602913186473e-01, -9.654245630055932e-03,  5.083686967915911e-05,  2.691237557605769e-07, -7.617499057203462e-09,
  3.750608212734061e-11,  5.581106608328639e-13, -1.257029081344867e-14,  8.593585183183610e-17,  3.355527092571469e-18,  1.242699244654812e-20,  1.374456357171617e-22,
  1.054099036735411e+00, -1.138261686975261e-02,  2.012430028802506e-05,  8.852262698520663e-07, -7.505300300863231e-09, -9.651994134037908e-11,  1.830056750127736e-12,
  3.546048721928447e-15, -3.524470025752001e-16,  5.243553043957470e-18,  1.340006813773792e-19, -8.692128081281918e-22,  1.355435381515122e+00, -1.165769771770641e-02,
 -4.532258434394869e-05,  1.205826528751720e-06,  8.367278434146897e-09, -2.537874685750020e-10, -2.103392660901568e-12,  6.250159925258466e-14,  5.789243009349024e-16,
 -1.369055686432127e-17, -1.759854755514052e-20,  6.385935376920100e-21,  1.667825424631625e+00, -8.961587600079169e-03, -1.183745827230315e-04, -1.352932498972628e-07,
  2.472705164651752e-08,  3.285636105571880e-10, -3.995757136192934e-12, -1.667120533635662e-13, -6.060874962924815e-16,  6.131531057894418e-17,  1.213077867704406e-18,
 -6.042376853673022e-21,  1.923575823955251e+00, -2.878847701921154e-03, -7.487658986889224e-05, -1.529995063803669e-06, -2.377633636876670e-08, -2.093392033036821e-10,
  2.294984675074328e-12,  1.545772207074950e-13,  3.963101578473854e-15,  6.140031997963948e-17,  2.785438078081805e-19, -1.705221126153969e-20,  3.502524351926790e-02,
 -5.128118930035241e-04,  5.560763899273378e-06, -5.317089548701118e-08,  4.575964519024708e-10, -3.908035375691517e-12,  2.850973052177884e-14, -1.106825731969200e-16,
  5.989541656211089e-18,  9.414522024613817e-20,  4.209373316070183e-22, -4.466112356324508e-23,  1.039426908623458e-01, -1.503980312346345e-03,  1.577809915232331e-05,
 -1.412670183140192e-07,  1.074251691215914e-09, -7.572502972081934e-12,  3.443268465701730e-14,  2.321396541467503e-16,  1.256619811522863e-17,  3.376930709259111e-19,
  9.135081760029151e-22, -1.332326510146608e-22,  2.083316872060028e-01, -2.956754688200287e-03,  2.931319801385125e-05, -2.317847657405133e-07,  1.313613057906149e-09,
 -4.226253937332888e-12, -5.030448823932947e-14,  1.534010198360736e-15,  1.943021043468834e-17,  7.216160114968520e-19,  2.405612982301698e-21, -2.857923076967700e-22,
  3.494444807602442e-01, -4.816431032095637e-03,  4.354339254909343e-05, -2.691707019883070e-07,  4.122786745703648e-10,  1.263424629201938e-11, -2.358810676972762e-13,
  2.983202190081085e-15,  4.629315349505475e-17,  1.054672092658005e-18,  7.148814398949243e-21, -5.235092612693025e-22,  5.288831377417581e-01, -6.977910808303793e-03,
  5.401805406368903e-05, -1.727780902616760e-07, -2.353042899979306e-09,  4.034029877780023e-11, -3.207111359232561e-13,  1.025204455655866e-15,  1.298047635717367e-16,
  1.388608753706784e-18,  1.069034916655607e-20, -7.782146190831106e-22,  7.483743074259711e-01, -9.236643520873434e-03,  5.336187598130544e-05,  1.538599055541803e-07,
 -6.759847954996276e-09,  4.710294789049930e-11,  2.634840949805027e-13, -7.794598927227993e-15,  2.147759931107232e-16,  3.695044797907454e-18, -4.735099384585387e-21,
 -1.134146358815811e-21,  1.008954779430445e+00, -1.118130417094431e-02,  2.997057631267870e-05,  7.520980763619491e-07, -8.994162405608092e-09, -5.247258742835031e-11,
  1.806612260287575e-12, -3.784887773414111e-15, -8.148305128473735e-17,  9.263532760781866e-18,  5.037578418214098e-20, -3.152690128903712e-21,  1.308173757868742e+00,
 -1.196052330932271e-02, -3.022408789893484e-05,  1.296981067285280e-06,  2.937379611040365e-09, -2.816221358227280e-10, -1.660180214383990e-13,  7.352147769691992e-14,
  1.352651432017045e-16, -9.538846835230856e-18,  1.908809504680955e-19,  1.702422882739294e-21,  1.630084899926582e+00, -9.907894954372306e-03, -1.174286989604043e-04,
  3.061019996610144e-07,  2.995971729437969e-08,  1.768103647070479e-10, -8.542236693353317e-12, -1.424790725851714e-13,  2.328470399528735e-15,  9.538662347709806e-17,
  2.536644246744250e-19, -3.801664403209884e-20,  1.910736613209467e+00, -3.558057654587834e-03, -9.564282934398607e-05, -1.939162112993846e-06, -2.697888454946738e-08,
 -8.591987573940490e-11,  8.734559047807157e-12,  3.167832475131838e-13,  6.089266699961306e-15,  4.557058134205591e-17, -1.436531951496717e-18, -6.746125121995566e-20,
  3.305909536684410e-02, -4.707592207454147e-04,  4.964181681643371e-06, -4.643808492233665e-08,  3.861523265091216e-10, -3.236202169984702e-12,  2.859851910867239e-14,
  1.334224844004331e-16,  9.025272257119047e-18,  5.138743005364784e-20, -3.079043930903879e-21, -1.150358810339783e-22,  9.816888062873701e-02, -1.384255343245264e-03,
  1.418117900689261e-05, -1.252425203917057e-07,  9.318742829046487e-10, -6.611545821634848e-12,  4.835584907343318e-14,  8.206992777060102e-16,  2.340774958664165e-17,
  1.948463234689875e-19, -9.649017585275803e-21, -3.487647067513961e-22,  1.969565594961414e-01, -2.733024241468764e-03,  2.665492948363054e-05, -2.114925784826304e-07,
  1.220959062698234e-09, -4.823954504185426e-12,  5.210775325112656e-15,  2.557811772592699e-15,  4.294608035712497e-17,  4.372236333249717e-19, -1.994118409050598e-20,
 -7.343284528782733e-22,  3.308551752443416e-01, -4.480874585106731e-03,  4.036035096779118e-05, -2.608284827897183e-07,  6.161349160503690e-10,  8.178544000008951e-12,
 -1.258381946512444e-13,  5.068593537758110e-15,  8.177017653692633e-17,  6.484304742294720e-19, -3.340146072170953e-20, -1.327116953555120e-21,  5.018218261918975e-01,
 -6.554641066752184e-03,  5.174414309108040e-05, -2.043717271133214e-07, -1.618256474368756e-09,  3.350412805461783e-11, -2.262519527437977e-13,  5.970882600036271e-15,
  1.756441544977628e-16,  7.328737623143642e-19, -5.366909638252831e-20, -2.157483734894727e-21,  7.122907177601953e-01, -8.804128393769635e-03,  5.459128459458190e-05,
  5.352369884605157e-08, -5.767710109009385e-09,  5.170274088390094e-11,  1.604504281236919e-13,  1.036313896122801e-15,  3.268175737716921e-16,  1.890949602535118e-18,
 -1.014867867632278e-19, -3.299607183256758e-21,  9.647627115607856e-01, -1.090794990411413e-02,  3.810521042234313e-05,  6.021143761117768e-07, -9.618800396258491e-09,
 -1.036592854556233e-11,  1.715199735787096e-12, -9.934793280737216e-16,  2.465058096573664e-16,  7.582073343729920e-18, -1.577647659855755e-19, -6.305757382168202e-21,
  1.259947215862239e+00, -1.213968792802947e-02, -1.456297270047803e-05,  1.299408298341371e-06, -2.566784689694995e-09, -2.606782932386666e-10,  1.912088720998571e-12,
  7.380642878032060e-14, -7.873613600866829e-17, -3.321903154651511e-18,  4.249550678016106e-20, -8.761259909079011e-21,  1.588609485060663e+00, -1.082429220252930e-02,
 -1.108019824350762e-04,  8.014437584926942e-07,  3.117959200062434e-08, -6.450345505909396e-11, -1.097957542049063e-11, -1.480102356052791e-14,  5.474054726966184e-15,
  6.506926289190062e-17, -1.882426685783070e-18, -5.293352981040551e-20,  1.894816302371981e+00, -4.423658293052393e-03, -1.215133340959977e-04, -2.369755439804531e-06,
 -2.576427216502182e-08,  2.531188875742447e-10,  2.045993846869359e-11,  5.196668919621899e-13,  5.777010425296547e-15, -9.375774160288898e-17, -6.098677415495006e-18,
 -1.435993555727711e-19,  3.125209820924128e-02, -4.331744299408393e-04,  4.441985103672686e-06, -4.073827877110812e-08,  3.287665065932890e-10, -2.471777138309403e-12,
  3.642396115017704e-14,  4.171681082748243e-16,  7.293970638951306e-18, -1.877034195121482e-19, -9.072130150290669e-21, -1.393795963003033e-22,  9.284958484943562e-02,
 -1.276573677077550e-03,  1.276359445859799e-05, -1.113179367273240e-07,  8.135627973847825e-10, -5.087591805170340e-12,  8.215632455608874e-14,  1.574430273359136e-15,
  1.933319606842126e-17, -5.431577325061330e-19, -2.785919355181012e-20, -4.241698764222194e-22,  1.864353273641505e-01, -2.529611504082172e-03,  2.423114234415812e-05,
 -1.926950080903247e-07,  1.132370521589071e-09, -3.676825552051199e-12,  9.693995835190324e-14,  3.960433343985892e-15,  3.561613052418925e-17, -1.100845945424931e-18,
 -5.823385261845425e-20, -8.920710579111757e-22,  3.135578715158974e-01, -4.170332328771439e-03,  3.729456944995147e-05, -2.497721156233437e-07,  7.625765179763484e-10,
  7.166458744160076e-12,  5.366746927170202e-14,  7.675293629539814e-15,  6.533475131909296e-17, -2.024229594674712e-18, -1.025182441672091e-19, -1.611204024336408e-21,
  4.764150796802496e-01, -6.150888592069467e-03,  4.915766991660470e-05, -2.251298054593408e-07, -9.856164006093865e-10,  3.072001866619302e-11,  1.945985296842104e-14,
  1.139410844146954e-14,  1.376588808130891e-16, -3.603298988636931e-18, -1.671963856465572e-19, -2.665561003054506e-21,  6.779496232282525e-01, -8.366317711991703e-03,
  5.471474959080285e-05, -3.024639914158460e-08, -4.686548800244626e-09,  5.711077523055477e-11,  3.387255497240299e-13,  1.148461297482371e-14,  2.822126100861135e-16,
 -5.545022671587466e-18, -2.770903538570391e-19, -4.151961443751909e-21,  9.217826599470957e-01, -1.057682424164742e-02,  4.440760032556385e-05,  4.488009108543673e-07,
 -9.411251566340062e-09,  3.155083526769974e-11,  1.826812105652693e-12,  9.459433391678247e-15,  3.329360031368569e-16, -4.887531555986023e-18, -4.728181534331847e-19,
 -7.161157731990207e-21,  1.211252728201481e+00, -1.219489484598477e-02,  6.214488866124709e-07,  1.219820625976064e-06, -7.156023254141166e-09, -1.903944917704143e-10,
  3.922563292550036e-12,  6.878257804057172e-14, -2.850167265965052e-16, -1.188128427692980e-17, -5.154348824656068e-19, -1.468799192445262e-20,  1.543612121741246e+00,
 -1.166394815169418e-02, -9.827984567501821e-05,  1.275916277924219e-06,  2.733009698824409e-08, -3.116556585464689e-10, -8.718208493272058e-12,  1.790366066645737e-13,
  5.946261830063598e-15, -5.097867762604869e-17, -3.683160494141664e-18, -2.064988034903016e-20,  1.874988218094213e+00, -5.515937140212015e-03, -1.521559912475579e-04,
 -2.709540946985849e-06, -1.452533752167190e-08,  9.345329429941202e-10,  3.668049259371720e-11,  5.904301742712909e-13, -3.596098319163857e-15, -4.703883884798687e-16,
 -1.247236218108654e-17, -1.010888033828721e-19,  2.958749784947919e-02, -3.995079892353494e-04,  3.983221590323720e-06, -3.582166294720429e-08,  2.891186606427416e-10,
 -1.440078136807119e-12,  4.979476579333996e-14,  4.619629686975470e-16, -7.216168057831994e-18, -6.409061070484572e-19, -1.223739473335910e-20,  5.011327102205973e-23,
  8.793935067420694e-02, -1.179593851934348e-03,  1.150291377590421e-05, -9.899188205920739e-08,  7.353532140020985e-10, -2.543507133034374e-12,  1.302386357238518e-13,
  1.633311958298577e-15, -2.399785401834399e-17, -1.932741950203524e-18, -3.751780957794313e-20,  1.514409339470120e-22,  1.766903635381030e-01, -2.344708293991836e-03,
  2.202559981453057e-05, -1.749995825953521e-07,  1.091527851637259e-09,  5.479333381920757e-14,  2.142249596074529e-13,  3.949417453284552e-15, -5.377982319635815e-17,
 -4.011007596155528e-18, -7.872493843975823e-20,  3.076969858368778e-22,  2.974545808532206e-01, -3.883745690113411e-03,  3.437567535304549e-05, -2.362781219233651e-07,
  9.370153724353684e-10,  1.117084533119505e-11,  2.805236009933827e-13,  7.687124721978624e-15, -9.555985570913138e-17, -7.180676629777804e-18, -1.401263536959654e-19,
  5.191070986318409e-22,  4.525806221512531e-01, -5.768654123706803e-03,  4.638216408479323e-05, -2.358436920587639e-07, -3.388249802750392e-10,  3.534201437586727e-11,
  3.702605969932839e-13,  1.223120949765062e-14, -1.360644645033140e-16, -1.205081848162878e-17, -2.304461800404962e-19,  8.070301119797385e-22,  6.453558088156499e-01,
 -7.931235998958426e-03,  5.394134414349783e-05, -9.552724346965007e-08, -3.432805865786432e-09,  6.985042062602137e-11,  7.395915445441582e-13,  1.486786585967361e-14,
 -1.537381256164253e-16, -1.937061830418875e-17, -3.754033009962867e-19,  1.296475084371400e-21,  8.802164628944181e-01, -1.020251689814988e-02,  4.891856196570225e-05,
  3.057594194070445e-07, -8.315334823711029e-09,  7.946952011012553e-11,  2.185140382262181e-12,  1.310835035373817e-14, -2.466462459479259e-16, -2.851379529535996e-17,
 -6.436925661512143e-19,  1.931932091759721e-21,  1.162572714613388e+00, -1.213357131775561e-02,  1.446495692505850e-05,  1.080605727863159e-06, -9.874117709833276e-09,
 -7.474005496870218e-11,  5.621192972916062e-12,  4.766531746840377e-14, -1.223786121215926e-15, -4.331724093386354e-17, -9.550917925738299e-19, -4.750544372336521e-22,
  1.495490610462164e+00, -1.238204680025273e-02, -8.058215910961388e-05,  1.654023732273740e-06,  1.951080955992146e-08, -4.419713268664984e-10, -1.524886184741908e-12,
  3.108285056725990e-13,  1.407937122095110e-15, -1.976479709807743e-16, -3.135391964440475e-18,  4.975052776479210e-20,  1.850280767049013e+00, -6.865436527713944e-03,
 -1.852788974524976e-04, -2.739438044923938e-06,  1.416117459691231e-08,  1.981036648491906e-09,  4.834515818276203e-11,  1.050066368418416e-13, -2.968006807171853e-14,
 -9.500148734513587e-16, -7.639278411300931e-18,  4.328837414786236e-19,  2.805058368179193e-02, -3.692847642345151e-04,  3.580387134858455e-06, -3.135762048273604e-08,
  2.730787042857268e-10, -1.403250746900242e-13,  5.541832481538498e-14, -2.202527991150924e-16, -3.730997365879939e-17, -9.417942240240530e-19,  1.545153429634995e-21,
  6.427296965499674e-22,  8.339777725509752e-02, -1.092124831044224e-03,  1.038451324832828e-05, -8.745029229718300e-08,  7.186879831982382e-10,  9.703478416318897e-13,
  1.528882948933569e-13, -5.000602142182087e-16, -1.151527157038069e-16, -2.860169482162466e-18,  4.410608909190109e-21,  1.957807263388116e-21,  1.676510617366392e-01,
 -2.176604515773555e-03,  2.003142271768730e-05, -1.572148318506569e-07,  1.151349361790060e-09,  6.175140378497852e-12,  2.750732820087318e-13, -6.121594036615974e-16,
 -2.435953854915523e-16, -5.970095074149148e-18,  8.513213763517230e-21,  4.086606530711394e-21,  2.824520373544346e-01, -3.619807086350409e-03,  3.163902664053888e-05,
 -2.190691926588063e-07,  1.242260279417642e-09,  1.986592699158367e-11,  4.070730585196431e-13, -4.531941737914571e-16, -4.352077821072446e-16, -1.069187759542630e-17,
  1.406706305501663e-20,  7.263843096797255e-21,  4.302301414683587e-01, -5.408952089465547e-03,  4.354468673434952e-05, -2.350254875586121e-07,  4.801559378791805e-10,
  4.738585098603457e-11,  5.749935416562496e-13, -6.246573063898866e-16, -7.038584322669900e-16, -1.786735391767268e-17,  2.122935070109735e-20,  1.193148069132550e-20,
  6.144854967028742e-01, -7.505111207812686e-03,  5.251503586564935e-05, -1.381893221204786e-07, -1.830538884531031e-09,  9.129930054457708e-11,  9.633018363487068e-13,
 -3.759658302122581e-15, -1.070537788699981e-15, -2.897687948124812e-17,  2.507887784580428e-20,  1.902593027803867e-20,  8.402093201199733e-01, -9.798613908170531e-03,
  5.185135523051731e-05,  1.883735398213324e-07, -6.181029451345954e-09,  1.343101768163423e-10,  2.254729725486828e-12, -1.562936497581477e-14, -1.656134317010741e-15,
 -4.565785277293502e-17, -3.254814705886852e-21,  3.063487798457292e-20,  1.114348115515917e+00, -1.196873247198053e-02,  2.645972868290581e-05,  9.183446572839409e-07,
 -9.941641847274797e-09,  7.006506972082549e-11,  6.123491753646828e-12, -2.320173388198692e-14, -3.372276352767520e-15, -6.998761227561838e-17, -1.145160449771003e-20,
  4.964889089423176e-20,  1.444805422672433e+00, -1.294267396194285e-02, -5.915087201547866e-05,  1.896451832456913e-06,  1.100605209300126e-08, -3.763453283477795e-10,
  6.599037281659819e-12,  2.236314993887422e-13, -7.204309428089051e-15, -2.533285190963462e-16,  1.040233529373289e-18,  1.442611467716079e-19,  1.819656280150211e+00,
 -8.471892462000970e-03, -2.152838113437299e-04, -2.134198581043741e-06,  6.493032094326328e-08,  3.036798532576269e-09,  3.272444136884801e-11, -1.396915102091016e-12,
 -6.222305146949622e-14, -5.911360647513522e-16,  3.253636842144499e-17,  1.347957674496421e-18,  2.662845278629436e-02, -3.420723209369017e-04,  3.230440301194694e-06,
 -2.694345632177281e-08,  2.822495518886889e-10,  9.515071638017262e-13,  2.790885151958157e-14, -1.876497474749500e-15, -6.135681709374373e-17, -1.094003828542600e-19,
  4.401074877324907e-20,  1.145802793494480e-21,  7.918906340326518e-02, -1.013048143912883e-03,  9.405356411978163e-06, -7.561008299993650e-08,  7.711183275898745e-10,
  3.966243045822026e-12,  7.323344595013351e-14, -5.590391877683665e-15, -1.882785604420800e-16, -3.333955332486491e-19,  1.340223409612683e-19,  3.504254297795112e-21,
  1.592536554166798e-01, -2.023574664147876e-03,  1.826055234940815e-05, -1.374706399367990e-07,  1.334127512854717e-09,  1.150439664494223e-11,  1.194092208539295e-13,
 -1.134556055558746e-14, -3.966332650210720e-16, -7.121064556110789e-19,  2.800023737034152e-19,  7.364495154112469e-21,  2.684629051793514e-01, -3.376838806483710e-03,
  2.914419476081471e-05, -1.955206591909846e-07,  1.726678297267237e-09,  2.757619697152866e-11,  1.466810618769553e-13, -1.965537737264097e-14, -7.106102562106924e-16,
 -1.356852091328074e-18,  4.992155263250101e-19,  1.322432830231061e-20,  4.092734713514259e-01, -5.071668559880018e-03,  4.080403675168768e-05, -2.190705231988791e-07,
  1.548895741401754e-09,  5.787225762763225e-11,  1.538250950898667e-13, -3.200018261628396e-14, -1.167981742285363e-15, -2.540685828432658e-18,  8.237368692000427e-19,
  2.201748886060486e-20,  5.852942797723261e-01, -7.091975481130529e-03,  5.074506723725738e-05, -1.517312522366833e-07,  1.941939652906775e-10,  1.083753281838175e-10,
  2.344636624649391e-13, -5.247418315010416e-14, -1.833512470387421e-15, -4.777107539397370e-18,  1.314309008122077e-18,  3.564949654933489e-20,  8.018567207663635e-01,
 -9.376220365168858e-03,  5.361592032194605e-05,  1.136314716497778e-07, -3.026289946289128e-09,  1.757415633691194e-10,  8.464130407263192e-13, -9.165354923664371e-14,
 -2.878156415176774e-15, -8.205641356764442e-18,  2.092578312276015e-18,  5.853323944403390e-20,  1.066962721135493e+00, -1.171552193708821e-02,  3.659638059867799e-05,
  7.780047035018836e-07, -7.195830892968090e-09,  1.948354483977495e-10,  3.614233043114074e-12, -1.660637103065435e-13, -5.195970685151798e-15, -7.653963618857216e-18,
  3.527430321642725e-18,  1.012252809785437e-19,  1.392235995967636e+00, -1.332236543472786e-02, -3.555291857154051e-05,  2.022496408737365e-06,  5.401852410107766e-09,
 -1.766774901713051e-10,  8.400265259995063e-12, -1.305790115551310e-13, -1.377657600483045e-14, -5.624247670126940e-17,  9.353372628890432e-18,  2.121914053415991e-19,
  1.782193237751725e+00, -1.027413326672633e-02, -2.325647770953028e-04, -5.842399506570997e-07,  1.291478762486503e-07,  3.120081235062970e-09, -3.498701394330752e-11,
 -3.359498408428820e-12, -4.575884181023996e-14,  1.853333625327327e-15,  8.238625352248043e-17,  2.969338314591317e-19,  2.530991330603955e-02, -3.174437344653355e-04,
  2.934902417583093e-06, -2.226059402426293e-08,  3.026115181088276e-10,  7.797419767864707e-13, -4.976527166164397e-14, -3.474943736671076e-15, -2.328172722309964e-17,
  2.416570530577008e-18,  7.073880315120886e-20, -4.539324153421180e-22,  7.528191462276526e-02, -9.412184964866395e-04,  8.574815460811110e-06, -6.260728614428781e-08,
  8.519320726322829e-10,  3.197551289245878e-12, -1.604652774006737e-13, -1.050246394935925e-14, -7.214259433264130e-17,  7.375654950730791e-18,  2.162717128529110e-19,
 -1.367455487538565e-21,  1.514416136864658e-01, -1.883708094499890e-03,  1.674672205570670e-05, -1.142614257819117e-07,  1.559958482356742e-09,  9.192196433672964e-12,
 -3.610132057497009e-13, -2.171713949115352e-14, -1.539642675089733e-16,  1.544526135919987e-17,  4.544942081884005e-19, -2.807730173916879e-21,  2.554077160190464e-01,
 -3.152558539054583e-03,  2.698190714907394e-05, -1.635227033713029e-07,  2.255943883544559e-09,  2.204191201721382e-11, -6.957897522286925e-13, -3.829693991928079e-14,
 -2.797273082050988e-16,  2.756987340688221e-17,  8.166346296889058e-19, -4.880482871689104e-21,  3.896237225270894e-01, -4.755242899284487e-03,  3.836171742720491e-05,
 -1.852071622070056e-07,  2.649468547653539e-09,  4.677566356298183e-11, -1.223655118228589e-12, -6.276473184378063e-14, -4.649245959089271e-16,  4.544866536386916e-17,
  1.361254116766485e-18, -7.773934547034960e-21,  5.577270580110272e-01, -6.693081464834437e-03,  4.901380466663582e-05, -1.315950858925027e-07,  2.265576345501991e-09,
  9.001692924056396e-11, -1.993160412771126e-12, -1.009589270107382e-13, -7.306179228775684e-16,  7.241151243741517e-17,  2.203782415490966e-18, -1.183624643945148e-20,
  7.652175229685897e-01, -8.942392629312249e-03,  5.480570962010804e-05,  9.337655091207470e-08,  4.313541248794125e-10,  1.552757960315180e-10, -2.911145357700253e-12,
 -1.677071720861931e-13, -1.122298279726114e-15,  1.164757870302480e-16,  3.593681394236526e-18, -1.783452660582848e-20,  1.020742958478832e+00, -1.138704636198154e-02,
  4.538037713730143e-05,  6.968470425382535e-07, -2.902304194984873e-09,  2.079167093931157e-10, -3.162884067954895e-12, -3.014500861376185e-13, -1.979256021244463e-15,
  2.053870355147029e-16,  6.189150516830362e-18, -2.955106296423079e-20,  1.338533195302969e+00, -1.350844684236333e-02, -1.085105708185016e-05,  2.089477015687269e-06,
  3.333590296373729e-09, -6.763013488599715e-11, -1.120670400283654e-12, -5.153908068661511e-13, -7.172626121645053e-15,  4.574169939546030e-16,  1.408073358813755e-17,
 -1.019377671815974e-19,  1.737386534058963e+00, -1.212328811583536e-02, -2.253583762462173e-04,  1.901766664734433e-06,  1.750211464127396e-07,  1.069962495921978e-09,
 -1.351628679402637e-10, -3.161516138518725e-12,  7.302425188357365e-14,  4.232939061909806e-15,  4.204832937005114e-18, -3.975538139182222e-18,  2.408552203327892e-02,
 -2.949501159737359e-04,  2.697038985548313e-06, -1.739233499448640e-08,  2.983522505944688e-10, -1.568582820462415e-12, -1.410513508406632e-13, -2.383060646413382e-15,
  1.003205371542604e-16,  3.795850966288589e-18, -2.747826655892553e-20, -3.824720081017403e-21,  7.164981075452975e-02, -8.753903990483848e-04,  7.906469551657568e-06,
 -4.877500610227339e-08,  8.534427223111154e-10, -4.144652799328742e-12, -4.366425580176789e-13, -7.200697633904613e-15,  3.054805819890856e-16,  1.160593942825366e-17,
 -8.357875630108515e-20, -1.170438789485072e-20,  1.441666573163202e-01, -1.754784684875010e-03,  1.552931054147892e-05, -8.851114747385189e-08,  1.607624129127861e-09,
 -6.699868848614440e-12, -9.328144882954742e-13, -1.488020515340307e-14,  6.382460332791732e-16,  2.437937116923528e-17, -1.741840310811271e-19, -2.462999186037223e-20,
  2.432176654407690e-01, -2.943912982725246e-03,  2.524680376702019e-05, -1.251772010132753e-07,  2.442348611133151e-09, -7.417332027016405e-12, -1.705208733685732e-12,
 -2.620293511580574e-14,  1.138679774718930e-15,  4.373448668716548e-17, -3.092317401461356e-19, -4.433381526842557e-20,  3.712035570675390e-01, -4.456460727479094e-03,
  3.641762742448148e-05, -1.375321973992414e-07,  3.147932566235556e-09, -3.513099528612803e-12, -2.878198094553652e-12, -4.282578225905354e-14,  1.884466762648832e-15,
  7.263601566403562e-17, -5.074999814260885e-19, -7.408380915341502e-20,  5.317299750012402e-01, -6.306556255557431e-03,  4.770048904042418e-05, -8.451451159239514e-08,
  3.357180107484072e-09,  8.573158703965633e-12, -4.649564696833714e-12, -6.858920597173581e-14,  3.037284187766048e-15,  1.168756733890767e-16, -8.090188816934653e-19,
 -1.204740741308576e-19,  7.303323763842391e-01, -8.499144216120287e-03,  5.605341209520299e-05,  1.197152965171552e-07,  2.456623239306316e-09,  2.977020417395572e-11,
 -7.306172277143440e-12, -1.135474189644617e-13,  4.973363983566016e-15,  1.894899464783601e-16, -1.322332958345938e-18, -1.986564219007124e-19,  9.759730702827545e-01,
 -1.099106929438805e-02,  5.357985679255830e-05,  6.766569651408235e-07, -1.890300833667197e-10,  3.193665677084921e-11, -1.108058733739132e-11, -2.069716369969534e-13,
  8.676532374928131e-15,  3.290275670769865e-16, -2.473982527540721e-18, -3.525480253272626e-19,  1.284485692841097e+00, -1.349419142673323e-02,  1.447928880874979e-05,
  2.125388908250462e-06,  4.864268771495816e-10, -2.749812128014670e-10, -1.562742655530975e-11, -3.942725630292888e-13,  1.639272254243679e-14,  7.140637894174206e-16,
 -6.589719483713893e-18, -7.982106972995586e-19,  1.685499939601397e+00, -1.378690736098561e-02, -1.856668794090752e-04,  4.673441361208875e-06,  1.587476311370556e-07,
 -2.839483134991439e-09, -1.700168010258168e-10,  1.265803971644813e-12,  1.813642451617048e-13,  5.137698616775557e-16, -1.796561909011063e-16, -2.439614971060372e-18,
  2.294766219451178e-02, -2.741311445089335e-04,  2.515298691382927e-06, -1.306828763142877e-08,  2.300793325264908e-10, -5.281503545730111e-12, -1.457694182842600e-13,
  2.463439545059049e-15,  1.760458164335687e-16, -6.008014935340978e-19, -1.735331520747420e-19, -1.227053018992556e-21,  6.827136022665932e-02, -8.142579493111651e-04,
  7.398390613281726e-06, -3.639661281182051e-08,  6.566042550156181e-10, -1.560167998112059e-11, -4.492178037483585e-13,  7.579299406274621e-15,  5.371140918771728e-16,
 -1.838607277751538e-18, -5.311467631044961e-19, -3.765497933057776e-21,  1.373898540266524e-01, -1.634380049665802e-03,  1.461288035572337e-05, -6.516818489563063e-08,
  1.231021774316729e-09, -3.107068494882140e-11, -9.538563642135627e-13,  1.606082221782442e-14,  1.125005348705178e-15, -3.877435191590014e-18, -1.117921998937753e-18,
 -7.952707817446672e-21,  2.318373526205435e-01, -2.747309337842452e-03,  2.396657881844038e-05, -8.966834464879615e-08,  1.852150593060696e-09, -5.175747057420915e-11,
 -1.731951753264291e-12,  2.910786118301643e-14,  2.011805987954694e-15, -7.033281165591419e-18, -2.012337564538444e-18, -1.436405176562997e-20,  3.539511130401956e-01,
 -4.170896166368924e-03,  3.505420986647393e-05, -9.173737713330594e-08,  2.334206524763226e-09, -7.805272138001659e-11, -2.906165173317948e-12,  4.881765029860869e-14,
  3.332465724455856e-15, -1.198393593615828e-17, -3.361621161020645e-18, -2.402264466549789e-20,  5.072617886081823e-01, -5.928124525517938e-03,  4.699341447511549e-05,
 -3.590084733785377e-08,  2.328773745457132e-09, -1.116817601684100e-10, -4.683680897707883e-12,  7.895789946142538e-14,  5.356116707913881e-15, -2.033332712407524e-17,
 -5.461241342187835e-18, -3.875927513608299e-20,  6.972426728310088e-01, -8.044322823499758e-03,  5.771260616164560e-05,  1.535734814631274e-07,  1.157962958640609e-09,
 -1.602482694098526e-10, -7.407608517002493e-12,  1.268342856854340e-13,  8.685972795678886e-15, -3.648496431047617e-17, -8.988113790310703e-18, -6.175960849613532e-20,
  9.329173612305446e-01, -1.053005469321692e-02,  6.165212301556709e-05,  6.630146329877038e-07, -2.475459755949822e-09, -2.626842049362777e-10, -1.152655597609024e-11,
  2.097438442039133e-13,  1.492464064751455e-14, -7.531574876362598e-17, -1.589057891733545e-17, -9.632906677424028e-20,  1.230901577821709e+00, -1.327676984690235e-02,
  3.977606796266805e-05,  2.066382094990553e-06, -9.263073730376910e-09, -7.030405503882432e-10, -1.622561348116951e-11,  4.215200898764158e-13,  2.899414701503912e-14,
 -2.093652786694198e-16, -3.452177368303912e-17, -1.057381843675159e-19,  1.627790405031738e+00, -1.501038730467694e-02, -1.168772407163800e-04,  6.560942971424834e-06,
  6.729749834751663e-08, -5.873622990309271e-09, -6.088533791703548e-11,  5.925171251678784e-12,  6.878247167757044e-14, -6.133250696274258e-15, -8.520597437721087e-17,
  6.355153970585498e-18,  2.189046561094934e-02, -2.545825534494008e-04,  2.376555465943436e-06, -1.038796745632248e-08,  9.808137706108636e-11, -7.383613569019118e-12,
 -1.065610940859366e-14,  6.445120800708961e-15,  3.776532180856787e-17, -6.283942525878367e-18, -5.560356849473764e-20,  5.966204829382488e-21,  6.513015321019168e-02,
 -7.566662928271383e-04,  7.012747290571132e-06, -2.886813051085364e-08,  2.631892884258101e-10, -2.210200284040534e-11, -3.533670955481098e-14,  1.971160590185901e-14,
  1.139400858014023e-16, -1.922383238511114e-17, -1.692847457624200e-19,  1.830335804848831e-20,  1.310815886605015e-01, -1.520324509064991e-03,  1.392508866802139e-05,
 -5.146559350959199e-08,  4.364550251491779e-10, -4.493669705829986e-11, -8.220209479151696e-14,  4.141774358785952e-14,  2.343350603305169e-16, -4.043064764065228e-17,
 -3.529902256929371e-19,  3.866778725113115e-20,  2.212253570348260e-01, -2.559468467324092e-03,  2.302794401503528e-05, -7.017410241527287e-08,  5.019189013182735e-10,
 -7.705936492747481e-11, -1.636062737616507e-13,  7.430194575303982e-14,  4.076148786704215e-16, -7.270784731757591e-17, -6.256158094163518e-19,  6.999321163063682e-20,
  3.378221364026887e-01, -3.894371096674383e-03,  3.411541676940557e-05, -7.000089302928182e-08,  2.435791603583775e-10, -1.206748506356695e-10, -2.946646379702840e-13,
  1.232970095935616e-13,  6.476395725166239e-16, -1.213151371047375e-16, -1.018069329496873e-18,  1.178713078325559e-19,  4.842990832740760e-01, -5.553471389211443e-03,
  4.669551639541979e-05, -2.154050812179409e-08, -7.581574957071622e-10, -1.803755890806815e-10, -4.810191833692061e-13,  1.976919428924567e-13,  9.749801518080113e-16,
 -1.967741391388876e-16, -1.578355029958181e-18,  1.937397692605341e-19,  6.660005091765983e-01, -7.575233655376577e-03,  5.953417489832608e-05,  1.385341626524264e-07,
 -3.389047916686528e-09, -2.676923205234448e-10, -6.505264481818366e-13,  3.166964406058762e-13,  1.409915261795037e-15, -3.228590420139742e-16, -2.366670083565612e-18,
  3.243136630824630e-19,  8.918323820274888e-01, -1.000616965184604e-02,  6.915623091905825e-05,  5.692397873888707e-07, -9.767431721154290e-09, -4.217216717071612e-10,
 -2.296667496808997e-13,  5.268699427985166e-13,  1.864244714556910e-15, -5.648910665707113e-16, -3.327073271051850e-18,  5.873190969069447e-19,  1.178582854207221e+00,
 -1.286307361218112e-02,  6.316597972707483e-05,  1.790246710183281e-06, -2.578345478778661e-08, -8.621133235552909e-10,  5.636452191980099e-12,  9.847964806983767e-13,
  2.652142000287389e-16, -1.166853103600606e-15, -2.385246156919237e-18,  1.312642077945619e-18,  1.566391225380001e+00, -1.562133002867526e-02, -3.566019112443462e-05,
  6.676681486110055e-06, -5.096870554231858e-08, -5.308388318847187e-09,  1.013343436707921e-10,  4.519536221749826e-12, -1.418804824514174e-13, -3.754532713662410e-15,
  1.775448624577123e-16,  2.904801408562536e-18,  2.090939392407351e-02, -2.360530622726760e-04,  2.256565088629589e-06, -9.952847888581138e-09, -3.772548143980759e-11,
 -5.548427595064317e-12,  1.527378605552931e-13,  4.134407456167852e-15, -1.640059415082879e-16, -3.329571555435254e-18,  1.763451748838768e-19,  2.437049242797676e-21,
  6.221355555069770e-02, -7.019113589254650e-04,  6.677371702545393e-06, -2.805276205073713e-08, -1.432497435913264e-10, -1.656071752472451e-11,  4.637237511886379e-13,
  1.260170263506209e-14, -5.023218617823282e-16, -1.012596231383697e-17,  5.408651875040126e-19,  7.406004470874706e-21,  1.252192597155178e-01, -1.411342474075754e-03,
  1.332047160555102e-05, -5.138733767464004e-08, -3.894794193841825e-10, -3.350275774664249e-11,  9.641795643381250e-13,  2.633040924481206e-14, -1.058243997881444e-15,
 -2.108845069967008e-17,  1.142150322518322e-18,  1.539812139610783e-20,  2.113506378840923e-01, -2.378591756440895e-03,  2.218441662304390e-05, -7.398381378383201e-08,
 -9.127940395588823e-10, -5.698337470819596e-11,  1.707579884653508e-12,  4.682940363079877e-14, -1.906964164420345e-15, -3.734912407733772e-17,  2.065980286148692e-18,
  2.717544806200628e-20,  3.227850342697960e-01, -3.624921657777942e-03,  3.322109375531532e-05, -8.463230636487564e-08, -1.966207901254704e-09, -8.803408070412870e-11,
  2.795774324303046e-12,  7.668581194098506e-14, -3.188504153884007e-15, -6.085892121746555e-17,  3.475058817425760e-18,  4.395578227274230e-20,  4.628300425168774e-01,
 -5.181416361164900e-03,  4.624827732925189e-05, -6.129764599630758e-08, -4.042519784610040e-09, -1.285260961698502e-10,  4.438503974470190e-12,  1.203802921781170e-13,
 -5.179900459084166e-15, -9.501597993146949e-17,  5.699276442221240e-18,  6.753298261767953e-20,  6.366608232884718e-01, -7.093629982265920e-03,  6.069996773651200e-05,
  4.359867632348989e-08, -8.200075668302957e-09, -1.824825024670900e-10,  7.135829468283199e-12,  1.858085117703451e-13, -8.498346864101762e-15, -1.458005101942278e-16,
  9.496284252823837e-18,  9.971238347006208e-20,  8.529528970357342e-01, -9.428871440393049e-03,  7.478360107768215e-05,  3.500834021667047e-07, -1.710620731939856e-08,
 -2.619105493588593e-10,  1.241123042910773e-11,  2.856202950586180e-13, -1.482405796239129e-14, -2.220017317763969e-16,  1.699324415723994e-17,  1.350361828038536e-19,
  1.128265760679068e+00, -1.228004476368725e-02,  8.165314363062603e-05,  1.256033948369867e-06, -3.959280417318416e-08, -4.317479417412065e-10,  2.751059899528078e-11,
  4.089904932609103e-13, -3.083415667418344e-14, -2.926116504890466e-16,  3.648134339448419e-17,  6.725612571919878e-20,  1.503813852595834e+00, -1.560703245968440e-02,
  3.658436703099964e-05,  5.176684485150067e-06, -1.255586308742154e-07, -1.943852856010589e-09,  1.543402403517081e-10, -7.402006556714737e-13, -1.450680742247624e-13,
  3.052064607147491e-15,  1.045938090764653e-16, -4.762894837562092e-18,  2.000050650705118e-02, -2.184955305319812e-04,  2.130572242040971e-06, -1.121726248686606e-08,
 -1.060094853532667e-10, -1.146382664911116e-12,  1.871611209176332e-13, -1.615513379601026e-15, -1.543692984627514e-16,  3.367910096076380e-18,  1.063138055675883e-19,
 -4.464288893816096e-21,  5.951053336179234e-02, -6.498986728541680e-04,  6.318258080283497e-06, -3.230526992398414e-08, -3.448378502170658e-10, -3.194212134538477e-12,
  5.678362066959602e-13, -4.968227167590630e-15, -4.704463869868032e-16,  1.035275484826601e-17,  3.232621212275603e-19, -1.371593072394518e-20,  1.197829066769635e-01,
 -1.307393043961018e-03,  1.264890048837650e-05, -6.154609291584600e-08, -7.899683594029560e-10, -5.714251482348236e-12,  1.178766393305807e-12, -1.054425264037764e-14,
 -9.830412160364542e-16,  2.193814069806309e-17,  6.729522125758073e-19, -2.904093857893126e-20,  2.021851543253388e-01, -2.204986402555731e-03,  2.117948293635271e-05,
 -9.516749823560057e-08, -1.575178832791892e-09, -7.810662572771891e-12,  2.080578576722348e-12, -1.924240613388259e-14, -1.749768607074081e-15,  3.987743006407710e-17,
  1.190844148871988e-18, -5.272299570603751e-20,  3.088095548220204e-01, -3.363857471122972e-03,  3.197191552421919e-05, -1.260249286575446e-07, -2.946530591818315e-09,
 -7.727763374884580e-12,  3.383108295697978e-12, -3.286505093777731e-14, -2.872502573741380e-15,  6.751822019329132e-17,  1.937176410961136e-18, -8.910123229966377e-20,
  4.428379335631391e-01, -4.815625522315683e-03,  4.506080866948454e-05, -1.399698159429337e-07, -5.379076166419347e-09, -1.822977156069921e-12,  5.296638070500870e-12,
 -5.534598408779631e-14, -4.537438005882109e-15,  1.117017346897765e-16,  3.014191585072404e-18, -1.469673006407406e-19,  6.092573858494043e-01, -6.608378441492693e-03,
  6.034906789281995e-05, -1.063143352365107e-07, -9.885342617201420e-09,  1.830466097491462e-11,  8.272727649451226e-12, -9.663983728523003e-14, -7.109449029303132e-15,
  1.882957915170584e-16,  4.592393284406052e-18, -2.463766619479181e-19,  8.164536056102999e-01, -8.818735076155697e-03,  7.722696551620969e-05,  5.236921752689439e-08,
 -1.900912276328654e-08,  7.563491224025732e-11,  1.349414662812048e-11, -1.887462533394810e-13, -1.136921899770102e-14,  3.425860330333641e-16,  6.879150755635713e-18,
 -4.424333987569066e-19,  1.080531728947149e+00, -1.157771136839710e-02,  9.276162519962650e-05,  5.912022532614754e-07, -4.127975466855159e-08,  2.543232803940909e-10,
  2.545258449360677e-11, -4.894449282105236e-13, -1.888491629285478e-14,  7.612759002442338e-16,  8.710579915388634e-18, -9.356544649344653e-19,  1.442313955531648e+00,
 -1.510174385380751e-02,  8.598122512272293e-05,  3.043007669126889e-06, -1.312808732070012e-07,  1.107222815394563e-09,  8.852360674952200e-11, -3.222879813048092e-12,
 -8.908069856163437e-15,  3.346972867620987e-15, -6.652624732766584e-17, -1.831203636295674e-18,  1.915971988620319e-02, -2.020184841351776e-04,  1.985759505485146e-06,
 -1.287655426359390e-08, -9.001648235379327e-11,  2.376096814585225e-12,  9.457327285495868e-14, -4.185143484207967e-15, -4.058609073725747e-18,  3.806878894511076e-18,
 -6.633218850408965e-20, -2.192306128685780e-21,  5.700944242619187e-02, -6.009974433206312e-04,  5.897588801814407e-06, -3.766614508263864e-08, -2.908112141990042e-10,
  7.467088732178572e-12,  2.848109380466815e-13, -1.276096109985836e-14, -1.051098403995905e-17,  1.160464341569487e-17, -2.045804102312073e-19, -6.645651102334793e-21,
  1.147507363125459e-01, -1.209370344480389e-03,  1.183531301124387e-05, -7.371642189168702e-08, -6.600655229178092e-10,  1.633092459685825e-11,  5.841642568467056e-13,
 -2.669647277812793e-14, -1.558897388780326e-17,  2.425987924820688e-17, -4.357830322489718e-19, -1.376419387696281e-20,  1.936962478134001e-01, -2.040542578543513e-03,
  1.988915642238950e-05, -1.191847046772242e-07, -1.301937384861393e-09,  3.087154348882100e-11,  1.012629972131297e-12, -4.763605584551064e-14, -1.044666469892476e-17,
  4.321270324442974e-17, -7.980040471016226e-19, -2.416355349497430e-20,  2.958549841751160e-01, -3.114918084808539e-03,  3.018470510011203e-05, -1.704615503753859e-07,
 -2.406501168511808e-09,  5.462584166904413e-11,  1.603324654906651e-12, -7.859534782553108e-14,  2.564784140205989e-17,  7.102133241744473e-17, -1.364699734677267e-18,
 -3.882166297724173e-20,  4.242837496118881e-01, -4.463282241910370e-03,  4.288391473674535e-05, -2.201887235534121e-07, -4.336880291190886e-09,  9.452632712907586e-11,
  2.411562449037352e-12, -1.254215324608441e-13,  1.452739589597084e-16,  1.123932823202449e-16, -2.287658880442343e-18, -5.919175739775911e-20,  5.837776988298804e-01,
 -6.133286030603149e-03,  5.816789318068654e-05, -2.520574433289975e-07, -7.856320167341424e-09,  1.656830774881678e-10,  3.532994029689526e-12, -2.007957969712338e-13,
  5.006540015274742e-16,  1.766525596984074e-16, -3.921986823555627e-18, -8.694284377173577e-20,  7.824112590768366e-01, -8.203358204277023e-03,  7.613109075992270e-05,
 -2.244580044535727e-07, -1.484605374928628e-08,  3.073483913037939e-10,  5.137693760003781e-12, -3.379158533939339e-13,  1.639220407413643e-15,  2.841704410571636e-16,
 -7.280284195555269e-18, -1.200476689936637e-19,  1.035734897925645e+00, -1.081789351083487e-02,  9.615359921915911e-05, -9.468719535027890e-10, -3.143739280270018e-08,
  6.583431928434876e-10,  7.466807739833498e-12, -6.586512635111817e-13,  6.483370450238097e-15,  4.793800384168029e-16, -1.638748342059036e-17, -1.066119909621886e-19,
  1.383466516596980e+00, -1.430125546828077e-02,  1.109165234988323e-04,  1.205067793514777e-06, -9.496918305985768e-08,  2.207303972286202e-09,  8.238019682407196e-12,
 -2.169942618016023e-12,  5.631542899475562e-14,  3.401827831295859e-16, -6.025847974804967e-17,  1.361042465426947e-18,  1.838241045168128e-02, -1.867707481582719e-04,
  1.824460598371515e-06, -1.385201051548843e-08, -2.890467440111363e-11,  3.330128144978535e-12, -8.172004837961550e-15, -2.742906858636695e-15,  7.396232725759527e-17,
  5.007660978034012e-19, -7.303006204794897e-20,  1.296257861339608e-21,  5.469685705789687e-02, -5.556906362901722e-04,  5.423484433080718e-06, -4.087085715305411e-08,
 -1.008528096010970e-10,  1.029686243781313e-11, -2.775398897308240e-14, -8.318907018479833e-15,  2.261763824332161e-16,  1.480096852512152e-18, -2.225057772038604e-19,
  3.999277666951039e-21,  1.100968014848061e-01, -1.118377228502210e-03,  1.089991855667684e-05, -8.114895020043462e-08, -2.511661822767203e-10,  2.199157943967903e-11,
 -6.730220916329623e-14, -1.725323139662635e-14,  4.753178824281943e-16,  2.936743427443029e-18, -4.647560338243820e-19,  8.522540029182653e-21,  1.858428160114872e-01,
 -1.887451013927177e-03,  1.835740104959251e-05, -1.341940055775185e-07, -5.445260512807920e-10,  4.031440300386876e-11, -1.433235087830696e-13, -3.038782299835505e-14,
  8.535538093008140e-16,  4.810689666272229e-18, -8.267296480202976e-19,  1.561128621589764e-20,  2.838645101110457e-01, -2.882184167559734e-03,  2.794898515517304e-05,
 -1.988551598707845e-07, -1.098488551151136e-09,  6.872276995914164e-11, -2.881978198475344e-13, -4.918517910073708e-14,  1.420365407557886e-15,  6.889631761701993e-18,
 -1.355900518246615e-18,  2.669305119702215e-20,  4.070985717299972e-01, -4.131801247516612e-03,  3.989473431314100e-05, -2.724534794803979e-07, -2.136021036240020e-09,
  1.138163029156206e-10, -5.697236030927261e-13, -7.626542726418467e-14,  2.292104160106404e-15,  8.487197758836068e-18, -2.138445540419359e-18,  4.468059415101612e-20,
  5.601534263893491e-01, -5.681905923640563e-03,  5.450826757703741e-05, -3.484575734654507e-07, -4.120163984957834e-09,  1.895041484412950e-10, -1.147658695665692e-12,
 -1.166797849359165e-13,  3.722974610727396e-15,  7.294648004866798e-18, -3.341054871931024e-18,  7.624045725815296e-20,  7.507938162341845e-01, -7.608626074194665e-03,
  7.222861410417417e-05, -4.091296913041405e-07, -8.169438941793862e-09,  3.303607429221122e-10, -2.477370503336829e-12, -1.813678670573141e-13,  6.379258248668725e-15,
 -5.766035328048570e-18, -5.310681007696568e-18,  1.396208180113449e-19,  9.939910013066452e-01, -1.005622604197364e-02,  9.357453152231673e-05, -3.945624310987506e-07,
 -1.779996787353329e-08,  6.511247989234598e-10, -6.367520538441718e-12, -2.980747281970508e-13,  1.265841225263448e-14, -8.087395701439003e-17, -8.686603550660021e-18,
  3.009252093810290e-19,  1.328095680180180e+00, -1.337857436124300e-02,  1.177043201323766e-04,  3.248311005350803e-08, -5.271786009118065e-08,  1.877240535402729e-09,
 -2.806458156159938e-11, -5.162853385661567e-13,  3.993119313563032e-14, -8.740993441441396e-16, -4.670876443688753e-18,  8.548084597788278e-19,  1.766346142821859e-02,
 -1.728429392838643e-04,  1.657565335453592e-06, -1.381358250010591e-08,  3.090495433218547e-11,  2.479382046323264e-12, -5.242956369883027e-14, -5.265710317567675e-16,
  5.489991064001554e-17, -1.133247735127375e-18, -1.033175783654806e-20,  1.133752028002752e-21,  5.255774528212696e-02, -5.142769107131812e-04,  4.929850301812941e-06,
 -4.093757593194687e-08,  8.379831565751527e-11,  7.650668675522558e-12, -1.613851711120944e-13, -1.562729888748110e-15,  1.668213640595998e-16, -3.472276802210683e-18,
 -3.058914491829567e-20,  3.449141802364340e-21,  1.057914700088285e-01, -1.035109178795213e-03,  9.915875489994600e-06, -8.186989901203299e-08,  1.422764268874230e-10,
  1.628728809667371e-11, -3.424592145795715e-13, -3.126966419497335e-15,  3.470070105256972e-16, -7.319270825483331e-18, -6.089105917218757e-20,  7.186789041756805e-21,
  1.785764003091024e-01, -1.747122374915779e-03,  1.672014430313194e-05, -1.368766815104317e-07,  1.743600406153509e-10,  2.971877545189975e-11, -6.227607849336297e-13,
 -5.211268596952315e-15,  6.137206376354424e-16, -1.319901877629410e-17, -1.003640458302934e-19,  1.273684137511009e-20,  2.727675546488501e-01, -2.668336055016258e-03,
  2.550035095309081e-05, -2.061872402944979e-07,  1.215972020610329e-10,  5.033195904023045e-11, -1.052039473391956e-12, -7.744969332596891e-15,  9.989230943539615e-16,
 -2.208562594176392e-17, -1.455790452199460e-19,  2.077341209616844e-20,  3.911883741224695e-01, -3.826136965660184e-03,  3.649131963509789e-05, -2.897404413963828e-07,
 -1.271908564485374e-10,  8.259901452340029e-11, -1.726406629552935e-12, -1.045042954677131e-14,  1.560422291715064e-15, -3.589029044279410e-17, -1.850880887028557e-19,
  3.248317879530673e-20,  5.382702320071919e-01, -5.263412652153427e-03,  5.004900499061816e-05, -3.864292808706418e-07, -8.023594652230909e-10,  1.357073627694085e-10,
 -2.851775386710238e-12, -1.234256532675868e-14,  2.411016233029570e-15, -5.878923864939737e-17, -1.802317032316172e-19,  5.004399886189776e-20,  7.214813659467408e-01,
 -7.052183246604835e-03,  6.673861675469893e-05, -4.915395668981794e-07, -2.454105575074892e-09,  2.316733457951427e-10, -4.951539314518171e-12, -9.601409512085755e-15,
  3.798833949880547e-15, -1.016480750330713e-16,  1.844609545808097e-20,  7.751196590989478e-20,  9.552276912052112e-01, -9.330485535588875e-03,  8.752794688287657e-05,
 -5.855524578820190e-07, -6.763316314944745e-09,  4.394470252217703e-10, -9.817061541028506e-12,  1.735845977997675e-14,  6.367869425176886e-15, -2.024399682978212e-16,
  1.198285176570347e-18,  1.192063184393703e-19,  1.276450320684300e+00, -1.244711937620326e-02,  1.141456457712696e-04, -5.499305421060972e-07, -2.245646708922937e-08,
  1.145722390077887e-09, -2.928392706253864e-11,  2.772292799613543e-13,  1.142407789732828e-14, -6.015395542937808e-16,  1.218367396111992e-17,  2.475886222098949e-20,
  1.699757714574562e-02, -1.602337500341487e-04,  1.496177973127460e-06, -1.299270569625043e-08,  6.757756978826209e-11,  1.204163422343742e-12, -4.881276378048571e-14,
  5.754415053258811e-16,  1.568000166948065e-17, -8.757075992411144e-19,  1.571882021688480e-20,  1.269334229999917e-22,  5.057644973277773e-02, -4.767700920760697e-04,
  4.450993956492310e-06, -3.858867793906365e-08,  1.971520478931307e-10,  3.737851264134131e-12, -1.494618143344658e-13,  1.775328543055621e-15,  4.715043486007510e-17,
 -2.662391210368508e-18,  4.820401898702824e-20,  3.726626997640797e-22,  1.018035487243029e-01, -9.596514426289059e-04,  8.956364370282511e-06, -7.744444822235401e-08,
  3.841729118235299e-10,  8.025040581110772e-12, -3.145697150512345e-13,  3.781203878290025e-15,  9.642352518774198e-17, -5.542563135651207e-18,  1.017404965668246e-19,
  7.310815964779655e-22,  1.718451502245157e-01, -1.619844082762605e-03,  1.511129463289159e-05, -1.301593902679486e-07,  6.170338751689764e-10,  1.479681914367467e-11,
 -5.654838957144338e-13,  6.914069065211820e-15,  1.662202174613884e-16, -9.813341989812049e-18,  1.837791195880037e-19,  1.175906345891474e-21,  2.624866819740844e-01,
 -2.474129703967534e-03,  2.306648690471058e-05, -1.975786776820447e-07,  8.737068068372434e-10,  2.535498857632119e-11, -9.404912637919609e-13,  1.177322165628313e-14,
  2.604436644132374e-16, -1.599453444236367e-17,  3.081257595083177e-19,  1.633171029075459e-21,  3.764457651893803e-01, -3.548037756281639e-03,  3.304938607949233e-05,
 -2.808241814485497e-07,  1.110847711950358e-09,  4.210884184809017e-11, -1.511322798418481e-12,  1.954186572708012e-14,  3.838918659567549e-16, -2.502518526833196e-17,
  5.017572840946321e-19,  1.893640385473161e-21,  5.179879302160832e-01, -4.881605377376735e-03,  4.541235032571910e-05, -3.812580369603578e-07,  1.236232919173466e-09,
  6.991776402331828e-11, -2.425526227368327e-12,  3.282280840589435e-14,  5.392981068085161e-16, -3.873162961100359e-17,  8.231194055812947e-19,  1.321810460742969e-21,
  6.943025633442242e-01, -6.542225131800701e-03,  6.073678977186548e-05, -5.000807640659663e-07,  1.026312883126505e-09,  1.201024544780255e-10, -4.037820447193864e-12,
  5.844405490844365e-14,  7.084273896837086e-16, -6.109901212124234e-17,  1.421586138049635e-18, -2.335423283991052e-21,  9.192598756657372e-01, -8.659621093527692e-03,
  8.010187695749673e-05, -6.357573328401401e-07, -1.988395798667637e-10,  2.264829775772003e-10, -7.465296915466444e-12,  1.206647049343940e-13,  7.071764607696236e-16,
 -1.022413722692843e-16,  2.798088081863472e-18, -1.985094624928449e-20,  1.228439757660200e+00, -1.156495029927486e-02,  1.060316469877612e-04, -7.609458795157095e-07,
 -5.800757576356533e-09,  5.606542464212765e-10, -1.900681928265484e-11,  3.864825170887670e-13, -2.063341525271401e-15, -1.796611201063649e-16,  7.694593462062309e-18,
 -1.511185968615072e-19,  1.637962142627731e-02, -1.488681480594007e-04,  1.347358211784304e-06, -1.177628158409919e-08,  8.143641049826693e-11,  2.579962328314964e-13,
 -2.953557778661654e-14,  6.953996175373073e-16, -4.590126826093928e-18, -2.795858821510135e-19,  1.177220782351978e-20, -1.990906563810591e-22,  4.873773424323707e-02,
 -4.429562634809382e-04,  4.008743430249907e-06, -3.501211976057562e-08,  2.406193511420899e-10,  8.427427729191811e-13, -9.034739394185154e-14,  2.125529193664136e-15,
 -1.430084717356361e-17, -8.430506347062470e-19,  3.578733552826191e-20, -6.103538140827350e-22,  9.810251949276319e-02, -8.916036362766822e-04,  8.067988245199193e-06,
 -7.038368515973658e-08,  4.788761696031454e-10,  1.938614031912077e-12, -1.898371718102726e-13,  4.462013275225150e-15, -3.091913058261428e-17, -1.731808385318064e-18,
  7.448844339235486e-20, -1.287520932626538e-21,  1.655979234884374e-01, -1.505015485109365e-03,  1.361619227228486e-05, -1.185837893318682e-07,  7.948430443480886e-10,
  3.874119282437902e-12, -3.403699609449488e-13,  7.994384469853711e-15, -5.771355355864556e-17, -3.005653233563506e-18,  1.318410718088159e-19, -2.323548684295271e-21,
  2.529445879827400e-01, -2.298812761102507e-03,  2.079251414219735e-05, -1.806459204836585e-07,  1.184710906622048e-09,  7.233927874919757e-12, -5.638161546544667e-13,
  1.324333097406384e-14, -1.009502014242581e-16, -4.757275155832528e-18,  2.147554457818469e-19, -3.889528572899281e-21,  3.627615577349271e-01, -3.296767884085015e-03,
  2.980809321004823e-05, -2.580822590254368e-07,  1.638772071759639e-09,  1.309632028626077e-11, -9.003646658706664e-13,  2.118810776407608e-14, -1.733919507275591e-16,
 -7.123046018552932e-18,  3.356368896118427e-19, -6.316388004188442e-21,  4.991597216463036e-01, -4.536183335987791e-03,  4.099273923059913e-05, -3.531210950534415e-07,
  2.132329306679721e-09,  2.361777558049142e-11, -1.430498225244199e-12,  3.385328558383001e-14, -3.041079883477326e-16, -1.027847176635337e-17,  5.183657059778479e-19,
 -1.030985907193491e-20,  6.690680405115195e-01, -6.079904315342977e-03,  5.489814045778179e-05, -4.691284990304363e-07,  2.597831095723564e-09,  4.373764666977442e-11,
 -2.340445367657546e-12,  5.613754747548572e-14, -5.722588370469997e-16, -1.428525044969271e-17,  8.141011250042718e-19, -1.762710976587591e-20,  8.858550086381697e-01,
 -8.049089745427979e-03,  7.257481462689819e-05, -6.112779104934457e-07,  2.814233297871658e-09,  8.773096721708797e-11, -4.182789953348733e-12,  1.035809317115893e-13,
 -1.270083418496448e-15, -1.754442373111786e-17,  1.347485498062192e-18, -3.387143006261557e-20,  1.183817345526281e+00, -1.075409165035145e-02,  9.664277110074348e-05,
 -7.853512950307983e-07,  1.670043880954688e-09,  2.227251644453772e-10, -9.730470867934145e-12,  2.640949313091661e-13, -4.473709844781072e-15,  9.666370641238351e-18,
  2.277095617052672e-18, -8.534678272964360e-20,  1.580484307968045e-02, -1.386322199195370e-04,  1.213923415346636e-06, -1.046430300648517e-08,  8.097017790196724e-11,
 -2.402775987157595e-13, -1.308516397525273e-14,  4.613153409759804e-16, -8.257093858848293e-18,  2.271454997926001e-20,  3.837065465113885e-21, -1.370504087202595e-22,
  4.702748140244225e-02, -4.125008380749745e-04,  3.611924475641161e-06, -3.112615212642161e-08,  2.402570484965287e-10, -6.825960981073122e-13, -4.013575218580378e-14,
  1.406469517646897e-15, -2.523565853928298e-17,  7.344236371115536e-20,  1.157841822274040e-20, -4.164364739072915e-22,  9.466002959206424e-02, -8.303063537738683e-04,
  7.269943728379972e-06, -6.261912664913321e-08,  4.814511410299918e-10, -1.269830335601153e-12, -8.466343741052173e-14,  2.940619404251996e-15, -5.297090585156500e-17,
  1.674722432785254e-19,  2.381231469563320e-20, -8.661130989308434e-22,  1.597870180459026e-01, -1.401558407329079e-03,  1.227080769259710e-05, -1.056188943180608e-07,
  8.073817269245148e-10, -1.885848826657337e-12, -1.525390479335629e-13,  5.237567021433337e-15, -9.490568479522281e-17,  3.343148687574860e-19,  4.140032722163849e-20,
 -1.531186034752952e-21,  2.440687522084588e-01, -2.140814598040984e-03,  1.874121348040241e-05, -1.611503345127423e-07,  1.221740812656324e-09, -2.320093258591219e-12,
 -2.540605065769163e-13,  8.604167454658120e-15, -1.572562000835456e-16,  6.326408121314362e-19,  6.569996579035041e-20, -2.489768629822405e-21,  3.500324485201575e-01,
 -3.070232114743679e-03,  2.687378765618226e-05, -2.307523695392674e-07,  1.728714540030100e-09, -2.177696656569664e-12, -4.079197864043151e-13,  1.360324623671542e-14,
 -2.517722539891443e-16,  1.186760248276685e-18,  9.877650565548225e-20, -3.880790407053776e-21,  4.816448876469676e-01, -4.224585952986758e-03,  3.697036093359998e-05,
 -3.167909962495667e-07,  2.331462703110512e-09, -6.592253476711524e-13, -6.508820378937613e-13,  2.135981532711064e-14, -4.028920137658347e-16,  2.291363777231139e-18,
  1.435449703491493e-19, -5.967869889631696e-21,  6.455922030090820e-01, -5.662481609702354e-03,  4.953833231813486e-05, -4.231240836242044e-07,  3.026188826811519e-09,
  4.073676490329597e-12, -1.065750866348012e-12,  3.447184223860430e-14, -6.701391501641998e-16,  4.780316630770818e-18,  2.025136323892491e-19, -9.302187791373513e-21,
  8.547746069597516e-01, -7.496964638388140e-03,  6.555236591265127e-05, -5.567684756578040e-07,  3.774830618714849e-09,  1.727621525657201e-11, -1.887711409912701e-12,
  6.062510302208424e-14, -1.243486740437992e-15,  1.183746837944785e-17,  2.618372895096947e-19, -1.515865445272160e-20,  1.142288574205841e+00, -1.001792465627731e-02,
  8.749096489682153e-05, -7.334509477702469e-07,  4.307735795442455e-09,  6.254543539728638e-11, -4.198471290324865e-12,  1.380389398974711e-13, -3.196421154953412e-15,
  4.649750252853403e-17,  9.326007963014282e-21, -2.447481577892320e-20,  1.526897218306473e-02, -1.294015516505384e-04,  1.095921806146887e-06, -9.220415088052060e-09,
  7.392236579981782e-11, -4.276196486242955e-13, -3.592423107015276e-15,  2.298768764686463e-16, -5.846914886304384e-18,  8.618381870371890e-20,  2.251910760480920e-23,
 -4.375840002783832e-23,  4.543299378998257e-02, -3.850354652360215e-04,  3.260888032484768e-06, -2.743178754534791e-08,  2.197102738160399e-10, -1.259674234920359e-12,
 -1.120464310168668e-14,  7.005157829611865e-16, -1.780634131150811e-17,  2.635436075854458e-19,  1.777265432925743e-23, -1.320387429622762e-22,  9.145054580525248e-02,
 -7.750240893278588e-04,  6.563606268399940e-06, -5.520481100439861e-08,  4.414569998700434e-10, -2.494725282378101e-12, -2.421222710170978e-14,  1.463351588715551e-15,
 -3.716678366802855e-17,  5.536846520664970e-19, -1.315609109621113e-22, -2.715437830811099e-22,  1.543693952040402e-01, -1.308245980440401e-03,  1.107912249110771e-05,
 -9.315751452741112e-08,  7.432400546424741e-10, -4.110454938553401e-12, -4.497339388134006e-14,  2.602566014409716e-15, -6.604982077759922e-17,  9.933248678355779e-19,
 -6.696687382301308e-22, -4.720937436482081e-22,  2.357935680422363e-01, -1.998293105201282e-03,  1.692229223104851e-05, -1.422329001599959e-07,  1.131080076633316e-09,
 -6.060642969844067e-12, -7.761863713685097e-14,  4.265059588433785e-15, -1.082000596263614e-16,  1.649031085962895e-18, -2.103939239252187e-21, -7.491840985617799e-22,
  3.381646193001444e-01, -2.865853904037820e-03,  2.426787143499739e-05, -2.038594573069060e-07,  1.613650198808494e-09, -8.247948261794378e-12, -1.296142771804163e-13,
  6.715910342330070e-15, -1.704835891151074e-16,  2.647244204891410e-18, -5.557167884473898e-21, -1.126493482656374e-21,  4.653148816179358e-01, -3.943400484344955e-03,
  3.339000024419916e-05, -2.802634085345068e-07,  2.203413101662169e-09, -1.045551605101160e-11, -2.155222607921804e-13,  1.047311680381639e-14, -2.666187149230187e-16,
  4.252369698481467e-18, -1.379860235137726e-20, -1.637968406202573e-21,  6.237038930891026e-01, -5.285663160277876e-03,  4.475034135794902e-05, -3.751559907426749e-07,
  2.918363537324825e-09, -1.214709685569356e-11, -3.676291698604489e-13,  1.669494962354788e-14, -4.282556884128294e-16,  7.111825782883099e-18, -3.493129999914687e-20,
 -2.316298261779820e-21,  8.257947389925356e-01, -6.998231020924607e-03,  5.923835080873217e-05, -4.955667811676786e-07,  3.783408894443720e-09, -1.171636360701742e-11,
 -6.750055135001662e-13,  2.864251795106333e-14, -7.487850234588943e-16,  1.329901931135416e-17, -1.006599193056121e-19, -3.035436214162781e-21,  1.103562730481990e+00,
 -9.351965631171756e-03,  7.912977452397956e-05, -6.588690310038121e-07,  4.810787130668074e-09, -1.886597477836392e-12, -1.522445937787512e-12,  6.109388777156307e-14,
 -1.688027121842423e-15,  3.445982973703167e-17, -4.413061550960128e-19, -7.886725973089480e-22,  1.476822747627107e-02, -1.210573212128823e-04,  9.920811118126411e-07,
 -8.108916680549936e-09,  6.493182948722319e-11, -4.549424470976455e-13,  6.756555280488363e-16,  8.984098111081231e-17, -3.041971837406913e-18,  6.433743245838906e-20,
 -8.141695496125597e-22, -2.026254150850282e-24,  4.394302308170818e-02, -3.602073064249102e-04,  2.951935729628853e-06, -2.412696091045118e-08,  1.931201647974947e-10,
 -1.349051231823835e-12,  1.809459873663214e-15,  2.743686963176893e-16, -9.250738981962169e-18,  1.958550018118921e-19, -2.491652162428311e-21, -5.632639802176176e-24,
  8.845143591785430e-02, -7.250489307617314e-04,  5.941812368132776e-06, -4.856048285917738e-08,  3.884523867126714e-10, -2.700602839017601e-12,  2.996884140394623e-15,
  5.749432331137695e-16, -1.926385709536618e-17,  4.085544414089677e-19, -5.241325857943889e-21, -9.972794727762660e-24,  1.493068740888116e-01, -1.223888921817578e-03,
  1.002973875552402e-05, -8.196109743567497e-08,  6.550425541858996e-10, -4.522124217423992e-12,  3.468271996130880e-15,  1.026584619354619e-15, -3.411557804332524e-17,
  7.254606545557148e-19, -9.419878430323985e-21, -1.312162863289175e-23,  2.280607641721597e-01, -1.869443987152381e-03,  1.531984873062327e-05, -1.251722857221641e-07,
  9.991163929962781e-10, -6.828657515547845e-12,  1.856029320428071e-15,  1.689985342818092e-15, -5.560644316250334e-17,  1.187214490404070e-18, -1.567619761552053e-20,
 -1.089838617551898e-23,  3.270745983756448e-01, -2.681070632423156e-03,  2.197062762630928e-05, -1.794758010949697e-07,  1.429991434017713e-09, -9.633951583565165e-12,
 -4.344665093411726e-15,  2.673548751657011e-15, -8.697624606983193e-17,  1.868330999778680e-18, -2.524765593582195e-20,  6.317633867295287e-24,  4.500550430500126e-01,
 -3.689151085253140e-03,  3.023079050060822e-05, -2.468786115802254e-07,  1.961925440633707e-09, -1.293820522656645e-11, -2.006749595627212e-14,  4.185960878189563e-15,
 -1.345343628116228e-16,  2.917637354091629e-18, -4.073198834286111e-20,  6.302158118016737e-23,  6.032498272792250e-01, -4.944895014161945e-03,  4.051943598195246e-05,
 -3.307511184012325e-07,  2.618008060919920e-09, -1.668602138039403e-11, -5.628850565109647e-14,  6.683520285979666e-15, -2.123282072195360e-16,  4.678106670642993e-18,
 -6.850995425486799e-20,  2.325766560109771e-22,  7.987133890292888e-01, -6.547104685592024e-03,  5.364481218953560e-05, -4.375577456526205e-07,  3.439809276253604e-09,
 -2.059011392917127e-11, -1.430332176465405e-13,  1.140578400486722e-14, -3.596607337179032e-16,  8.158359715834846e-18, -1.290225988536200e-19,  8.056374241851940e-22,
  1.067372700662713e+00, -8.749257891269248e-03,  7.167886020036541e-05, -5.836982741386636e-07,  4.519106949474864e-09, -2.297600053296394e-11, -4.054928975770460e-13,
  2.359786754678271e-14, -7.523502158685508e-16,  1.826778037107788e-17, -3.358713578001234e-19,  3.874659825660863e-21,  1.429927924519374e-02, -1.134929211188222e-04,
  9.007120751416026e-07, -7.141234553390357e-09,  5.615031427068019e-11, -4.176233840179197e-13,  2.132188726323749e-15,  2.337551234861176e-17, -1.293050340606670e-18,
  3.410954555510911e-20, -6.333953412741969e-22,  7.098718625414740e-24,  4.254766266582646e-02, -3.376994104621012e-04,  2.680074860490900e-06, -2.124844006193679e-08,
  1.670479523305698e-10, -1.241055377043727e-12,  6.271739206852647e-15,  7.227759265426416e-17, -3.931854288962115e-18,  1.036367194675701e-19, -1.927886042175309e-21,
  2.174170899315232e-23,  8.564276240942438e-02, -6.797437328258465e-04,  5.394620553727422e-06, -4.276905305632036e-08,  3.361559829391214e-10, -2.492998892266778e-12,
  1.239148208638758e-14,  1.542287262143707e-16, -8.185770367472072e-18,  2.155245586649773e-19, -4.020686371438278e-21,  4.579067071160581e-23,  1.445658077388412e-01,
 -1.147413776618631e-03,  9.106141703488135e-06, -7.219159645738279e-08,  5.672162139229400e-10, -4.195753106154501e-12,  2.034519744576767e-14,  2.818820434605262e-16,
 -1.448878881884155e-17,  3.809871032414273e-19, -7.137325548475688e-21,  8.243700381072891e-23,  2.208189627872109e-01, -1.752632004386852e-03,  1.390923367189003e-05,
 -1.102636535280506e-07,  8.659344256897671e-10, -6.382117146021935e-12,  2.984478534593918e-14,  4.771551837950822e-16, -2.358957675648244e-17,  6.195190252972407e-19,
 -1.167584875348210e-20,  1.375000886196234e-22,  3.166887356207148e-01, -2.513546066669183e-03,  1.994787795491217e-05, -1.581225134520099e-07,  1.240946676268968e-09,
 -9.099087087022466e-12,  4.030987051636799e-14,  7.790915091349815e-16, -3.681804834212359e-17,  9.661327364957492e-19, -1.836585331959518e-20,  2.221036916749680e-22,
  4.357640960231710e-01, -3.458640960682423e-03,  2.744805833367894e-05, -2.175518523506960e-07,  1.705696632752059e-09, -1.241367759471060e-11,  5.049880482070122e-14,
  1.262393147613895e-15, -5.671826999364304e-17,  1.488845546900281e-18, -2.866339788789819e-20,  3.596469779829771e-22,  5.840943927147443e-01, -4.635929055265627e-03,
  3.679064538304720e-05, -2.915545261503764e-07,  2.282562506915436e-09, -1.642159109355421e-11,  5.746033129800478e-14,  2.088448536915172e-15, -8.881205870029310e-17,
  2.338564529985435e-18, -4.591773181057266e-20,  6.076390076385583e-22,  7.733513115481498e-01, -6.138045385392436e-03,  4.871039455543596e-05, -3.859134040346807e-07,
  3.013854445578756e-09, -2.125327993947679e-11,  5.274022560346283e-14,  3.685820276236006e-15, -1.479607667975925e-16,  3.935097031137270e-18, -7.993438544985893e-20,
  1.149765735225503e-21,  1.033479855909702e+00, -8.202652747614857e-03,  6.509194948992148e-05, -5.154148415675703e-07,  4.003996268976999e-09, -2.697624571632588e-11,
  4.969331791114048e-16,  7.782699322797180e-15, -2.961085873380879e-16,  8.132776836383875e-18, -1.778211176362069e-19,  2.991993854830492e-21  };
  constexpr double w[3840] = {  3.892137711728037e-04, -2.708094787970480e-05,  1.178198150890901e-06, -4.081764338983649e-08,  1.226646072539391e-09,
 -3.332521479601500e-11,  8.380007228139635e-13, -1.979850643633280e-14,  4.439930027741516e-16, -9.520744382802875e-18,  1.962946672015953e-19, -3.906404068887696e-21,
  2.844441174975575e-03, -2.800076996486012e-04,  1.701420153195039e-05, -8.048812531591202e-07,  3.229154740247860e-08, -1.147515982948470e-09,  3.706635466717444e-11,
 -1.106930235913372e-12,  3.092689957323101e-14, -8.154775428583683e-16,  2.042794866580553e-17, -4.884340989415725e-19,  9.027558233827091e-03, -1.255549775595396e-03,
  1.032299456958094e-04, -6.391612654812562e-06,  3.270686873056508e-07, -1.451723109055167e-08,  5.754863733265920e-10, -2.077353137108676e-11,  6.922418883581094e-13,
 -2.151190127021959e-14,  6.282683798728304e-16, -1.733916534391066e-17,  1.882937005873960e-02, -3.543890798313915e-03,  3.781759199989134e-04, -2.948262514480226e-05,
  1.855753374175686e-06, -9.941979630121049e-08,  4.682005287245554e-09, -1.980480633124450e-10,  7.641187489491366e-12, -2.720010648689859e-13,  9.012142983958332e-15,
 -2.796488688183969e-16,  2.999111791034995e-02, -7.244952871816131e-03,  9.630061705472374e-04, -9.124797538468731e-05,  6.844436458617494e-06, -4.298980112532289e-07,
  2.340881844647412e-08, -1.131231344083544e-09,  4.933693398096460e-11, -1.966543077639510e-12,  7.233973713303065e-14, -2.472534810603830e-15,  3.909876601668663e-02,
 -1.151192871480921e-02,  1.831977317442661e-03, -2.040292605685801e-04,  1.770622571069981e-05, -1.269442363947199e-06,  7.798582197261140e-08, -4.208518816939169e-09,
  2.031169708773471e-10, -8.886672311765159e-12,  3.561904879022085e-13, -1.317507550593771e-14,  4.299973929440186e-02, -1.472025305135418e-02,  2.700549123403511e-03,
 -3.422716061082816e-04,  3.339899627283831e-05, -2.663935501584282e-06,  1.803604480948463e-07, -1.063745300908228e-08,  5.569151083704292e-10, -2.625384656091259e-11,
  1.126940916943238e-12, -4.438889217663343e-14,  3.984989357396956e-02, -1.521079664514853e-02,  3.103668863476666e-03, -4.338131182931941e-04,  4.628526648055233e-05,
 -4.004748832822005e-06,  2.920342628615128e-07, -1.843231110018983e-08,  1.026748887397066e-09, -5.123013801813556e-11,  2.316466996089035e-12, -9.568973078224373e-14,
  2.956555643738638e-02, -1.212579289219867e-02,  2.659650241343008e-03, -3.976015034336957e-04,  4.511856503688506e-05, -4.129918157249482e-06,  3.170487865435982e-07,
 -2.097305225097459e-08,  1.219487488201607e-09, -6.328095354964606e-11,  2.965894209847202e-12, -1.265958231633360e-13,  1.379251055936107e-02, -5.879483514017367e-03,
  1.341776130801360e-03, -2.081822769677966e-04,  2.444563367620124e-05, -2.308756800560752e-06,  1.823810920806296e-07, -1.238383960434794e-08,  7.374425435016569e-10,
 -3.910980860235040e-11,  1.869883286561579e-12, -8.127572698948336e-14,  2.970511845390993e-04, -1.932534767993508e-05,  7.872361703413082e-07, -2.559376792281286e-08,
  7.234859102390918e-10, -1.852982492520331e-11,  4.401540314010025e-13, -9.841146733398262e-15,  2.092005411521082e-16, -4.258865845921754e-18,  8.348038401943297e-20,
 -1.581609077706446e-21,  1.945907225110002e-03, -1.752204888756189e-04,  9.830212500267915e-06, -4.323097869351581e-07,  1.620711228640613e-08, -5.403982253890120e-10,
  1.643459722712392e-11, -4.634479405701077e-13,  1.225869111060873e-14, -3.067305604880378e-16,  7.306807091536641e-18, -1.664695217438432e-19,  5.272907641554529e-03,
 -6.655618713403090e-04,  5.032967473450809e-05, -2.891279581772252e-06,  1.381567215304655e-07, -5.755424089817023e-09,  2.150384020054602e-10, -7.342438763578840e-12,
  2.321686377506517e-13, -6.865276041535742e-15,  1.912752513573788e-16, -5.047837826652349e-18,  9.017872776958678e-03, -1.548017240919369e-03,  1.525302821833764e-04,
 -1.107616764724069e-05,  6.537225637880155e-07, -3.301534054293383e-08,  1.472240522889833e-09, -5.919413985971256e-11,  2.178108887473353e-12, -7.416307928998901e-14,
  2.356689708722496e-15, -7.031084298164277e-17,  1.144862664531467e-02, -2.557083677473840e-03,  3.170442244078994e-04, -2.823181387623961e-05,  2.002113530821793e-06,
 -1.194826255716410e-07,  6.207648656803462e-09, -2.872615276299402e-10,  1.203519332379478e-11, -4.621273089461455e-13,  1.641758550580294e-14, -5.432073226972643e-16,
  1.175274173593289e-02, -3.258232484595488e-03,  4.906771875621319e-04, -5.200196877488803e-05,  4.315042071300382e-06, -2.970135148806345e-07,  1.757956440039771e-08,
 -9.168095375543901e-10,  4.287686481902982e-11, -1.822143844977236e-12,  7.109257448764036e-14, -2.564809527106011e-15,  1.025186761926043e-02, -3.368378255521349e-03,
  5.943401200992175e-04, -7.270697645535302e-05,  6.870768795952224e-06, -5.322770584526340e-07,  3.509265015765866e-08, -2.020031578207293e-09,  1.034254095995459e-10,
 -4.776677152006689e-12,  2.011985593140802e-13, -7.788106635275380e-15,  7.750202527521273e-03, -2.888150492196509e-03,  5.755905331303777e-04, -7.872932292535207e-05,
  8.235934507655597e-06, -6.999238870025900e-07,  5.021141012217371e-08, -3.122148846672271e-09,  1.715492156371723e-10, -8.452558600311720e-12,  3.778018591032531e-13,
 -1.544126332100531e-14,  4.919998846180197e-03, -1.995579288054185e-03,  4.328112431356466e-04, -6.402785848885677e-05,  7.196047012873921e-06, -6.529038308937919e-07,
  4.971907987240283e-08, -3.264647225664662e-09,  1.885335514903020e-10, -9.721957495196309e-12,  4.530177081854273e-13, -1.923323890908750e-14,  2.092814724352048e-03,
 -8.889062428738760e-04,  2.020894485512835e-04, -3.124100514130438e-05,  3.655903385393420e-06, -3.441744539669887e-07,  2.710670299099988e-08, -1.835401915690831e-09,
  1.090080705443871e-10, -5.766866324273535e-12,  2.750778454155812e-13, -1.193024254821323e-14,  2.306453203285133e-04, -1.408402289356361e-05,  5.389683547883070e-07,
 -1.649049451659192e-08,  4.395892711388518e-10, -1.063787847725991e-11,  2.391867930830798e-13, -5.070372517605820e-15,  1.023457197194655e-16, -1.981132722191104e-18,
  3.697214817536827e-20, -6.677232737401248e-22,  1.374745766912317e-03, -1.136225611817485e-04,  5.900749419490107e-06, -2.417568593808302e-07,  8.484491932436013e-09,
 -2.658507187252699e-10,  7.622053035954137e-12, -2.031853746689874e-13,  5.092853753185588e-15, -1.210149410279617e-16,  2.743024875644056e-18, -5.957483936473225e-20,
  3.239650489233855e-03, -3.713481739438504e-04,  2.584699792571558e-05, -1.378505973045945e-06,  6.153708376100462e-08, -2.406683363621622e-09,  8.475997945638154e-11,
 -2.737448982143862e-12,  8.212000791409049e-14, -2.309982183417483e-15,  6.137165422089041e-17, -1.547951036653129e-18,  4.622242674479877e-03, -7.216442791100795e-04,
  6.554561570214045e-05, -4.427307386831937e-06,  2.446997851351726e-07, -1.163518014350559e-08,  4.906620405706856e-10, -1.872733450821595e-11,  6.563086175631578e-13,
 -2.134635616766116e-14,  6.496716956603385e-16, -1.860959337720808e-17,  4.729560950679668e-03, -9.712709288996659e-04,  1.118859377401751e-04, -9.332286822271027e-06,
  6.238838296668820e-07, -3.528109256090452e-08,  1.744536308394255e-09, -7.712088332156733e-11,  3.096784341356905e-12, -1.142993140783475e-13,  3.913326580386464e-15,
 -1.250848217399489e-16,  3.825928326184545e-03, -9.919550186562956e-04,  1.406178019342975e-04, -1.411777474275300e-05,  1.115710563926332e-06, -7.346980566357602e-08,
  4.176061711394853e-09, -2.098465460369391e-10,  9.483558913248469e-12, -3.904593555960524e-13,  1.479326491857338e-14, -5.193579024208708e-16,  2.617693750689255e-03,
 -8.203486631574813e-04,  1.384845939948320e-04, -1.627770106174247e-05,  1.483740562153260e-06, -1.112477512459958e-07,  7.119407606071511e-09, -3.988174566360596e-10,
  1.991654322154543e-11, -8.989921463240972e-13,  3.707475095261678e-14, -1.407432631996288e-15,  1.581760597849262e-03, -5.729590296242195e-04,  1.110877974073445e-04,
 -1.481740456640071e-05,  1.515133611317882e-06, -1.261276802565144e-07,  8.879690140178073e-09, -5.427563273454379e-10,  2.935853988172609e-11, -1.425925160257794e-12,
  6.289896916202594e-14, -2.539809907483801e-15,  8.398332420545381e-04, -3.361446395900745e-04,  7.193892804210114e-05, -1.051161760534852e-05,  1.168130672696518e-06,
 -1.048998715669263e-07,  7.913467488970822e-09, -5.151653863957822e-10,  2.951733624641399e-11, -1.511119330164093e-12,  6.994653980697997e-14, -2.951482652787610e-15,
  3.203715423396997e-04, -1.355025347703866e-04,  3.067052168146557e-05, -4.721512907444362e-06,  5.503603712109679e-07, -5.162303485381909e-08,  4.051935217539899e-09,
 -2.734873420450557e-10,  1.619479376861485e-11, -8.543771194039448e-13,  4.064742973780791e-14, -1.758593427012779e-15,  1.818292182966616e-04, -1.045860995322876e-05,
  3.771547944295982e-07, -1.088959285410092e-08,  2.744029735510960e-10, -6.287914428962812e-12,  1.340902638570434e-13, -2.699922137133611e-15,  5.183480019998947e-17,
 -9.555424032705604e-19,  1.700205753714130e-20, -2.930896144686190e-22,  9.990903202982651e-04, -7.606104888791541e-05,  3.666325529271340e-06, -1.402499611263132e-07,
  4.616437318514345e-09, -1.361543076566205e-10,  3.685259817788472e-12, -9.298176329306910e-14,  2.210796155949015e-15, -4.993221453175920e-17,  1.077754118025167e-18,
 -2.232791346485863e-20,  2.082619695589134e-03, -2.170531209348168e-04,  1.392190019050558e-05, -6.900135859986167e-07,  2.879840000613831e-08, -1.057981238161306e-09,
  3.513639878983146e-11, -1.073615691113279e-12,  3.055872628687433e-14, -8.176884649529488e-16,  2.071296919898476e-17, -4.991870380509245e-19,  2.522899772604341e-03,
 -3.574990259453123e-04,  2.990128532168797e-05, -1.877106053133719e-06,  9.707827184472696e-08, -4.342234460472809e-09,  1.730137529694230e-10, -6.262597226296325e-12,
  2.088239444307388e-13, -6.481014642286841e-15,  1.887067792592294e-16, -5.183851499842798e-18,  2.109247598851603e-03, -3.962528319160547e-04,  4.226539196509869e-05,
 -3.292840287878258e-06,  2.069977372316923e-07, -1.106673331094460e-08,  5.196599418696824e-10, -2.189965660865828e-11,  8.411120774005854e-13, -2.978170921519070e-14,
  9.807709201070681e-16, -3.022794396259797e-17,  1.351140067180339e-03, -3.253750295575170e-04,  4.319296444612932e-05, -4.090307681246516e-06,  3.066967321682832e-07,
 -1.925505490226511e-08,  1.047769577033812e-09, -5.058263611040482e-11,  2.203011647942210e-12, -8.765122073266901e-14,  3.216975202512689e-15, -1.096565251875302e-16,
  7.197578536907946e-04, -2.136700176080288e-04,  3.431485209668717e-05, -3.856851095886979e-06,  3.376796908089340e-07, -2.441253546350708e-08,  1.511387547659410e-09,
 -8.214194872907777e-11,  3.989882440565225e-12, -1.755611804203103e-13,  7.072026428038484e-15, -2.627141051926442e-16,  3.409986971137755e-04, -1.194429503413312e-04,
  2.242659050883959e-05, -2.905504097153496e-06,  2.893913144696551e-07, -2.352472690952550e-08,  1.620884140952703e-09, -9.714997675870610e-11,  5.161789615981503e-12,
 -2.466327415481652e-13,  1.071701715591297e-14, -4.268232182184564e-16,  1.477095843761185e-04, -5.818269756950008e-05,  1.225559420066116e-05, -1.764795547365468e-06,
  1.935298361359255e-07, -1.717096679390679e-08,  1.281225540523840e-09, -8.257850039532635e-11,  4.688503671211513e-12, -2.380271306096593e-13,  1.093357922923210e-14,
 -4.581194856853927e-16,  4.954901902497645e-05, -2.085315621135888e-05,  4.695807776155975e-06, -7.193774849259864e-07,  8.347511357809546e-08, -7.797065249028680e-09,
  6.096218383260873e-10, -4.099833140992057e-11,  2.419604111255917e-12, -1.272497524737950e-13,  6.036260568248450e-15, -2.604424533429410e-16,  1.452957061112606e-04,
 -7.897971262248758e-06,  2.691758228377561e-07, -7.353054452122213e-09,  1.755520128541407e-10, -3.817135735053091e-12,  7.735078269957627e-14, -1.481957133238737e-15,
  2.710539329656165e-17, -4.765732524648567e-19,  8.096266528848242e-21, -1.333926193545974e-22,  7.443827835486458e-04, -5.238638131495548e-05,  2.350095092044236e-06,
 -8.412612172542649e-08,  2.602146042205397e-09, -7.236065499475259e-11,  1.851767606878723e-12, -4.427844653003975e-14,  9.998232350793667e-16, -2.148547049630479e-17,
  4.419869465980275e-19, -8.740897699905045e-21,  1.393976446878893e-03, -1.323195907735669e-04,  7.832729940460991e-06, -3.612307025950976e-07,  1.411005981856159e-08,
 -4.873338090061765e-10,  1.527192398810602e-11, -4.417038865155485e-13,  1.193292163836665e-14, -3.037948981186862e-16,  7.337799519478284e-18, -1.689679208383055e-19,
  1.458781904338711e-03, -1.873680249849901e-04,  1.442512569875921e-05, -8.413609336899217e-07,  4.070034976346676e-08, -1.711788968977722e-09,  6.440905192043268e-11,
 -2.209709834873530e-12,  7.005738980245937e-14, -2.073150342854684e-15,  5.770154341958249e-17, -1.518744873080202e-18,  1.012040797231550e-03, -1.731514986983505e-04,
  1.705301122565588e-05, -1.238144790923225e-06,  7.303992744624047e-08, -3.684672102824076e-09,  1.640065887179214e-10, -6.576979889307038e-12,  2.411881259289866e-13,
 -8.178261847650577e-15,  2.586128803615038e-16, -7.672514654125428e-18,  5.178821115520481e-04, -1.150515726165280e-04,  1.423200375124043e-05, -1.266073653176334e-06,
  8.974958035426958e-08, -5.354852245128996e-09,  2.781266857067806e-10, -1.286402079173549e-11,  5.385262478607833e-13, -2.065450493326990e-14,  7.326387464645206e-16,
 -2.419320304211758e-17,  2.141436478350244e-04, -5.977330034561187e-05,  9.078358235658128e-06, -9.708381029534127e-07,  8.128972714614596e-08, -5.644656617067599e-09,
  3.368956940832155e-10, -1.770776312361477e-11,  8.341586802396337e-13, -3.568426116532423e-14,  1.400570000713611e-15, -5.079632563094555e-17,  7.819636659583889e-05,
 -2.632583632958321e-05,  4.761807072499115e-06, -5.965214060949160e-07,  5.764605498004244e-08, -4.560205722300905e-09,  3.065588440260869e-10, -1.796757226120068e-11,
  9.353943684922026e-13, -4.386875990006630e-14,  1.873985555748390e-15, -7.347642720281044e-17,  2.691013541959488e-05, -1.039660681784508e-05,  2.148753416740409e-06,
 -3.041001373477653e-07,  3.282948812724853e-08, -2.871848984094406e-09,  2.115557716161043e-10, -1.347757319700400e-11,  7.571416664123176e-13, -3.806872116323678e-14,
  1.733241570737590e-15, -7.203709564006154e-17,  7.756095608047932e-06, -3.244992311367847e-06,  7.263017543941175e-07, -1.106343019940821e-07,  1.277036900935339e-08,
 -1.187053007448988e-09,  9.239651114419780e-11, -6.188206376296555e-12,  3.638135284528561e-13, -1.906541433088661e-14,  9.014028742917809e-16, -3.877253905544287e-17,
  1.175123123758623e-04, -6.054971401580061e-06,  1.955648763256529e-07, -5.066626538459092e-09,  1.148589922996134e-10, -2.374513801866161e-12,  4.580700770175221e-14,
 -8.364861775550322e-16,  1.459872311146563e-17, -2.451775306066255e-19,  3.982341830761798e-21, -6.279119226375659e-23,  5.669168992084277e-04, -3.701204782290229e-05,
  1.549438485426290e-06, -5.201935841816084e-08,  1.514976576487304e-09, -3.978945930798707e-11,  9.641861653493767e-13, -2.187926250842286e-14,  4.697519457965957e-16,
 -9.614951427124464e-18,  1.886909356232167e-19, -3.565157963488751e-21,  9.671506913498427e-04, -8.378837189456232e-05,  4.585527638441801e-06, -1.970693238624825e-07,
  7.213345364404994e-09, -2.344604647031663e-10,  6.938902713294694e-12, -1.900940671181274e-13,  4.876898740337195e-15, -1.181764953827029e-16,  2.722496052437299e-18,
 -5.990914849941574e-20,  8.889458476871604e-04, -1.034266756606218e-04,  7.330149543416016e-06, -3.972799754254386e-07,  1.797678135412480e-08, -7.108725580802612e-10,
  2.525426951701552e-11, -8.209331204192752e-13,  2.473695973570118e-14, -6.976294727241832e-16,  1.855005684001557e-17, -4.675120642267586e-19,  5.202822945224025e-04,
 -8.076013125198757e-05,  7.328278759319453e-06, -4.950046334620994e-07,  2.735997066725160e-08, -1.300443300403323e-09,  5.478734352490673e-11, -2.087657335469153e-12,
  7.299066051818475e-14, -2.366711873999377e-15,  7.175745991972958e-17, -2.046256262779190e-18,  2.152653452744839e-04, -4.382944390256107e-05,  5.029552116252977e-06,
 -4.187670988963624e-07,  2.797465813389889e-08, -1.581559837037491e-09,  7.819381287812928e-11, -3.456147193053728e-12,  1.387335021211791e-13, -5.117389001368054e-15,
  1.750426087307872e-16, -5.587757016347628e-18,  6.921041330564967e-05, -1.802127321077773e-05,  2.572838361750834e-06, -2.604621309283990e-07,  2.076554539034445e-08,
 -1.379565741537584e-09,  7.909724695362498e-11, -4.007805905893968e-12,  1.825534837978834e-13, -7.571493703339192e-15,  2.888083011237748e-16, -1.020206014791214e-17,
  1.921281248140903e-05, -6.173312419543810e-06,  1.069384754363183e-06, -1.288858546147373e-07,  1.203203798061930e-08, -9.227166402949861e-10,  6.031467941430406e-11,
 -3.446355596637823e-12,  1.753153430796785e-13, -8.050249794056265e-15,  3.373060011991958e-16, -1.299322418783875e-17,  5.110174497312904e-06, -1.928345049621391e-06,
  3.895754857998468e-07, -5.400877156005398e-08,  5.723534602600477e-09, -4.924096138679036e-10,  3.573276141210656e-11, -2.245707454779437e-12,  1.246134461003041e-13,
 -6.195603179447150e-15,  2.792078147022405e-16, -1.149649250637962e-17,  1.231508660196111e-06, -5.115872378502882e-07,  1.136802892121179e-07, -1.720027673215568e-08,
  1.973179609660475e-09, -1.823796184918172e-10,  1.412239772685094e-11, -9.413393288063844e-13,  5.509990281426137e-14, -2.875764268311837e-15,  1.354534743351144e-16,
 -5.806030067479299e-18,  9.607619334920499e-05, -4.705666013873835e-06,  1.443984504088180e-07, -3.556180769041097e-09,  7.670707195386068e-11, -1.510592641045513e-12,
  2.779018750549035e-14, -4.844927675137094e-16,  8.080456708399430e-18, -1.298152475070883e-19,  2.018701038011749e-21, -3.049808980260300e-23,  4.402174269988677e-04,
 -2.675462970753750e-05,  1.047952048371247e-06, -3.307011710359895e-08,  9.085592633784405e-10, -2.257624822494775e-11,  5.188248745921341e-13, -1.118819433510125e-14,
  2.286872794694487e-16, -4.463401709889243e-18,  8.364656295007257e-20, -1.511289227174247e-21,  6.927528925270167e-04, -5.490689276639801e-05,  2.783465274480224e-06,
 -1.116574283658661e-07,  3.835173553610465e-09, -1.174535825869146e-10,  3.286049375192588e-12, -8.534029496385183e-14,  2.080596842644471e-15, -4.801435524757372e-17,
  1.055475928143115e-18, -2.220254767870323e-20,  5.680356861040139e-04, -5.986496812919573e-05,  3.908018637490155e-06, -1.969193120083195e-07,  8.338167813304698e-09,
 -3.100867674427608e-10,  1.040204757945907e-11, -3.203822266901360e-13,  9.174228958795041e-15, -2.465174764015924e-16,  6.260214836372274e-18, -1.510100744463288e-19,
  2.852578479648558e-04, -4.004710269662608e-05,  3.343171858057214e-06, -2.098427483070787e-07,  1.085545979367423e-08, -4.856202749652710e-10,  1.934369937487593e-11,
 -6.995951542765854e-13,  2.329344379229413e-14, -7.213912171132305e-16,  2.094585353201945e-17, -5.733990849439542e-19,  9.683842850786286e-05, -1.795929308505683e-05,
  1.904248396433372e-06, -1.479197742778326e-07,  9.285733727569815e-09, -4.961630909113408e-10,  2.329452545602676e-11, -9.816614635196533e-13,  3.770098087206818e-14,
 -1.334614113841708e-15,  4.393169956845548e-17, -1.352993918129926e-18,  2.436470254724360e-05, -5.869749304259436e-06,  7.829836147052380e-07, -7.466517173371291e-08,
  5.643598611483299e-09, -3.573423687762527e-10,  1.961328678545575e-11, -9.549522343192876e-13,  4.193483232857004e-14, -1.681624548810831e-15,  6.217756009029842e-17,
 -2.134072264417604e-18,  5.094493782370686e-06, -1.549770395798181e-06,  2.554323854953588e-07, -2.945659471956538e-08,  2.643945565316901e-09, -1.957458233260287e-10,
  1.239565047211263e-11, -6.882240155294844e-13,  3.410713408368676e-14, -1.529269463763468e-15,  6.269416255779526e-17, -2.367274687431031e-18,  1.018940566457945e-06,
 -3.736047496878306e-07,  7.344080136104930e-08, -9.934374669617277e-09,  1.029947507816144e-09, -8.688723985131611e-11,  6.195060324378409e-12, -3.832105578695414e-13,
  2.096106963247320e-14, -1.028664445714844e-15,  4.581078511047359e-17, -1.866019672096796e-18,  1.988960361727818e-07, -8.191167907817623e-08,  1.804405342010688e-08,
 -2.708307862208605e-09,  3.084279509591868e-10, -2.831879485144984e-11,  2.179586807883111e-12, -1.444792640562665e-13,  8.414022714828684e-15, -4.370958085446461e-16,
  2.049940033728395e-17, -8.751899783942182e-19,  7.932033403999249e-05, -3.702392367043080e-06,  1.081971069876674e-07, -2.538461028110159e-09,  5.220055637201472e-11,
 -9.810184139187722e-13,  1.723945517478160e-14, -2.873965053827068e-16,  4.587156173374638e-18, -7.059234124186570e-20,  1.052524103414041e-21, -1.524815824720782e-23,
  3.477614130486618e-04, -1.974164558634146e-05,  7.253645757684670e-07, -2.156215288781865e-08,  5.598959016087623e-10, -1.318498786288152e-11,  2.877986245972010e-13,
 -5.906103030409998e-15,  1.150738850942372e-16, -2.144103900172557e-18,  3.841187457595444e-20, -6.642602775828825e-22,  5.104428618111116e-04, -3.710979698669552e-05,
  1.746180167841894e-06, -6.549722808476604e-08,  2.114233243954251e-09, -6.108629989867389e-11,  1.617413497550365e-12, -3.985817749767045e-14,  9.241935032486441e-16,
 -2.032542751417996e-17,  4.265850944234264e-19, -8.582007852672961e-21,  3.788137450644093e-04, -3.618120778447720e-05,  2.177635753195425e-06, -1.021017258085211e-07,
  4.048341439552192e-09, -1.416593225313915e-10,  4.488805531491276e-12, -1.310253105392830e-13,  3.565857953652459e-15, -9.129321861696669e-17,  2.213878932585896e-18,
 -5.110355934916225e-20,  1.659798208254887e-04, -2.102358597935530e-05,  1.613259444605371e-06, -9.403411993235009e-08,  4.550038621575221e-09, -1.914463824963979e-10,
  7.204929230197015e-12, -2.471293390715591e-13,  7.829300802709137e-15, -2.313809796242512e-16,  6.427566142812385e-18, -1.687471943648409e-19,  4.700067007298279e-05,
 -7.894653035170162e-06,  7.709017496856816e-07, -5.571968797241855e-08,  3.279295898402372e-09, -1.652476017877084e-10,  7.352117589305731e-12, -2.948119602175779e-13,
  1.081180273835857e-14, -3.666203983222708e-16,  1.159209799000165e-17, -3.438074727646349e-19,  9.354973800199359e-06, -2.067858400603216e-06,  2.562338805819368e-07,
 -2.290763391607895e-08,  1.634855528272676e-09, -9.829825352082590e-11,  5.147607866062840e-12, -2.400924259204839e-13,  1.013508213100822e-14, -3.918924043812417e-16,
  1.401001345451141e-17, -4.660830849479230e-19,  1.467828435839771e-06, -4.189439747205920e-07,  6.523668813588335e-08, -7.156312037418968e-09,  6.144837878550648e-10,
 -4.372648877475482e-11,  2.672007777878555e-12, -1.436441230489654e-13,  6.913045741926821e-15, -3.017810294114159e-16,  1.207273244654464e-17, -4.457532860813240e-19,
  2.151374809099153e-07, -7.615436759087716e-08,  1.448552321959458e-08, -1.902961103430337e-09,  1.922353815479593e-10, -1.584679738167946e-11,  1.106777137484656e-12,
 -6.720406581090300e-14,  3.614990538644251e-15, -1.747406106266495e-16,  7.675737391137731e-18, -3.087786666002884e-19,  3.279028245112422e-08, -1.336040758553948e-08,
  2.912119778693954e-09, -4.328836976927262e-10,  4.886886024461701e-11, -4.451713640026840e-12,  3.401928946531829e-13, -2.240470932197513e-14,  1.297086623098596e-15,
 -6.701807397824441e-17,  3.127512777873691e-18, -1.329163507145787e-19,  6.606724304497365e-05, -2.945820652382102e-06,  8.216535767091976e-08, -1.840199872647471e-09,
  3.614256460339608e-11, -6.493366675498231e-13,  1.091649078763421e-14, -1.742935348876808e-16,  2.666100757995096e-18, -3.934048483415174e-20,  5.636564704747200e-22,
 -7.829547774941977e-24,  2.789532814415174e-04, -1.483927520949562e-05,  5.127449063523992e-07, -1.438768643777025e-08,  3.537551280918608e-10, -7.908143861983373e-12,
  1.642009345402038e-13, -3.211182781970446e-15,  5.971528468200405e-17, -1.063385906557965e-18,  1.823226568240765e-20, -3.020501221927254e-22,  3.856694390009788e-04,
 -2.578996616977748e-05,  1.128785953901112e-06, -3.966115465415876e-08,  1.205067016065420e-09, -3.289320664555729e-11,  8.252237793689272e-13, -1.931687728282126e-14,
  4.263718240153524e-16, -8.943350967264644e-18,  1.793278675550889e-19, -3.452300697999928e-21,  2.624833684098710e-04, -2.274251821662458e-05,  1.263597379293788e-06,
 -5.518938393927207e-08,  2.050974581101973e-09, -6.757771122084319e-11,  2.023905885443378e-12, -5.601159734823942e-14,  1.449197574170710e-15, -3.535750115273626e-17,
  8.188552429421322e-19, -1.808754194506043e-20,  1.019793555869132e-04, -1.163340370256042e-05,  8.203458510897972e-07, -4.439664455831847e-08,  2.008925471511720e-09,
 -7.947893512426452e-11,  2.824934674422998e-12, -9.185138918786491e-14,  2.767297179353025e-15, -7.799285351118903e-17,  2.071390640372553e-18, -5.211367876556955e-20,
  2.451421572802864e-05, -3.710442359608252e-06,  3.328074944046517e-07, -2.233636449441849e-08,  1.230182556774865e-09, -5.836055968397583e-11,  2.456499403910988e-12,
 -9.357464034050581e-14,  3.271630467965715e-15, -1.060947085482580e-16,  3.217077360580710e-18, -9.173872543293826e-20,  3.916817845696232e-06, -7.878279631967572e-07,
  9.019667558295486e-08, -7.527098437204996e-09,  5.053083630980404e-10, -2.875362567823215e-11,  1.432169952883933e-12, -6.380400775571461e-14,  2.582050128932607e-15,
 -9.602071172587550e-17,  3.310811073316335e-18, -1.065098630249223e-19,  4.622786930299242e-07, -1.225673601945223e-07,  1.789822595235162e-08, -1.856319947717329e-09,
  1.516917741563601e-10, -1.032770271801492e-11,  6.065130013710674e-13, -3.145427030058383e-14,  1.465113980779466e-15, -6.207909050053676e-17,  2.416602100694025e-18,
 -8.702300095286068e-20,  4.855767036815338e-08, -1.646279897869115e-08,  3.010166919901214e-09, -3.819284803749984e-10,  3.741764515562904e-11, -3.001892888761977e-12,
  2.046503086314799e-13, -1.216036111362537e-14,  6.415114520734582e-16, -3.046912319063986e-17,  1.317267281854916e-18, -5.223173837813869e-20,  5.543258649438039e-09,
 -2.228552417527490e-09,  4.794532499533682e-10, -7.043521564163065e-11,  7.868138029808325e-12, -7.100140093252356e-13,  5.379979095709132e-14, -3.516171755282429e-15,
  2.021562770953466e-16, -1.037933399795100e-17,  4.815859439826482e-19, -2.035940563203706e-20,  5.547143567373329e-05, -2.367898701817019e-06,  6.316604454258145e-08,
 -1.353078784084780e-09,  2.542527953607808e-11, -4.374311111253741e-13,  7.045295229769083e-15, -1.078805277156230e-16,  1.584628801443443e-18, -2.240845496951621e-20,
  3.096886052322777e-22, -4.129529143039491e-24,  2.268282133774250e-04, -1.134247021213263e-05,  3.694522960472201e-07, -9.805883249008833e-09,  2.286998218630032e-10,
 -4.861264164382748e-12,  9.615608560604197e-14, -1.794456181053431e-15,  3.189145669292568e-17, -5.433095503574612e-19,  8.926415068198529e-21, -1.418113338277461e-22,
  2.979605433028503e-04, -1.837945434363104e-05,  7.498716295442768e-07, -2.472643853106406e-08,  7.083107030043042e-10, -1.829101334139625e-11,  4.353464128824160e-13,
 -9.690547809082938e-15,  2.038122809974896e-16, -4.080873757090550e-18,  7.823612521064152e-20, -1.442227617010317e-21,  1.882073816676787e-04, -1.481284683228135e-05,
  7.609070946272674e-07, -3.099911617731589e-08,  1.080929412032006e-09, -3.356702465012432e-11,  9.508875927874469e-13, -2.496569076254668e-14,  6.143839081907857e-16,
 -1.429000251831927e-17,  3.161368188831362e-19, -6.683274403470086e-21,  6.583488800889433e-05, -6.755833716580757e-06,  4.379008872735318e-07, -2.200952652356454e-08,
  9.314918605214200e-10, -3.465299437737502e-11,  1.163159473881625e-12, -3.584426587742581e-14,  1.026685957107609e-15, -2.758475785234595e-17,  7.001089303997921e-19,
 -1.687030314802072e-20,  1.367693293314960e-05, -1.857107158178992e-06,  1.527216533577051e-07, -9.503656202449029e-09,  4.891683262741151e-10, -2.181955405458711e-11,
  8.677739776294287e-13, -3.136131315324916e-14,  1.043955089095700e-15, -3.233269367801452e-17,  9.389513425309772e-19, -2.570842224435453e-20,  1.785289258941791e-06,
 -3.241358626681103e-07,  3.412383164078629e-08, -2.648080323255559e-09,  1.666682884113671e-10, -8.948584763966304e-12,  4.227514293659067e-13, -1.794210449282516e-14,
  6.943318469636822e-16, -2.477327853931105e-17,  8.219534558293589e-19, -2.551334592511073e-20,  1.598860409776771e-07, -3.895925453162250e-08,  5.294859814782279e-09,
 -5.160352410333806e-10,  3.992117727611909e-11, -2.588523918810347e-12,  1.454917645883185e-13, -7.251694403496890e-15,  3.258004301836738e-16, -1.335688869616231e-17,
  5.044789088665343e-19, -1.767001332467644e-20,  1.183771619493134e-08, -3.806937596464693e-09,  6.639656287351964e-10, -8.084642082790874e-11,  7.640219679773823e-12,
 -5.937784851445318e-13,  3.935417966766311e-14, -2.280275405157407e-15,  1.176068297189862e-16, -5.473282776356426e-18,  2.323105431517274e-19, -9.059309232689541e-21,
  9.665719002415829e-10, -3.820298829393135e-10,  8.086372320729123e-11, -1.170833969202475e-11,  1.291214385820024e-12, -1.151972649773598e-13,  8.640558108765324e-15,
 -5.595985302009223e-16,  3.191048869810830e-17, -1.626282759327663e-18,  7.495083813386457e-20, -3.149260720698840e-21,  4.691661971958707e-05, -1.921212369577500e-06,
  4.910840347771933e-08, -1.008008928718980e-09,  1.814959078100109e-11, -2.995298177066255e-13,  4.628468314023393e-15, -6.800374964742294e-17,  9.631568551142226e-19,
 -1.301067429672670e-20,  1.737278451415922e-22, -2.258622040167440e-24,  1.867033328288130e-04, -8.801979498324176e-06,  2.708924655195444e-07, -6.814318770701568e-09,
  1.510095582974307e-10, -3.057016163759213e-12,  5.768702584309219e-14, -1.028543313225394e-15,  1.749741796273499e-17, -2.853746181349905e-19,  4.497965215337979e-21,
 -6.865794400504382e-23,  2.348009440592529e-04, -1.339921354588032e-05,  5.106954692955136e-07, -1.583288089984426e-08,  4.282980053987831e-10, -1.047860774941429e-11,
  2.369141849572335e-13, -5.020541429706783e-15,  1.007172411319336e-16, -1.926837835583963e-18,  3.534709439586186e-20, -6.243852572272013e-22,  1.391312638980724e-04,
 -9.963537262480018e-06,  4.739842992562499e-07, -1.803804733242996e-08,  5.909215953756608e-10, -1.731305576254510e-11,  4.643105182003742e-13, -1.157386367762969e-14,
  2.710686708450721e-16, -6.013658770901741e-18,  1.271354026770867e-19, -2.573006763445319e-21,  4.444412018263553e-05, -4.099994957148002e-06,  2.444581107231894e-07,
 -1.141792473647520e-08,  4.521917130555446e-10, -1.582341562547004e-11,  5.016803123778248e-13, -1.465359699191268e-14,  3.990148417758308e-16, -1.021867728273162e-17,
  2.477865698415520e-19, -5.716903769922269e-21,  8.121620816871688e-06, -9.855171215121298e-07,  7.422459254458716e-08, -4.278762120092148e-09,  2.056544050728779e-10,
 -8.617744680575227e-12,  3.235415925165829e-13, -1.108291702916516e-14,  3.509049272470117e-16, -1.036875772593563e-17,  2.880634745195117e-19, -7.564330313141987e-21,
  8.832004573023488e-07, -1.436350147562959e-07,  1.384945410669941e-08, -9.962228637250615e-10,  5.862270251506490e-11, -2.962262812126309e-12,  1.324148131573366e-13,
 -5.341427067043297e-15,  1.972238125422626e-16, -6.736773157313893e-18,  2.146323978030914e-19, -6.414887990570936e-21,  6.090858504602595e-08, -1.348639611258996e-08,
  1.693260098369421e-09, -1.541509967892041e-10,  1.123262458572619e-11, -6.905399115817613e-13,  3.699696664909501e-14, -1.765713460553965e-15,  7.625506677183137e-17,
 -3.015260937959529e-18,  1.101684801979867e-19, -3.742987259482592e-21,  3.150913241157780e-09, -9.500598946908352e-10,  1.566545039428214e-10, -1.817390568424030e-11,
  1.646699268753561e-12, -1.233325633412566e-13,  7.910994877160443e-15, -4.452095588976078e-16,  2.237010565886320e-17, -1.016904655405764e-18,  4.225593922612546e-20,
 -1.616531123144554e-21,  1.751726042302050e-10, -6.772992846933275e-11,  1.404479026566887e-11, -1.997174977712471e-12,  2.167988580254110e-13, -1.907521693329107e-14,
  1.413309252154864e-15, -9.053797174669077e-17,  5.112678422640774e-18, -2.582863856366137e-19,  1.180979833557430e-20, -4.926782307264807e-22,  3.994731096138469e-05,
 -1.572211932139258e-06,  3.857488872961662e-08, -7.600945682522574e-10,  1.313191752180237e-11, -2.082023246153211e-13,  3.093982293096510e-15, -4.350953738624049e-17,
  5.989716642384552e-19, -7.722433202272767e-21,  9.755883171921847e-23, -1.307414032199563e-24,  1.553642288773428e-04, -6.925054793312817e-06,  2.018193402282060e-07,
 -4.820828406679869e-09,  1.016721865010794e-10, -1.963230619479166e-12,  3.539933320599956e-14, -6.034284121684929e-16,  9.847283490879604e-18, -1.538807369147291e-19,
  2.324893821902892e-21, -3.427406978720021e-23,  1.883176534043968e-04, -9.971264628602629e-06,  3.557859139881091e-07, -1.038973184159466e-08,  2.658405668724852e-10,
 -6.170895834729473e-12,  1.327056777143951e-13, -2.680479253422719e-15,  5.134214866163353e-17, -9.394358612345153e-19,  1.650521837468600e-20, -2.795499668547689e-22,
  1.056865546251265e-04, -6.899624031862494e-06,  3.045272579216140e-07, -1.084273446440310e-08,  3.341745045058386e-10, -9.247980011829564e-12,  2.350309262309930e-13,
 -5.567386223313917e-15,  1.241758003212373e-16, -2.629344586438304e-18,  5.315091312558530e-20, -1.030060544159239e-21,  3.123425868832946e-05, -2.589796134425315e-06,
  1.422020740553658e-07, -6.177723337650444e-09,  2.291215308691476e-10, -7.545857657640256e-12,  2.260709673620561e-13, -6.260959270698393e-15,  1.620964770647580e-16,
 -3.957187881066193e-18,  9.167462494942380e-20, -2.024828923592938e-21,  5.106570165275305e-06, -5.519652646064311e-07,  3.805958828980600e-08, -2.031660659809390e-09,
  9.115257250709518e-11, -3.586739489340704e-12,  1.270520383046299e-13, -4.122701126079156e-15,  1.240689138860125e-16, -3.495012528540952e-18,  9.281408524027567e-20,
 -2.335393050849512e-21,  4.722708997356420e-07, -6.830231998740214e-08,  6.013466046956716e-09, -3.999530716655452e-10,  2.195611579303360e-11, -1.042021961236220e-12,
  4.398570153818744e-14, -1.683159059004542e-15,  5.918449505504318e-17, -1.931791587674644e-18,  5.898972373309665e-20, -1.694516163941884e-21,  2.558189464106246e-08,
 -5.087474625540028e-09,  5.860096659646088e-10, -4.955887400889428e-11,  3.385447243125860e-12, -1.964964620621505e-13,  9.996724151089454e-15, -4.552251007957387e-16,
  1.883548429272505e-17, -7.161291186409705e-19,  2.523795143705533e-20, -8.294511587872410e-22,  9.254798201831043e-10, -2.580615684351464e-10,  3.983275430872717e-11,
 -4.368148549783519e-12,  3.769742534519643e-13, -2.705552700980852e-14,  1.671272110854405e-15, -9.095393307759023e-17,  4.435034262523831e-18, -1.962443130208755e-19,
  7.958564227542424e-21, -2.978375587129070e-22,  3.332581205298313e-11, -1.251892491972589e-11,  2.528772167102596e-12, -3.515295912012769e-13,  3.741878957515488e-14,
 -3.236652946781177e-15,  2.362512408904305e-16, -1.493626025776513e-17,  8.336355395225038e-19, -4.167644188335440e-20,  1.887810925545129e-21, -7.809360311135508e-23,
  3.422255037161358e-05, -1.296817644180338e-06,  3.058902878793020e-08, -5.796399971439018e-10,  9.621940344965414e-12, -1.466326089972203e-13,  2.107031919284765e-15,
 -2.813922311338704e-17,  3.789446980591307e-19, -4.799066953690705e-21,  5.232715304076902e-23, -7.924090431571517e-25,  1.305621898518593e-04, -5.516955336210826e-06,
  1.525694382492670e-07, -3.467193390614279e-09,  6.969926515305197e-11, -1.285333947923054e-12,  2.219480912357419e-14, -3.615883947995056e-16,  5.672279254645647e-18,
 -8.527650178819236e-20,  1.225626242130644e-21, -1.761431492633803e-23,  1.534265426214831e-04, -7.559745680070355e-06,  2.530551085168630e-07, -6.973115711525788e-09,
  1.690344212682752e-10, -3.728172742341689e-12,  7.635530686059140e-14, -1.471901807737423e-15,  2.694457442012188e-17, -4.719656236252050e-19,  7.951634418760070e-21,
 -1.291809286740105e-22,  8.224845922679471e-05, -4.905261326523988e-06,  2.012567451464096e-07, -6.715053678240107e-09,  1.949920803930952e-10, -5.103581779155921e-12,
  1.230266245076669e-13, -2.772640490717766e-15,  5.893243349953767e-17, -1.191669941253363e-18,  2.305786135212784e-20, -4.279439962643999e-22,  2.275575785270323e-05,
 -1.696201905734774e-06,  8.589900893388737e-08, -3.474846107434396e-09,  1.208121980799258e-10, -3.747756759516772e-12,  1.061564739224836e-13, -2.789237316625128e-15,
  6.868034336307386e-17, -1.598586829301011e-18,  3.539159123497171e-20, -7.482810578421668e-22,  3.382223128318410e-06, -3.247568019328356e-07,  2.050911032146251e-08,
 -1.013870379934651e-09,  4.246471444852615e-11, -1.568953045150699e-12,  5.242494440933176e-14, -1.611029968305921e-15,  4.606274439793110e-17, -1.236424000633551e-18,
  3.136898901956207e-20, -7.558257477471784e-22,  2.716117506413119e-07, -3.469785535803228e-08,  2.783843703800943e-09, -1.708823455300377e-10,  8.737645062061627e-12,
 -3.888784652123108e-13,  1.547751476665319e-14, -5.609758191935596e-16,  1.875565345503242e-17, -5.840676436010879e-19,  1.706739446771893e-20, -4.704575635439995e-22,
  1.183324780893155e-08, -2.088786427897950e-09,  2.194028531804519e-10, -1.715225111081448e-11,  1.093841469613769e-12, -5.971492749864685e-14,  2.874715968706728e-15,
 -1.244970551761536e-16,  4.920074142804247e-18, -1.793382756039642e-19,  6.079334389326916e-21, -1.927593056159215e-22,  3.028293910927987e-10, -7.686207645978446e-11,
  1.098913949557960e-11, -1.129633681774206e-12,  9.220839656588137e-14, -6.303604111758417e-15,  3.730205161958902e-16, -1.953979753835207e-17,  9.207733142126973e-19,
 -3.951000801320210e-20,  1.558468524282916e-21, -5.687921675649071e-23,  6.741975806985587e-12, -2.437142282721880e-12,  4.759243965883822e-13, -6.428705302524451e-14,
  6.677545271369681e-15, -5.655473189020971e-16,  4.053191016598176e-17, -2.521773976936230e-18,  1.387734913759559e-19, -6.851410698363574e-21,  3.068983658157951e-22,
 -1.256927786086910e-23,  2.948407356499217e-05, -1.077517233308493e-06,  2.446850086517071e-08, -4.466477473598493e-10,  7.137607899047042e-12, -1.042951128690125e-13,
  1.465447166151537e-15, -1.843465135054533e-17,  2.364857231208101e-19, -3.290451436959179e-21,  2.582249954176988e-23, -4.156852543724425e-25,  1.106963792019391e-04,
 -4.445648294218272e-06,  1.168910870711052e-07, -2.531823135488173e-09,  4.859434528496447e-11, -8.561737330517578e-13,  1.420958040813933e-14, -2.210674138747589e-16,
  3.325072913950370e-18, -4.886369243081116e-20,  6.561179683572193e-22, -9.157032311453676e-24,  1.267646605685891e-04, -5.829120030698866e-06,  1.834324887689807e-07,
 -4.777946387772357e-09,  1.099020762997575e-10, -2.306524225151175e-12,  4.503974566952257e-14, -8.297495875084907e-16,  1.453362454847212e-17, -2.437668766484591e-19,
  3.945968421298437e-21, -6.154580669019755e-23,  6.540299696956621e-05, -3.571324324337075e-06,  1.364827543929112e-07, -4.274340066243276e-09,  1.171121563259613e-10,
 -2.903531455067547e-12,  6.642885597095888e-14, -1.426435928156982e-15,  2.892558887167032e-17, -5.583071271890360e-19,  1.036242905118484e-20, -1.842678648338762e-22,
  1.712111874248042e-05, -1.147854549675368e-06,  5.371060034446265e-08, -2.025745776047577e-09,  6.609752388166239e-11, -1.933630915770304e-12,  5.180456018583283e-14,
 -1.292545987839151e-15,  3.028808368299487e-17, -6.720909848371751e-19,  1.423131002476106e-20, -2.880560836876295e-22,  2.347929051916171e-06, -1.998055337107538e-07,
  1.156952072713742e-08, -5.298985491239006e-10,  2.072714835778020e-11, -7.193445289430680e-13,  2.267182427608177e-14, -6.598674988367638e-16,  1.792338627143380e-17,
 -4.582619653905371e-19,  1.110509929492885e-20, -2.561075127469395e-22,  1.670885896803746e-07, -1.873508891398709e-08,  1.368669181653387e-09, -7.744762712552536e-11,
  3.684852983306337e-12, -1.536431378188519e-13,  5.759188309131380e-15, -1.974934882431735e-16,  6.270906709008523e-18, -1.860770736312505e-19,  5.196785224076490e-21,
 -1.372758040313742e-22,  6.010133631309221e-09, -9.305657923855212e-10,  8.870894291488831e-11, -6.384350919982887e-12,  3.787547257531478e-13, -1.938558409282430e-14,
  8.803940722283138e-16, -3.615619238954625e-17,  1.360979415397025e-18, -4.743265292731805e-20,  1.542623782891510e-21, -4.707156914029370e-23,  1.112191316065973e-10,
 -2.523995103873916e-11,  3.307006638159897e-12, -3.159758767461801e-13,  2.422387915943213e-14, -1.567778352270337e-15,  8.839668889336342e-17, -4.435441068910871e-18,
  2.011086630631337e-19, -8.335240618182827e-21,  3.186350621296504e-22, -1.130389515320169e-23,  1.474600906291710e-12, -5.060772635733734e-13,  9.458599685669502e-14,
 -1.231854823384761e-14,  1.240829875103705e-15, -1.023766304818700e-16,  7.173760712488823e-18, -4.376823315902889e-19,  2.367669429153785e-20, -1.151432632024393e-21,
  5.089085414818917e-23, -2.059605908845697e-24,  2.553410189661259e-05, -9.014138156995938e-07,  1.973084811323269e-08, -3.473837469171197e-10,  5.365581629857320e-12,
 -7.456637388899837e-14,  1.038663348752432e-15, -1.259172982003172e-17,  1.333055694795968e-19, -2.501479856774627e-21,  1.690532663284088e-23,  3.617953848465639e-26,
  9.460870918797138e-05, -3.620020083999189e-06,  9.066394141296396e-08, -1.874679541464281e-09,  3.443563264892206e-11, -5.788609686932288e-13,  9.276910441877473e-15,
 -1.384353701270784e-16,  1.955973424288482e-18, -2.910101317895612e-20,  3.665461199976110e-22, -4.383349940494315e-24,  1.060579934930481e-04, -4.564268230418344e-06,
  1.352961591141737e-07, -3.336873034206075e-09,  7.294003637182153e-11, -1.458950180053874e-12,  2.718851740720553e-14, -4.792247106999871e-16,  8.049562390194079e-18,
 -1.291425475643200e-19,  2.010689453525662e-21, -3.029952773569429e-23,  5.301636123305392e-05, -2.656687212952837e-06,  9.476466311550951e-08, -2.790397830189229e-09,
  7.222032964814949e-11, -1.699986486024996e-12,  3.691583978321994e-14, -7.559442624610695e-16,  1.467768525395957e-17, -2.695617554456552e-19,  4.807493881347833e-21,
 -8.246774521733055e-23,  1.325710677682936e-05, -7.999812253913374e-07,  3.466020574544449e-08, -1.220599901509665e-09,  3.741021395147522e-11, -1.034060507347951e-12,
  2.620491566728888e-14, -6.213362670193586e-16,  1.388306176344754e-17, -2.933066989160416e-19,  5.946230029015422e-21, -1.154647277352239e-22,  1.700273480947120e-06,
 -1.279750908916947e-07,  6.806812679065740e-09, -2.890800908098854e-10,  1.056481160306333e-11, -3.447730883320813e-13,  1.024871584862593e-14, -2.825915135049584e-16,
  7.295767102955055e-18, -1.775797004144020e-19,  4.110792839103205e-21, -9.074957665932016e-23,  1.093197779302646e-07, -1.069360260328251e-08,  7.116623528793913e-10,
 -3.710227184603267e-11,  1.641621509242514e-12, -6.410682566045101e-14,  2.261296358200269e-15, -7.331353087476181e-17,  2.209166973914663e-18, -6.239876306909859e-20,
  1.663991949647572e-21, -4.207960839765340e-23,  3.336266403024252e-09, -4.477377753068931e-10,  3.861717992764180e-11, -2.550303011512137e-12,  1.403535654891752e-13,
 -6.717978340375192e-15,  2.870904955669612e-16, -1.115345910127751e-17,  3.989331095303611e-19, -1.326246212496158e-20,  4.128641083654671e-22, -1.209653052485777e-23,
  4.605652859661213e-11, -9.162607090043975e-12,  1.089253553585874e-12, -9.595691922360425e-14,  6.862471493531554e-15, -4.179949033889531e-16,  2.233680110262445e-17,
 -1.068423423292042e-18,  4.640728530057066e-20, -1.850331486956284e-21,  6.829536442629700e-23, -2.346996456058381e-24,  3.559588898737403e-13, -1.138020631789163e-13,
  2.009326182096435e-14, -2.498212675916850e-15,  2.421283744021662e-16, -1.933825197466306e-17,  1.317977069750681e-18, -7.850930193876406e-20,  4.159461302248523e-21,
 -1.986222532448840e-22,  8.638512015447229e-24, -3.446650131263002e-25,  2.221966038792255e-05, -7.588871172462317e-07,  1.603220360468018e-08, -2.722228626100472e-10,
  4.097131194713436e-12, -5.346552732171530e-14,  7.332745114057867e-16, -9.623338195103099e-18,  5.731140175923265e-20, -1.627565540559216e-21,  3.091784863642069e-23,
  5.918056768163741e-25,  8.144893110831549e-05, -2.976134019710775e-06,  7.112742524356613e-08, -1.405432209744100e-09,  2.480368758792197e-11, -3.965316206919811e-13,
  6.137800757565467e-15, -9.009141541333131e-17,  1.135169361793030e-18, -1.728242588940968e-20,  2.471311710415503e-22, -1.266471330091328e-24,  8.973740686856389e-05,
 -3.624237135397626e-06,  1.013965484448935e-07, -2.371899237701354e-09,  4.933342747661896e-11, -9.421372894663593e-13,  1.677469704773277e-14, -2.827847065502894e-16,
  4.575274554894284e-18, -7.022906637815867e-20,  1.041723579290890e-21, -1.550786904998516e-23,  4.371845718220308e-05, -2.015168516103058e-06,  6.722939051711066e-08,
 -1.865076928843943e-09,  4.560648753769530e-11, -1.022725899580083e-12,  2.109455913058404e-14, -4.105233269133505e-16,  7.706849204289399e-18, -1.343271838618163e-19,
  2.267962338609821e-21, -3.888866588751692e-23,  1.053152060082747e-05, -5.724886487451628e-07,  2.301836559549292e-08, -7.584374797590753e-10,  2.183230911904813e-11,
 -5.720421347913703e-13,  1.371724787257408e-14, -3.084993109246238e-16,  6.611490068168399e-18, -1.327461669048840e-19,  2.563396266140182e-21, -4.840524056723810e-23,
  1.278773106473656e-06, -8.497169425956939e-08,  4.161460447713492e-09, -1.641239772782226e-10,  5.602986878647752e-12, -1.723128510768963e-13,  4.831466340996533e-15,
 -1.261220303829893e-16,  3.102153794393017e-18, -7.181558788030627e-20,  1.586215629028914e-21, -3.362760380581015e-23,  7.563461331134740e-08, -6.415938110350994e-09,
  3.896608164984587e-10, -1.872160613742860e-11,  7.698217032391086e-13, -2.817317599466233e-14,  9.346863650090915e-16, -2.863040850720336e-17,  8.187739398955784e-19,
 -2.199321634367781e-20,  5.595424125946254e-22, -1.354266896137790e-23,  2.012327051358254e-09, -2.312562490132240e-10,  1.802823787014646e-11, -1.090089897618533e-12,
  5.552779073618585e-14, -2.481417617671900e-15,  9.958263700138553e-17, -3.652563462713097e-18,  1.239078893623058e-19, -3.921357197749060e-21,  1.166167103173554e-22,
 -3.274365076429927e-24,  2.152770402248578e-11, -3.674534043155308e-12,  3.931078187424065e-13, -3.169791754067044e-14,  2.101689622145630e-15, -1.198274383600105e-16,
  6.038583274996412e-18, -2.740843336843231e-19,  1.135598994996350e-20, -4.338445213170379e-22,  1.540383758826430e-23, -5.110100988537134e-25,  9.717495420227984e-14,
 -2.818671734041867e-14,  4.625668043118132e-15, -5.423884482549889e-16,  5.010118903736281e-17, -3.843724821898620e-18,  2.531759362493562e-19, -1.464615711758663e-20,
  7.565507758816554e-22, -3.533747519409511e-23,  1.507391992192383e-24, -5.912430673663321e-26,  1.942141167898134e-05, -6.426572632462700e-07,  1.312642128102059e-08,
 -2.143555423980589e-10,  3.182857581793148e-12, -3.893737196630749e-14,  4.827143243602387e-16, -8.431620735492020e-18,  2.801980363482895e-20,  1.975405805261648e-22,
  5.970883277316653e-23,  4.741541841057855e-25,  7.058441159221674e-05, -2.468383471143974e-06,  5.640542750634392e-08, -1.064805105601612e-09,  1.816081626524514e-11,
 -2.758990421352663e-13,  4.043411596214759e-15, -6.188694295859673e-17,  6.825823234272683e-19, -7.995365164794745e-21,  2.243775319278590e-22, -3.401921845022998e-25,
  7.669975880243558e-05, -2.914799405052927e-06,  7.711211301391341e-08, -1.713853957183939e-09,  3.395179223474403e-11, -6.200946431395983e-13,  1.057676839982290e-14,
 -1.699609888623678e-16,  2.656435054731718e-18, -3.966410893151495e-20,  5.408142960591152e-22, -7.983149417882977e-24,  3.660737454188574e-05, -1.555845498546466e-06,
  4.863120929567298e-08, -1.274960451311111e-09,  2.941069829153082e-11, -6.304412672622869e-13,  1.243321005913256e-14, -2.266795646002963e-16,  4.156471384341660e-18,
 -7.093179729117979e-20,  1.046162054208204e-21, -1.881297533167841e-23,  8.559586324627583e-06, -4.195746377364061e-07,  1.568631128860023e-08, -4.853171218909981e-10,
  1.309102620899998e-11, -3.263762916788273e-13,  7.442860551663009e-15, -1.571483971898008e-16,  3.257218783642591e-18, -6.305451415709907e-20,  1.117409553222692e-21,
 -2.109021524006351e-23,  9.948476642395376e-07, -5.826016842794248e-08,  2.633687174413074e-09, -9.677167956749288e-11,  3.079463777954198e-12, -8.953071191589563e-14,
  2.374129700519692e-15, -5.838077742373549e-17,  1.374263343882102e-18, -3.038659241940244e-20,  6.329058006744329e-22, -1.301663176341993e-23,  5.503029351387483e-08,
 -4.023967053150745e-09,  2.236239690955357e-10, -9.920684448173562e-12,  3.784277830435463e-13, -1.300163068177700e-14,  4.059676340697849e-16, -1.172404608369400e-17,
  3.186478866057428e-19, -8.141774960561084e-21,  1.970182569753791e-22, -4.573344720318677e-24,  1.310142334544213e-09, -1.273240574702326e-10,  8.982024396006622e-12,
 -4.969297414712897e-13,  2.337546025812996e-14, -9.747251528775879e-16,  3.668648275080424e-17, -1.267998247583879e-18,  4.075261336346118e-20, -1.225773284536345e-21,
  3.475583148836970e-23, -9.340390867877564e-25,  1.132875896325361e-11, -1.620979169801727e-12,  1.552319124528273e-13, -1.138978062453253e-14,  6.963395422756694e-16,
 -3.699441657879705e-17,  1.750308051185794e-18, -7.506938751185264e-20,  2.955347457224974e-21, -1.077764995271473e-22,  3.667902172935753e-24, -1.170684245716347e-25,
  3.079971117849386e-14, -7.820467147938984e-15,  1.170615825238742e-15, -1.276211029310700e-16,  1.111069260073636e-17, -8.114345240945266e-19,  5.126745163081959e-20,
 -2.862131684919797e-21,  1.433755210691426e-22, -6.520600028114025e-24,  2.717345607324766e-25, -1.044209307646083e-26,  1.704566320745613e-05, -5.471247073251059e-07,
  1.083583500501462e-08, -1.691085361771637e-10,  2.501452194656203e-12, -3.006031384699439e-14,  2.636526284164440e-16, -6.945006668792149e-18,  7.905346749182585e-20,
  2.518753166763411e-21,  4.013888165340857e-23, -1.720228973912989e-24,  6.153889999923001e-05, -2.063698819566150e-06,  4.520468147427938e-08, -8.136508485326991e-10,
  1.348474363493662e-11, -1.973883135919701e-13,  2.585115990551805e-15, -4.298281645089227e-17,  5.467510424197152e-19, -4.784161384448136e-23,  1.456654994472386e-22,
 -4.035391203792379e-24,  6.615600076034075e-05, -2.371792926589940e-06,  5.943661222887549e-08, -1.257509084463224e-09,  2.374739082077469e-11, -4.149388089713435e-13,
  6.819530526566463e-15, -1.042203059512041e-16,  1.547283462545248e-18, -2.354393130486325e-20,  2.992236826314777e-22, -3.306459480225328e-24,  3.107534602326307e-05,
 -1.220856865147570e-06,  3.578623133606838e-08, -8.909622307472011e-10,  1.934033360880410e-11, -3.952850005324643e-13,  7.613814078604352e-15, -1.278267114617083e-16,
  2.193658668169826e-18, -4.162953592985305e-20,  5.121520050012915e-22, -5.976612772707738e-24,  7.099828847723203e-06, -3.142582979883678e-07,  1.093164387305774e-08,
 -3.196837243937463e-10,  8.046338517390390e-12, -1.906001313922007e-13,  4.213059647372430e-15, -8.214796080122381e-17,  1.609586359793878e-18, -3.249425741788575e-20,
  5.048390742969879e-22, -8.030835569043628e-24,  7.976167894943550e-07, -4.111650703141075e-08,  1.717665053305132e-09, -5.920711469272356e-11,  1.748183159005338e-12,
 -4.805853799536740e-14,  1.219951610975300e-15, -2.795749908270984e-17,  6.252561322581759e-19, -1.364767737080268e-20,  2.615096634073152e-22, -5.011843532920899e-24,
  4.188144241132026e-08, -2.625039455300791e-09,  1.337768693840629e-10, -5.510604481322884e-12,  1.942135731957346e-13, -6.270281687956840e-15,  1.853087734812047e-16,
 -5.017995155062210e-18,  1.294707111682226e-19, -3.177081094780027e-21,  7.243780903705870e-23, -1.603693981072519e-24,  9.141440897742274e-10, -7.418386596739788e-11,
  4.746980283475797e-12, -2.409009947642684e-13,  1.042791001332417e-14, -4.057905883448999e-16,  1.433606128923815e-17, -4.655630126662085e-19,  1.416541970424978e-20,
 -4.051908154473354e-22,  1.091629955930707e-23, -2.804667927020383e-25,  6.671312855855374e-12, -7.807328487424376e-13,  6.680692959559647e-14, -4.445091028862443e-15,
  2.493018317917625e-16, -1.230041493645876e-17,  5.444980378207319e-19, -2.198060159181569e-20,  8.195187609736362e-22, -2.843559616230626e-23,  9.243241965696927e-25,
 -2.829762458919307e-26,  1.160700906777983e-14, -2.463481446778884e-15,  3.299477639956692e-16, -3.293267537274420e-17,  2.669165315246510e-18, -1.837181792291260e-19,
  1.104025142518589e-20, -5.905257792040016e-22,  2.851119459700186e-23, -1.255813892839856e-24,  5.089089370691688e-26, -1.908294607645053e-27,  1.501858824921324e-05,
 -4.679186034312831e-07,  9.027780064723009e-09, -1.336109754987085e-10,  1.949629905141655e-12, -2.569007265987469e-14,  1.193400769620205e-16, -2.853114488554021e-18,
  1.729032092309793e-19,  1.826582095500940e-21, -8.823648516400923e-23, -3.422870520160205e-24,  5.395035001972659e-05, -1.737728773521143e-06,  3.661501808172427e-08,
 -6.264794221837916e-10,  1.007024452679004e-11, -1.477824996076266e-13,  1.631810552256519e-15, -2.483316320032478e-17,  5.928202719999647e-19,  7.230920503626677e-22,
 -1.338241474442974e-22, -7.395843069094348e-24,  5.753259884037960e-05, -1.950778655982789e-06,  4.637870981073876e-08, -9.359491575096616e-10,  1.687480388790241e-11,
 -2.813996466318450e-13,  4.482235123328603e-15, -6.618540374772914e-17,  8.886124161059604e-19, -1.359103143497633e-20,  2.147523795908117e-22, -1.100637679799338e-24,
  2.670349418201720e-05, -9.726144793440302e-07,  2.671961170845014e-08, -6.359247032770815e-10,  1.300764073363303e-11, -2.488236580473655e-13,  4.818246662444864e-15,
 -7.798600048174322e-17,  1.027583076315721e-18, -2.352326347096367e-20,  4.489899349641192e-22,  1.470230630575964e-24,  5.996154508060532e-06, -2.402188824451940e-07,
  7.757975125954257e-09, -2.166344253166157e-10,  5.085112678567264e-12, -1.122239051253531e-13,  2.482702432886606e-15, -4.599786621295895e-17,  7.410262114146787e-19,
 -1.693799850854291e-20,  3.217087752799462e-22, -1.408555925374762e-24,  6.567202379523444e-07, -2.980551025549886e-08,  1.147798989992412e-09, -3.756539203096621e-11,
  1.026384305014237e-12, -2.630349607969069e-14,  6.556783492479108e-16, -1.414520437403292e-17,  2.806090229966019e-19, -6.378799146544788e-21,  1.262716987519119e-22,
 -1.650778115115306e-24,  3.316664519255657e-08, -1.774675445355407e-09,  8.282562197196636e-11, -3.205319223313376e-12,  1.039355192490031e-13, -3.129382646247962e-15,
  8.892576136716064e-17, -2.258839738265431e-18,  5.392565972093107e-20, -1.303962274517463e-21,  2.871615890336635e-23, -5.580223293932441e-25,  6.783729570453335e-10,
 -4.544900871057619e-11,  2.639764785347029e-12, -1.239444629524144e-13,  4.913702763674856e-15, -1.779031435471527e-16,  5.938623709044812e-18, -1.807333883830167e-19,
  5.169358517272983e-21, -1.417133174804575e-22,  3.629855376540885e-24, -8.772317804898938e-26,  4.355307500847765e-12, -4.067732344864790e-13,  3.111492729778706e-14,
 -1.880257617695473e-15,  9.618870982776054e-17, -4.394962096046036e-18,  1.818478323036062e-19, -6.882254013795227e-21,  2.421626304412987e-22, -7.983694319886461e-24,
  2.470199492055690e-25, -7.224022901957329e-27,  5.277137477145527e-15, -8.862613950169362e-16,  1.045400125872078e-16, -9.414999797319143e-18,  7.012415051695327e-19,
 -4.502574255951182e-20,  2.550734944072184e-21, -1.296848078374414e-22,  5.993818749508269e-24, -2.541775975393852e-25,  9.963350147776095e-27, -3.628874814849966e-28,
  1.328190222304152e-05, -4.016175156068335e-07,  7.595115451520392e-09, -1.063871164733671e-10,  1.461378205584667e-12, -2.312946088219462e-14,  1.204517898344006e-16,
  2.803242695097179e-18,  1.467134873540191e-19, -3.731853460976567e-21, -1.511285822214925e-22,  1.737965464682555e-24,  4.754124976619516e-05, -1.472352356764972e-06,
  2.997281140800537e-08, -4.870708444428330e-10,  7.460906917047609e-12, -1.148465377332542e-13,  1.195337529763887e-15, -7.025819299406844e-18,  4.592505274061132e-19,
 -9.230180798700946e-21, -2.872587102643381e-22,  2.878288679367259e-24,  5.040637171538724e-05, -1.620477256150230e-06,  3.659891634047121e-08, -7.057089064047333e-10,
  1.218733496076058e-11, -1.932463137216518e-13,  2.964834752737002e-15, -4.402131227421376e-17,  5.410523067784023e-19, -6.150519174859032e-21,  1.475745540557524e-22,
 -2.343894143526166e-24,  2.319676327886087e-05, -7.861847303758004e-07,  2.019149042567785e-08, -4.620156002842536e-10,  9.027018222493137e-12, -1.563290270666666e-13,
  2.993028000824494e-15, -5.508768103162151e-17,  5.140245641666010e-19, -5.110998696114555e-21,  4.230981385013680e-22, -4.966950194626865e-24,  5.144694201862024e-06,
 -1.873219307903371e-07,  5.581857525106876e-09, -1.503870586521780e-10,  3.343932685440604e-12, -6.589190326820069e-14,  1.452201450144691e-15, -2.965736350741091e-17,
  3.504665893078607e-19, -5.161365224405814e-21,  2.550071701288296e-22, -2.973114135246213e-24,  5.533556909015851e-07, -2.218210990748583e-08,  7.806271708675470e-10,
 -2.461560472744065e-11,  6.300565239949992e-13, -1.448568388510331e-14,  3.570571234078189e-16, -7.982382693450007e-18,  1.279365296327467e-19, -2.426236192549811e-21,
  7.571128829535566e-23, -1.028855143210772e-24,  2.718402284856873e-08, -1.241752842079943e-09,  5.259844818735036e-11, -1.945574890324502e-12,  5.841622212111440e-14,
 -1.595612523195871e-15,  4.412549639173178e-17, -1.102049457129088e-18,  2.300323876890719e-20, -5.151257661770373e-22,  1.308486298347554e-23, -2.281505641755743e-25,
  5.309780959811527e-10, -2.917115782435524e-11,  1.527809331189716e-12, -6.748186565402646e-14,  2.450736640199493e-15, -8.128117100559459e-17,  2.590414970869941e-18,
 -7.500661798429767e-20,  1.966120828393424e-21, -5.124660247953881e-23,  1.311348574250360e-24, -2.912690348467752e-26,  3.112891210139466e-12, -2.273539365479456e-13,
  1.550603550634089e-14, -8.599033352538017e-16,  3.992906669229679e-17, -1.677541463052036e-18,  6.510953442449407e-20, -2.309775678259366e-21,  7.603171274334970e-23,
 -2.380662853065519e-24,  7.045297357326523e-26, -1.948833779102647e-27,  2.889509257301241e-15, -3.628063304689953e-16,  3.731033743478572e-17, -3.004104337275425e-18,
  2.028982069253290e-19, -1.203041637141308e-20,  6.374409167707206e-22, -3.055364163695041e-23,  1.341606632003361e-24, -5.444877688486517e-26,  2.053050661033160e-27,
 -7.222725432091664e-29,  1.178938489015122e-05, -3.455996504280806e-07,  6.444097389019270e-09, -8.651443203405378e-11,  1.036137290041672e-12, -1.892593948673841e-14,
  2.376587691388323e-16,  4.458922179757592e-18, -5.913685877831174e-20, -6.274861633772811e-21,  5.786001359442427e-23,  6.119781630050643e-24,  4.209703525096308e-05,
 -1.254084565748307e-06,  2.477333789654154e-08, -3.845546966918481e-10,  5.441947896341977e-12, -8.723363073042795e-14,  1.141352461224215e-15,  6.490996679979673e-19,
 -9.935124306141893e-21, -1.405015349196776e-20,  1.199512284568444e-22,  1.241821667323849e-23,  4.446073341095108e-05, -1.358515559803946e-06,  2.918430917299842e-08,
 -5.381509603096976e-10,  8.943502383856070e-12, -1.350943752028431e-13,  1.948160755831527e-15, -2.933936365782953e-17,  3.972572513976814e-19, -2.676156148751869e-21,
  2.378876999639159e-23, -2.609241502243528e-24,  2.034315703364422e-05, -6.445889422075892e-07,  1.542200728171614e-08, -3.391851786891286e-10,  6.503090390870506e-12,
 -1.012146722680583e-13,  1.673017370453302e-15, -3.894229168624192e-17,  5.525817087654496e-19,  4.363062591878591e-21, -2.574893998632304e-24, -1.177666026638798e-23,
  4.474452697725115e-06, -1.490652671687002e-07,  4.060155721892909e-09, -1.057942764427220e-10,  2.313412201853230e-12, -3.984591981930387e-14,  7.629944271975150e-16,
 -1.978924901709127e-17,  3.037982506056761e-19,  1.054567446789535e-21,  3.068415407355262e-23, -6.155188906042325e-24,  4.754627996379629e-07, -1.696660593333297e-08,
  5.374835201809927e-10, -1.645532332483872e-11,  4.100495053500792e-13, -8.197931882994512e-15,  1.813478859470994e-16, -4.798506051308636e-18,  8.289385076713806e-20,
 -4.442127364673306e-22,  2.055197434129082e-23, -1.361772337093367e-24,  2.293037103458780e-08, -9.005618119683193e-10,  3.396731039951828e-11, -1.217856318413114e-12,
  3.496349824984642e-14, -8.376864140212727e-16,  2.140070558500086e-17, -5.796007449400360e-19,  1.170357419538344e-20, -1.676175209387767e-22,  4.722857338861744e-24,
 -1.625587138560237e-25,  4.344118506878283e-10, -1.962590555328876e-11,  9.089095347978360e-13, -3.850203495904928e-14,  1.307349091281026e-15, -3.860060192368429e-17,
  1.153491143502435e-18, -3.356924921466236e-20,  8.186511512869607e-22, -1.795693497702821e-23,  4.721943584105043e-25, -1.227413621682814e-26,  2.398772459044713e-12,
 -1.358106596295418e-13,  8.138174498216771e-15, -4.224363606314541e-16,  1.791023543769544e-17, -6.792845679096224e-19,  2.469793229311701e-20, -8.365718392207086e-22,
  2.556451197291322e-23, -7.396912896677566e-25,  2.131213254060802e-26, -5.763872250783977e-28,  1.866127428862408e-15, -1.673741551033128e-16,  1.486580538232279e-17,
 -1.073612449053599e-18,  6.502386109117201e-20, -3.514681885011055e-21,  1.732155538685713e-22, -7.786955134240806e-24,  3.218582474398543e-25, -1.240481822623996e-26,
  4.484656765677347e-28, -1.516891023766175e-29,  1.050387946364049e-05, -2.979443021139807e-07,  5.494007524331780e-09, -7.261829741081163e-11,  7.228753445575841e-13,
 -1.211869425041978e-14,  3.079526692700445e-16, -1.478635461218803e-19, -1.906375654436258e-19, -6.579587798513485e-23,  1.982498618672200e-22, -9.979829001569739e-25,
  3.744977132144501e-05, -1.072999194973560e-06,  2.062835870587872e-08, -3.099525188365424e-10,  3.970702744310362e-12, -6.006901239354706e-14,  1.091203403363011e-15,
 -5.904069181758427e-18, -3.206464116749416e-19, -1.176858484096445e-21,  4.154764776018681e-22, -1.755121361830118e-24,  3.945590344167324e-05, -1.148629824103106e-06,
  2.350343722760970e-08, -4.143842017824244e-10,  6.649686278284089e-12, -9.684727257955530e-14,  1.290372558320735e-15, -1.816425435810290e-17,  2.974658922653087e-19,
 -3.211938831662850e-21, -2.766524964592545e-23,  4.072704176277344e-25,  1.798808545116403e-05, -5.358662930860652e-07,  1.191542421779316e-08, -2.494815810125429e-10,
  4.802865108210903e-12, -7.202725455430113e-14,  8.483914910417503e-16, -1.964965892810730e-17,  6.044572181797447e-19, -3.466258925831455e-21, -2.929338948610875e-22,
  8.202569667609681e-25,  3.935929354224247e-06, -1.210878537586612e-07,  2.989170338368880e-09, -7.432827909531041e-11,  1.660547927551876e-12, -2.705332598521184e-14,
  3.495922372057909e-16, -9.694683658973925e-18,  3.083514892833278e-19, -1.922166244007519e-21, -1.334434828422171e-22, -9.365736951398467e-26,  4.150882222445193e-07,
 -1.335618974488843e-08,  3.746275922570722e-10, -1.101016710218284e-11,  2.802296028810525e-13, -5.169953993096996e-15,  8.222717686566905e-17, -2.348838345165539e-18,
  6.916422918209162e-20, -5.853953592488268e-22, -1.876963258313309e-23, -1.910303155995284e-25,  1.979098934627964e-08, -6.788868550777065e-10,  2.223367535078658e-11,
 -7.693812493307322e-13,  2.223016639586807e-14, -4.810878776687178e-16,  9.693882870357336e-18, -2.776899063378903e-19,  7.579935709774194e-21, -9.447560294879531e-23,
 -2.007254662471994e-25, -4.606050670659508e-26,  3.679598985876797e-10, -1.389742203396677e-11,  5.510271110351366e-13, -2.252927274722411e-14,  7.492028150291381e-16,
 -1.972613495260921e-17,  5.037508850853533e-19, -1.497421161009179e-20,  4.049775835972027e-22, -7.385694583898596e-24,  1.138614376511473e-25, -4.328990288617977e-27,
  1.959373994586734e-12, -8.696762327296960e-14,  4.425972417004106e-15, -2.189188980485643e-16,  8.746051300758620e-18, -2.949471619601674e-19,  9.657781538734297e-21,
 -3.200004489136348e-22,  9.589837127871881e-24, -2.456525238770816e-25,  6.213109101312358e-27, -1.794157577981198e-28,  1.372298044030518e-15, -8.646769269843093e-17,
  6.475081215109207e-18, -4.271830256819249e-19,  2.326991779804558e-20, -1.125090920764977e-21,  5.097119389551053e-23, -2.157503626127259e-24,  8.382926259747754e-26,
 -3.018795401080446e-27,  1.034654567149589e-28, -3.389621041234728e-30,  9.394743902936720e-06, -2.572971654419658e-07,  4.685253700030779e-09, -6.260304778152781e-11,
  5.506875769375492e-13, -5.419058489314337e-15,  2.277837892754652e-16, -4.976594357876961e-18, -8.056355830671539e-20,  4.967826203988002e-21,  2.318541866716357e-23,
 -5.053048968787384e-24,  3.346568746698671e-05, -9.218524375442229e-07,  1.725487690131543e-08, -2.546858963421142e-10,  3.012052076282313e-12, -3.695701117088900e-14,
  7.964382708744784e-16, -1.406913988844292e-17, -1.238771713438809e-19,  9.645991022670103e-21,  6.020159652165611e-23, -1.051116582144298e-23,  3.520831815098444e-05,
 -9.788211139893682e-07,  1.911029900441401e-08, -3.219571422040979e-10,  4.986316548444469e-12, -7.101875493148494e-14,  8.965270922576682e-16, -1.063643106882146e-17,
  1.716120452540312e-19, -3.426267251546895e-21,  2.296243651308995e-23,  1.243849040126008e-24,  1.601801452676051e-05, -4.513147062348025e-07,  9.338344708553266e-09,
 -1.832037634863018e-10,  3.531900365637508e-12, -5.627213773486653e-14,  5.357536875755140e-16, -4.250390531418198e-18,  3.131712137730476e-19, -1.079184752333158e-20,
 -1.649005843616642e-23,  8.438066949062505e-24,  3.494342415474592e-06, -1.003291193758198e-07,  2.240058694653598e-09, -5.170557505785702e-11,  1.186759506239521e-12,
 -2.090407086867097e-14,  1.991248985798417e-16, -1.846144026628561e-18,  1.606982227632523e-19, -5.416392077866785e-21, -9.803887807838857e-24,  4.109306389761412e-24,
  3.669187423417500e-07, -1.081869004118569e-08,  2.662918734789126e-10, -7.264623429824154e-12,  1.924290435027862e-13, -3.760185951691885e-15,  4.327707937159330e-17,
 -6.085028972354825e-19,  3.633064662257996e-20, -1.110200129477009e-21, -6.415723777953008e-25,  7.200047895631794e-25,  1.738036970693368e-08, -5.325615388481534e-10,
  1.485249924207540e-11, -4.802235786448293e-13,  1.443307169478369e-14, -3.175807676964192e-16,  4.780890249872236e-18, -9.269530502774101e-20,  3.897250720904306e-21,
 -1.060871020692267e-22,  3.049130584139284e-25,  4.553144691825658e-26,  3.197272107487817e-10, -1.039315391018883e-11,  3.413754601591033e-13, -1.316042293572544e-14,
  4.482355010638420e-16, -1.142438954321505e-17,  2.306037481830609e-19, -5.649718916079292e-21,  1.919633779593016e-22, -4.864843771335614e-24,  4.683759206618819e-26,
  3.632666250699474e-28,  1.668535901670342e-12, -6.006843400312612e-14,  2.477674553118374e-15, -1.160928055940922e-16,  4.588959398982316e-18, -1.427774203109643e-19,
  3.934184058259025e-21, -1.186843170624811e-22,  3.821867612807531e-24, -1.020184891841689e-25,  1.982237789200451e-27, -3.891015725477145e-29,  1.104685232256474e-15,
 -5.020428772268443e-17,  3.010214090722428e-18, -1.845520214025348e-19,  9.333152499913147e-21, -4.013150885266121e-22,  1.613516271584445e-23, -6.372235466796329e-25,
  2.387531736954184e-26, -8.111924634265109e-28,  2.533788153320099e-29, -7.745040365627210e-31,  8.435964200322172e-06, -2.226768514717015e-07,  3.984131241396336e-09,
 -5.441258390458082e-11,  4.848747751534956e-13, -1.753801133110384e-15,  7.827028951168795e-17, -4.889480533756533e-18,  7.096708846984564e-20,  2.577725706957962e-21,
 -1.067717796422814e-22, -3.713620787491200e-25,  3.003608985184894e-05, -7.952691777984063e-07,  1.446639928926146e-08, -2.115055190820249e-10,  2.431188822302406e-12,
 -2.270058098352100e-14,  3.978360510891988e-16, -1.279912805214145e-17,  1.743095419381661e-19,  5.064265644640672e-21, -2.158063178993264e-22, -9.436667628995187e-25,
  3.157611116334652e-05, -8.401372020153823e-07,  1.568216141497059e-08, -2.524614803417414e-10,  3.759738417895953e-12, -5.256078855054705e-14,  6.588194353109368e-16,
 -6.857044743528893e-18,  7.440150434120855e-20, -1.819566240569026e-21,  4.626527007531714e-23, -2.132570022491811e-25,  1.434949476419300e-05, -3.845221809477790e-07,
  7.444014006616000e-09, -1.350228767477866e-10,  2.529764553843107e-12, -4.405693603183727e-14,  5.014851679730183e-16,  5.748601233635858e-20, -1.333692925519040e-20,
 -5.881628364885531e-21,  2.012938271661826e-22,  5.418871785890943e-25,  3.125353137214973e-06, -8.459785875254317e-08,  1.720537302569018e-09, -3.581180523946381e-11,
  8.145359804757500e-13, -1.633911013248995e-14,  1.914263210726660e-16,  4.122673074143742e-19, -4.686230211311661e-21, -3.029206639232530e-21,  1.001738240109444e-22,
  3.508565252853595e-25,  3.274193344312055e-07, -8.990085895081901e-09,  1.952795077673105e-10, -4.734847713656366e-12,  1.267580021335781e-13, -2.830291892066815e-15,
  3.680237067738658e-17, -3.458002769532863e-20,  2.487560258046721e-21, -6.338285287460735e-22,  1.942905962720570e-23,  7.154844539423882e-26,  1.545621914205066e-08,
 -4.333122040882604e-10,  1.028408597789129e-11, -2.945456044861008e-13,  9.077106357935514e-15, -2.232430391367017e-16,  3.395820788906898e-18, -2.304676595836413e-20,
  7.358669248803446e-22, -6.022496902058014e-23,  1.662973610176618e-24,  4.278365670042333e-27,  2.827678261171328e-10, -8.187564968445604e-12,  2.197938175107611e-13,
 -7.559084154513850e-15,  2.652302281462910e-16, -7.241898142469590e-18,  1.349123966400522e-19, -1.903616068836277e-21,  5.593233144792351e-23, -2.564833842147354e-24,
  6.385275502908404e-26, -1.158075417904903e-28,  1.460594128198494e-12, -4.475972230591109e-14,  1.444912169088733e-15, -6.130353178779422e-17,  2.467238778728039e-18,
 -7.732699543995653e-20,  1.865314668814112e-21, -4.230948555102376e-23,  1.290838739553384e-24, -4.420659372735838e-26,  1.085358198075598e-27, -1.293856327534325e-29,
  9.409270316088178e-16, -3.294058692215074e-17,  1.481386453270842e-18, -8.319278298684253e-20,  4.086800649008506e-21, -1.631796187454271e-22,  5.687257652828870e-24,
 -1.957099221481331e-25,  7.010232922356844e-27, -2.411842653737348e-28,  7.261866927574644e-30, -1.911933938163253e-31,  7.605050794498310e-06, -1.932859317106293e-07,
  3.376787064504170e-09, -4.687425030814115e-11,  4.590785972195438e-13, -1.204688891138070e-15, -1.858990665748934e-17, -1.918060608107194e-18,  9.345633617177207e-20,
 -9.415939302249254e-22, -5.213710540495836e-23,  1.978525884529592e-24,  2.707129276398880e-05, -6.890606526276197e-07,  1.214812316426089e-08, -1.758287440160369e-10,
  2.047386995120789e-12, -1.671291348315846e-14,  1.333750555941207e-16, -5.899909813118532e-18,  2.133846751661946e-19, -2.121196059631679e-21, -1.070187026593727e-22,
  4.069843115404389e-24,  2.844863492958316e-05, -7.258500305404871e-07,  1.298148310874055e-08, -1.999173856972523e-10,  2.852265173323202e-12, -3.883259329761778e-14,
  4.926612002936276e-16, -5.202244439699839e-18,  3.752618226197897e-20, -3.999601856369122e-22,  2.149352956700815e-23, -6.670632918362915e-25,  1.292113700807428e-05,
 -3.308257968385274e-07,  6.039632605491462e-09, -1.009441047007875e-10,  1.768232125768713e-12, -3.219154969010644e-14,  4.760067808092252e-16, -2.281522682015587e-18,
 -9.266285311030437e-20,  7.708634869412417e-22,  1.015429566534823e-22, -3.556342883988693e-24,  2.812050700991127e-06, -7.235417229011020e-08,  1.359023583725944e-09,
 -2.514126869825297e-11,  5.342154431396926e-13, -1.169689392878593e-14,  1.898442847830989e-16, -7.425563244448518e-19, -4.719567062565135e-20,  3.283173014410602e-22,
  5.219158963360860e-23, -1.776731681441463e-24,  2.942670083505045e-07, -7.624636355269160e-09,  1.489165704979183e-10, -3.111961180079986e-12,  7.888266505844082e-14,
 -1.965458605520139e-15,  3.456279099788508e-17, -1.759358738390475e-19, -7.345072872584557e-21,  2.429535145857775e-23,  1.047607488891603e-23, -3.386662070366717e-25,
  1.386820352028448e-08, -3.630202626693540e-10,  7.487413252036429e-12, -1.807953671951623e-13,  5.381872620338340e-15, -1.483789149940256e-16,  2.843304941591473e-18,
 -2.189737876322671e-20, -3.239643658338512e-22, -3.866927261583972e-24,  9.209420616865525e-25, -2.753690701235499e-26,  2.530484564011571e-10, -6.729851026575273e-12,
  1.502943248669450e-13, -4.313586698090359e-15,  1.491991347316881e-16, -4.509751591399482e-18,  9.612706924713787e-20, -1.131601778500402e-21,  4.889029114842519e-24,
 -4.717345772123061e-25,  3.469662057503673e-26, -9.355941307548092e-28,  1.300825029166178e-12, -3.557535529780750e-14,  9.020340053653170e-16, -3.210258012154807e-17,
  1.291301365370312e-18, -4.330642135815802e-20,  1.072937085144736e-21, -1.921141307608948e-23,  3.418487761299401e-25, -1.237192242606886e-26,  5.059518814483449e-28,
 -1.257590159533202e-29,  8.278377986889030e-16, -2.417869196880715e-17,  7.875475639317458e-19, -3.798948494804246e-20,  1.847420060642076e-21, -7.345634911862213e-23,
  2.363896689201278e-24, -6.736398560136106e-26,  2.016597347739321e-27, -6.843119116767443e-29,  2.275845225880151e-30, -6.295066128679614e-32,  6.882546808079565e-06,
 -1.683987861515452e-07,  2.857457631780784e-09, -3.975867442671377e-11,  4.277473178525672e-13, -1.999065964847872e-15, -3.746135776422562e-17,  2.858887118321174e-19,
  4.097615059970291e-20, -1.536878325399639e-21,  1.309671113605340e-23,  7.791429236203784e-25,  2.449681098946967e-05, -5.997830577562883e-07,  1.022413775905040e-08,
 -1.456141095346860e-10,  1.735365387574762e-12, -1.481448229858181e-14,  4.832560891685686e-17, -7.929868097302801e-19,  9.912573019471163e-20, -3.320817076478948e-21,
  2.807026541359173e-23,  1.621644520853632e-24,  2.573876723432065e-05, -6.308734721796371e-07,  1.083261370797463e-08, -1.598991344755576e-10,  2.182715447679493e-12,
 -2.862967775878724e-14,  3.625231893566395e-16, -4.117543441309777e-18,  3.243737634974452e-20, -2.193052433950935e-23,  5.808223261742393e-25, -2.499324749260942e-25,
  1.168741560117574e-05, -2.869181228013504e-07,  4.978745166212232e-09, -7.720952859896541e-11,  1.231923993969119e-12, -2.182261701380962e-14,  3.786957086265346e-16,
 -4.303655836898938e-18, -2.595242842550690e-20,  2.144605540335083e-21, -1.648291752654293e-23, -1.438887034280690e-24,  2.542651320267788e-06, -6.255967556247687e-08,
  1.101668823023086e-09, -1.822765497726359e-11,  3.433611132894205e-13, -7.539096078598098e-15,  1.517167111244300e-16, -1.803943339220051e-18, -1.498087166363528e-20,
  1.061146264560809e-21, -7.508329627613897e-24, -7.392211885046625e-25,  2.659413277028238e-07, -6.563926672712383e-09,  1.179889053120938e-10, -2.121361612795274e-12,
  4.734398207363937e-14, -1.218621663926129e-15,  2.689285071835395e-17, -3.435487034551956e-19, -2.225114799984557e-21,  1.828167600883511e-22, -1.052159560249548e-24,
 -1.457886261841134e-25,  1.252397890216611e-08, -3.105378322818906e-10,  5.747988904368869e-12, -1.149475060927075e-13,  3.041166193463490e-15, -8.859972481610557e-17,
  2.101648949213125e-18, -2.962216796983604e-20, -6.961000371083260e-23,  1.163334214922025e-23, -2.783079757696330e-26, -1.233546682379952e-26,  2.282551454902381e-10,
 -5.700059503211277e-12,  1.102550586127368e-13, -2.533188167466750e-15,  7.956156716247449e-17, -2.573274809867102e-18,  6.554435267751868e-20, -1.054758139297743e-21,
  3.775758469459865e-24,  1.942648386472402e-25,  2.495211607525027e-27, -4.315285576046367e-28,  1.170935863182210e-12, -2.960634132015531e-14,  6.162625155656322e-16,
 -1.713642921419792e-17,  6.441758541757053e-19, -2.307173745226694e-20,  6.432747313477092e-22, -1.247331476629978e-23,  1.433443137418802e-25, -1.372076413929875e-27,
  9.726712258048841e-29, -5.503023116227006e-30,  7.414206736744716e-16, -1.929367127051848e-17,  4.690405637485905e-19, -1.763529321209937e-20,  8.227840444035851e-22,
 -3.382866137026910e-23,  1.109601193224607e-24, -2.911253443236742e-26,  6.702178564371779e-28, -1.736601754425583e-29,  5.856395128603765e-31, -2.009115211713170e-32,
  6.251809202238345e-06, -1.473345279508420e-07,  2.419952176923716e-09, -3.327863914335491e-11,  3.799897049798988e-13, -2.700200695220129e-15, -1.842415581157758e-17,
  8.566884257293361e-19, -1.279594800951176e-22, -6.934323778405490e-22,  2.195087273806117e-23, -1.952700574934518e-25,  2.225083547814295e-05, -5.245295380663425e-07,
  8.633782094434593e-09, -1.201579818348547e-10,  1.450295746684526e-12, -1.366285464857508e-14,  5.466863618965604e-17,  7.738933686539844e-19,  9.762071554853401e-21,
 -1.533372891438019e-21,  4.643667237200246e-23, -4.105716424741708e-25,  2.337722726128304e-05, -5.513346542605984e-07,  9.105898438642256e-09, -1.291208054081336e-10,
  1.688391208140388e-12, -2.119629579499469e-14,  2.615863506645151e-16, -3.102458553470151e-18,  3.041576822594767e-20, -1.133433158694320e-22, -3.125850993551463e-24,
  2.828119091273717e-26,  1.061396822350399e-05, -2.504893048666790e-07,  4.157578066056144e-09, -6.053835345228287e-11,  8.763915178009063e-13, -1.420928348283749e-14,
  2.567559024439963e-16, -4.108440733998628e-18,  3.028922438561569e-20,  8.697515440678149e-22, -3.455463096738684e-23,  2.984273890652590e-25,  2.308772271911119e-06,
 -5.453812001539900e-08,  9.115163345121964e-10, -1.376002019200488e-11,  2.247582269042391e-13, -4.526143131037844e-15,  9.956072214345513e-17, -1.772722086870054e-18,
  1.309229682507240e-20,  4.396567583027391e-22, -1.710941374551552e-23,  1.430909339348450e-25,  2.414282247882944e-07, -5.710604262205645e-09,  9.637776895075683e-11,
 -1.527111351566293e-12,  2.862905169166340e-14, -6.911154767595261e-16,  1.715548680147663e-17, -3.261048038038548e-19,  2.649726096677732e-21,  7.557140793890752e-23,
 -3.066440372961863e-24,  2.405306960846278e-26,  1.136607035816568e-08, -2.693624724807084e-10,  4.610201242215885e-12, -7.800607116063944e-14,  1.706630886501589e-15,
 -4.800578879502082e-17,  1.297934074630920e-18, -2.610207391526085e-20,  2.464451484227091e-22,  4.756963350512950e-24, -2.150864185871396e-25,  1.437294826045414e-27,
  2.070525011467233e-10, -4.921375968910166e-12,  8.604654680814295e-14, -1.596169333389602e-15,  4.153263073730989e-17, -1.334527690961328e-18,  3.872822159472351e-20,
 -8.294894126712322e-22,  9.541419579334203e-24,  7.871409605989670e-26, -4.996877116375200e-27,  1.573614567062233e-29,  1.061275646884271e-12, -2.535374628863009e-14,
  4.596531930789713e-16, -9.792082731695262e-18,  3.113892292978623e-19, -1.133413931114867e-20,  3.540115379595301e-22, -8.281760004308682e-24,  1.231074215009757e-25,
 -4.742681509009253e-28, -1.564864166450424e-29, -4.699652774471324e-31,  6.706688610894054e-16, -1.620728313827396e-17,  3.180985452375282e-19, -8.676063577566333e-21,
  3.570344001200638e-22, -1.500787743137457e-23,  5.249079521472342e-25, -1.448450137760600e-26,  3.114796963233668e-28, -5.564736985437795e-30,  1.184533583601638e-31,
 -4.210900709419329e-33,  5.698801505240801e-06, -1.294731488074636e-07,  2.055249294788452e-09, -2.764695363405742e-11,  3.234270161316153e-13, -2.872519182924913e-15,
  2.838289755178039e-18,  6.009280054539275e-19, -1.204307220017036e-20, -5.280016507720674e-23,  9.598249982369515e-24, -2.744824677421545e-25,  2.028225599483335e-05,
 -4.608526511326786e-07,  7.322348612299816e-09, -9.906055194799165e-11,  1.191923541493652e-12, -1.209475195421915e-14,  7.471032645481623e-17,  5.159514610474441e-19,
 -1.779313287782013e-20, -1.744004960706192e-22,  2.050325560117321e-23, -5.761738980327149e-25,  2.130837832509418e-05, -4.842561640024705e-07,  7.705573656249393e-09,
 -1.051844575555950e-10,  1.320759190554799e-12, -1.585520954314002e-14,  1.875799241837018e-16, -2.214684751514714e-18,  2.458939295229603e-20, -1.936241510980774e-22,
 -7.032104905659540e-25,  5.715535805063780e-26,  9.674241911222656e-06, -2.199157508465449e-07,  3.506856326415298e-09, -4.849162350823163e-11,  6.451659949055441e-13,
 -9.297840299456230e-15,  1.582897090708040e-16, -2.870302991753465e-18,  4.114505251505548e-20, -1.287102876413991e-22, -1.439222077896621e-23,  4.553055941150773e-25,
  2.104236493510613e-06, -4.785145213949859e-08,  7.653624312634319e-10, -1.077412486522354e-11,  1.544001970869474e-13, -2.674677626701485e-15,  5.732294247420123e-17,
 -1.215658270127495e-18,  1.876955173387704e-20, -5.606473942249310e-23, -7.153019477912980e-24,  2.265644019662725e-25,  2.200215653669219e-07, -5.006016132702870e-09,
  8.040913707655978e-11, -1.160161964974484e-12,  1.824177664807443e-14, -3.776364295278844e-16,  9.468577053696758e-18, -2.184712003381365e-19,  3.546411878292609e-21,
 -1.344847789362538e-23, -1.273758343953523e-24,  4.147692923491067e-26,  1.035702680045926e-08, -2.358240862811450e-10,  3.811126546179678e-12, -5.691937752497969e-14,
  1.003895119304371e-15, -2.463103743969117e-17,  6.925053596877239e-19, -1.693529366210298e-20,  2.889919770795158e-22, -1.518158743656966e-24, -8.827204693761034e-26,
  3.041165167783830e-27,  1.886360758828432e-10, -4.300059830723974e-12,  7.014241169617425e-14, -1.101925459616673e-15,  2.244023270185543e-17, -6.479311611847017e-19,
  1.994960635832205e-20, -5.133794435121626e-22,  9.323341162538386e-24, -6.996523686328435e-26, -2.017156178217646e-27,  7.889583731764193e-29,  9.665711128497334e-13,
 -2.207643129488514e-14,  3.658597000177179e-16, -6.232767758601210e-18,  1.531028167642072e-19, -5.195831784849631e-21,  1.737784583091358e-22, -4.744190720107192e-24,
  9.446058983142703e-26, -1.044702298091788e-27, -6.518446786922887e-30,  4.587589653099447e-31,  6.103818062072816e-16, -1.400080713501204e-17,  2.402404711234489e-19,
 -4.800029122007976e-21,  1.551355846694266e-22, -6.309898578255668e-24,  2.337243896294218e-25, -7.064745438056831e-27,  1.671531844572441e-28, -2.956871955540316e-30,
  3.768869815794450e-32, -5.327296006866328e-34,  5.211810230818523e-06, -1.142745530485553e-07,  1.752664711512430e-09, -2.292308674727990e-11,  2.677961202634408e-13,
 -2.645678564799843e-15,  1.438801861254707e-17,  2.383521229469065e-19, -9.521767887247455e-21,  1.366016043067567e-22,  1.085827092931926e-24, -1.121139004574735e-25,
  1.854890864822259e-05, -4.067222970299737e-07,  6.240390256209816e-09, -8.182378680409322e-11,  9.687889784947151e-13, -1.019395031287237e-14,  8.111101538327971e-17,
 -3.944445386372963e-20, -1.453468023662632e-20,  2.372151387604080e-22,  2.620628987628055e-24, -2.360418578957700e-25,  1.948712610811600e-05, -4.273237914244902e-07,
  6.560427007532500e-09, -8.636410742043230e-11,  1.044083125421457e-12, -1.201503426177380e-14,  1.355237151251889e-16, -1.540475293003799e-18,  1.762370523593688e-20,
 -1.821048355295356e-22,  9.972018473543018e-25,  1.958009243294332e-26,  8.847233892997826e-06, -1.940259297806615e-07,  2.981356417492988e-09, -3.947494749719307e-11,
  4.914280403556153e-13, -6.321895361921135e-15,  9.507008184810928e-17, -1.704320662138626e-18,  3.026783072719254e-20, -3.828919420686704e-22, -3.743845854737997e-25,
  1.804385083394127e-25,  1.924312127425818e-06, -4.220734632942167e-08,  6.493434299517800e-10, -8.667312722112777e-12,  1.122441348758105e-13, -1.642915278655131e-15,
  3.109796818404235e-17, -6.853356877451677e-19,  1.365058705069500e-20, -1.822275444716289e-22, -1.825172661906652e-25,  8.938900867164545e-26,  2.012022123189432e-07,
 -4.413972254213154e-09,  6.802401357318404e-11, -9.182260031008470e-13,  1.252937340431613e-14, -2.116911669133769e-16,  4.815928434059964e-18, -1.194146975915854e-19,
  2.520313561630934e-21, -3.513321141993630e-23, -2.194580595319733e-28,  1.617149606288493e-26,  9.470725244512080e-09, -2.078264437516685e-10,  3.210739539492718e-12,
 -4.403825612313670e-14,  6.441833570800337e-16, -1.272510500563120e-17,  3.360787876815091e-19, -9.012273732029373e-21,  1.983006825946727e-22, -2.903803866159102e-24,
  4.872360620134090e-27,  1.162559594988162e-27,  1.724818735193298e-10, -3.786546976035081e-12,  5.871823345953029e-14, -8.248512968709085e-16,  1.326800345372603e-17,
 -3.106525959519479e-19,  9.297772582465938e-21, -2.648866023273188e-22,  6.068451040339514e-24, -9.486605540235201e-26,  3.961897266055204e-28,  2.914360572184461e-29,
  8.836954405718707e-13, -1.941370884537495e-14,  3.029595430235730e-16, -4.427323481441958e-18,  8.174742290844257e-20, -2.313261724676054e-21,  7.745826507291298e-23,
 -2.337725397953813e-24,  5.642361260449764e-26, -9.731741699883460e-28,  7.758543010200169e-30,  1.564924642627331e-31,  5.579066849737468e-16, -1.227499264472716e-17,
  1.941957092540438e-19, -3.080213692659768e-21,  7.175000457166095e-23, -2.558672407382531e-24,  9.666918658840794e-26, -3.160939869311900e-27,  8.402990367072781e-29,
 -1.737075185840803e-30,  2.546658730070896e-32, -1.954250008070609e-34,  4.781110195718737e-06, -1.012845935553694e-07,  1.501615563930672e-09, -1.904118622317156e-11,
  2.187180430316603e-13, -2.250062936111511e-15,  1.755058304015721e-17,  1.333321149764236e-20, -4.675110360609563e-21,  1.169347791498049e-22, -1.358815627747514e-24,
 -1.423563632016553e-26,  1.701599954189490e-05, -3.604780191178951e-07,  5.345120088354404e-09, -6.784964274063648e-11,  7.840502933528819e-13, -8.304895892379453e-15,
  7.482905347265796e-17, -3.632684380511467e-19, -5.907729838592126e-21,  2.087436663310701e-22, -2.558041404984096e-24, -3.125573602013294e-26,  1.787661231493666e-05,
 -3.787190450184695e-07,  5.616894753911105e-09, -7.141805338020277e-11,  8.331190874655950e-13, -9.222088207816395e-15,  9.936224870211652e-17, -1.072560736781158e-18,
  1.191406927260064e-20, -1.333862594227665e-22,  1.272338548424985e-24, -3.331632327157869e-27,  8.116008745063882e-06, -1.719450844591828e-07,  2.551023318746348e-09,
 -3.251404832115363e-11,  3.844537997556356e-13, -4.515944869904706e-15,  5.888703456665811e-17, -9.474983083088854e-19,  1.755688577963099e-20, -2.994308421571569e-22,
  3.346423790497943e-24,  1.494908945567253e-26,  1.765253626927710e-06, -3.740036231768132e-08,  5.551422908088290e-10, -7.099434460311953e-12,  8.552470334347664e-14,
 -1.083434217276917e-15,  1.706274656850029e-17, -3.491144447809828e-19,  7.621903607436209e-21, -1.409938601538210e-22,  1.645687233648065e-24,  6.912462203262993e-27,
  1.845693546395849e-07, -3.910733003707022e-09,  5.808600395121548e-11, -7.463342506849116e-13,  9.222771725202831e-15, -1.282597797562810e-16,  2.417551290551018e-18,
 -5.796647393076214e-20,  1.374104930057329e-21, -2.648447067100947e-23,  3.222485122723753e-25,  9.560445612015475e-28,  8.687669384663465e-09, -1.840960185301051e-10,
  2.736937082017435e-12, -3.540319625539834e-14,  4.532076783041817e-16, -7.063558040602878e-18,  1.575731387607673e-19, -4.228189773900947e-21,  1.056490304743699e-22,
 -2.103097332148922e-24,  2.693306861147746e-26,  2.835409067563572e-29,  1.582170467272873e-10, -3.353189547093745e-12,  4.992196417868615e-14, -6.523092327799042e-16,
  8.786228315405817e-18, -1.575623771251543e-19,  4.118907844391622e-21, -1.204973706151044e-22,  3.139996289304350e-24, -6.472192722374780e-26,  8.887231620238047e-28,
 -1.487194148521659e-30,  8.105789445807071e-13, -1.718326561313700e-14,  2.564270138075614e-16, -3.407457013841002e-18,  4.969587836715962e-20, -1.065703680069761e-21,
  3.249280448539425e-23, -1.024382444699730e-24,  2.788964432562283e-26, -6.036164787457411e-28,  9.203207070740036e-30, -5.213627388968376e-32,  5.117030470665224e-16,
 -1.085296099275256e-17,  1.627702076120374e-19, -2.240844411258145e-21,  3.795754015981670e-23, -1.048011739466929e-24,  3.770970270374689e-26, -1.293120215995577e-27,
  3.770361980154365e-29, -8.962117116898652e-31,  1.649268495434084e-32, -2.037046891390599e-34,  4.398630205756712e-06, -9.012942652572542e-08,  1.292707069180920e-09,
 -1.587895286439361e-11,  1.778868813004081e-13, -1.837775167503793e-15,  1.638425827514314e-17, -7.987407071394030e-20, -1.484356756444932e-21,  6.140407226558286e-23,
 -1.229694205581041e-24,  1.235914879170105e-26,  1.565473802240926e-05, -3.207725875164486e-07,  4.601017855182864e-09, -5.653980527880100e-11,  6.350038220499734e-13,
 -6.646217459925744e-15,  6.299222727507734e-17, -4.529343767507254e-19, -3.352993298592779e-22,  1.026531657437932e-22, -2.352979971142086e-24,  2.440437651467531e-26,
  1.644648111764446e-05, -3.369985686673962e-07,  4.834164522858377e-09, -5.944360287106390e-11,  6.702967637238074e-13, -7.158789451165187e-15,  7.401370271204264e-17,
 -7.587687662483558e-19,  7.969248163821336e-21, -8.782892004965311e-23,  9.694003665275768e-25, -8.488169176063599e-27,  7.466712871834398e-06, -1.529994066991843e-07,
  2.195008362211176e-09, -2.701654641640729e-11,  3.064080958827060e-13, -3.366558790311034e-15,  3.878736583659669e-17, -5.322772121942299e-19,  9.163644202372989e-21,
 -1.710389623102468e-22,  2.771680243392598e-24, -2.780034273734943e-26,  1.624025731717987e-06, -3.327825107203009e-08,  4.775084457417634e-10, -5.885022147760898e-12,
  6.728348891267479e-14, -7.679029896629421e-16,  1.003000024953672e-17, -1.737422871760840e-19,  3.714715491587725e-21, -7.825817581167393e-23,  1.343624008133905e-24,
 -1.401927222284277e-26,  1.698023846455738e-07, -3.479537308774182e-09,  4.993962382601009e-11, -6.166118358482043e-13,  7.128585367032712e-15, -8.553869264031878e-17,
  1.284402208588231e-18, -2.679176630526410e-20,  6.465993767687138e-22, -1.441096521429939e-23,  2.551773954524011e-25, -2.776790974764454e-27,  7.992547005110261e-09,
 -1.637861792717956e-10,  2.351515057514557e-12, -2.911077011280286e-14,  3.418688417966152e-16, -4.383068480106730e-18,  7.658814106133720e-20, -1.856520167478880e-21,
  4.845853876029132e-23, -1.120130340720653e-24,  2.037726520546707e-26, -2.339352598246221e-28,  1.455565605173043e-10, -2.982944376265207e-12,  4.284844036302936e-14,
 -5.325365796733541e-16,  6.400646128326895e-18, -8.975630731714629e-20,  1.848548574794259e-21, -5.077062724701945e-23,  1.404338225542423e-24, -3.349301301462310e-26,
  6.290309333967717e-28, -7.770851050449538e-30,  7.457069907023620e-13, -1.528327661832886e-14,  2.197194278294592e-16, -2.748635911113249e-18,  3.430159788451035e-20,
 -5.468935058536765e-22,  1.351226079872805e-23, -4.142378091033495e-25,  1.206172277287635e-26, -2.982663625909608e-28,  5.871201098377856e-30, -8.088771030706032e-32,
  4.707380360909364e-16, -9.649361268856114e-18,  1.389631152372632e-19, -1.762230303021127e-21,  2.370815411915362e-23, -4.668115180460249e-25,  1.435303389444292e-26,
 -4.922815548264940e-28,  1.527387198755399e-29, -4.018293334765063e-31,  8.667538027763117e-33, -1.445949331276856e-34,  4.057653807882236e-06, -8.050423317495197e-08,
  1.118090791537916e-09, -1.330627564095325e-11,  1.448622262318809e-13, -1.475027292684411e-15,  1.375391834295536e-17, -1.003738242575329e-19, -2.028704938861794e-23,
  2.373972063948961e-23, -6.620888284283658e-25,  1.152658228565640e-26,  1.444119810147530e-05, -2.865152242316279e-07,  3.979368383544843e-09, -4.736529301727301e-11,
  5.161763871799240e-13, -5.284982363969594e-15,  5.059876804059985e-17, -4.204709697013482e-19,  1.941726232156208e-21,  3.141703288659067e-23, -1.225122489833844e-24,
  2.288309544795662e-26,  1.517155955777583e-05, -3.010065128976378e-07,  4.180759044897514e-09, -4.977448705725612e-11,  5.433008241146910e-13, -5.611261994923202e-15,
  5.591224387365185e-17, -5.475775211072386e-19,  5.417449073594780e-21, -5.624176202006622e-23,  6.228215187659570e-25, -6.812016600101236e-27,  6.887893421305233e-06,
 -1.366576025580170e-07,  1.898154336190387e-09, -2.260662452460071e-11,  2.473283810008330e-13, -2.586356496954778e-15,  2.720161385461119e-17, -3.186117891213907e-19,
  4.700569368211471e-21, -8.499120350765242e-23,  1.562732220286328e-24, -2.399618511798968e-26,  1.498129996933019e-06, -2.972345303418919e-08,  4.128789421566810e-10,
 -4.919713983513253e-12,  5.399820815413951e-14, -5.743907758219512e-16,  6.472701982682992e-18, -9.080475858833660e-20,  1.713800457467645e-21, -3.693513229711702e-23,
  7.404072043929159e-25, -1.186032278507741e-26,  1.566389851932481e-07, -3.107798963209655e-09,  4.317298803187924e-11, -5.147842878004003e-13,  5.675590990995533e-15,
 -6.179188947559842e-17,  7.585635270239721e-19, -1.267229163275291e-20,  2.819874641839219e-22, -6.626767985512157e-24,  1.381379620025191e-25, -2.268062518072991e-27,
  7.372937328222100e-09, -1.462844773041302e-10,  2.032394267837720e-12, -2.425723613135835e-14,  2.691443945760394e-16, -3.025651677843569e-18,  4.125815559876215e-20,
 -8.137234966526058e-22,  2.036056593721043e-23, -5.046994554176454e-25,  1.080501475610897e-26, -1.816936807217658e-28,  1.342721804455693e-10, -2.664100475403618e-12,
  3.701990388274437e-14, -4.424814122043235e-16,  4.956120121082717e-18, -5.832875377212346e-20,  9.056809855755110e-22, -2.091792041869029e-23,  5.722800845305550e-25,
 -1.476200355066513e-26,  3.240582470843496e-28, -5.615489375318071e-30,  6.878926982435118e-13, -1.364885927505903e-14,  1.897157424817220e-16, -2.272964646795560e-18,
  2.585585284323528e-20, -3.266343767283841e-22,  5.987766599225417e-24, -1.613027229870330e-25,  4.756288722803390e-27, -1.273886152845227e-28,  2.886732543756675e-30,
 -5.235662555349136e-32,  4.342383687863267e-16, -8.616402498891961e-18,  1.198341222762370e-19, -1.442716161539104e-21,  1.693666460649352e-23, -2.437732996982419e-25,
  5.648494602244414e-27, -1.792110936447204e-28,  5.710807304463519e-30, -1.610969686173576e-31,  3.867344489589388e-33, -7.666369794781990e-35  };
  int offset = -10;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 10;
    if (std::isnan(t)) {
      fill_n(rr+offset, 10, 0.5);
      fill_n(ww+offset, 10, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 10; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=10; ++j) {
        const int boxof = it*120+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
