# -*- coding: utf-8 -*-
# TOFU
# Copyright (C) 2005-2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import balazar3.tofu as tofu
from balazar3.tofu import *
import soya

tofu._saving_lock = soya

MAIN_LOOP = None

class MainLoop(tofu.MainLoop, soya.MainLoop):
  def __init__(self):
    scene = soya.World()
    soya.MainLoop.__init__(self, scene)
    tofu.MainLoop.__init__(self)
    
    global MAIN_LOOP
    MAIN_LOOP = self
    
  def stop(self):
    soya.MainLoop.stop(self)
    tofu.MainLoop.stop(self)

  @side("single", "client")
  def base_main_loop(self):
    soya.MainLoop.main_loop(self)
    
  @side("single", "server", "client")
  def begin_round(self):
    soya.MainLoop.begin_round(self)
    
  @side("server")
  def begin_round(self):
    self.poll()
    
  @side("client")
  def begin_round(self):
    self.nb_round += 1
    
    self.poll()
    
  def advance_time(self, proportion):
    soya.MainLoop.advance_time(self, proportion)
    
  def end_round(self):
    soya.MainLoop.end_round(self)
    
    
class Level(tofu.Level, soya.World):
  def __init__(self):
    soya.World.__init__(self)
    tofu.Level.__init__(self)
    
  def loaded(self):
    soya.World.__init__(self)
    soya.World.loaded(self)
    tofu.Level.loaded(self)
    
  def add_mobile(self, mobile, _send_later = 0):
    tofu.Level.add_mobile(self, mobile, _send_later = 0)
    self.add(mobile)
    
  def remove_mobile(self, mobile):
    tofu.Level.remove_mobile(self, mobile)
    self.remove(mobile)
    
  def base_begin_round(self):
    soya.World.begin_round(self)
    
  def advance_time(self, proportion):
    if self.active:
      tofu.Level.advance_time(self, proportion)
      
      
class Mobile(tofu.Mobile, soya.World):
  def __init__(self):
    soya.World .__init__(self)
    tofu.Mobile.__init__(self)
    
  def loaded(self):
    soya.World.__init__(self)
    soya.World .loaded(self)
    tofu.Mobile.loaded(self)
    
  def begin_round(self):
    tofu.Mobile.begin_round(self)
    soya.World .begin_round(self)
    
  def advance_time(self, proportion):
    soya.World.advance_time(self, proportion)

