//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/BackgroundItemCatalog.cpp
//! @brief     Implements class BackgroundItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Device/BackgroundItemCatalog.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Device/BackgroundItems.h"

BackgroundItem* BackgroundItemCatalog::create(Type type)
{
    switch (type) {
    case Type::None:
        return new NoBackgroundItem();
    case Type::Constant:
        return new ConstantBackgroundItem();
    case Type::Poission:
        return new PoissonBackgroundItem();
    }
    ASSERT(false);
}

QVector<BackgroundItemCatalog::Type> BackgroundItemCatalog::types()
{
    return {Type::None, Type::Constant, Type::Poission};
}

UiInfo BackgroundItemCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::None:
        return {"None", "", ""};
    case Type::Constant:
        return {"Constant background", "", ""};
    case Type::Poission:
        return {"Poisson noise", "", ""};
    }
    ASSERT(false);
}

BackgroundItemCatalog::Type BackgroundItemCatalog::type(const BackgroundItem* item)
{
    if (dynamic_cast<const NoBackgroundItem*>(item))
        return Type::None;
    if (dynamic_cast<const ConstantBackgroundItem*>(item))
        return Type::Constant;
    if (dynamic_cast<const PoissonBackgroundItem*>(item))
        return Type::Poission;

    ASSERT(false);
}
