//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobProgressAssistant.cpp
//! @brief     Implements class JobProgressAssistant
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Job/JobProgressAssistant.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Model/JobModel.h"
#include <QProgressBar>

JobProgressAssistant::JobProgressAssistant(QProgressBar* progressBar, JobModel* jobModel)
    : m_progressBar(progressBar)
{
    connect(jobModel, &JobModel::globalProgress, this, &JobProgressAssistant::onGlobalProgress);
}

void JobProgressAssistant::onGlobalProgress(int progress)
{
    ASSERT(m_progressBar);
    if (progress < 0 || progress >= 100)
        m_progressBar->hide();
    else {
        m_progressBar->show();
        m_progressBar->setValue(progress);
    }
}
