# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 <Marc Gariépy> <mgariepy@revolutionlinux.com> Révolution Linux
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3  or (at your option)
#any later version, as published by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import sys
import os
import gtk

from menueditor.menueditorconfig import getdatapath

class AddsubmenuDialog(gtk.Dialog):
    __gtype_name__ = "AddsubmenuDialog"

    def __init__(self):
        """__init__ - This function is typically not called directly.
        Creation of a AddsubmenuDialog requires redeading the associated ui
        file and parsing the ui definition extrenally,
        and then calling AddsubmenuDialog.finish_initializing().

        Use the convenience function NewAddsubmenuDialog to create
        a AddsubmenuDialog object.

        """
        pass

    def finish_initializing(self, builder):
        """finish_initalizing should be called after parsing the ui definition
        and creating a AddsubmenuDialog object with it in order to finish
        initializing the start of the new AddsubmenuDialog instance.

        """
        #get a reference to the builder and set up the signals
        self.builder = builder
        self.builder.connect_signals(self)

    def ok(self, widget, data=None):
        """ok - The user has elected to save the changes.
        Called before the dialog returns gtk.RESONSE_OK from run().

        """
        pass

    def cancel(self, widget, data=None):
        """cancel - The user has elected cancel changes.
        Called before the dialog returns gtk.RESPONSE_CANCEL for run()

        """
        pass

    @property
    def comment(self):
        return self.builder.get_object("entComment").get_text()

    def set_comment(self, text):
        return self.builder.get_object("entComment").set_text(text)

    @property
    def name(self):
        return self.builder.get_object("entName").get_text()

    def set_name(self, text):
        return self.builder.get_object("entName").set_text(text)

def NewAddsubmenuDialog():
    """NewAddsubmenuDialog - returns a fully instantiated
    dialog-addsubmenuDialog object. Use this function rather than
    creating AddsubmenuDialog instance directly.

    """

    #look for the ui file that describes the ui
    ui_filename = os.path.join(getdatapath(), 'ui', 'AddsubmenuDialog.ui')
    if not os.path.exists(ui_filename):
        ui_filename = None

    builder = gtk.Builder()
    builder.add_from_file(ui_filename)
    dialog = builder.get_object("addsubmenu_dialog")
    dialog.finish_initializing(builder)
    return dialog

if __name__ == "__main__":
    dialog = NewAddsubmenuDialog()
    dialog.show()
    gtk.main()

